/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.manifest.parser.components;

import com.android.tools.manifest.parser.XmlNode;
import com.android.tools.manifest.parser.components.IntentFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ManifestAppComponentInfo {
    protected String qualifiedName = "";
    protected boolean enabled = true;
    protected boolean exported = true;
    protected List<IntentFilter> intentFilters = new ArrayList<IntentFilter>();
    protected Set<String> permissions = new HashSet<String>();

    public ManifestAppComponentInfo(XmlNode node, String applicationId) {
        for (String attribute : node.attributes().keySet()) {
            String value = node.attributes().get(attribute);
            if ("name".equals(attribute)) {
                if (value.startsWith(".")) {
                    this.qualifiedName = applicationId + value;
                    continue;
                }
                this.qualifiedName = value;
                continue;
            }
            if ("enabled".equals(attribute)) {
                this.enabled = value.isEmpty() || "true".equals(value);
                continue;
            }
            if ("exported".equals(attribute)) {
                this.exported = value.isEmpty() || "true".equals(value);
                continue;
            }
            if (!"permission".equals(attribute)) continue;
            this.permissions.add(value);
        }
        for (XmlNode child : node.children()) {
            if (!"intent-filter".equals(child.name())) continue;
            IntentFilter intentFilter = ManifestAppComponentInfo.parseIntentFilter(child);
            this.intentFilters.add(intentFilter);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getExported() {
        return this.exported;
    }

    public boolean hasIntentFilter() {
        return !this.intentFilters.isEmpty();
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public List<IntentFilter> getIntentFilters() {
        return this.intentFilters;
    }

    public boolean hasPermission(String permission) {
        return this.permissions.contains(permission);
    }

    public boolean hasCategory(String name) {
        for (IntentFilter intentFilter : this.getIntentFilters()) {
            if (!intentFilter.hasCategory(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAction(String name) {
        for (IntentFilter intentFilter : this.getIntentFilters()) {
            if (!intentFilter.hasAction(name)) continue;
            return true;
        }
        return false;
    }

    private static IntentFilter parseIntentFilter(XmlNode node) {
        IntentFilter intentFilter = new IntentFilter();
        for (XmlNode child : node.children()) {
            if ("action".equals(child.name())) {
                String action = ManifestAppComponentInfo.getNameChildNodeValue(child);
                intentFilter.addAction(action);
                continue;
            }
            if (!"category".equals(child.name())) continue;
            String category = ManifestAppComponentInfo.getNameChildNodeValue(child);
            intentFilter.addCategory(category);
        }
        return intentFilter;
    }

    private static String getNameChildNodeValue(XmlNode node) {
        for (String attribute : node.attributes().keySet()) {
            if (!"name".equals(attribute)) continue;
            return node.attributes().get(attribute);
        }
        throw new IllegalStateException("No name attribute in node " + node.name());
    }
}

