/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxNameUtils;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelNamespacingMode;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Project {
    protected final LintClient client;
    protected final File dir;
    protected File referenceDir;
    protected final File partialResultsDir;
    protected Configuration configuration;
    protected String pkg;
    protected Document dom;
    protected int buildSdk = -1;
    protected String buildTargetHash;
    protected IAndroidTarget target;
    protected ApiConstraint manifestMinSdks = ApiConstraint.ALL;
    protected AndroidVersion manifestMinSdk = AndroidVersion.DEFAULT;
    protected AndroidVersion manifestTargetSdk = AndroidVersion.DEFAULT;
    protected LanguageLevel javaLanguageLevel;
    protected LanguageVersionSettings kotlinLanguageLevel;
    protected boolean library;
    protected boolean externalLibrary;
    protected String name;
    protected String proguardPath;
    protected boolean mergeManifests = true;
    protected SdkInfo sdkInfo;
    protected List<File> files;
    protected List<File> proguardFiles;
    protected List<File> gradleFiles;
    protected List<File> manifestFiles;
    protected List<File> javaSourceFolders;
    protected List<File> generatedSourceFolders;
    protected List<File> javaClassFolders;
    protected List<File> nonProvidedJavaLibraries;
    protected List<File> javaLibraries;
    protected List<File> testSourceFolders;
    protected List<File> instrumentationTestSourceFolders;
    protected List<File> unitTestSourceFolders;
    protected List<File> testLibraries;
    protected List<File> testFixturesSourceFolders;
    protected List<File> testFixturesLibraries;
    protected List<File> resourceFolders;
    protected List<File> generatedResourceFolders;
    protected List<File> assetFolders;
    protected List<Project> directLibraries;
    protected List<Project> allLibraries;
    protected boolean reportIssues = true;
    public Boolean gradleProject;
    protected Boolean appCompat;
    protected Boolean leanback;
    protected Set<Desugaring> desugaring;
    private Map<String, String> superClassMap;
    private ResourceVisibilityLookup resourceVisibility;
    private Document mergedManifest;
    private com.intellij.openapi.project.Project ideaProject;
    private Map<Object, Object> clientProperties;
    private ResourceNamespace namespace;
    protected LintModelMavenName mavenCoordinates = null;
    private List<String> mCachedApplicableDensities;

    public static Project create(LintClient client, File dir, File referenceDir) {
        return new Project(client, dir, referenceDir);
    }

    public boolean isGradleProject() {
        if (this.gradleProject == null) {
            this.gradleProject = this.client.isGradleProject(this);
        }
        return this.gradleProject;
    }

    public boolean isAndroidProject() {
        return true;
    }

    public LintModelModule getBuildModule() {
        LintModelVariant variant = this.getBuildVariant();
        if (variant != null) {
            return variant.getModule();
        }
        return null;
    }

    public LintModelVariant getBuildVariant() {
        return null;
    }

    public LintModelAndroidLibrary getBuildLibraryModel() {
        return null;
    }

    public Set<Desugaring> getDesugaring() {
        if (this.desugaring == null) {
            this.desugaring = this.client.getDesugaring(this);
        }
        return this.desugaring;
    }

    public boolean isDesugaring(Desugaring type) {
        return this.getDesugaring().contains((Object)type);
    }

    public boolean isCoreLibraryDesugaringEnabled() {
        LintModelVariant variant = this.getBuildVariant();
        return variant != null && variant.getBuildFeatures().getCoreLibraryDesugaringEnabled();
    }

    public void putClientProperty(Object key, Object value) {
        if (this.clientProperties == null) {
            this.clientProperties = new HashMap<Object, Object>();
        }
        if (value != null) {
            this.clientProperties.put(key, value);
        } else {
            this.clientProperties.remove(key);
        }
    }

    public <T> T getClientProperty(Object key) {
        if (this.clientProperties == null) {
            return null;
        }
        return (T)this.clientProperties.get(key);
    }

    public com.intellij.openapi.project.Project getIdeaProject() {
        return this.ideaProject;
    }

    public void setIdeaProject(com.intellij.openapi.project.Project ideaProject) {
        this.ideaProject = ideaProject;
    }

    public AgpVersion getGradleModelVersion() {
        LintModelModule gradleProjectModel = this.getBuildModule();
        if (gradleProjectModel != null) {
            return gradleProjectModel.getAgpVersion();
        }
        return null;
    }

    public Document getMergedManifest() {
        if (this.mergedManifest == null) {
            if (LintClient.isUnitTest() && Context.Companion.checkForbidden("project.getMergedManifest()", this.dir, null)) {
                return null;
            }
            this.mergedManifest = this.client.getMergedManifest(this);
        }
        return this.mergedManifest;
    }

    protected Project(LintClient client, File dir, File referenceDir, File partialResultsDir) {
        this.client = client;
        this.dir = dir;
        this.referenceDir = referenceDir;
        this.partialResultsDir = partialResultsDir;
        this.initialize();
    }

    protected Project(LintClient client, File dir, File referenceDir) {
        this(client, dir, referenceDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        block20: {
            try {
                Properties properties2 = new Properties();
                File propFile = new File(this.dir, "project.properties");
                if (!propFile.exists()) break block20;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(propFile));
                try {
                    String key;
                    String library2;
                    properties2.load(is);
                    String value = properties2.getProperty("android.library");
                    this.library = "true".equals(value);
                    String proguardPath = properties2.getProperty("proguard.config");
                    if (proguardPath != null) {
                        this.proguardPath = proguardPath;
                    }
                    this.mergeManifests = !"false".equals(properties2.getProperty("manifestmerger.enabled"));
                    String target2 = properties2.getProperty("target");
                    if (target2 != null) {
                        this.setBuildTargetHash(target2);
                    }
                    if ("true".equals(properties2.getProperty("android_java8_libs"))) {
                        this.desugaring = Desugaring.FULL;
                    }
                    for (int i = 1; i < 1000 && (library2 = properties2.getProperty(key = String.format(Locale.US, "android.library.reference.%1$d", i))) != null; ++i) {
                        if (library2.isEmpty()) {
                            break;
                        }
                        File libraryDir = new File(this.dir, library2).getCanonicalFile();
                        if (this.directLibraries == null) {
                            this.directLibraries = new ArrayList<Project>();
                        }
                        File libraryReferenceDir = this.referenceDir;
                        if (!libraryDir.getPath().startsWith(this.referenceDir.getPath())) {
                            libraryReferenceDir = libraryReferenceDir.getCanonicalFile();
                            if (!libraryDir.getPath().startsWith(this.referenceDir.getPath())) {
                                for (File file = libraryReferenceDir; file != null && !file.getPath().isEmpty(); file = file.getParentFile()) {
                                    if (!libraryDir.getPath().startsWith(file.getPath())) continue;
                                    libraryReferenceDir = file;
                                    break;
                                }
                            }
                        }
                        try {
                            Project libraryPrj = this.client.getProject(libraryDir, libraryReferenceDir);
                            this.directLibraries.add(libraryPrj);
                            libraryPrj.setReportIssues(false);
                            continue;
                        }
                        catch (CircularDependencyException e) {
                            e.setProject(this);
                            e.setLocation(Location.create(propFile));
                            throw e;
                        }
                    }
                }
                finally {
                    try {
                        Closeables.close((Closeable)is, (boolean)true);
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ioe) {
                this.client.log(ioe, "Initializing project state", new Object[0]);
            }
        }
        this.directLibraries = this.directLibraries != null ? Collections.unmodifiableList(this.directLibraries) : Collections.emptyList();
    }

    private LintModelNamespacingMode getNamespacingMode() {
        LintModelVariant variant = this.getBuildVariant();
        if (variant != null) {
            return variant.getBuildFeatures().getNamespacingMode();
        }
        return LintModelNamespacingMode.DISABLED;
    }

    public ResourceNamespace getResourceNamespace() {
        if (this.namespace == null) {
            String packageName = this.getPackage();
            this.namespace = packageName == null || this.getNamespacingMode() == LintModelNamespacingMode.DISABLED ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)packageName);
        }
        return this.namespace;
    }

    public String toString() {
        return "Project [dir=" + this.dir + "]";
    }

    public int hashCode() {
        return this.dir.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return this.dir.equals(other.dir);
    }

    public void addFile(File file) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        this.files.add(file);
    }

    public List<File> getSubset() {
        return this.files;
    }

    public UastParser.UastSourceList getUastSourceList(LintDriver driver, Project main2) {
        return null;
    }

    public List<File> getJavaSourceFolders() {
        if (this.javaSourceFolders == null) {
            this.javaSourceFolders = this.client.getJavaSourceFolders(this);
        }
        return this.javaSourceFolders;
    }

    public List<File> getGeneratedSourceFolders() {
        if (this.generatedSourceFolders == null) {
            this.generatedSourceFolders = this.client.getGeneratedSourceFolders(this);
        }
        return this.generatedSourceFolders;
    }

    public List<File> getJavaClassFolders() {
        if (this.javaClassFolders == null) {
            this.javaClassFolders = this.client.getJavaClassFolders(this);
        }
        return this.javaClassFolders;
    }

    public List<File> getJavaLibraries(boolean includeProvided) {
        if (includeProvided) {
            if (this.javaLibraries == null) {
                this.javaLibraries = this.client.getJavaLibraries(this, true);
            }
            return this.javaLibraries;
        }
        if (this.nonProvidedJavaLibraries == null) {
            this.nonProvidedJavaLibraries = this.client.getJavaLibraries(this, false);
        }
        return this.nonProvidedJavaLibraries;
    }

    public List<File> getTestSourceFolders() {
        if (this.testSourceFolders == null) {
            this.testSourceFolders = this.client.getTestSourceFolders(this);
        }
        return this.testSourceFolders;
    }

    public List<File> getUnitTestSourceFolders() {
        return Collections.emptyList();
    }

    public List<File> getInstrumentationTestSourceFolders() {
        return Collections.emptyList();
    }

    public List<File> getTestLibraries() {
        if (this.testLibraries == null) {
            this.testLibraries = this.client.getTestLibraries(this);
        }
        return this.testLibraries;
    }

    public List<File> getTestFixturesSourceFolders() {
        return Collections.emptyList();
    }

    public List<File> getTestFixturesLibraries() {
        return Collections.emptyList();
    }

    public List<File> getResourceFolders() {
        if (this.resourceFolders == null) {
            this.resourceFolders = this.client.getResourceFolders(this);
        }
        return this.resourceFolders;
    }

    public List<File> getGeneratedResourceFolders() {
        if (this.generatedResourceFolders == null) {
            this.generatedResourceFolders = this.client.getGeneratedResourceFolders(this);
        }
        return this.generatedResourceFolders;
    }

    public List<File> getAssetFolders() {
        if (this.assetFolders == null) {
            this.assetFolders = this.client.getAssetFolders(this);
        }
        return this.assetFolders;
    }

    public String getDisplayPath(File file) {
        return this.client.getDisplayPath(file, this, TextFormat.TEXT);
    }

    public String getRelativePath(File file) {
        return Project.getRelativePath(this.dir, file);
    }

    public static String getRelativePath(File root, File file) {
        String path2 = file.getPath();
        if (root == null) {
            return path2;
        }
        String referencePath = root.getPath();
        if (path2.startsWith(referencePath)) {
            int length = referencePath.length();
            if (path2.length() > length && path2.charAt(length) == File.separatorChar) {
                ++length;
            }
            return path2.substring(length);
        }
        return path2;
    }

    public File getDir() {
        return this.dir;
    }

    public File getReferenceDir() {
        return this.referenceDir;
    }

    public File getPartialResultsDir() {
        return this.partialResultsDir;
    }

    public Configuration getConfiguration(LintDriver driver) {
        if (this.configuration == null) {
            this.configuration = this.client.getConfiguration(this, driver);
            this.configuration.setFileLevel(false);
        }
        return this.configuration;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getApplicationId() {
        LintModelVariant variant = this.getBuildVariant();
        if (variant != null) {
            return variant.getMainArtifact().getApplicationId();
        }
        return this.getPackage();
    }

    public AndroidVersion getMinSdkVersion() {
        return this.manifestMinSdk == null ? AndroidVersion.DEFAULT : this.manifestMinSdk;
    }

    public ApiConstraint getMinSdkVersions() {
        return this.manifestMinSdks;
    }

    public int getMinSdk() {
        AndroidVersion version2 = this.getMinSdkVersion();
        return version2 == AndroidVersion.DEFAULT ? -1 : version2.getApiLevel();
    }

    public AndroidVersion getTargetSdkVersion() {
        return this.manifestTargetSdk == AndroidVersion.DEFAULT ? this.getMinSdkVersion() : this.manifestTargetSdk;
    }

    public LanguageLevel getJavaLanguageLevel() {
        if (this.javaLanguageLevel == null) {
            this.javaLanguageLevel = this.client.getJavaLanguageLevel(this);
        }
        return this.javaLanguageLevel;
    }

    public LanguageVersionSettings getKotlinLanguageLevel() {
        if (this.kotlinLanguageLevel == null) {
            this.kotlinLanguageLevel = this.client.getKotlinLanguageLevel(this);
        }
        return this.kotlinLanguageLevel;
    }

    public int getTargetSdk() {
        AndroidVersion version2 = this.getTargetSdkVersion();
        return version2 == AndroidVersion.DEFAULT ? -1 : version2.getApiLevel();
    }

    public int getBuildSdk() {
        return this.buildSdk;
    }

    public String getBuildTargetHash() {
        return this.buildTargetHash;
    }

    public void setBuildTargetHash(String buildTargetHash) {
        this.buildTargetHash = buildTargetHash;
        AndroidVersion version2 = AndroidTargetHash.getPlatformVersion((String)buildTargetHash);
        if (version2 != null) {
            this.buildSdk = version2.getFeatureLevel();
        } else {
            if (buildTargetHash.indexOf(45) == -1) {
                version2 = AndroidTargetHash.getPlatformVersion((String)("android-" + buildTargetHash));
            }
            if (version2 == null) {
                this.client.log(Severity.WARNING, null, "Unexpected build target format: %1$s", buildTargetHash);
            }
        }
    }

    public IAndroidTarget getBuildTarget() {
        if (this.target == null) {
            this.target = this.client.getCompileTarget(this);
        }
        return this.target;
    }

    public Document getManifestDom() {
        return this.dom;
    }

    public void readManifest(Document document) {
        NodeList usesSdks;
        String packageAttribute;
        this.dom = document;
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        if (this.pkg == null && !"".equals(packageAttribute = root.getAttribute("package"))) {
            this.pkg = packageAttribute;
        }
        if ((usesSdks = root.getElementsByTagName("uses-sdk")).getLength() > 0) {
            Element element = (Element)usesSdks.item(0);
            String minSdk = null;
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                minSdk = element.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
            }
            if (minSdk != null && !minSdk.isEmpty()) {
                this.manifestMinSdk = SdkVersionInfo.getVersion((String)minSdk, null);
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                String targetSdk = element.getAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion");
                if (!targetSdk.isEmpty()) {
                    this.manifestTargetSdk = SdkVersionInfo.getVersion((String)targetSdk, null);
                }
            } else {
                this.manifestTargetSdk = this.manifestMinSdk;
            }
            this.manifestMinSdks = ApiConstraint.Companion.getFromUsesSdk(element);
            if (this.manifestMinSdks == null) {
                this.manifestMinSdks = ApiConstraint.ALL;
            }
        }
    }

    public boolean isLibrary() {
        return this.library;
    }

    public boolean isExternalLibrary() {
        return this.externalLibrary;
    }

    public LintModelMavenName getMavenCoordinate() {
        LintModelModule model2;
        if (this.mavenCoordinates == null && (model2 = this.getBuildModule()) != null) {
            this.mavenCoordinates = model2.getMavenName();
        }
        return this.mavenCoordinates;
    }

    public List<Project> getDirectLibraries() {
        return this.directLibraries != null ? this.directLibraries : Collections.emptyList();
    }

    public void setDirectLibraries(List<Project> libraries2) {
        this.directLibraries = libraries2;
    }

    public List<Project> getAllLibraries() {
        if (this.allLibraries == null) {
            if (this.directLibraries.isEmpty()) {
                this.allLibraries = Collections.emptyList();
                return this.allLibraries;
            }
            ArrayList<Project> all2 = new ArrayList<Project>();
            HashSet seen = Sets.newHashSet();
            HashSet path2 = Sets.newHashSet();
            seen.add(this);
            path2.add(this);
            this.addLibraryProjects(all2, seen, path2);
            this.allLibraries = all2;
        }
        return this.allLibraries;
    }

    private void addLibraryProjects(Collection<Project> collection, Set<Project> seen, Set<Project> path2) {
        for (Project library2 : this.directLibraries) {
            if (seen.contains(library2)) {
                if (!path2.contains(library2)) continue;
                this.client.log(Severity.WARNING, null, "Internal lint error: cyclic library dependency for %1$s", library2);
                continue;
            }
            collection.add(library2);
            seen.add(library2);
            path2.add(library2);
            library2.addLibraryProjects(collection, seen, path2);
            path2.remove(library2);
        }
    }

    public LintModelModuleType getType() {
        LintModelModule buildModule = this.getBuildModule();
        if (buildModule != null) {
            return buildModule.getType();
        }
        if (this.isLibrary()) {
            return LintModelModuleType.LIBRARY;
        }
        return LintModelModuleType.APP;
    }

    public boolean hasDynamicFeatures() {
        return false;
    }

    public SdkInfo getSdkInfo() {
        if (this.sdkInfo == null) {
            this.sdkInfo = this.client.getSdkInfo(this);
        }
        return this.sdkInfo;
    }

    public List<File> getManifestFiles() {
        if (this.manifestFiles == null) {
            File manifestFile = new File(this.dir, "AndroidManifest.xml");
            this.manifestFiles = manifestFile.exists() ? Collections.singletonList(manifestFile) : Collections.emptyList();
        }
        return this.manifestFiles;
    }

    public List<File> getProguardFiles() {
        if (this.proguardFiles == null) {
            ArrayList<File> files2 = new ArrayList<File>();
            if (this.proguardPath != null) {
                Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)":;"));
                for (String path2 : splitter.split((CharSequence)this.proguardPath)) {
                    if (path2.contains("${")) continue;
                    File file = new File(path2);
                    if (!file.isAbsolute()) {
                        file = new File(this.getDir(), path2);
                    }
                    if (!file.exists()) continue;
                    files2.add(file);
                }
            }
            if (files2.isEmpty()) {
                File file = new File(this.getDir(), "proguard.cfg");
                if (file.exists()) {
                    files2.add(file);
                }
                if ((file = new File(this.getDir(), "proguard-project.txt")).exists()) {
                    files2.add(file);
                }
            }
            this.proguardFiles = files2;
        }
        return this.proguardFiles;
    }

    public List<File> getPropertyFiles() {
        File wrapper;
        File gradle;
        ArrayList<File> propertyFiles = new ArrayList<File>(2);
        File local = new File(this.dir, "local.properties");
        if (local.isFile()) {
            propertyFiles.add(local);
        }
        if ((gradle = new File(this.dir, "gradle.properties")).isFile()) {
            propertyFiles.add(gradle);
        }
        if ((wrapper = new File(this.dir, SdkConstants.FD_GRADLE_WRAPPER + File.separator + "gradle-wrapper.properties")).isFile()) {
            propertyFiles.add(wrapper);
        }
        return propertyFiles;
    }

    public List<File> getGradleBuildScripts() {
        if (this.gradleFiles == null) {
            if (this.isGradleProject()) {
                File settings;
                this.gradleFiles = Lists.newArrayListWithExpectedSize((int)2);
                File build = new File(this.dir, "build.gradle");
                if (build.exists()) {
                    this.gradleFiles.add(build);
                }
                if ((build = new File(this.dir, "build.gradle.kts")).exists()) {
                    this.gradleFiles.add(build);
                }
                if ((settings = new File(this.dir, "settings.gradle")).exists()) {
                    this.gradleFiles.add(settings);
                }
                if ((settings = new File(this.dir, "settings.gradle.kts")).exists()) {
                    this.gradleFiles.add(settings);
                }
            } else {
                this.gradleFiles = Collections.emptyList();
            }
        }
        return this.gradleFiles;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.client.getProjectName(this);
        }
        return this.name;
    }

    public void setName(String name) {
        assert (!name.isEmpty());
        this.name = name;
    }

    public void setReportIssues(boolean reportIssues) {
        this.reportIssues = reportIssues;
    }

    public boolean getReportIssues() {
        return this.reportIssues;
    }

    public boolean isMergingManifests() {
        return this.mergeManifests;
    }

    public Boolean dependsOn(String artifact) {
        if ("androidx.appcompat:appcompat".equals(artifact = AndroidxNameUtils.getCoordinateMapping((String)artifact)) || "com.android.support:appcompat-v7".equals(artifact)) {
            if (this.appCompat == null) {
                UastParser parser = this.client.getUastParser(this);
                if (parser.getPrepared()) {
                    JavaEvaluator evaluator = parser.getEvaluator();
                    PsiClass activity = evaluator.findClass("androidx.appcompat.app.AppCompatActivity");
                    this.appCompat = activity != null ? Boolean.valueOf(true) : Boolean.valueOf((activity = evaluator.findClass("android.support.v7.app.AppCompatActivity")) != null);
                } else {
                    for (File file : this.getJavaLibraries(true)) {
                        String name = file.getName();
                        if (!name.startsWith("appcompat") && !name.equals("android-support-v4.jar") && !name.startsWith("support-v4-") && !name.startsWith("legacy-support-")) continue;
                        return true;
                    }
                    for (Project dependency : this.getDirectLibraries()) {
                        Boolean b = dependency.dependsOn(artifact);
                        if (b == null || !b.booleanValue()) continue;
                        return true;
                    }
                    return false;
                }
            }
            return this.appCompat;
        }
        return null;
    }

    public List<String> getApplicableDensities() {
        if (this.mCachedApplicableDensities == null) {
            LintModelVariant variant = this.getBuildVariant();
            if (variant != null) {
                HashSet relevantDensities = Sets.newHashSet();
                for (String densityName : variant.getResourceConfigurations()) {
                    Density density = Density.getEnum((String)densityName);
                    if (density == null || !density.isRecommended() || density == Density.NODPI || density == Density.ANYDPI) continue;
                    relevantDensities.add(densityName);
                }
                if (!relevantDensities.isEmpty()) {
                    this.mCachedApplicableDensities = Lists.newArrayListWithExpectedSize((int)relevantDensities.size());
                    for (String density : relevantDensities) {
                        String folder = ResourceFolderType.DRAWABLE.getName() + "-" + density;
                        this.mCachedApplicableDensities.add(folder);
                    }
                    Collections.sort(this.mCachedApplicableDensities);
                } else {
                    this.mCachedApplicableDensities = Collections.emptyList();
                }
            } else {
                this.mCachedApplicableDensities = Collections.emptyList();
            }
        }
        return this.mCachedApplicableDensities.isEmpty() ? null : this.mCachedApplicableDensities;
    }

    public Map<String, String> getSuperClassMap() {
        if (this.superClassMap == null) {
            this.superClassMap = this.client.createSuperClassMap(this);
        }
        return this.superClassMap;
    }

    public ResourceVisibilityLookup getResourceVisibility() {
        if (this.resourceVisibility == null) {
            LintModelVariant variant = this.getBuildVariant();
            if (variant != null) {
                List<LintModelLibrary> libraries2 = variant.getMainArtifact().getDependencies().getAll();
                ArrayList<ResourceVisibilityLookup> list2 = new ArrayList<ResourceVisibilityLookup>(libraries2.size());
                for (LintModelLibrary library2 : libraries2) {
                    if (!(library2 instanceof LintModelAndroidLibrary)) continue;
                    LintModelAndroidLibrary l = (LintModelAndroidLibrary)library2;
                    ResourceVisibilityLookup lookup = Project.createLibraryVisibilityLookup(l);
                    list2.add(lookup);
                }
                this.resourceVisibility = ResourceVisibilityLookup.create(list2);
            } else if (this.getBuildLibraryModel() != null) {
                LintModelAndroidLibrary library3 = this.getBuildLibraryModel();
                this.resourceVisibility = Project.createLibraryVisibilityLookup(library3);
            } else {
                this.resourceVisibility = ResourceVisibilityLookup.NONE;
            }
        }
        return this.resourceVisibility;
    }

    private static ResourceVisibilityLookup createLibraryVisibilityLookup(LintModelAndroidLibrary androidLibrary) {
        File publicResources = androidLibrary.getPublicResources();
        File symbolFile = androidLibrary.getSymbolFile();
        LintModelMavenName c = androidLibrary.getResolvedCoordinates();
        String key = c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion();
        return ResourceVisibilityLookup.create((File)publicResources, (File)symbolFile, (String)key);
    }

    public LintClient getClient() {
        return this.client;
    }
}

