/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u0000 \u00192\u001e\u0012\u001a\u0012\u0018\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00040\u00020\u0001:\u0001\u0019B#\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nB-\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001b\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u00020\u0012H\u0096\u0002J\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0003J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/detector/api/PartialResult;", "", "", "Lcom/android/tools/lint/detector/api/Project;", "Lkotlin/jvm/JvmSuppressWildcards;", "Lcom/android/tools/lint/detector/api/LintMap;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "data", "", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/util/Map;)V", "requestedProject", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/util/Map;Lcom/android/tools/lint/detector/api/Project;)V", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "isEmpty", "", "iterator", "", "map", "mapFor", "project", "maps", "", "projects", "Companion", "android.sdktools.lint-api"})
public final class PartialResult
implements Iterable<Map.Entry<Project, LintMap>>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private final Map<Project, LintMap> data;
    @Nullable
    private final Project requestedProject;

    private PartialResult(Issue issue, Map<Project, LintMap> data, Project requestedProject) {
        this.issue = issue;
        this.data = data;
        this.requestedProject = requestedProject;
    }

    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    public PartialResult(@NotNull Issue issue, @NotNull Map<Project, LintMap> data) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this(issue, data, null);
    }

    @NotNull
    public final LintMap mapFor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LintMap lintMap = this.data.get(project);
        if (lintMap == null) {
            LintMap lintMap2;
            LintMap it = lintMap2 = new LintMap();
            boolean bl = false;
            this.data.put(project, it);
            lintMap = lintMap2;
        }
        return lintMap;
    }

    @NotNull
    public final LintMap map() {
        Project project = this.requestedProject;
        if (project == null) {
            throw new IllegalStateException("requestedProject was not set".toString());
        }
        Project project2 = project;
        return this.mapFor(project2);
    }

    @NotNull
    public final Collection<LintMap> maps() {
        return this.data.values();
    }

    @NotNull
    public final Collection<Project> projects() {
        return this.data.keySet();
    }

    public final boolean isEmpty() {
        for (LintMap map2 : this.maps()) {
            if (!map2.isNotEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<Project, LintMap>> iterator() {
        return this.data.entrySet().iterator();
    }

    @JvmStatic
    @NotNull
    public static final PartialResult withRequestedProject(@NotNull PartialResult partialResult, @NotNull Project requestedProject) {
        return Companion.withRequestedProject(partialResult, requestedProject);
    }

    public /* synthetic */ PartialResult(Issue issue, Map data, Project requestedProject, DefaultConstructorMarker $constructor_marker) {
        this(issue, data, requestedProject);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/detector/api/PartialResult$Companion;", "", "()V", "withRequestedProject", "Lcom/android/tools/lint/detector/api/PartialResult;", "partialResult", "requestedProject", "Lcom/android/tools/lint/detector/api/Project;", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PartialResult withRequestedProject(@NotNull PartialResult partialResult, @NotNull Project requestedProject) {
            Intrinsics.checkNotNullParameter((Object)partialResult, (String)"partialResult");
            Intrinsics.checkNotNullParameter((Object)requestedProject, (String)"requestedProject");
            return new PartialResult(partialResult.getIssue(), partialResult.data, requestedProject, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

