/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.base.Splitter;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0001<B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eJ,\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010 2\b\u0010+\u001a\u0004\u0018\u00010 2\b\u0010,\u001a\u0004\u0018\u00010-J\u0006\u0010.\u001a\u00020\u0012J\u0010\u0010.\u001a\u0004\u0018\u00010\u00122\u0006\u0010/\u001a\u00020\u0010J\b\u00100\u001a\u0004\u0018\u00010\bJ*\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020 2\b\u00107\u001a\u0004\u0018\u000108H\u0016J(\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020 J2\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u0010;\u001a\u0004\u0018\u00010&2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u00105\u001a\u00020\"2\u0006\u00106\u001a\u00020 R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0018R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/tools/lint/detector/api/ClassContext;", "Lcom/android/tools/lint/detector/api/Context;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "jarFile", "binDir", "bytecode", "", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "isFromClassLibrary", "", "sourceContents", "", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Ljava/io/File;Ljava/io/File;[BLorg/objectweb/asm/tree/ClassNode;ZLjava/lang/CharSequence;)V", "getBytecode", "()[B", "getClassNode", "()Lorg/objectweb/asm/tree/ClassNode;", "()Z", "getJarFile", "()Ljava/io/File;", "searchedForSource", "sourceFile", "findPsiClass", "Lcom/intellij/psi/PsiClass;", "qualifiedName", "", "getLocation", "Lcom/android/tools/lint/detector/api/Location;", "instruction", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "getLocationForLine", "line", "", "patternStart", "patternEnd", "hints", "Lcom/android/tools/lint/detector/api/Location$SearchHints;", "getSourceContents", "read", "getSourceFile", "report", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "field", "Lorg/objectweb/asm/tree/FieldNode;", "method", "Companion", "android.sdktools.lint-api"})
public final class ClassContext
extends Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File jarFile;
    @NotNull
    private final File binDir;
    @NotNull
    private final byte[] bytecode;
    @NotNull
    private final ClassNode classNode;
    private final boolean isFromClassLibrary;
    @Nullable
    private CharSequence sourceContents;
    @Nullable
    private File sourceFile;
    private boolean searchedForSource;

    public ClassContext(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main2, @NotNull File file, @Nullable File jarFile, @NotNull File binDir, @NotNull byte[] bytecode, @NotNull ClassNode classNode, boolean isFromClassLibrary, @Nullable CharSequence sourceContents) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)binDir, (String)"binDir");
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        super(driver, project, main2, file, null, 16, null);
        this.jarFile = jarFile;
        this.binDir = binDir;
        this.bytecode = bytecode;
        this.classNode = classNode;
        this.isFromClassLibrary = isFromClassLibrary;
        this.sourceContents = sourceContents;
    }

    @Nullable
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final byte[] getBytecode() {
        return this.bytecode;
    }

    @NotNull
    public final ClassNode getClassNode() {
        return this.classNode;
    }

    public final boolean isFromClassLibrary() {
        return this.isFromClassLibrary;
    }

    @Nullable
    public final File getSourceFile() {
        block7: {
            String string;
            Object source;
            block8: {
                if (this.sourceFile != null || this.searchedForSource) break block7;
                this.searchedForSource = true;
                source = this.classNode.sourceFile;
                if (source == null) {
                    int index2;
                    source = this.file.getName();
                    String string2 = source;
                    Intrinsics.checkNotNull((Object)string2);
                    if (StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) {
                        String string3 = ((String)source).substring(0, ((String)source).length() - ".class".length());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        source = string3 + ".java";
                    }
                    if ((index2 = StringsKt.indexOf$default((CharSequence)((CharSequence)source), (char)'$', (int)0, (boolean)false, (int)6, null)) != -1) {
                        String string4 = ((String)source).substring(0, index2);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        source = string4 + ".java";
                    }
                }
                if (this.jarFile == null) break block8;
                String relative = this.file.getParent() + File.separator + (String)source;
                List<File> list2 = this.getProject().getJavaSourceFolders();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"project.getJavaSourceFolders()");
                List<File> sources = list2;
                for (File dir : sources) {
                    File sourceFile = new File(dir, relative);
                    if (!sourceFile.exists()) continue;
                    this.sourceFile = sourceFile;
                    break block7;
                }
                break block7;
            }
            String topPath = this.binDir.getPath();
            String parentPath = this.file.getParentFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)parentPath, (String)"parentPath");
            Intrinsics.checkNotNullExpressionValue((Object)topPath, (String)"topPath");
            if (!StringsKt.startsWith$default((String)parentPath, (String)topPath, (boolean)false, (int)2, null)) break block7;
            int start2 = topPath.length() + 1;
            if (start2 > parentPath.length()) {
                string = "";
            } else {
                String string5 = parentPath.substring(start2);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            }
            String relative = string;
            List<File> list3 = this.getProject().getJavaSourceFolders();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"project.getJavaSourceFolders()");
            List<File> sources = list3;
            for (File dir : sources) {
                File sourceFile = new File(dir, relative + File.separator + (String)source);
                if (!sourceFile.exists()) continue;
                this.sourceFile = sourceFile;
                break;
            }
        }
        return this.sourceFile;
    }

    @NotNull
    public final CharSequence getSourceContents() {
        if (this.sourceContents == null) {
            File sourceFile = this.getSourceFile();
            if (sourceFile != null) {
                this.sourceContents = this.getClient().readFile(sourceFile);
            }
            if (this.sourceContents == null) {
                this.sourceContents = "";
            }
        }
        CharSequence charSequence = this.sourceContents;
        Intrinsics.checkNotNull((Object)charSequence);
        return charSequence;
    }

    @Nullable
    public final CharSequence getSourceContents(boolean read2) {
        return read2 ? this.getSourceContents() : this.sourceContents;
    }

    @NotNull
    public final Location getLocationForLine(int line, @Nullable String patternStart, @Nullable String patternEnd, @Nullable Location.SearchHints hints) {
        File sourceFile = this.getSourceFile();
        if (sourceFile != null) {
            return line != -1 ? Location.Companion.create(sourceFile, this.getSourceContents(), line - 1, patternStart, patternEnd, hints) : Location.Companion.create(sourceFile);
        }
        File file = this.jarFile;
        if (file == null) {
            file = this.file;
        }
        return Location.Companion.create(file);
    }

    @Override
    public void report(@NotNull Issue issue, @NotNull Location location2, @NotNull String message2, @Nullable LintFix quickfixData) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (this.getDriver().isSuppressed(issue, this.classNode)) {
            return;
        }
        ClassNode curr = this.classNode;
        while (curr != null) {
            ClassNode prev = curr;
            curr = this.getDriver().getOuterClassNode(curr);
            if (curr == null) continue;
            if (prev.outerMethod != null) {
                List methods = curr.methods;
                for (MethodNode m : methods) {
                    Intrinsics.checkNotNull((Object)m, (String)"null cannot be cast to non-null type org.objectweb.asm.tree.MethodNode");
                    MethodNode method = m;
                    if (!Intrinsics.areEqual((Object)method.name, (Object)prev.outerMethod) || !Intrinsics.areEqual((Object)method.desc, (Object)prev.outerMethodDesc)) continue;
                    if (!this.getDriver().isSuppressed(issue, this.classNode, method, null)) break;
                    return;
                }
            }
            if (!this.getDriver().isSuppressed(issue, curr)) continue;
            return;
        }
        Incident incident = new Incident(issue, location2, message2, quickfixData);
        LintClient.report$default(this.getDriver().getClient(), this, incident, null, 4, null);
    }

    public final void report(@NotNull Issue issue, @Nullable MethodNode method, @Nullable AbstractInsnNode instruction, @NotNull Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (method != null && this.getDriver().isSuppressed(issue, this.classNode, method, instruction)) {
            return;
        }
        Context.report$default(this, issue, location2, message2, null, 8, null);
    }

    public final void report(@NotNull Issue issue, @Nullable FieldNode field, @NotNull Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (field != null && this.getDriver().isSuppressed(issue, field)) {
            return;
        }
        Context.report$default(this, issue, location2, message2, null, 8, null);
    }

    @NotNull
    public final Location getLocation(@NotNull ClassNode classNode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        String pattern = null;
        String string2 = classNode.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classNode.name");
        if (ClassContext.Companion.isAnonymousClass(string2)) {
            String string3 = classNode.superName;
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            classNode.superName\n        }");
        } else {
            String string4 = classNode.name;
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            classNode.name\n        }");
        }
        pattern = string;
        int index2 = StringsKt.lastIndexOf$default((CharSequence)pattern, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (index2 != -1) {
            String string5 = pattern.substring(index2 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            pattern = string5;
        }
        if ((index2 = StringsKt.lastIndexOf$default((CharSequence)pattern, (char)'/', (int)0, (boolean)false, (int)6, null)) != -1) {
            String string6 = pattern.substring(index2 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
            pattern = string6;
        }
        return this.getLocationForLine(Companion.findLineNumber(classNode), pattern, null, Location.SearchHints.Companion.create(Location.SearchDirection.BACKWARD).matchJavaSymbol());
    }

    @NotNull
    public final Location getLocation(@NotNull MethodNode methodNode, @NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        String pattern = null;
        Location.SearchDirection searchMode = null;
        if (Intrinsics.areEqual((Object)methodNode.name, (Object)"<init>")) {
            String string;
            int n;
            String string2;
            searchMode = Location.SearchDirection.EOL_BACKWARD;
            String string3 = classNode.name;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classNode.name");
            if (ClassContext.Companion.isAnonymousClass(string3)) {
                String string4 = classNode.superName;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"classNode.superName");
                string2 = string4;
                String string5 = classNode.superName;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"classNode.superName");
                n = StringsKt.lastIndexOf$default((CharSequence)string5, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                String string6 = string2.substring(n);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                String string7 = classNode.name;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"classNode.name");
                string2 = string7;
                String string8 = classNode.name;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"classNode.name");
                n = StringsKt.lastIndexOf$default((CharSequence)string8, (char)'$', (int)0, (boolean)false, (int)6, null) + 1;
                String string9 = string2.substring(n);
                string = string9;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).substring(startIndex)");
            }
            pattern = string;
        } else {
            searchMode = Location.SearchDirection.BACKWARD;
            String string = methodNode.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodNode.name");
            pattern = string;
        }
        return this.getLocationForLine(Companion.findLineNumber(methodNode), pattern, null, Location.SearchHints.Companion.create(searchMode).matchJavaSymbol());
    }

    @NotNull
    public final Location getLocation(@NotNull AbstractInsnNode instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Location.SearchHints hints = Location.SearchHints.Companion.create(Location.SearchDirection.FORWARD).matchJavaSymbol();
        String pattern = null;
        if (instruction instanceof MethodInsnNode) {
            if (Intrinsics.areEqual((Object)((MethodInsnNode)instruction).name, (Object)"<init>")) {
                pattern = ((MethodInsnNode)instruction).owner;
                hints = hints.matchConstructor();
            } else {
                pattern = ((MethodInsnNode)instruction).name;
            }
            String string = pattern;
            Intrinsics.checkNotNull((Object)string);
            int index2 = StringsKt.lastIndexOf$default((CharSequence)string, (char)'$', (int)0, (boolean)false, (int)6, null);
            if (index2 != -1) {
                String string2 = pattern.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                pattern = string2;
            }
            if ((index2 = StringsKt.lastIndexOf$default((CharSequence)pattern, (char)'/', (int)0, (boolean)false, (int)6, null)) != -1) {
                String string3 = pattern.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                pattern = string3;
            }
        }
        int line = Companion.findLineNumber(instruction);
        return this.getLocationForLine(line, pattern, null, hints);
    }

    @Nullable
    public final PsiClass findPsiClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        String string = classNode.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classNode.name");
        return this.findPsiClass(Companion.getFqcn(string));
    }

    @Nullable
    public final PsiClass findPsiClass(@NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        com.intellij.openapi.project.Project project = this.getProject().getIdeaProject();
        if (project == null) {
            return null;
        }
        com.intellij.openapi.project.Project ideaProject = project;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)ideaProject);
        if (javaPsiFacade == null) {
            return null;
        }
        JavaPsiFacade psiFacade = javaPsiFacade;
        return psiFacade.findClass(qualifiedName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)ideaProject));
    }

    @JvmStatic
    public static final int findLineNumber(@NotNull AbstractInsnNode node) {
        return Companion.findLineNumber(node);
    }

    @JvmStatic
    public static final int findLineNumber(@NotNull MethodNode node) {
        return Companion.findLineNumber(node);
    }

    @JvmStatic
    public static final int findLineNumber(@NotNull ClassNode node) {
        return Companion.findLineNumber(node);
    }

    @JvmStatic
    private static final MethodNode getFirstRealMethod(ClassNode classNode) {
        return ClassContext.Companion.getFirstRealMethod(classNode);
    }

    @JvmStatic
    private static final boolean isAnonymousClass(String fqcn) {
        return ClassContext.Companion.isAnonymousClass(fqcn);
    }

    @JvmStatic
    @NotNull
    public static final String getFqcn(@NotNull String owner) {
        return Companion.getFqcn(owner);
    }

    @JvmStatic
    @NotNull
    public static final String createSignature(@Nullable String owner, @Nullable String name, @Nullable String desc) {
        return Companion.createSignature(owner, name, desc);
    }

    @JvmStatic
    private static final String getTypeString(Type type) {
        return ClassContext.Companion.getTypeString(type);
    }

    @JvmStatic
    @NotNull
    public static final String getInternalName(@NotNull String qualifiedName) {
        return Companion.getInternalName(qualifiedName);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\fH\u0003J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0003\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/detector/api/ClassContext$Companion;", "", "()V", "createSignature", "", "owner", "name", "desc", "findLineNumber", "", "node", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "Lorg/objectweb/asm/tree/ClassNode;", "Lorg/objectweb/asm/tree/MethodNode;", "getFirstRealMethod", "classNode", "getFqcn", "getInternalName", "qualifiedName", "getTypeString", "type", "Lorg/objectweb/asm/Type;", "isAnonymousClass", "", "fqcn", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int findLineNumber(@NotNull AbstractInsnNode node) {
            AbstractInsnNode curr;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            for (curr = node; curr != null; curr = curr.getPrevious()) {
                if (curr.getType() != 15) continue;
                return ((LineNumberNode)curr).line;
            }
            for (curr = node; curr != null; curr = curr.getNext()) {
                if (curr.getType() != 15) continue;
                return ((LineNumberNode)curr).line;
            }
            return -1;
        }

        @JvmStatic
        public final int findLineNumber(@NotNull MethodNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.instructions != null && node.instructions.size() > 0) {
                AbstractInsnNode abstractInsnNode = node.instructions.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"node.instructions.get(0)");
                return this.findLineNumber(abstractInsnNode);
            }
            return -1;
        }

        @JvmStatic
        public final int findLineNumber(@NotNull ClassNode node) {
            MethodNode firstMethod;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.methods != null && !node.methods.isEmpty() && (firstMethod = this.getFirstRealMethod(node)) != null) {
                return this.findLineNumber(firstMethod);
            }
            return -1;
        }

        @JvmStatic
        private final MethodNode getFirstRealMethod(ClassNode classNode) {
            if (classNode.methods != null) {
                List methods = classNode.methods;
                for (MethodNode m : methods) {
                    Intrinsics.checkNotNull((Object)m, (String)"null cannot be cast to non-null type org.objectweb.asm.tree.MethodNode");
                    MethodNode method = m;
                    if (method.name.charAt(0) == '<') continue;
                    return method;
                }
                if (!classNode.methods.isEmpty()) {
                    Object e = classNode.methods.get(0);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.objectweb.asm.tree.MethodNode");
                    return (MethodNode)e;
                }
            }
            return null;
        }

        @JvmStatic
        private final boolean isAnonymousClass(String fqcn) {
            int lastIndex = StringsKt.lastIndexOf$default((CharSequence)fqcn, (char)'$', (int)0, (boolean)false, (int)6, null);
            return lastIndex != -1 && lastIndex < fqcn.length() - 1 && Character.isDigit(fqcn.charAt(lastIndex + 1));
        }

        @JvmStatic
        @NotNull
        public final String getFqcn(@NotNull String owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return StringsKt.replace$default((String)StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), (char)'$', (char)'.', (boolean)false, (int)4, null);
        }

        @JvmStatic
        @NotNull
        public final String createSignature(@Nullable String owner, @Nullable String name, @Nullable String desc) {
            StringBuilder sb = new StringBuilder(100);
            if (desc != null) {
                Type returnType = Type.getReturnType((String)desc);
                Intrinsics.checkNotNullExpressionValue((Object)returnType, (String)"returnType");
                sb.append(this.getTypeString(returnType));
                sb.append(' ');
            }
            if (owner != null) {
                sb.append(this.getFqcn(owner));
            }
            if (name != null) {
                Type[] argumentTypes;
                sb.append('#');
                sb.append(name);
                if (desc != null && (argumentTypes = Type.getArgumentTypes((String)desc)) != null && !(argumentTypes.length == 0)) {
                    sb.append('(');
                    boolean first = true;
                    for (Type type : argumentTypes) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                        sb.append(this.getTypeString(type));
                    }
                    sb.append(')');
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        @JvmStatic
        private final String getTypeString(Type type) {
            String string;
            String s = type.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
            if (StringsKt.startsWith$default((String)s, (String)"java.lang.", (boolean)false, (int)2, null)) {
                String string2 = s.substring("java.lang.".length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = s;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getInternalName(@NotNull String qualifiedName) {
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            String fqcn = qualifiedName;
            if (StringsKt.indexOf$default((CharSequence)fqcn, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                return fqcn;
            }
            int index2 = StringsKt.indexOf$default((CharSequence)fqcn, (char)'<', (int)0, (boolean)false, (int)6, null);
            if (index2 != -1) {
                String string = fqcn.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                fqcn = string;
            }
            if (StringsKt.indexOf$default((CharSequence)fqcn, (char)'$', (int)0, (boolean)false, (int)6, null) != -1) {
                return StringsKt.replace$default((String)fqcn, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
            StringBuilder sb = new StringBuilder(fqcn.length());
            String prev = null;
            for (String part : Splitter.on((char)'.').split((CharSequence)fqcn)) {
                if (prev != null && !(((CharSequence)prev).length() == 0)) {
                    if (Character.isUpperCase(prev.charAt(0))) {
                        sb.append('$');
                    } else {
                        sb.append('/');
                    }
                }
                sb.append(part);
                prev = part;
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

