/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001c\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0010J\"\u0010\u0015\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u0019\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry;", "", "file", "Ljava/io/File;", "jarFile", "binDir", "bytes", "", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;[B)V", "getBinDir", "()Ljava/io/File;", "getBytes", "()[B", "getFile", "getJarFile", "compareTo", "", "other", "path", "", "toString", "visit", "Lorg/objectweb/asm/tree/ClassNode;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "flags", "Lorg/objectweb/asm/ClassVisitor;", "visitor", "Companion", "SuperclassVisitor", "android.sdktools.lint-api"})
public final class ClassEntry
implements Comparable<ClassEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @Nullable
    private final File jarFile;
    @NotNull
    private final File binDir;
    @NotNull
    private final byte[] bytes;

    public ClassEntry(@NotNull File file, @Nullable File jarFile, @NotNull File binDir, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)binDir, (String)"binDir");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.file = file;
        this.jarFile = jarFile;
        this.binDir = binDir;
        this.bytes = bytes;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final File getBinDir() {
        return this.binDir;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    @NotNull
    public final String path() {
        Object object;
        if (this.jarFile != null) {
            object = this.jarFile.getPath() + ":" + this.file.getPath();
        } else {
            String string = this.file.getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            file.path\n        }");
        }
        return object;
    }

    @Override
    public int compareTo(@NotNull ClassEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String p1 = this.file.getPath();
        String p2 = other.file.getPath();
        int m1 = p1.length();
        int m2 = p2.length();
        if (m1 == m2 && Intrinsics.areEqual((Object)p1, (Object)p2)) {
            return 0;
        }
        int m = Math.min(m1, m2);
        for (int i = 0; i < m; ++i) {
            char c2;
            char c1 = p1.charAt(i);
            if (c1 == (c2 = p2.charAt(i))) continue;
            return c1 == '.' ? -1 : (c2 == '.' ? 1 : c1 - c2);
        }
        return m == m1 ? -1 : 1;
    }

    @NotNull
    public String toString() {
        String string = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        return string;
    }

    @Nullable
    public final ClassNode visit(@NotNull LintClient client, int flags) {
        ClassVisitor classVisitor;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        File file = this.jarFile;
        if (file == null) {
            file = this.file;
        }
        return (classVisitor = Companion.visit(client, file, this.file.getPath(), this.bytes, (ClassVisitor)new ClassNode(), flags)) instanceof ClassNode ? (ClassNode)classVisitor : null;
    }

    public static /* synthetic */ ClassNode visit$default(ClassEntry classEntry, LintClient lintClient, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return classEntry.visit(lintClient, n);
    }

    @Nullable
    public final ClassVisitor visit(@NotNull LintClient client, @NotNull ClassVisitor visitor2, int flags) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        File file = this.jarFile;
        if (file == null) {
            file = this.file;
        }
        return Companion.visit(client, file, this.file.getPath(), this.bytes, visitor2, flags);
    }

    public static /* synthetic */ ClassVisitor visit$default(ClassEntry classEntry, LintClient lintClient, ClassVisitor classVisitor, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return classEntry.visit(lintClient, classVisitor, n);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005JI\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry$SuperclassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "map", "", "", "(Ljava/util/Map;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "android.sdktools.lint-api"})
    private static final class SuperclassVisitor
    extends ClassVisitor {
        @NotNull
        private final Map<String, String> map;

        public SuperclassVisitor(@NotNull Map<String, String> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            super(589824);
            this.map = map2;
        }

        public void visit(int version2, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (superName != null && !Intrinsics.areEqual((Object)"java/lang/Object", (Object)superName)) {
                this.map.put(name, superName);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J,\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J(\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ6\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ<\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u001e2\b\b\u0002\u0010#\u001a\u00020$\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry$Companion;", "", "()V", "addClassFiles", "", "dir", "Ljava/io/File;", "classFiles", "", "addEntries", "client", "Lcom/android/tools/lint/client/api/LintClient;", "entries", "Lcom/android/tools/lint/client/api/ClassEntry;", "classPath", "", "addSuperClasses", "visitor", "Lcom/android/tools/lint/client/api/ClassEntry$SuperclassVisitor;", "createSuperClassMap", "", "", "libraryEntries", "classEntries", "fromClassFiles", "classFolders", "fromClassPath", "fromLazyClassPath", "", "visit", "Lorg/objectweb/asm/ClassVisitor;", "file", "relative", "bytes", "", "flags", "", "LazyClassEntryIterator", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ClassEntry> fromClassPath(@NotNull LintClient client, @NotNull List<? extends File> classPath) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
            if (!((Collection)classPath).isEmpty()) {
                void var3_3;
                List libraryEntries = new ArrayList(64);
                this.addEntries(client, libraryEntries, classPath);
                CollectionsKt.sort((List)libraryEntries);
                list2 = var3_3;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @NotNull
        public final List<ClassEntry> fromClassFiles(@NotNull LintClient client, @NotNull List<? extends File> classFiles, @NotNull List<? extends File> classFolders) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classFiles, (String)"classFiles");
            Intrinsics.checkNotNullParameter(classFolders, (String)"classFolders");
            List entries = new ArrayList(classFiles.size());
            if (!((Collection)classFolders).isEmpty()) {
                for (File file : classFiles) {
                    String path2 = file.getPath();
                    if (!file.isFile()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    if (!StringsKt.endsWith$default((String)path2, (String)".class", (boolean)false, (int)2, null)) continue;
                    try {
                        byte[] bytes = client.readBytes(file);
                        for (File file2 : classFolders) {
                            String string = file2.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.path");
                            if (!StringsKt.startsWith$default((String)path2, (String)string, (boolean)false, (int)2, null)) continue;
                            entries.add(new ClassEntry(file, null, file2, bytes));
                        }
                    }
                    catch (IOException e) {
                        client.log(e, null, new Object[0]);
                    }
                }
                if (!((Collection)entries).isEmpty()) {
                    CollectionsKt.sort((List)entries);
                }
            }
            return entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addEntries(LintClient client, List<ClassEntry> entries, List<? extends File> classPath) {
            for (File file : classPath) {
                Object[] objectArray;
                String name = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null)) {
                    Object object;
                    if (!file.exists()) continue;
                    try {
                        objectArray = (Object[])new ZipFile(file);
                        object = null;
                        try {
                            ZipFile jar = (ZipFile)objectArray;
                            boolean bl = false;
                            Enumeration<? extends ZipEntry> enumeration = jar.entries();
                            while (enumeration.hasMoreElements()) {
                                ZipEntry entry = enumeration.nextElement();
                                String string = entry.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                                try {
                                    Closeable closeable = jar.getInputStream(entry);
                                    Throwable throwable = null;
                                    try {
                                        InputStream stream = (InputStream)closeable;
                                        boolean bl2 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                                        byte[] bytes = ByteStreamsKt.readBytes((InputStream)stream);
                                        File file2 = new File(entry.getName());
                                        boolean bl3 = entries.add(new ClassEntry(file2, file, file, bytes));
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                }
                                catch (Throwable e) {
                                    client.log(e, null, new Object[0]);
                                }
                            }
                            jar = Unit.INSTANCE;
                        }
                        catch (Throwable jar) {
                            object = jar;
                            throw jar;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)objectArray, (Throwable)object);
                        }
                    }
                    catch (IOException e) {
                        object = new Object[]{file};
                        client.log(e, "Could not read jar file contents from %1$s", (Object[])object);
                    }
                    continue;
                }
                if (file.isDirectory()) {
                    List classFiles = new ArrayList();
                    this.addClassFiles(file, classFiles);
                    for (File file3 : classFiles) {
                        try {
                            byte[] bytes = client.readBytes(file3);
                            entries.add(new ClassEntry(file3, null, file, bytes));
                        }
                        catch (IOException e) {
                            client.log(e, null, new Object[0]);
                        }
                    }
                    continue;
                }
                if (StringsKt.endsWith$default((String)name, (String)".srcjar", (boolean)false, (int)2, null)) continue;
                objectArray = new Object[]{file};
                client.log(null, "Ignoring class path entry %1$s", objectArray);
            }
        }

        private final void addClassFiles(File dir, List<File> classFiles) {
            File[] fileArray = dir.listFiles();
            if (fileArray == null) {
                return;
            }
            File[] files2 = fileArray;
            if (!(files2.length == 0)) {
                for (File file : files2) {
                    if (file.isFile()) {
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                        if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                            classFiles.add(file);
                            continue;
                        }
                    }
                    if (!file.isDirectory()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    this.addClassFiles(file, classFiles);
                }
            }
        }

        @NotNull
        public final Iterator<ClassEntry> fromLazyClassPath(@NotNull LintClient client, @NotNull List<? extends File> classPath) {
            Iterator iterator;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
            if (!((Collection)classPath).isEmpty()) {
                iterator = new LazyClassEntryIterator(client, classPath);
            } else {
                Iterator iterator2 = Collections.emptyIterator();
                iterator = iterator2;
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"{\n                emptyIterator()\n            }");
            }
            return iterator;
        }

        @NotNull
        public final Map<String, String> createSuperClassMap(@NotNull LintClient client, @NotNull List<ClassEntry> libraryEntries, @NotNull List<ClassEntry> classEntries) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(libraryEntries, (String)"libraryEntries");
            Intrinsics.checkNotNullParameter(classEntries, (String)"classEntries");
            int size = libraryEntries.size() + classEntries.size();
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)size);
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(size)");
            Map map2 = hashMap;
            SuperclassVisitor visitor2 = new SuperclassVisitor(map2);
            this.addSuperClasses(client, visitor2, libraryEntries);
            this.addSuperClasses(client, visitor2, classEntries);
            return map2;
        }

        @NotNull
        public final Map<String, String> createSuperClassMap(@NotNull LintClient client, @NotNull List<ClassEntry> entries) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)entries.size());
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(entries.size)");
            Map map2 = hashMap;
            SuperclassVisitor visitor2 = new SuperclassVisitor(map2);
            this.addSuperClasses(client, visitor2, entries);
            return map2;
        }

        private final void addSuperClasses(LintClient client, SuperclassVisitor visitor2, List<ClassEntry> entries) {
            int flags = 7;
            for (ClassEntry entry : entries) {
                entry.visit(client, visitor2, flags);
            }
        }

        @Nullable
        public final ClassVisitor visit(@NotNull LintClient client, @NotNull File file, @Nullable String relative, @NotNull byte[] bytes, @NotNull ClassVisitor visitor2, int flags) {
            ClassVisitor classVisitor;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            try {
                ClassReader reader = new ClassReader(bytes);
                reader.accept(visitor2, flags);
                classVisitor = visitor2;
            }
            catch (Throwable t) {
                String message2;
                String string = t.getMessage();
                if (string == null) {
                    string = message2 = t.toString();
                }
                if (relative != null && t instanceof IllegalArgumentException && StringsKt.startsWith$default((String)message2, (String)"Unsupported class file", (boolean)false, (int)2, null) && (StringsKt.startsWith$default((String)relative, (String)"META-INF/versions/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"META-INF\\versions\\", (boolean)false, (int)2, null))) {
                    return null;
                }
                Object[] objectArray = new Object[2];
                String string2 = relative;
                objectArray[0] = file.getPath() + (String)(string2 != null ? ":" + string2 : "");
                objectArray[1] = message2;
                client.log(null, "Error processing %1$s: broken class file? (%2$s)", objectArray);
                classVisitor = null;
            }
            return classVisitor;
        }

        public static /* synthetic */ ClassVisitor visit$default(Companion companion, LintClient lintClient, File file, String string, byte[] byArray, ClassVisitor classVisitor, int n, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            return companion.visit(lintClient, file, string, byArray, classVisitor, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0002J\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\t\u0010\r\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry$Companion$LazyClassEntryIterator;", "", "Lcom/android/tools/lint/client/api/ClassEntry;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "classPath", "", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/util/List;)V", "classFileIndex", "", "classFiles", "classPathIndex", "next", "getNext", "()Lcom/android/tools/lint/client/api/ClassEntry;", "setNext", "(Lcom/android/tools/lint/client/api/ClassEntry;)V", "zipClassEntries", "zipClassEntriesIndex", "findNext", "hasNext", "", "android.sdktools.lint-api"})
        private static final class LazyClassEntryIterator
        implements Iterator<ClassEntry>,
        KMappedMarker {
            @NotNull
            private final LintClient client;
            @NotNull
            private final List<File> classPath;
            private int classPathIndex;
            @NotNull
            private List<? extends File> classFiles;
            private int classFileIndex;
            @NotNull
            private List<ClassEntry> zipClassEntries;
            private int zipClassEntriesIndex;
            @Nullable
            private ClassEntry next;

            public LazyClassEntryIterator(@NotNull LintClient client, @NotNull List<? extends File> classPath) {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
                this.client = client;
                this.classPath = classPath;
                this.classFiles = CollectionsKt.emptyList();
                this.zipClassEntries = CollectionsKt.emptyList();
                this.next = this.findNext();
            }

            @Nullable
            public final ClassEntry getNext() {
                return this.next;
            }

            public final void setNext(@Nullable ClassEntry classEntry) {
                this.next = classEntry;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            @NotNull
            public ClassEntry next() {
                ClassEntry classEntry = this.next;
                if (classEntry == null) {
                    throw new NoSuchElementException();
                }
                ClassEntry result = classEntry;
                this.next = this.findNext();
                return result;
            }

            private final ClassEntry findNext() {
                if (!((Collection)this.classFiles).isEmpty()) {
                    Object bytes;
                    int n = this.classFileIndex;
                    this.classFileIndex = n + 1;
                    File classFile = this.classFiles.get(n);
                    if (this.classFileIndex == this.classFiles.size()) {
                        this.classFiles = CollectionsKt.emptyList();
                    }
                    try {
                        bytes = this.client.readBytes(classFile);
                        bytes = new ClassEntry(classFile, null, this.classPath.get(this.classPathIndex - 1), (byte[])bytes);
                    }
                    catch (IOException e) {
                        this.client.log(e, null, new Object[0]);
                        bytes = this.findNext();
                    }
                    return bytes;
                }
                if (!((Collection)this.zipClassEntries).isEmpty()) {
                    int bytes = this.zipClassEntriesIndex;
                    this.zipClassEntriesIndex = bytes + 1;
                    ClassEntry entry = this.zipClassEntries.get(bytes);
                    if (this.zipClassEntriesIndex == this.zipClassEntries.size()) {
                        this.zipClassEntries = CollectionsKt.emptyList();
                    }
                    return entry;
                }
                while (this.classPathIndex < this.classPath.size()) {
                    int bytes = this.classPathIndex;
                    this.classPathIndex = bytes + 1;
                    File classPathEntry = this.classPath.get(bytes);
                    String path2 = classPathEntry.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    if (StringsKt.endsWith$default((String)path2, (String)".jar", (boolean)false, (int)2, null) && classPathEntry.isFile()) {
                        this.zipClassEntries = Companion.fromClassPath(this.client, CollectionsKt.listOf((Object)classPathEntry));
                        if (!(!((Collection)this.zipClassEntries).isEmpty())) continue;
                        this.zipClassEntriesIndex = 0;
                        return this.findNext();
                    }
                    if (classPathEntry.isDirectory()) {
                        ArrayList files2 = new ArrayList(64);
                        Companion.addClassFiles(classPathEntry, files2);
                        if (!(!((Collection)files2).isEmpty())) continue;
                        CollectionsKt.sort((List)files2);
                        this.classFiles = files2;
                        this.classFileIndex = 0;
                        return this.findNext();
                    }
                    if (StringsKt.endsWith$default((String)path2, (String)".srcjar", (boolean)false, (int)2, null)) continue;
                    Object[] objectArray = new Object[]{classPathEntry};
                    this.client.log(null, "Ignoring class path entry %1$s", objectArray);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }
}

