/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UImportStatement;

public class WrongImportDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("SuspiciousImport", "'`import android.R`' statement", "Importing `android.R` is usually not intentional; it sometimes happens when you use an IDE and ask it to automatically add imports at a time when your project's R class it not present.\n\nOnce the import is there you might get a lot of \"confusing\" error messages because of course the fields available on `android.R` are not the ones you'd expect from just looking at your own `R` class.", Category.CORRECTNESS, 9, Severity.WARNING, new Implementation(WrongImportDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true);

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UImportStatement.class);
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new ImportVisitor(context2);
    }

    private static class ImportVisitor
    extends UElementHandler {
        private final JavaContext context;

        public ImportVisitor(JavaContext context2) {
            this.context = context2;
        }

        @Override
        public void visitImportStatement(UImportStatement statement) {
            String qualifiedName;
            PsiElement resolved = statement.resolve();
            if (resolved instanceof PsiClass && "android.R".equals(qualifiedName = ((PsiClass)resolved).getQualifiedName())) {
                PsiElement psi = statement.getSourcePsi();
                if (psi instanceof KtImportDirective && ((KtImportDirective)psi).getAlias() != null) {
                    return;
                }
                Location location2 = this.context.getLocation((UElement)statement);
                this.context.report(ISSUE, (UElement)statement, location2, "Don't include `android.R` here; use a fully qualified name for each usage instead");
            }
        }
    }
}

