/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WearStandaloneAppDetector
extends Detector
implements XmlScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(WearStandaloneAppDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue INVALID_WEAR_FEATURE_ATTRIBUTE = Issue.create("InvalidWearFeatureAttribute", "Invalid attribute for Wear uses-feature", "For the `android.hardware.type.watch` uses-feature, android:required=\"false\" is disallowed. A single APK for Wear and non-Wear devices is not supported.\n", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/wearables/apps/packaging.html");
    public static final Issue WEAR_STANDALONE_APP_ISSUE = Issue.create("WearStandaloneAppFlag", "Invalid or missing Wear standalone app flag", "Wearable apps should specify whether they can work standalone, without a phone app. Add a valid meta-data entry for `com.google.android.wearable.standalone` to your application element and set the value to `true` or `false`.\n```xml\n<meta-data android:name=\"com.google.android.wearable.standalone\"\n           android:value=\"true\"/>`\n```\n", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/wearables/apps/packaging.html");
    public static final String WEARABLE_STANDALONE_ATTR = "com.google.android.wearable.standalone";
    public static final String KEY_QFX_EXTRA_MISSING_META_DATA = "metadata";
    private boolean sawWearUsesFeature;
    private boolean sawStandaloneMetadata;

    @Override
    public void beforeCheckFile(Context context2) {
        this.sawWearUsesFeature = false;
        this.sawStandaloneMetadata = false;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("uses-feature", "meta-data");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String tagName = element.getTagName();
        String attrName = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if ("uses-feature".equals(tagName)) {
            if ("android.hardware.type.watch".equals(attrName)) {
                this.sawWearUsesFeature = true;
                Attr requiredAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                if (requiredAttr != null && !Boolean.parseBoolean(requiredAttr.getValue())) {
                    context2.report(INVALID_WEAR_FEATURE_ATTRIBUTE, requiredAttr, context2.getLocation(requiredAttr), "`android:required=\"false\"` is not supported for this feature");
                }
            }
        } else if (this.sawWearUsesFeature && "meta-data".equals(tagName) && WEARABLE_STANDALONE_ATTR.equals(attrName) && element.getParentNode() != null && element.getParentNode().getNodeName().equals("application")) {
            this.sawStandaloneMetadata = true;
            Attr valueAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "value");
            if (valueAttr == null) {
                LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "value", "true").build();
                context2.report(WEAR_STANDALONE_APP_ISSUE, element, context2.getNameLocation(element), "Missing `android:value` attribute", fix);
            } else {
                String value = valueAttr.getValue();
                if (value == null || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    LintFix fixes = this.fix().alternatives(this.fix().replace().with("true").build(), this.fix().replace().with("false").build());
                    context2.report(WEAR_STANDALONE_APP_ISSUE, valueAttr, context2.getValueLocation(valueAttr), "Expecting a boolean value for attribute `android:value`", fixes);
                }
            }
        }
    }

    @Override
    public void afterCheckFile(Context context2) {
        if (this.sawWearUsesFeature && !this.sawStandaloneMetadata && context2.getProject().getTargetSdk() >= 23) {
            XmlContext xmlContext = (XmlContext)context2;
            Element root = xmlContext.document.getDocumentElement();
            Element application = XmlUtils.getFirstSubTagByName((Node)root, (String)"application");
            if (application != null) {
                Incident incident = new Incident(WEAR_STANDALONE_APP_ISSUE, application, xmlContext.getNameLocation(application), "Missing `<meta-data android:name=\"com.google.android.wearable.standalone\" ../>` element", this.fix().data(KEY_QFX_EXTRA_MISSING_META_DATA, true));
                Constraint constraint2 = Constraints.targetSdkAtLeast(23).and(Constraints.notLibraryProject());
                xmlContext.report(incident, constraint2);
            }
        }
    }
}

