/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ViewBindingTypeDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.SdkUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J(\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J(\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 H\u0016J \u0010!\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J&\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0014\u0010'\u001a\n (*\u0004\u0018\u00010\b0\b*\u00020\u000bH\u0002J\f\u0010)\u001a\u00020\b*\u00020\u001eH\u0002J\f\u0010)\u001a\u00020\b*\u00020\u0011H\u0002R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/ViewBindingTypeDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "layoutToBindingIdPairs", "", "Lcom/android/ide/common/util/PathString;", "Lcom/google/common/collect/Multimap;", "", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "Lcom/android/tools/lint/detector/api/Context;", "getEvaluator", "(Lcom/android/tools/lint/detector/api/Context;)Lcom/android/tools/lint/client/api/JavaEvaluator;", "addViewBindingTypesForId", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "map", "attachLocations", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "location", "Lcom/android/tools/lint/detector/api/Location;", "id", "layout", "checkConsistentAcrossLayouts", "idAttribute", "Lorg/w3c/dom/Attr;", "element", "Lorg/w3c/dom/Element;", "getApplicableAttributes", "", "getViewBindingTypesForId", "item", "Lcom/android/ide/common/resources/ResourceItem;", "file", "visitAttribute", "attribute", "toLayoutName", "kotlin.jvm.PlatformType", "toTagOrClass", "Companion", "android.sdktools.lint-checks"})
public final class ViewBindingTypeDetector
extends LayoutDetector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<PathString, Multimap<String, String>> layoutToBindingIdPairs;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ViewBindingTypeDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"viewBindingType");
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://schemas.android.com/tools")) {
            return;
        }
        boolean isDataBindingLayout = Intrinsics.areEqual((Object)context2.document.getDocumentElement().getTagName(), (Object)"layout");
        if (isDataBindingLayout) {
            context2.report(new Incident(ISSUE, "`tools:viewBindingType` is not applicable in data binding layouts.", context2.getLocation(attribute)));
        } else {
            Element element = attribute.getOwnerElement();
            String tagName = element.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"include")) {
                context2.report(new Incident(ISSUE, "`tools:viewBindingType` is not applicable on `<" + tagName + ">` tags.", context2.getLocation(attribute)));
            } else {
                String typeTag = attribute.getValue();
                JavaEvaluator evaluator = this.getEvaluator(context2);
                Intrinsics.checkNotNullExpressionValue((Object)typeTag, (String)"typeTag");
                PsiClass psiClass = ViewTypeDetector.Companion.findViewForTag(typeTag, evaluator);
                if (psiClass == null || !JavaEvaluator.extendsClass$default(evaluator, psiClass, "android.view.View", false, 4, null)) {
                    context2.report(new Incident(ISSUE, "`tools:viewBindingType` (`" + typeTag + "`) must refer to a class that inherits from `android.view.View`", context2.getLocation(attribute)));
                } else {
                    Attr idAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id");
                    if (idAttribute == null) {
                        context2.report(new Incident(ISSUE, "`tools:viewBindingType` should be defined on a tag that also defines an `android:id`. Otherwise, its value won't have any effect.", context2.getLocation(attribute)));
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                        String tagView = this.toTagOrClass(element);
                        PsiClass psiClass2 = ViewTypeDetector.Companion.findViewForTag(typeTag, evaluator);
                        String typeClass = psiClass2 != null ? psiClass2.getQualifiedName() : null;
                        PsiClass tagClass = ViewTypeDetector.Companion.findViewForTag(tagView, evaluator);
                        if (typeClass != null && tagClass != null && !JavaEvaluator.extendsClass$default(evaluator, tagClass, typeClass, false, 4, null)) {
                            context2.report(new Incident(ISSUE, "`tools:viewBindingType` (`" + typeTag + "`) is not compatible (i.e. a match or superclass) with its tag (`" + tagView + "`).", context2.getLocation(attribute)));
                        } else {
                            this.checkConsistentAcrossLayouts(context2, idAttribute, evaluator, element);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentAcrossLayouts(XmlContext context2, Attr idAttribute, JavaEvaluator evaluator, Element element) {
        boolean full = context2.isGlobalAnalysis();
        LintClient client = context2.getClient();
        Project project = full ? context2.getMainProject() : context2.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        ResourceUrl resourceUrl = ResourceUrl.parse((String)idAttribute.getValue());
        if (resourceUrl != null && resourceUrl.type == ResourceType.ID && !resourceUrl.isFramework()) {
            String id = resourceUrl.name;
            List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ID, id);
            if (items.size() > 1) {
                String layout = this.toLayoutName(context2);
                Set bindingTypes = new LinkedHashSet();
                for (Object item : items) {
                    Collection<String> it;
                    Object fileName;
                    Object object = item.getSource();
                    if (object == null) continue;
                    if ((object = object.getFileName()) == null || !Intrinsics.areEqual((Object)SdkUtils.fileNameToResourceName((String)(fileName = object)), (Object)layout)) continue;
                    Context context3 = context2;
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                    if (this.getViewBindingTypesForId(context3, (ResourceItem)item) == null) continue;
                    boolean bl = false;
                    bindingTypes.addAll(it);
                }
                if (bindingTypes.size() > 1) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object item;
                    item = bindingTypes;
                    boolean $i$f$map = false;
                    void var17_22 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Object object = ViewTypeDetector.Companion.findViewForTag((String)it, evaluator);
                        if (object == null || (object = object.getQualifiedName()) == null) {
                            object = it;
                        }
                        collection.add(object);
                    }
                    SortedSet views = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                    Location location2 = context2.getLocation(element);
                    Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                    Intrinsics.checkNotNullExpressionValue((Object)layout, (String)"layout");
                    this.attachLocations(context2, location2, id, layout);
                    context2.report(new Incident(ISSUE, "`tools:viewBindingType` is not defined consistently, with the following types resolved across layouts: " + CollectionsKt.joinToString$default((Iterable)views, null, null, null, (int)0, null, (Function1)checkConsistentAcrossLayouts.2.INSTANCE, (int)31, null), location2));
                }
            }
        }
    }

    private final void attachLocations(XmlContext context2, Location location2, String id, String layout) {
        if (Scope.Companion.checkSingleFile(context2.getDriver().getScope())) {
            return;
        }
        List locations = new ArrayList();
        Map<PathString, Multimap<String, String>> map2 = this.layoutToBindingIdPairs;
        if (map2 != null) {
            Map<PathString, Multimap<String, String>> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<PathString, Multimap<String, String>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                File file;
                Map.Entry<PathString, Multimap<String, String>> element$iv;
                Map.Entry<PathString, Multimap<String, String>> entry = element$iv = iterator.next();
                boolean bl = false;
                PathString path2 = entry.getKey();
                Multimap<String, String> u = entry.getValue();
                if (!Intrinsics.areEqual((Object)SdkUtils.fileNameToResourceName((String)path2.getFileName()), (Object)layout)) continue;
                Set types = new LinkedHashSet();
                for (Map.Entry entry2 : u.entries()) {
                    Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"u.entries()");
                    String k = (String)entry2.getKey();
                    String v = (String)entry2.getValue();
                    if (!Intrinsics.areEqual((Object)id, (Object)k)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                    types.add(v);
                }
                if (!(!((Collection)types).isEmpty()) || (file = path2.toFile()) == null || Intrinsics.areEqual((Object)file, (Object)context2.file)) continue;
                Location l = Location.Companion.create(file);
                String list2 = Lint.formatList$default(CollectionsKt.sorted((Iterable)types), 0, 2, null);
                l.setMessage("Using `viewBindingType` " + list2 + " here", false);
                locations.add(l);
            }
        }
        Location prev = location2;
        Iterable $this$sortedBy$iv = locations;
        boolean $i$f$sortedBy = false;
        for (Location l : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Location it = (Location)a;
                boolean bl = false;
                Comparable comparable = it.getFile();
                it = (Location)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getFile());
            }
        })) {
            prev.setSecondary(l);
            prev = l;
        }
    }

    private final String toLayoutName(Context $this$toLayoutName) {
        return SdkUtils.fileNameToResourceName((String)$this$toLayoutName.file.getName());
    }

    private final String toTagOrClass(Element $this$toTagOrClass) {
        String string;
        if (Intrinsics.areEqual((Object)$this$toTagOrClass.getTagName(), (Object)"view")) {
            String string2;
            String it = string2 = $this$toTagOrClass.getAttribute("class");
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            string = ((CharSequence)it).length() > 0 ? string2 : null;
            if (string == null) {
                string = "android.view.View";
            }
        } else {
            String string3 = $this$toTagOrClass.getTagName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            tagName\n        }");
        }
        return string;
    }

    private final String toTagOrClass(XmlPullParser $this$toTagOrClass) {
        String string;
        String tag = $this$toTagOrClass.getName();
        if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
            string = $this$toTagOrClass.getAttributeValue(null, "class");
            if (string == null) {
                string = "android.view.View";
            }
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
            string = tag;
        }
        return string;
    }

    private final JavaEvaluator getEvaluator(Context $this$evaluator) {
        return $this$evaluator.getClient().getUastParser($this$evaluator.getProject()).getEvaluator();
    }

    private final Collection<String> getViewBindingTypesForId(Context context2, ResourceItem item) {
        PathString pathString = item.getSource();
        if (pathString == null) {
            return null;
        }
        PathString source = pathString;
        Multimap<String, String> multimap = this.getViewBindingTypesForId(context2, source);
        if (multimap == null) {
            return null;
        }
        Multimap<String, String> map2 = multimap;
        return map2.get((Object)item.getName());
    }

    private final Multimap<String, String> getViewBindingTypesForId(Context context2, PathString file) {
        Map cache;
        Multimap map2;
        if (!StringsKt.endsWith$default((String)file.getFileName(), (String)".xml", (boolean)false, (int)2, null)) {
            return null;
        }
        Map map3 = this.layoutToBindingIdPairs;
        if (map3 == null) {
            Map map4;
            Map it = map4 = (Map)new LinkedHashMap();
            boolean bl = false;
            this.layoutToBindingIdPairs = it;
            map3 = map4;
        }
        if ((map2 = (cache = map3).get(file)) == null) {
            map2 = (Multimap)ArrayListMultimap.create();
            cache.put(file, map2);
            try {
                XmlPullParser parser = context2.getClient().createXmlPullParser(file);
                if (parser != null) {
                    this.addViewBindingTypesForId(parser, (Multimap<String, String>)map2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map2;
    }

    private final void addViewBindingTypesForId(XmlPullParser parser, Multimap<String, String> map2) {
        block4: while (true) {
            int event = parser.next();
            switch (event) {
                case 2: {
                    String id;
                    if (parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id") == null) continue block4;
                    String string = parser.getAttributeValue("http://schemas.android.com/tools", "viewBindingType");
                    String binding = string == null ? this.toTagOrClass(parser) : string;
                    if (!(((CharSequence)id).length() > 0) || !(((CharSequence)binding).length() > 0) || map2.containsEntry((Object)(id = Lint.stripIdPrefix(id)), (Object)binding)) continue block4;
                    map2.put((Object)id, (Object)binding);
                    continue block4;
                }
                case 1: {
                    return;
                }
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "ViewBindingType", "`tools:viewBindingType` issues", "All issues related to using the View Binding `tools:viewBindingType` attribute.", implementation, null, category, 1, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/ViewBindingTypeDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

