/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/VectorDrawableCompatDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "skipChecks", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableAttributes", "", "", "getApplicableElements", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
public final class VectorDrawableCompatDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean skipChecks;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean bl = this.skipChecks = context2.getProject().getMinSdk() >= 21;
        if (LintClient.Companion.isStudio()) {
            this.skipChecks = true;
        }
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return !this.skipChecks && (folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT);
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"vector", "animated-vector"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (context2.getProject().getMinSdk() >= 21 || context2.getResourceFolderType() != ResourceFolderType.DRAWABLE) {
            return;
        }
        LintModelVariant lintModelVariant = context2.getProject().getBuildVariant();
        if (lintModelVariant == null) {
            return;
        }
        boolean usingLibraryVectors = lintModelVariant.getUseSupportLibraryVectorDrawables();
        String string = context2.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
        String name = ResourcesUtil.fileNameToResourceName((String)string);
        context2.getPartialResults(ISSUE).map().put(name, usingLibraryVectors);
    }

    @Override
    @Nullable
    public Collection<String> getApplicableAttributes() {
        Collection collection;
        if (this.skipChecks) {
            collection = null;
        } else {
            Object[] objectArray = new String[]{"src", "srcCompat"};
            collection = CollectionsKt.listOf((Object[])objectArray);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        Location location2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (context2.getResourceFolderType() != ResourceFolderType.LAYOUT) {
            return;
        }
        String name = attribute.getLocalName();
        String namespace = attribute.getNamespaceURI();
        if (Intrinsics.areEqual((Object)"src", (Object)name) && !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace) || Intrinsics.areEqual((Object)"srcCompat", (Object)name) && !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res-auto", (Object)namespace)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)attribute.getValue());
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        PartialResult partialResults = context2.getPartialResults(ISSUE);
        String drawableName = resourceUrl2.name;
        Boolean useSupportLibrary = null;
        Project project = context2.getProject();
        LintMap lintMap = partialResults.map();
        Intrinsics.checkNotNullExpressionValue((Object)drawableName, (String)"drawableName");
        Boolean currentProjectPartialResultBool = LintMap.getBoolean$default(lintMap, drawableName, null, 2, null);
        if (currentProjectPartialResultBool != null) {
            useSupportLibrary = currentProjectPartialResultBool;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = partialResults;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(it != context2.getProject())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Map.Entry projectToMap : (List)destination$iv$iv) {
                Boolean partialResultBool = LintMap.getBoolean$default((LintMap)projectToMap.getValue(), drawableName, null, 2, null);
                if (partialResultBool == null) continue;
                useSupportLibrary = partialResultBool;
                project = (Project)projectToMap.getKey();
                break;
            }
        }
        if (useSupportLibrary == null) {
            return;
        }
        if (useSupportLibrary.booleanValue() && Intrinsics.areEqual((Object)"src", (Object)name)) {
            location2 = context2.getNameLocation(attribute);
            String message2 = "When using VectorDrawableCompat, you need to use `app:srcCompat`";
            Incident incident = new Incident(ISSUE, attribute, location2, message2);
            context2.report(incident, Constraints.minSdkLessThan(21));
        } else if (!useSupportLibrary.booleanValue() && Intrinsics.areEqual((Object)"srcCompat", (Object)name)) {
            location2 = context2.getNameLocation(attribute);
            Object path2 = "build.gradle";
            LintModelModule model2 = project.getBuildModule();
            if (model2 != null) {
                path2 = model2.getModulePath() + File.separator + (String)path2;
            }
            String message3 = "To use VectorDrawableCompat, you need to set `android.defaultConfig.vectorDrawables.useSupportLibrary = true` in `" + (String)path2 + "`";
            Incident incident = new Incident(ISSUE, attribute, location2, message3);
            context2.report(incident, Constraints.minSdkLessThan(21));
        }
    }

    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE};
        ISSUE = Issue.Companion.create("VectorDrawableCompat", "Using VectorDrawableCompat", "\n                To use VectorDrawableCompat, you need to make two modifications to your project. \\\n                First, set `android.defaultConfig.vectorDrawables.useSupportLibrary = true` in your \\\n                `build.gradle` file, and second, use `app:srcCompat` instead of `android:src` to \\\n                refer to vector drawables.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(VectorDrawableCompatDetector.class, Scope.ALL_RESOURCES_SCOPE, enumSetArray)).addMoreInfo("https://developer.android.com/guide/topics/graphics/vector-drawable-resources").addMoreInfo("https://medium.com/androiddevelopers/using-vector-assets-in-android-apps-4318fd662eb9");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/VectorDrawableCompatDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

