/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnsafeBroadcastReceiverDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    public static final Issue ACTION_STRING = Issue.create("UnsafeProtectedBroadcastReceiver", "Unsafe Protected `BroadcastReceiver`", "`BroadcastReceiver`s that declare an intent-filter for a protected-broadcast action string must check that the received intent's action string matches the expected value, otherwise it is possible for malicious actors to spoof intents.", Category.SECURITY, 6, Severity.WARNING, new Implementation(UnsafeBroadcastReceiverDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE), Scope.JAVA_FILE_SCOPE));
    public static final Issue BROADCAST_SMS = Issue.create("UnprotectedSMSBroadcastReceiver", "Unprotected SMS `BroadcastReceiver`", "BroadcastReceivers that declare an intent-filter for `SMS_DELIVER` or `SMS_RECEIVED` must ensure that the caller has the `BROADCAST_SMS` permission, otherwise it is possible for malicious actors to spoof intents.", Category.SECURITY, 6, Severity.WARNING, new Implementation(UnsafeBroadcastReceiverDetector.class, Scope.MANIFEST_SCOPE));
    private Set<String> mReceiversWithProtectedBroadcastIntentFilter = null;

    @VisibleForTesting
    static boolean isProtectedBroadcast(String actionName) {
        switch (actionName) {
            case "EventConditionProvider.EVALUATE": 
            case "NotificationHistoryDatabase.CLEANUP": 
            case "NotificationManagerService.TIMEOUT": 
            case "ScheduleConditionProvider.EVALUATE": 
            case "SnoozeHelper.EVALUATE": 
            case "action.cne.started": 
            case "android.accounts.LOGIN_ACCOUNTS_CHANGED": 
            case "android.accounts.action.ACCOUNT_REMOVED": 
            case "android.accounts.action.VISIBLE_ACCOUNTS_CHANGED": 
            case "android.app.action.ACTION_PASSWORD_CHANGED": 
            case "android.app.action.ACTION_PASSWORD_EXPIRING": 
            case "android.app.action.ACTION_PASSWORD_FAILED": 
            case "android.app.action.ACTION_PASSWORD_SUCCEEDED": 
            case "android.app.action.AFFILIATED_PROFILE_TRANSFER_OWNERSHIP_COMPLETE": 
            case "android.app.action.APPLICATION_DELEGATION_SCOPES_CHANGED": 
            case "android.app.action.APP_BLOCK_STATE_CHANGED": 
            case "android.app.action.AUTOMATIC_ZEN_RULE_STATUS_CHANGED": 
            case "android.app.action.BUGREPORT_FAILED": 
            case "android.app.action.BUGREPORT_SHARE": 
            case "android.app.action.BUGREPORT_SHARING_DECLINED": 
            case "android.app.action.CHOOSE_PRIVATE_KEY_ALIAS": 
            case "android.app.action.CLOSE_NOTIFICATION_HANDLER_PANEL": 
            case "android.app.action.COMPLIANCE_ACKNOWLEDGEMENT_REQUIRED": 
            case "android.app.action.DEVICE_ADMIN_DISABLED": 
            case "android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED": 
            case "android.app.action.DEVICE_ADMIN_ENABLED": 
            case "android.app.action.DEVICE_OWNER_CHANGED": 
            case "android.app.action.DEVICE_POLICY_CONSTANTS_CHANGED": 
            case "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED": 
            case "android.app.action.DEVICE_POLICY_RESOURCE_UPDATED": 
            case "android.app.action.ENTER_CAR_MODE": 
            case "android.app.action.ENTER_CAR_MODE_PRIORITIZED": 
            case "android.app.action.ENTER_DESK_MODE": 
            case "android.app.action.EXIT_CAR_MODE": 
            case "android.app.action.EXIT_CAR_MODE_PRIORITIZED": 
            case "android.app.action.EXIT_DESK_MODE": 
            case "android.app.action.INTERRUPTION_FILTER_CHANGED": 
            case "android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL": 
            case "android.app.action.LOCK_TASK_ENTERING": 
            case "android.app.action.LOCK_TASK_EXITING": 
            case "android.app.action.LOST_MODE_LOCATION_UPDATE": 
            case "android.app.action.MANAGED_PROFILE_PROVISIONED": 
            case "android.app.action.MANAGED_USER_CREATED": 
            case "android.app.action.NETWORK_LOGS_AVAILABLE": 
            case "android.app.action.NEXT_ALARM_CLOCK_CHANGED": 
            case "android.app.action.NOTIFICATION_CHANNEL_BLOCK_STATE_CHANGED": 
            case "android.app.action.NOTIFICATION_CHANNEL_GROUP_BLOCK_STATE_CHANGED": 
            case "android.app.action.NOTIFICATION_LISTENER_ENABLED_CHANGED": 
            case "android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED": 
            case "android.app.action.NOTIFICATION_POLICY_CHANGED": 
            case "android.app.action.NOTIFY_PENDING_SYSTEM_UPDATE": 
            case "android.app.action.PROFILE_OWNER_CHANGED": 
            case "android.app.action.PROVISIONING_COMPLETED": 
            case "android.app.action.RESET_PROTECTION_POLICY_CHANGED": 
            case "android.app.action.SCHEDULE_EXACT_ALARM_PERMISSION_STATE_CHANGED": 
            case "android.app.action.SECURITY_LOGS_AVAILABLE": 
            case "android.app.action.SHOW_DEVICE_MONITORING_DIALOG": 
            case "android.app.action.SHOW_NEW_USER_DISCLAIMER": 
            case "android.app.action.STATSD_STARTED": 
            case "android.app.action.SYSTEM_UPDATE_POLICY_CHANGED": 
            case "android.app.action.TRANSFER_OWNERSHIP_COMPLETE": 
            case "android.app.action.USER_ADDED": 
            case "android.app.action.USER_REMOVED": 
            case "android.app.action.USER_STARTED": 
            case "android.app.action.USER_STOPPED": 
            case "android.app.action.USER_SWITCHED": 
            case "android.app.backup.intent.CLEAR": 
            case "android.app.backup.intent.INIT": 
            case "android.appwidget.action.APPWIDGET_DELETED": 
            case "android.appwidget.action.APPWIDGET_DISABLED": 
            case "android.appwidget.action.APPWIDGET_ENABLED": 
            case "android.appwidget.action.APPWIDGET_HOST_RESTORED": 
            case "android.appwidget.action.APPWIDGET_RESTORED": 
            case "android.appwidget.action.APPWIDGET_UPDATE_OPTIONS": 
            case "android.bluetooth.a2dp-sink.profile.action.AUDIO_CONFIG_CHANGED": 
            case "android.bluetooth.a2dp-sink.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.a2dp-sink.profile.action.PLAYING_STATE_CHANGED": 
            case "android.bluetooth.a2dp.profile.action.ACTIVE_DEVICE_CHANGED": 
            case "android.bluetooth.a2dp.profile.action.CODEC_CONFIG_CHANGED": 
            case "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED": 
            case "android.bluetooth.action.CSIS_CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.action.CSIS_DEVICE_AVAILABLE": 
            case "android.bluetooth.action.CSIS_SET_MEMBER_AVAILABLE": 
            case "android.bluetooth.action.LE_AUDIO_ACTIVE_DEVICE_CHANGED": 
            case "android.bluetooth.action.LE_AUDIO_CONF_CHANGED": 
            case "android.bluetooth.action.LE_AUDIO_CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.action.LE_AUDIO_GROUP_NODE_STATUS_CHANGED": 
            case "android.bluetooth.action.LE_AUDIO_GROUP_STATUS_CHANGED": 
            case "android.bluetooth.action.TETHERING_STATE_CHANGED": 
            case "android.bluetooth.adapter.action.BLE_ACL_CONNECTED": 
            case "android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED": 
            case "android.bluetooth.adapter.action.BLE_STATE_CHANGED": 
            case "android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED": 
            case "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.adapter.action.DISCOVERY_FINISHED": 
            case "android.bluetooth.adapter.action.DISCOVERY_STARTED": 
            case "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED": 
            case "android.bluetooth.adapter.action.SCAN_MODE_CHANGED": 
            case "android.bluetooth.adapter.action.STATE_CHANGED": 
            case "android.bluetooth.avrcp-controller.profile.action.BROWSE_CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.avrcp-controller.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.avrcp-controller.profile.action.FOLDER_LIST": 
            case "android.bluetooth.avrcp-controller.profile.action.TRACK_EVENT": 
            case "android.bluetooth.device.action.ACL_CONNECTED": 
            case "android.bluetooth.device.action.ACL_DISCONNECTED": 
            case "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED": 
            case "android.bluetooth.device.action.ALIAS_CHANGED": 
            case "android.bluetooth.device.action.BATTERY_LEVEL_CHANGED": 
            case "android.bluetooth.device.action.BOND_STATE_CHANGED": 
            case "android.bluetooth.device.action.CLASS_CHANGED": 
            case "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL": 
            case "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY": 
            case "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST": 
            case "android.bluetooth.device.action.FOUND": 
            case "android.bluetooth.device.action.MAS_INSTANCE": 
            case "android.bluetooth.device.action.NAME_CHANGED": 
            case "android.bluetooth.device.action.NAME_FAILED": 
            case "android.bluetooth.device.action.PAIRING_CANCEL": 
            case "android.bluetooth.device.action.PAIRING_REQUEST": 
            case "android.bluetooth.device.action.SDP_RECORD": 
            case "android.bluetooth.device.action.UUID": 
            case "android.bluetooth.devicepicker.action.DEVICE_SELECTED": 
            case "android.bluetooth.devicepicker.action.LAUNCH": 
            case "android.bluetooth.headset.action.HF_INDICATORS_VALUE_CHANGED": 
            case "android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT": 
            case "android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED": 
            case "android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED": 
            case "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.headsetclient.profile.action.AG_CALL_CHANGED": 
            case "android.bluetooth.headsetclient.profile.action.AG_EVENT": 
            case "android.bluetooth.headsetclient.profile.action.AUDIO_STATE_CHANGED": 
            case "android.bluetooth.headsetclient.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.headsetclient.profile.action.LAST_VTAG": 
            case "android.bluetooth.headsetclient.profile.action.NETWORK_SERVICE_STATE_CHANGED": 
            case "android.bluetooth.headsetclient.profile.action.RESULT": 
            case "android.bluetooth.hearingaid.profile.action.ACTIVE_DEVICE_CHANGED": 
            case "android.bluetooth.hearingaid.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.hearingaid.profile.action.PLAYING_STATE_CHANGED": 
            case "android.bluetooth.hiddevice.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.input.profile.action.HANDSHAKE": 
            case "android.bluetooth.input.profile.action.IDLE_TIME_CHANGED": 
            case "android.bluetooth.input.profile.action.PROTOCOL_MODE_CHANGED": 
            case "android.bluetooth.input.profile.action.REPORT": 
            case "android.bluetooth.input.profile.action.VIRTUAL_UNPLUG_STATUS": 
            case "android.bluetooth.intent.DISCOVERABLE_TIMEOUT": 
            case "android.bluetooth.map.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.mapmce.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.mapmce.profile.action.MESSAGE_DELETED_STATUS_CHANGED": 
            case "android.bluetooth.mapmce.profile.action.MESSAGE_DELIVERED_SUCCESSFULLY": 
            case "android.bluetooth.mapmce.profile.action.MESSAGE_READ_STATUS_CHANGED": 
            case "android.bluetooth.mapmce.profile.action.MESSAGE_RECEIVED": 
            case "android.bluetooth.mapmce.profile.action.MESSAGE_SENT_SUCCESSFULLY": 
            case "android.bluetooth.pan.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.pbap.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.pbapclient.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.sap.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.bluetooth.volume-control.profile.action.CONNECTION_STATE_CHANGED": 
            case "android.btopp.intent.action.ACCEPT": 
            case "android.btopp.intent.action.CONFIRM": 
            case "android.btopp.intent.action.DECLINE": 
            case "android.btopp.intent.action.HIDE": 
            case "android.btopp.intent.action.HIDE_COMPLETE": 
            case "android.btopp.intent.action.INCOMING_FILE_NOTIFICATION": 
            case "android.btopp.intent.action.LIST": 
            case "android.btopp.intent.action.OPEN": 
            case "android.btopp.intent.action.OPEN_INBOUND": 
            case "android.btopp.intent.action.OPEN_OUTBOUND": 
            case "android.btopp.intent.action.RETRY": 
            case "android.btopp.intent.action.STOP_HANDOVER_TRANSFER": 
            case "android.btopp.intent.action.TRANSFER_COMPLETE": 
            case "android.btopp.intent.action.USER_CONFIRMATION_TIMEOUT": 
            case "android.btopp.intent.action.WHITELIST_DEVICE": 
            case "android.content.action.PERMISSION_RESPONSE_RECEIVED": 
            case "android.content.action.REQUEST_PERMISSION": 
            case "android.content.jobscheduler.JOB_DEADLINE_EXPIRED": 
            case "android.content.jobscheduler.JOB_DELAY_EXPIRED": 
            case "android.content.pm.action.SESSION_COMMITTED": 
            case "android.content.pm.action.SESSION_UPDATED": 
            case "android.content.syncmanager.SYNC_ALARM": 
            case "android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED": 
            case "android.hardware.usb.action.USB_ACCESSORY_ATTACHED": 
            case "android.hardware.usb.action.USB_ACCESSORY_DETACHED": 
            case "android.hardware.usb.action.USB_ACCESSORY_HANDSHAKE": 
            case "android.hardware.usb.action.USB_DEVICE_ATTACHED": 
            case "android.hardware.usb.action.USB_DEVICE_DETACHED": 
            case "android.hardware.usb.action.USB_PORT_CHANGED": 
            case "android.hardware.usb.action.USB_STATE": 
            case "android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED": 
            case "android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED": 
            case "android.intent.action.ACTION_IDLE_MAINTENANCE_END": 
            case "android.intent.action.ACTION_IDLE_MAINTENANCE_START": 
            case "android.intent.action.ACTION_MANAGED_ROAMING_IND": 
            case "android.intent.action.ACTION_MDN_STATE_CHANGED": 
            case "android.intent.action.ACTION_POWER_CONNECTED": 
            case "android.intent.action.ACTION_POWER_DISCONNECTED": 
            case "android.intent.action.ACTION_PREFERRED_ACTIVITY_CHANGED": 
            case "android.intent.action.ACTION_SET_RADIO_CAPABILITY_DONE": 
            case "android.intent.action.ACTION_SET_RADIO_CAPABILITY_FAILED": 
            case "android.intent.action.ACTION_SHUTDOWN": 
            case "android.intent.action.ACTION_SUBINFO_CONTENT_CHANGE": 
            case "android.intent.action.ACTION_SUBINFO_RECORD_UPDATED": 
            case "android.intent.action.ACTION_UNSOL_RESPONSE_OEM_HOOK_RAW": 
            case "android.intent.action.ADVANCED_SETTINGS": 
            case "android.intent.action.AIRPLANE_MODE": 
            case "android.intent.action.ANR": 
            case "android.intent.action.ANY_DATA_STATE": 
            case "android.intent.action.APPLICATION_LOCALE_CHANGED": 
            case "android.intent.action.APPLICATION_RESTRICTIONS_CHANGED": 
            case "android.intent.action.BATTERY_CHANGED": 
            case "android.intent.action.BATTERY_LEVEL_CHANGED": 
            case "android.intent.action.BATTERY_LOW": 
            case "android.intent.action.BATTERY_OKAY": 
            case "android.intent.action.BOOT_COMPLETED": 
            case "android.intent.action.CALL": 
            case "android.intent.action.CALL_PRIVILEGED": 
            case "android.intent.action.CANCEL_ENABLE_ROLLBACK": 
            case "android.intent.action.CHARGING": 
            case "android.intent.action.CONFIGURATION_CHANGED": 
            case "android.intent.action.CONTENT_CHANGED": 
            case "android.intent.action.DATA_SMS_RECEIVED": 
            case "android.intent.action.DATA_STALL_DETECTED": 
            case "android.intent.action.DATE_CHANGED": 
            case "android.intent.action.DEVICE_CUSTOMIZATION_READY": 
            case "android.intent.action.DEVICE_LOCKED_CHANGED": 
            case "android.intent.action.DEVICE_STORAGE_FULL": 
            case "android.intent.action.DEVICE_STORAGE_LOW": 
            case "android.intent.action.DEVICE_STORAGE_NOT_FULL": 
            case "android.intent.action.DEVICE_STORAGE_OK": 
            case "android.intent.action.DISCHARGING": 
            case "android.intent.action.DISTRACTING_PACKAGES_CHANGED": 
            case "android.intent.action.DOCK_ACTIVE": 
            case "android.intent.action.DOCK_EVENT": 
            case "android.intent.action.DOCK_IDLE": 
            case "android.intent.action.DOMAINS_NEED_VERIFICATION": 
            case "android.intent.action.DREAMING_STARTED": 
            case "android.intent.action.DREAMING_STOPPED": 
            case "android.intent.action.DROPBOX_ENTRY_ADDED": 
            case "android.intent.action.DYNAMIC_SENSOR_CHANGED": 
            case "android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED": 
            case "android.intent.action.EMERGENCY_CALL_STATE_CHANGED": 
            case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": 
            case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": 
            case "android.intent.action.GET_RESTRICTION_ENTRIES": 
            case "android.intent.action.GLOBAL_BUTTON": 
            case "android.intent.action.HDMI_PLUGGED": 
            case "android.intent.action.HEADSET_PLUG": 
            case "android.intent.action.INCIDENT_REPORT_READY": 
            case "android.intent.action.INPUT_METHOD_CHANGED": 
            case "android.intent.action.INTENT_FILTER_NEEDS_VERIFICATION": 
            case "android.intent.action.LOCALE_CHANGED": 
            case "android.intent.action.LOCKED_BOOT_COMPLETED": 
            case "android.intent.action.MANAGED_PROFILE_ADDED": 
            case "android.intent.action.MANAGED_PROFILE_AVAILABLE": 
            case "android.intent.action.MANAGED_PROFILE_REMOVED": 
            case "android.intent.action.MANAGED_PROFILE_UNAVAILABLE": 
            case "android.intent.action.MANAGED_PROFILE_UNLOCKED": 
            case "android.intent.action.MASTER_CLEAR_NOTIFICATION": 
            case "android.intent.action.MEDIA_BAD_REMOVAL": 
            case "android.intent.action.MEDIA_CHECKING": 
            case "android.intent.action.MEDIA_EJECT": 
            case "android.intent.action.MEDIA_MOUNTED": 
            case "android.intent.action.MEDIA_NOFS": 
            case "android.intent.action.MEDIA_REMOVED": 
            case "android.intent.action.MEDIA_RESOURCE_GRANTED": 
            case "android.intent.action.MEDIA_SHARED": 
            case "android.intent.action.MEDIA_UNMOUNTABLE": 
            case "android.intent.action.MEDIA_UNMOUNTED": 
            case "android.intent.action.MEDIA_UNSHARED": 
            case "android.intent.action.MY_PACKAGE_REPLACED": 
            case "android.intent.action.MY_PACKAGE_SUSPENDED": 
            case "android.intent.action.MY_PACKAGE_UNSUSPENDED": 
            case "android.intent.action.NEW_OUTGOING_CALL": 
            case "android.intent.action.OVERLAY_ADDED": 
            case "android.intent.action.OVERLAY_CHANGED": 
            case "android.intent.action.OVERLAY_PRIORITY_CHANGED": 
            case "android.intent.action.OVERLAY_REMOVED": 
            case "android.intent.action.PACKAGES_SUSPENDED": 
            case "android.intent.action.PACKAGES_SUSPENSION_CHANGED": 
            case "android.intent.action.PACKAGES_UNSUSPENDED": 
            case "android.intent.action.PACKAGE_ADDED": 
            case "android.intent.action.PACKAGE_CHANGED": 
            case "android.intent.action.PACKAGE_DATA_CLEARED": 
            case "android.intent.action.PACKAGE_ENABLE_ROLLBACK": 
            case "android.intent.action.PACKAGE_FIRST_LAUNCH": 
            case "android.intent.action.PACKAGE_FULLY_LOADED": 
            case "android.intent.action.PACKAGE_FULLY_REMOVED": 
            case "android.intent.action.PACKAGE_INSTALL": 
            case "android.intent.action.PACKAGE_NEEDS_INTEGRITY_VERIFICATION": 
            case "android.intent.action.PACKAGE_NEEDS_VERIFICATION": 
            case "android.intent.action.PACKAGE_REMOVED": 
            case "android.intent.action.PACKAGE_REMOVED_INTERNAL": 
            case "android.intent.action.PACKAGE_REPLACED": 
            case "android.intent.action.PACKAGE_RESTARTED": 
            case "android.intent.action.PACKAGE_UNSUSPENDED_MANUALLY": 
            case "android.intent.action.PACKAGE_VERIFIED": 
            case "android.intent.action.PENDING_INCIDENT_REPORTS_CHANGED": 
            case "android.intent.action.PHONE_STATE": 
            case "android.intent.action.PRECISE_CALL_STATE": 
            case "android.intent.action.PRE_BOOT_COMPLETED": 
            case "android.intent.action.PROFILE_ACCESSIBLE": 
            case "android.intent.action.PROFILE_INACCESSIBLE": 
            case "android.intent.action.PROXY_CHANGE": 
            case "android.intent.action.QUERY_PACKAGE_RESTART": 
            case "android.intent.action.RADIO_TECHNOLOGY": 
            case "android.intent.action.REBOOT": 
            case "android.intent.action.ROLLBACK_COMMITTED": 
            case "android.intent.action.SCREEN_OFF": 
            case "android.intent.action.SCREEN_ON": 
            case "android.intent.action.SERVICE_STATE": 
            case "android.intent.action.SHOW_FOREGROUND_SERVICE_MANAGER": 
            case "android.intent.action.SIG_STR": 
            case "android.intent.action.SIM_STATE_CHANGED": 
            case "android.intent.action.SPLIT_CONFIGURATION_CHANGED": 
            case "android.intent.action.SUBSCRIPTION_INFO_RECORD_ADDED": 
            case "android.intent.action.SUBSCRIPTION_PHONE_STATE": 
            case "android.intent.action.SUB_DEFAULT_CHANGED": 
            case "android.intent.action.THERMAL_EVENT": 
            case "android.intent.action.TIMEZONE_CHANGED": 
            case "android.intent.action.TIME_SET": 
            case "android.intent.action.TIME_TICK": 
            case "android.intent.action.TWILIGHT_CHANGED": 
            case "android.intent.action.UID_REMOVED": 
            case "android.intent.action.USER_ACTIVITY_NOTIFICATION": 
            case "android.intent.action.USER_ADDED": 
            case "android.intent.action.USER_BACKGROUND": 
            case "android.intent.action.USER_FOREGROUND": 
            case "android.intent.action.USER_INFO_CHANGED": 
            case "android.intent.action.USER_INITIALIZE": 
            case "android.intent.action.USER_PRESENT": 
            case "android.intent.action.USER_REMOVED": 
            case "android.intent.action.USER_STARTED": 
            case "android.intent.action.USER_STARTING": 
            case "android.intent.action.USER_STOPPED": 
            case "android.intent.action.USER_STOPPING": 
            case "android.intent.action.USER_SWITCHED": 
            case "android.intent.action.USER_UNLOCKED": 
            case "android.intent.action.WALLPAPER_CHANGED": 
            case "android.intent.action.internal_sim_state_changed": 
            case "android.internal.policy.action.BURN_IN_PROTECTION": 
            case "android.location.MODE_CHANGED": 
            case "android.location.PROVIDERS_CHANGED": 
            case "android.location.action.GNSS_CAPABILITIES_CHANGED": 
            case "android.media.ACTION_SCO_AUDIO_STATE_UPDATED": 
            case "android.media.AUDIO_BECOMING_NOISY": 
            case "android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION": 
            case "android.media.MASTER_BALANCE_CHANGED_ACTION": 
            case "android.media.MASTER_MONO_CHANGED_ACTION": 
            case "android.media.MASTER_MUTE_CHANGED_ACTION": 
            case "android.media.MASTER_VOLUME_CHANGED_ACTION": 
            case "android.media.RINGER_MODE_CHANGED": 
            case "android.media.SCO_AUDIO_STATE_CHANGED": 
            case "android.media.STREAM_DEVICES_CHANGED_ACTION": 
            case "android.media.STREAM_MUTE_CHANGED_ACTION": 
            case "android.media.VIBRATE_SETTING_CHANGED": 
            case "android.media.VOLUME_CHANGED_ACTION": 
            case "android.media.action.HDMI_AUDIO_PLUG": 
            case "android.media.action.MICROPHONE_MUTE_CHANGED": 
            case "android.media.action.SPEAKERPHONE_STATE_CHANGED": 
            case "android.media.tv.action.CHANNEL_BROWSABLE_REQUESTED": 
            case "android.media.tv.action.PARENTAL_CONTROLS_ENABLED_CHANGED": 
            case "android.media.tv.action.PREVIEW_PROGRAM_ADDED_TO_WATCH_NEXT": 
            case "android.media.tv.action.PREVIEW_PROGRAM_BROWSABLE_DISABLED": 
            case "android.media.tv.action.WATCH_NEXT_PROGRAM_BROWSABLE_DISABLED": 
            case "android.net.ConnectivityService.action.PKT_CNT_SAMPLE_INTERVAL_ELAPSED": 
            case "android.net.action.CLEAR_DNS_CACHE": 
            case "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED": 
            case "android.net.conn.CAPTIVE_PORTAL": 
            case "android.net.conn.CAPTIVE_PORTAL_TEST_COMPLETED": 
            case "android.net.conn.CONNECTIVITY_CHANGE": 
            case "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE": 
            case "android.net.conn.CONNECTIVITY_CHANGE_SUPL": 
            case "android.net.conn.DATA_ACTIVITY_CHANGE": 
            case "android.net.conn.INET_CONDITION_ACTION": 
            case "android.net.conn.NETWORK_CONDITIONS_MEASURED": 
            case "android.net.conn.RESTRICT_BACKGROUND_CHANGED": 
            case "android.net.conn.TETHER_STATE_CHANGED": 
            case "android.net.nsd.STATE_CHANGED": 
            case "android.net.proxy.PAC_REFRESH": 
            case "android.net.scoring.SCORER_CHANGED": 
            case "android.net.scoring.SCORE_NETWORKS": 
            case "android.net.sip.SIP_SERVICE_UP": 
            case "android.net.sip.action.SIP_CALL_OPTION_CHANGED": 
            case "android.net.sip.action.SIP_INCOMING_CALL": 
            case "android.net.sip.action.SIP_REMOVE_PROFILE": 
            case "android.net.sip.action.SIP_SERVICE_UP": 
            case "android.net.sip.action.START_SIP": 
            case "android.net.wifi.CONFIGURED_NETWORKS_CHANGE": 
            case "android.net.wifi.LINK_CONFIGURATION_CHANGED": 
            case "android.net.wifi.PASSPOINT_ICON_RECEIVED": 
            case "android.net.wifi.RSSI_CHANGED": 
            case "android.net.wifi.SCAN_RESULTS": 
            case "android.net.wifi.STATE_CHANGE": 
            case "android.net.wifi.WIFI_AP_STATE_CHANGED": 
            case "android.net.wifi.WIFI_CREDENTIAL_CHANGED": 
            case "android.net.wifi.WIFI_STATE_CHANGED": 
            case "android.net.wifi.action.NETWORK_SETTINGS_RESET": 
            case "android.net.wifi.action.PASSPOINT_DEAUTH_IMMINENT": 
            case "android.net.wifi.action.PASSPOINT_ICON": 
            case "android.net.wifi.action.PASSPOINT_LAUNCH_OSU_VIEW": 
            case "android.net.wifi.action.PASSPOINT_OSU_PROVIDERS_LIST": 
            case "android.net.wifi.action.PASSPOINT_SUBSCRIPTION_REMEDIATION": 
            case "android.net.wifi.action.REFRESH_USER_PROVISIONING": 
            case "android.net.wifi.action.WIFI_NETWORK_SUGGESTION_POST_CONNECTION": 
            case "android.net.wifi.action.WIFI_SCAN_AVAILABILITY_CHANGED": 
            case "android.net.wifi.aware.action.WIFI_AWARE_RESOURCE_CHANGED": 
            case "android.net.wifi.aware.action.WIFI_AWARE_STATE_CHANGED": 
            case "android.net.wifi.p2p.CONNECTION_STATE_CHANGE": 
            case "android.net.wifi.p2p.DISCOVERY_STATE_CHANGE": 
            case "android.net.wifi.p2p.PEERS_CHANGED": 
            case "android.net.wifi.p2p.STATE_CHANGED": 
            case "android.net.wifi.p2p.THIS_DEVICE_CHANGED": 
            case "android.net.wifi.p2p.action.WIFI_P2P_PERSISTENT_GROUPS_CHANGED": 
            case "android.net.wifi.rtt.action.WIFI_RTT_STATE_CHANGED": 
            case "android.net.wifi.supplicant.CONNECTION_CHANGE": 
            case "android.net.wifi.supplicant.STATE_CHANGE": 
            case "android.nfc.action.ADAPTER_STATE_CHANGED": 
            case "android.nfc.action.PREFERRED_PAYMENT_CHANGED": 
            case "android.nfc.action.REQUIRE_UNLOCK_FOR_NFC": 
            case "android.nfc.action.TRANSACTION_DETECTED": 
            case "android.nfc.handover.intent.action.HANDOVER_SEND": 
            case "android.nfc.handover.intent.action.HANDOVER_SEND_MULTIPLE": 
            case "android.nfc.handover.intent.action.HANDOVER_STARTED": 
            case "android.nfc.handover.intent.action.TRANSFER_DONE": 
            case "android.nfc.handover.intent.action.TRANSFER_PROGRESS": 
            case "android.os.UpdateLock.UPDATE_LOCK_CHANGED": 
            case "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED": 
            case "android.os.action.CHARGING": 
            case "android.os.action.DEVICE_IDLE_MODE_CHANGED": 
            case "android.os.action.DISCHARGING": 
            case "android.os.action.ENHANCED_DISCHARGE_PREDICTION_CHANGED": 
            case "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED": 
            case "android.os.action.LOW_POWER_STANDBY_ENABLED_CHANGED": 
            case "android.os.action.POWER_SAVE_MODE_CHANGED": 
            case "android.os.action.POWER_SAVE_MODE_CHANGED_INTERNAL": 
            case "android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED": 
            case "android.os.action.POWER_SAVE_WHITELIST_CHANGED": 
            case "android.os.action.SCREEN_BRIGHTNESS_BOOST_CHANGED": 
            case "android.os.action.SETTING_RESTORED": 
            case "android.os.action.USER_RESTRICTIONS_CHANGED": 
            case "android.os.storage.action.DISK_SCANNED": 
            case "android.os.storage.action.VOLUME_STATE_CHANGED": 
            case "android.permission.CLEAR_APP_GRANTED_URI_PERMISSIONS": 
            case "android.permission.GET_APP_GRANTED_URI_PERMISSIONS": 
            case "android.provider.Telephony.MMS_DOWNLOADED": 
            case "android.provider.Telephony.SECRET_CODE": 
            case "android.provider.Telephony.SIM_FULL": 
            case "android.provider.Telephony.SMS_CB_RECEIVED": 
            case "android.provider.Telephony.SMS_DELIVER": 
            case "android.provider.Telephony.SMS_RECEIVED": 
            case "android.provider.Telephony.SMS_REJECTED": 
            case "android.provider.Telephony.SMS_SERVICE_CATEGORY_PROGRAM_DATA_RECEIVED": 
            case "android.provider.Telephony.WAP_PUSH_DELIVER": 
            case "android.provider.Telephony.WAP_PUSH_RECEIVED": 
            case "android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED": 
            case "android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED_INTERNAL": 
            case "android.provider.action.SMS_EMERGENCY_CB_RECEIVED": 
            case "android.provider.action.SMS_MMS_DB_CREATED": 
            case "android.provider.action.SMS_MMS_DB_LOST": 
            case "android.safetycenter.action.REFRESH_SAFETY_SOURCES": 
            case "android.safetycenter.action.SAFETY_CENTER_ENABLED_CHANGED": 
            case "android.scheduling.action.REBOOT_READY": 
            case "android.se.omapi.action.SECURE_ELEMENT_STATE_CHANGED": 
            case "android.search.action.SEARCHABLES_CHANGED": 
            case "android.security.STORAGE_CHANGED": 
            case "android.security.action.KEYCHAIN_CHANGED": 
            case "android.security.action.KEY_ACCESS_CHANGED": 
            case "android.security.action.TRUST_STORE_CHANGED": 
            case "android.server.notification.action.DISABLE_NAS": 
            case "android.server.notification.action.ENABLE_NAS": 
            case "android.server.notification.action.LEARNMORE_NAS": 
            case "android.service.autofill.action.DELAYED_FILL": 
            case "android.settings.action.GRAYSCALE_CHANGED": 
            case "android.telecom.action.CURRENT_TTY_MODE_CHANGED": 
            case "android.telecom.action.DEFAULT_DIALER_CHANGED": 
            case "android.telecom.action.NUISANCE_CALL_STATUS_CHANGED": 
            case "android.telecom.action.PHONE_ACCOUNT_REGISTERED": 
            case "android.telecom.action.PHONE_ACCOUNT_UNREGISTERED": 
            case "android.telecom.action.POST_CALL": 
            case "android.telecom.action.SHOW_MISSED_CALLS_NOTIFICATION": 
            case "android.telephony.action.ANOMALY_REPORTED": 
            case "android.telephony.action.CARRIER_CONFIG_CHANGED": 
            case "android.telephony.action.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE": 
            case "android.telephony.action.CARRIER_SIGNAL_PCO_VALUE": 
            case "android.telephony.action.CARRIER_SIGNAL_REDIRECTED": 
            case "android.telephony.action.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED": 
            case "android.telephony.action.CARRIER_SIGNAL_RESET": 
            case "android.telephony.action.DEFAULT_SMS_SUBSCRIPTION_CHANGED": 
            case "android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED": 
            case "android.telephony.action.MULTI_SIM_CONFIG_CHANGED": 
            case "android.telephony.action.NETWORK_COUNTRY_CHANGED": 
            case "android.telephony.action.PRIMARY_SUBSCRIPTION_LIST_CHANGED": 
            case "android.telephony.action.SECRET_CODE": 
            case "android.telephony.action.SERVICE_PROVIDERS_UPDATED": 
            case "android.telephony.action.SHOW_NOTICE_ECM_BLOCK_OTHERS": 
            case "android.telephony.action.SHOW_VOICEMAIL_NOTIFICATION": 
            case "android.telephony.action.SIM_APPLICATION_STATE_CHANGED": 
            case "android.telephony.action.SIM_CARD_STATE_CHANGED": 
            case "android.telephony.action.SIM_SLOT_STATUS_CHANGED": 
            case "android.telephony.action.SUBSCRIPTION_CARRIER_IDENTITY_CHANGED": 
            case "android.telephony.action.SUBSCRIPTION_PLANS_CHANGED": 
            case "android.telephony.action.SUBSCRIPTION_SPECIFIC_CARRIER_IDENTITY_CHANGED": 
            case "android.telephony.action.TOGGLE_PROVISION": 
            case "android.telephony.euicc.action.OTA_STATUS_CHANGED": 
            case "android.telephony.ims.action.RCS_SINGLE_REGISTRATION_CAPABILITY_UPDATE": 
            case "android.telephony.ims.action.WFC_IMS_REGISTRATION_ERROR": 
            case "com.android.bluetooth.BluetoothMapContentObserver.action.MESSAGE_DELIVERY": 
            case "com.android.bluetooth.BluetoothMapContentObserver.action.MESSAGE_SENT": 
            case "com.android.bluetooth.btservice.action.ALARM_WAKEUP": 
            case "com.android.bluetooth.gatt.REFRESH_BATCHED_SCAN": 
            case "com.android.bluetooth.map.USER_CONFIRM_TIMEOUT": 
            case "com.android.bluetooth.pbap.authcancelled": 
            case "com.android.bluetooth.pbap.authchall": 
            case "com.android.bluetooth.pbap.authresponse": 
            case "com.android.bluetooth.pbap.userconfirmtimeout": 
            case "com.android.bluetooth.sap.USER_CONFIRM_TIMEOUT": 
            case "com.android.bluetooth.sap.action.DISCONNECT_ACTION": 
            case "com.android.cellbroadcastreceiver.GET_LATEST_CB_AREA_INFO": 
            case "com.android.content.pm.action.CAN_INTERACT_ACROSS_PROFILES_CHANGED": 
            case "com.android.ims.ACTION_PRESENCE_CHANGED": 
            case "com.android.ims.ACTION_PUBLISH_STATUS_CHANGED": 
            case "com.android.ims.ACTION_RCS_SERVICE_AVAILABLE": 
            case "com.android.ims.ACTION_RCS_SERVICE_DIED": 
            case "com.android.ims.ACTION_RCS_SERVICE_UNAVAILABLE": 
            case "com.android.ims.IMS_INCOMING_CALL": 
            case "com.android.ims.IMS_SERVICE_DOWN": 
            case "com.android.ims.IMS_SERVICE_UP": 
            case "com.android.ims.internal.uce.UCE_SERVICE_DOWN": 
            case "com.android.ims.internal.uce.UCE_SERVICE_UP": 
            case "com.android.imsconnection.DISCONNECTED": 
            case "com.android.intent.action.IMS_CONFIG_CHANGED": 
            case "com.android.intent.action.IMS_FEATURE_CHANGED": 
            case "com.android.intent.action.timezone.RULES_UPDATE_OPERATION": 
            case "com.android.intent.action.timezone.TRIGGER_RULES_UPDATE_CHECK": 
            case "com.android.intent.isim_refresh": 
            case "com.android.internal.action.EUICC_FACTORY_RESET": 
            case "com.android.internal.action.EUICC_REMOVE_INVISIBLE_SUBSCRIPTIONS": 
            case "com.android.internal.intent.action.BUGREPORT_REQUESTED": 
            case "com.android.internal.location.ALARM_TIMEOUT": 
            case "com.android.internal.location.ALARM_WAKEUP": 
            case "com.android.internal.provider.action.VOICEMAIL_SMS_RECEIVED": 
            case "com.android.internal.stk.alpha_notify": 
            case "com.android.internal.stk.command": 
            case "com.android.internal.stk.icc_status_change": 
            case "com.android.internal.stk.session_end": 
            case "com.android.internal.telephony.ACTION_CARRIER_CERTIFICATE_DOWNLOAD": 
            case "com.android.internal.telephony.ACTION_LINE1_NUMBER_ERROR_DETECTED": 
            case "com.android.internal.telephony.ACTION_TEST_OVERRIDE_CARRIER_ID": 
            case "com.android.internal.telephony.ACTION_VOWIFI_ENABLED": 
            case "com.android.internal.telephony.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE": 
            case "com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE": 
            case "com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED": 
            case "com.android.internal.telephony.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED": 
            case "com.android.internal.telephony.CARRIER_SIGNAL_RESET": 
            case "com.android.internal.telephony.CARRIER_VVM_PACKAGE_INSTALLED": 
            case "com.android.internal.telephony.OPEN_DEFAULT_SMS_APP": 
            case "com.android.internal.telephony.PROVISION": 
            case "com.android.internal.telephony.action.COUNTRY_OVERRIDE": 
            case "com.android.internal.telephony.carrier_key_download_alarm": 
            case "com.android.internal.telephony.data-restart-trysetup": 
            case "com.android.internal.telephony.data-stall": 
            case "com.android.internal.telephony.provisioning_apn_alarm": 
            case "com.android.nfc.action.LLCP_DOWN": 
            case "com.android.nfc.action.LLCP_UP": 
            case "com.android.nfc.cardemulation.action.CLOSE_TAP_DIALOG": 
            case "com.android.nfc.handover.action.ALLOW_CONNECT": 
            case "com.android.nfc.handover.action.CANCEL_HANDOVER_TRANSFER": 
            case "com.android.nfc.handover.action.DENY_CONNECT": 
            case "com.android.nfc.handover.action.TIMEOUT_CONNECT": 
            case "com.android.nfc_extras.action.AID_SELECTED": 
            case "com.android.nfc_extras.action.RF_FIELD_OFF_DETECTED": 
            case "com.android.nfc_extras.action.RF_FIELD_ON_DETECTED": 
            case "com.android.phone.SIP_ADD_PHONE": 
            case "com.android.phone.settings.CARRIER_PROVISIONING": 
            case "com.android.phone.settings.TRIGGER_CARRIER_PROVISIONING": 
            case "com.android.phone.vvm.ACTION_VISUAL_VOICEMAIL_SERVICE_EVENT": 
            case "com.android.phone.vvm.omtp.sms.REQUEST_SENT": 
            case "com.android.server.ACTION_EXPIRED_PASSWORD_NOTIFICATION": 
            case "com.android.server.ACTION_PROFILE_OFF_DEADLINE": 
            case "com.android.server.ACTION_TRIGGER_IDLE": 
            case "com.android.server.ACTION_TURN_PROFILE_ON_NOTIFICATION": 
            case "com.android.server.NetworkTimeUpdateService.action.POLL": 
            case "com.android.server.Wifi.action.TOGGLE_PNO": 
            case "com.android.server.WifiManager.action.DELAYED_DRIVER_STOP": 
            case "com.android.server.WifiManager.action.DEVICE_IDLE": 
            case "com.android.server.WifiManager.action.START_PNO": 
            case "com.android.server.WifiManager.action.START_SCAN": 
            case "com.android.server.action.NETWORK_STATS_POLL": 
            case "com.android.server.action.NETWORK_STATS_UPDATED": 
            case "com.android.server.action.REMOTE_BUGREPORT_SHARING_ACCEPTED": 
            case "com.android.server.action.REMOTE_BUGREPORT_SHARING_DECLINED": 
            case "com.android.server.action.RESET_TWILIGHT_AUTO": 
            case "com.android.server.action.UPDATE_TWILIGHT_STATE": 
            case "com.android.server.adb.WIRELESS_DEBUG_PAIRED_DEVICES": 
            case "com.android.server.adb.WIRELESS_DEBUG_PAIRING_RESULT": 
            case "com.android.server.adb.WIRELESS_DEBUG_STATUS": 
            case "com.android.server.am.DELETE_DUMPHEAP": 
            case "com.android.server.biometrics.face.ACTION_LOCKOUT_RESET": 
            case "com.android.server.biometrics.fingerprint.ACTION_LOCKOUT_RESET": 
            case "com.android.server.connectivity.tethering.PROVISIONING_RECHECK_ALARM": 
            case "com.android.server.connectivityservice.CONNECTED_TO_PROVISIONING_NETWORK_ACTION": 
            case "com.android.server.device_idle.STEP_IDLE_STATE": 
            case "com.android.server.device_idle.STEP_LIGHT_IDLE_STATE": 
            case "com.android.server.fingerprint.ACTION_LOCKOUT_RESET": 
            case "com.android.server.inputmethod.InputMethodManagerService.SHOW_INPUT_METHOD_PICKER": 
            case "com.android.server.jobscheduler.FORCE_IDLE": 
            case "com.android.server.jobscheduler.GARAGE_MODE_OFF": 
            case "com.android.server.jobscheduler.GARAGE_MODE_ON": 
            case "com.android.server.jobscheduler.UNFORCE_IDLE": 
            case "com.android.server.net.action.SNOOZE_RAPID": 
            case "com.android.server.net.action.SNOOZE_WARNING": 
            case "com.android.server.notification.CountdownConditionProvider": 
            case "com.android.server.pm.DISABLE_QUIET_MODE_AFTER_UNLOCK": 
            case "com.android.server.retaildemo.ACTION_RESET_DEMO": 
            case "com.android.server.stats.action.TRIGGER_COLLECTION": 
            case "com.android.server.telecom.intent.action.CALLS_ADD_ENTRY": 
            case "com.android.server.usb.ACTION_OPEN_IN_APPS": 
            case "com.android.server.wifi.ACTION_SHOW_SET_RANDOMIZATION_DETAILS": 
            case "com.android.server.wifi.ConnectToNetworkNotification.CONNECT_TO_NETWORK": 
            case "com.android.server.wifi.ConnectToNetworkNotification.PICK_NETWORK_AFTER_FAILURE": 
            case "com.android.server.wifi.ConnectToNetworkNotification.PICK_WIFI_NETWORK": 
            case "com.android.server.wifi.ConnectToNetworkNotification.USER_DISMISSED_NOTIFICATION": 
            case "com.android.server.wifi.action.CarrierNetwork.USER_ALLOWED_CARRIER": 
            case "com.android.server.wifi.action.CarrierNetwork.USER_DISALLOWED_CARRIER": 
            case "com.android.server.wifi.action.CarrierNetwork.USER_DISMISSED": 
            case "com.android.server.wifi.action.NetworkSuggestion.USER_ALLOWED_APP": 
            case "com.android.server.wifi.action.NetworkSuggestion.USER_DISALLOWED_APP": 
            case "com.android.server.wifi.action.NetworkSuggestion.USER_DISMISSED": 
            case "com.android.server.wifi.wakeup.DISMISS_NOTIFICATION": 
            case "com.android.server.wifi.wakeup.OPEN_WIFI_PREFERENCES": 
            case "com.android.server.wifi.wakeup.OPEN_WIFI_SETTINGS": 
            case "com.android.server.wifi.wakeup.TURN_OFF_WIFI_WAKE": 
            case "com.android.server.wm.ACTION_REVOKE_SYSTEM_ALERT_WINDOW_PERMISSION": 
            case "com.android.settings.bluetooth.ACTION_DISMISS_PAIRING": 
            case "com.android.settings.location.MODE_CHANGING": 
            case "com.android.settings.network.DELETE_SUBSCRIPTION": 
            case "com.android.settings.network.SWITCH_TO_SUBSCRIPTION": 
            case "com.android.settings.wifi.action.NETWORK_REQUEST": 
            case "com.android.sync.SYNC_CONN_STATUS_CHANGED": 
            case "intent.action.ACTION_RF_BAND_INFO": 
            case "wifi_scan_available": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("receiver");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String tag = element.getTagName();
        if ("receiver".equals(tag)) {
            Element filter2;
            String name = Lint.resolveManifestName(element);
            String permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            if (permission == null || permission.isEmpty()) {
                Element parent = (Element)element.getParentNode();
                permission = parent.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            }
            if ((filter2 = XmlUtils.getFirstSubTagByName((Node)element, (String)"intent-filter")) != null) {
                for (Element action : XmlUtils.getSubTagsByName((Node)filter2, (String)"action")) {
                    String actionName = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (("android.provider.Telephony.SMS_DELIVER".equals(actionName) || "android.provider.Telephony.SMS_RECEIVED".equals(actionName)) && !"android.permission.BROADCAST_SMS".equals(permission)) {
                        LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "permission", "android.permission.BROADCAST_SMS").build();
                        context2.report(BROADCAST_SMS, element, context2.getNameLocation(element), "BroadcastReceivers that declare an intent-filter for `SMS_DELIVER` or `SMS_RECEIVED` must ensure that the caller has the `BROADCAST_SMS` permission, otherwise it is possible for malicious actors to spoof intents", fix);
                        continue;
                    }
                    if (!UnsafeBroadcastReceiverDetector.isProtectedBroadcast(actionName)) continue;
                    if (this.mReceiversWithProtectedBroadcastIntentFilter == null) {
                        this.mReceiversWithProtectedBroadcastIntentFilter = Sets.newHashSet();
                    }
                    this.mReceiversWithProtectedBroadcastIntentFilter.add(name);
                }
            }
        }
    }

    private Set<String> getReceiversWithProtectedBroadcastIntentFilter(Context context2) {
        if (this.mReceiversWithProtectedBroadcastIntentFilter == null) {
            Element application;
            Project mainProject;
            Document mergedManifest;
            this.mReceiversWithProtectedBroadcastIntentFilter = Sets.newHashSet();
            if (!context2.getScope().contains((Object)Scope.MANIFEST) && (mergedManifest = (mainProject = context2.getMainProject()).getMergedManifest()) != null && mergedManifest.getDocumentElement() != null && (application = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application")) != null) {
                for (Element element : XmlUtils.getSubTags((Node)application)) {
                    Element filter2;
                    if (!"receiver".equals(element.getTagName()) || (filter2 = XmlUtils.getFirstSubTagByName((Node)element, (String)"intent-filter")) == null) continue;
                    for (Element action : XmlUtils.getSubTagsByName((Node)filter2, (String)"action")) {
                        String actionName = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (!UnsafeBroadcastReceiverDetector.isProtectedBroadcast(actionName)) continue;
                        String name = Lint.resolveManifestName(element);
                        this.mReceiversWithProtectedBroadcastIntentFilter.add(name);
                    }
                }
            }
        }
        return this.mReceiversWithProtectedBroadcastIntentFilter;
    }

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.content.BroadcastReceiver");
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        String name = declaration.getName();
        if (name == null) {
            return;
        }
        String qualifiedName = declaration.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        if (!this.getReceiversWithProtectedBroadcastIntentFilter(context2).contains(qualifiedName)) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        for (PsiMethod method : declaration.findMethodsByName("onReceive", false)) {
            if (!evaluator.parametersMatch(method, "android.content.Context", "android.content.Intent")) continue;
            UnsafeBroadcastReceiverDetector.checkOnReceive(context2, method);
        }
    }

    private static void checkOnReceive(JavaContext context2, PsiMethod method) {
        PsiParameter parameter = method.getParameterList().getParameters()[1];
        OnReceiveVisitor visitor2 = new OnReceiveVisitor(context2.getEvaluator(), parameter);
        UastFacade.INSTANCE.getMethodBody(method).accept((UastVisitor)visitor2);
        if (!visitor2.getCallsGetAction()) {
            String report2 = !visitor2.getUsesIntent() ? "This broadcast receiver declares an intent-filter for a protected broadcast action string, which can only be sent by the system, not third-party applications. However, the receiver's `onReceive` method does not appear to call `getAction` to ensure that the received Intent's action string matches the expected value, potentially making it possible for another actor to send a spoofed intent with no action string or a different action string and cause undesired behavior." : "This broadcast receiver declares an intent-filter for a protected broadcast action string, which can only be sent by the system, not third-party applications. However, the receiver's onReceive method does not appear to call getAction to ensure that the received Intent's action string matches the expected value, potentially making it possible for another actor to send a spoofed intent with no action string or a different action string and cause undesired behavior. In this case, it is possible that the onReceive method passed the received Intent to another method that checked the action string. If so, this finding can safely be ignored.";
            Location location2 = context2.getNameLocation((PsiElement)method);
            context2.report(ACTION_STRING, (PsiElement)method, location2, report2);
        }
    }

    private static class OnReceiveVisitor
    extends AbstractUastVisitor {
        private final JavaEvaluator mEvaluator;
        private final PsiParameter mParameter;
        private boolean mCallsGetAction;
        private boolean mUsesIntent;

        public OnReceiveVisitor(JavaEvaluator context2, PsiParameter parameter) {
            this.mEvaluator = context2;
            this.mParameter = parameter;
        }

        public boolean getCallsGetAction() {
            return this.mCallsGetAction;
        }

        public boolean getUsesIntent() {
            return this.mUsesIntent;
        }

        public boolean visitCallExpression(UCallExpression node) {
            PsiMethod method;
            if (!this.mCallsGetAction && UastExpressionUtils.isMethodCall((UElement)node) && (method = node.resolve()) != null && "getAction".equals(method.getName()) && this.mEvaluator.isMemberInSubClassOf((PsiMember)method, "android.content.Intent", false)) {
                this.mCallsGetAction = true;
            }
            return super.visitCallExpression(node);
        }

        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            PsiElement resolved;
            if (!this.mUsesIntent && this.mParameter != null && this.mParameter.isEquivalentTo(resolved = node.resolve())) {
                this.mUsesIntent = true;
            }
            return super.visitSimpleNameReferenceExpression(node);
        }
    }
}

