/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.DataFlowAnalyzerKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/ToastDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkShown", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "toastName", "", "getApplicableMethodNames", "", "isShowCall", "", "call", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class ToastDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"makeText", "make"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        String className = containingClass.getQualifiedName();
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String name = string;
        if (Intrinsics.areEqual((Object)className, (Object)"android.widget.Toast") && Intrinsics.areEqual((Object)name, (Object)"makeText")) {
            UExpression duration;
            List args = node.getValueArguments();
            if (args.size() == 3 && (duration = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(2)))) instanceof ULiteralExpression) {
                JavaContext.report$default(context2, ISSUE, (UElement)duration, context2.getLocation((UElement)duration), "Expected duration `Toast.LENGTH_SHORT` or `Toast.LENGTH_LONG`, a custom duration value is not supported", null, 16, null);
            }
            this.checkShown(context2, node, "Toast");
        } else if (Intrinsics.areEqual((Object)name, (Object)"make") && (Intrinsics.areEqual((Object)className, (Object)"com.google.android.material.snackbar.Snackbar") || Intrinsics.areEqual((Object)className, (Object)"android.support.design.widget.Snackbar"))) {
            this.checkShown(context2, node, "Snackbar");
        }
    }

    private final boolean isShowCall(UCallExpression call) {
        return Intrinsics.areEqual((Object)Lint.getMethodName(call), (Object)"show");
    }

    private final void checkShown(JavaContext context2, UCallExpression node, String toastName) {
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        AtomicBoolean shown = new AtomicBoolean(false);
        AtomicBoolean escapes = new AtomicBoolean(false);
        Set set = SetsKt.setOf((Object)node);
        List list2 = CollectionsKt.emptyList();
        DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(this, shown, escapes, set, list2){
            final /* synthetic */ ToastDetector this$0;
            final /* synthetic */ AtomicBoolean $shown;
            final /* synthetic */ AtomicBoolean $escapes;
            {
                this.this$0 = $receiver;
                this.$shown = $shown;
                this.$escapes = $escapes;
                super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                if (ToastDetector.access$isShowCall(this.this$0, call)) {
                    this.$shown.set(true);
                    return;
                }
                super.receiver(call);
            }

            public void field(@NotNull UElement field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                this.$escapes.set(true);
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                this.$escapes.set(true);
            }

            public void returns(@NotNull UReturnExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.$escapes.set(true);
            }
        };
        method.accept((UastVisitor)visitor2);
        if (!(shown.get() || escapes.get() || visitor2.getFailedResolve() && DataFlowAnalyzerKt.anyCall(method, (Function1<? super UCallExpression, Boolean>)((Function1)new Function1<UCallExpression, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull UCallExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ToastDetector.access$isShowCall((ToastDetector)this.receiver, p0);
            }
        })))) {
            LintFix fix = CheckResultDetector.Companion.isExpressionValueUnused((UElement)node) ? this.fix().replace().name("Call show()").range(context2.getLocation((UElement)node)).end().with(".show()").build() : (LintFix)null;
            context2.report(ISSUE, (UElement)node, context2.getCallLocation(node, true, false), toastName + " created but not shown: did you forget to call `show()`?", fix);
        }
    }

    public static final /* synthetic */ boolean access$isShowCall(ToastDetector $this, UCallExpression call) {
        return $this.isShowCall(call);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ToastDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "ShowToast", "Toast created but not shown", "\n                    `Toast.makeText()` creates a `Toast` but does **not** show it. You must \\\n                    call `show()` on the resulting object to actually make the `Toast` \\\n                    appear.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ToastDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

