/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.ThreadDetector;
import com.android.tools.lint.checks.ThreadDetectorKt;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0016J<\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001e\u0010\u001c\u001a\u00020\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0016H\u0002J\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\"\u0010%\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tH\u0002J\u001e\u0010*\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010,\u001a\u00020\tH\u0002J(\u0010.\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "visitedAnnotationUsages", "", "Lcom/intellij/psi/PsiElement;", "addThreadAnnotations", "", "", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "result", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableAnnotations", "", "checkThreading", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "callerThreads", "calleeThreads", "describeThread", "describeThreads", "annotations", "any", "", "getThreadContext", "methodCall", "getThreadsFromExpressionContext", "lambdaCall", "Lorg/jetbrains/uast/UExpression;", "getThreadsFromMethod", "originalMethod", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isCompatibleThread", "caller", "callee", "callers", "visitAnnotationUsage", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Companion", "android.sdktools.lint-checks"})
public final class ThreadDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PsiElement> visitedAnnotationUsages = new LinkedHashSet();
    @NotNull
    public static final String THREAD_ANNOTATION_SUFFIX = "Thread";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ThreadDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue THREAD;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetectorKt.UI_THREAD_ANNOTATION.oldName(), AnnotationDetectorKt.UI_THREAD_ANNOTATION.newName(), AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.oldName(), AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.newName(), AnnotationDetectorKt.BINDER_THREAD_ANNOTATION.oldName(), AnnotationDetectorKt.BINDER_THREAD_ANNOTATION.newName(), AnnotationDetectorKt.WORKER_THREAD_ANNOTATION.oldName(), AnnotationDetectorKt.WORKER_THREAD_ANNOTATION.newName(), AnnotationDetectorKt.ANY_THREAD_ANNOTATION.oldName(), AnnotationDetectorKt.ANY_THREAD_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.visitedAnnotationUsages.clear();
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (usageInfo.anyCloser((Function1<? super AnnotationInfo, Boolean>)((Function1)visitAnnotationUsage.1.INSTANCE))) {
            return;
        }
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        PsiElement psiElement2 = element.getSourcePsi();
        if (psiElement2 == null) {
            return;
        }
        PsiElement usagePsi = psiElement2;
        if (!this.visitedAnnotationUsages.add(usagePsi)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[usageInfo.getType().ordinal()]) {
            case 1: {
                List<String> list2 = this.getThreadContext(context2, element);
                if (list2 == null) {
                    return;
                }
                List<String> list3 = this.getThreadsFromMethod(context2, method);
                if (list3 == null) {
                    return;
                }
                this.checkThreading(context2, element, method, list2, list3);
                break;
            }
            case 2: 
            case 3: {
                UCallableReferenceExpression uCallableReferenceExpression = element instanceof UCallableReferenceExpression ? (UCallableReferenceExpression)element : null;
                if (uCallableReferenceExpression == null) {
                    return;
                }
                UCallableReferenceExpression reference = uCallableReferenceExpression;
                PsiElement psiElement3 = reference.resolve();
                PsiMethod psiMethod2 = psiElement3 instanceof PsiMethod ? (PsiMethod)psiElement3 : null;
                if (psiMethod2 == null) {
                    return;
                }
                PsiMethod referencedMethod = psiMethod2;
                List<String> list4 = this.getThreadsFromExpressionContext(context2, (UExpression)reference);
                if (list4 == null) {
                    return;
                }
                List<String> list5 = this.getThreadsFromMethod(context2, referencedMethod);
                if (list5 == null) {
                    return;
                }
                this.checkThreading(context2, element, referencedMethod, list4, list5);
                break;
            }
            default: {
                return;
            }
        }
    }

    private final void checkThreading(JavaContext context2, UElement node, PsiMethod method, List<String> callerThreads, List<String> calleeThreads) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = calleeThreads;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.isCompatibleThread(callerThreads, it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String name = string;
        if (StringsKt.startsWith$default((String)name, (String)"post", (boolean)false, (int)2, null) && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.view.View")) {
            return;
        }
        if (calleeThreads.containsAll((Collection)callerThreads)) {
            return;
        }
        if (calleeThreads.contains(AnnotationDetectorKt.ANY_THREAD_ANNOTATION.oldName()) || calleeThreads.contains(AnnotationDetectorKt.ANY_THREAD_ANNOTATION.newName())) {
            return;
        }
        String string2 = "%1$s %2$s must be called from the %3$s thread, currently inferred thread is %4$s thread";
        Object[] objectArray = new Object[]{method.isConstructor() ? "Constructor" : "Method", method.getName(), this.describeThreads(calleeThreads, true), this.describeThreads(callerThreads, false)};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        String message2 = string3;
        Location location2 = context2.getLocation(node);
        this.report(context2, THREAD, node, location2, message2);
    }

    private final String describeThreads(List<String> annotations, boolean any) {
        StringBuilder sb = new StringBuilder();
        int n = annotations.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                if (i == annotations.size() - 1) {
                    if (any) {
                        sb.append(" or ");
                    } else {
                        sb.append(" and ");
                    }
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.describeThread(annotations.get(i)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String describeThread(String annotation) {
        String string = annotation;
        return (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.UI_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.UI_THREAD_ANNOTATION.newName())) ? "UI" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.newName())) ? "main" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.BINDER_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.BINDER_THREAD_ANNOTATION.newName())) ? "binder" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.WORKER_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.WORKER_THREAD_ANNOTATION.newName())) ? "worker" : ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.ANY_THREAD_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.ANY_THREAD_ANNOTATION.newName())) ? "any" : (AndroidPlatformAnnotations.Companion.isPlatformAnnotation(annotation) ? this.describeThread(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(annotation)) : "other")))));
    }

    private final boolean isCompatibleThread(List<String> callers, String callee) {
        boolean bl;
        boolean bl2 = bl = !((Collection)callers).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        for (String caller : callers) {
            if (this.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    private final boolean isCompatibleThread(String caller, String callee) {
        if (Intrinsics.areEqual((Object)callee, (Object)caller)) {
            return true;
        }
        if (AnnotationDetectorKt.ANY_THREAD_ANNOTATION.isEquals(callee)) {
            return true;
        }
        if (AnnotationDetectorKt.UI_THREAD_ANNOTATION.isEquals(callee) ? AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.isEquals(caller) : AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.isEquals(callee) && AnnotationDetectorKt.UI_THREAD_ANNOTATION.isEquals(caller)) {
            return true;
        }
        int callerNameIndex = StringsKt.lastIndexOf$default((CharSequence)caller, (char)'.', (int)0, (boolean)false, (int)6, null);
        int calleeNameIndex = StringsKt.lastIndexOf$default((CharSequence)callee, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (callerNameIndex != -1 && calleeNameIndex != -1) {
            return StringsKt.regionMatches((String)caller, (int)callerNameIndex, (String)callee, (int)calleeNameIndex, (int)(caller.length() - callerNameIndex), (boolean)false);
        }
        return false;
    }

    private final List<String> getThreadContext(JavaContext context2, UElement methodCall) {
        PsiMethod method;
        Class[] classArray = new Class[]{UAnonymousClass.class, ULambdaExpression.class};
        UElement uElement = UastUtils.getParentOfType((UElement)methodCall, UMethod.class, (boolean)true, (Class[])classArray);
        PsiMethod psiMethod = method = uElement instanceof PsiMethod ? (PsiMethod)uElement : null;
        if (method != null) {
            UClass containingClass = UastUtils.getContainingUClass((UElement)methodCall);
            if (containingClass instanceof UAnonymousClass) {
                Class[] classArray2 = new Class[]{UCallExpression.class};
                UObjectLiteralExpression anonClassCall = (UObjectLiteralExpression)UastUtils.getParentOfType((UElement)methodCall, UObjectLiteralExpression.class, (boolean)true, (Class[])classArray2);
                List<String> list2 = this.getThreadsFromExpressionContext(context2, (UExpression)anonClassCall);
                if (list2 == null) {
                    list2 = this.getThreadsFromMethod(context2, method);
                }
                return list2;
            }
            return this.getThreadsFromMethod(context2, method);
        }
        classArray = new Class[]{UAnonymousClass.class, ULambdaExpression.class};
        ULambdaExpression lambdaCall = (ULambdaExpression)UastUtils.getParentOfType((UElement)methodCall, ULambdaExpression.class, (boolean)true, (Class[])classArray);
        return this.getThreadsFromExpressionContext(context2, (UExpression)lambdaCall);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getThreadsFromExpressionContext(JavaContext context2, UExpression lambdaCall) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        UExpression uExpression = lambdaCall;
        UElement uElement = uExpression != null ? uExpression.getUastParent() : null;
        UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression lambdaCallExpression = uCallExpression;
        PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)lambdaCallExpression, (UExpression)lambdaCall);
        if (psiParameter == null) {
            return null;
        }
        PsiParameter lambdaArgument = psiParameter;
        Iterable iterable = JavaEvaluator.getAnnotations$default(context2.getEvaluator(), (PsiModifierListOwner)lambdaArgument, false, null, 4, null);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UAnnotation it = (UAnnotation)element$iv$iv;
            boolean bl = false;
            if (!ThreadDetectorKt.access$isThreadingAnnotation(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UAnnotation it = (UAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (it.getQualifiedName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (!((Collection)annotations).isEmpty()) {
            return annotations;
        }
        PsiMethod functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)lambdaArgument.getType());
        return this.getThreadsFromMethod(context2, functionalInterfaceMethod);
    }

    private final List<String> getThreadsFromMethod(JavaContext context2, PsiMethod originalMethod) {
        PsiMethod method = originalMethod;
        if (method != null) {
            List annotations;
            JavaEvaluator evaluator = context2.getEvaluator();
            List<String> result = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                annotations = JavaEvaluator.getAnnotations$default(evaluator, (PsiModifierListOwner)method, false, null, 4, null);
                for (UAnnotation annotation : annotations) {
                    result = this.addThreadAnnotations(annotation, result);
                }
                if (result != null) {
                    return result;
                }
                if (evaluator.isStatic((PsiModifierListOwner)method)) {
                    return null;
                }
                method = evaluator.getSuperMethod(method);
            }
            while (cls != null) {
                annotations = JavaEvaluator.getAnnotations$default(evaluator, (PsiModifierListOwner)cls, false, null, 4, null);
                for (UAnnotation annotation : annotations) {
                    result = this.addThreadAnnotations(annotation, result);
                }
                if (result != null) {
                    return result;
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private final List<String> addThreadAnnotations(UAnnotation annotation, List<String> result) {
        List resultList = result;
        String name = annotation.getQualifiedName();
        if (name != null && StringsKt.endsWith$default((String)name, (String)THREAD_ANNOTATION_SUFFIX, (boolean)false, (int)2, null) && (AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(name) || AndroidPlatformAnnotations.Companion.isPlatformAnnotation(name))) {
            if (resultList == null) {
                resultList = new ArrayList(4);
            }
            String string = AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.newName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SUPPORT_ANNOTATIONS_PREFIX.newName()");
            if (StringsKt.startsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) {
                String string2 = AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName();
                String string3 = name.substring(AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                String oldName = string2 + string3;
                resultList.add(oldName);
            } else if (StringsKt.startsWith$default((String)name, (String)"android.annotation.", (boolean)false, (int)2, null)) {
                String string4 = AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName();
                String string5 = name.substring("android.annotation.".length());
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                String oldName = string4 + string5;
                resultList.add(oldName);
            } else {
                resultList.add(name);
            }
        }
        return resultList;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        THREAD = Issue.Companion.create$default(companion, "WrongThread", "Wrong Thread", "\n                Ensures that a method which expects to be called on a specific thread, is \\\n                actually called from that thread. For example, calls on methods in widgets \\\n                should always be made on the UI thread.\n                ", implementation, "https://developer.android.com/guide/components/processes-and-threads.html#Threads", category, 6, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "THREAD", "Lcom/android/tools/lint/detector/api/Issue;", "THREAD_ANNOTATION_SUFFIX", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            nArray[AnnotationUsageType.METHOD_CALL_PARAMETER.ordinal()] = 2;
            nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

