/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.RestrictToDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationOrigin;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.model.LintModelMavenName;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.UnknownJavaExpression;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\fH\u0002J<\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\"2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0006H\u0002J(\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkRestrictTo", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMember;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "applyClassAnnotationsToMembers", "", "member", "scope", "", "checkVisibleForTesting", "inheritAnnotation", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isTestContext", "element", "reportRestriction", "where", "containingClass", "Lcom/intellij/psi/PsiClass;", "reportVisibilityError", "desc", "visitAnnotationUsage", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "Companion", "android.sdktools.lint-checks"})
public final class RestrictToDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RestrictToDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String VISIBLE_FOR_TESTING_SUFFIX = ".VisibleForTesting";
    @NotNull
    private static final String ATTR_OTHERWISE = "otherwise";
    @NotNull
    private static final String ATTR_PRODUCTION_VISIBILITY = "productionVisibility";
    @NotNull
    private static final String ATTR_VISIBILITY = "visibility";
    private static final int VISIBILITY_PRIVATE = 2;
    private static final int VISIBILITY_PACKAGE_PRIVATE = 3;
    private static final int VISIBILITY_PROTECTED = 4;
    private static final int VISIBILITY_NONE = 5;
    private static final int RESTRICT_TO_LIBRARY_GROUP = 1;
    private static final int RESTRICT_TO_LIBRARY = 2;
    private static final int RESTRICT_TO_LIBRARY_GROUP_PREFIX = 4;
    private static final int RESTRICT_TO_TESTS = 8;
    private static final int RESTRICT_TO_SUBCLASSES = 16;
    @JvmField
    @NotNull
    public static final Issue RESTRICTED = Issue.Companion.create("RestrictedApi", "Restricted API", "\n                This API has been flagged with a restriction that has not been met.\n\n                Examples of API restrictions:\n                * Method can only be invoked by a subclass\n                * Method can only be accessed from within the same library (defined by the Gradle library group id)\n                * Method can only be accessed from tests.\n\n                You can add your own API restrictions with the `@RestrictTo` annotation.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue TEST_VISIBILITY = Issue.Companion.create("VisibleForTests", "Visible Only For Tests", "\n                With the `@VisibleForTesting` annotation you can specify an `otherwise=` \\\n                attribute which specifies the intended visibility if the method had not \\\n                been made more widely visible for the tests.\n\n                This check looks for accesses from production code (e.g. not tests) where \\\n                the access would not have been allowed with the intended production \\\n                visibility.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[3];
        Intrinsics.checkNotNullExpressionValue((Object)AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.oldName(), (String)"RESTRICT_TO_ANNOTATION.oldName()");
        Intrinsics.checkNotNullExpressionValue((Object)AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.newName(), (String)"RESTRICT_TO_ANNOTATION.newName()");
        objectArray[2] = "VisibleForTesting";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type != AnnotationUsageType.ASSIGNMENT_LHS && type != AnnotationUsageType.ASSIGNMENT_RHS && super.isApplicableAnnotationUsage(type);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        PsiElement psiElement;
        PsiElement sourcePsi;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        AnnotationUsageType type = usageInfo.getType();
        if (type == AnnotationUsageType.EXTENDS && element instanceof UTypeReferenceExpression && Lint.isKotlin(sourcePsi = element.getSourcePsi()) && Intrinsics.areEqual((Object)((psiElement = sourcePsi) != null && (psiElement = psiElement.getParent()) != null ? psiElement.toString() : null), (Object)"CONSTRUCTOR_CALLEE")) {
            return;
        }
        PsiElement psiElement2 = usageInfo.getReferenced();
        PsiMember member = psiElement2 instanceof PsiMember ? (PsiMember)psiElement2 : null;
        UAnnotation annotation = annotationInfo.getAnnotation();
        String qualifiedName = annotationInfo.getQualifiedName();
        if (AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(qualifiedName)) {
            this.checkRestrictTo(context2, element, member, annotation, usageInfo, true);
        } else if (StringsKt.endsWith$default((String)qualifiedName, (String)VISIBLE_FOR_TESTING_SUFFIX, (boolean)false, (int)2, null) && member != null && type != AnnotationUsageType.METHOD_OVERRIDE && type != AnnotationUsageType.METHOD_CALL_PARAMETER) {
            this.checkVisibleForTesting(context2, element, member, annotation, usageInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTestContext(JavaContext context2, UElement element) {
        UElement current = element;
        if (context2.isTestSource()) {
            return true;
        }
        while (true) {
            UAnnotated owner;
            void $this$getParentOfType$iv;
            UElement uElement = current;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            if ((UAnnotated)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UAnnotated.class, (boolean)strict$iv) == null) break;
            for (UAnnotation annotation : owner.getUAnnotations()) {
                String name;
                if (annotation.getQualifiedName() == null) continue;
                if (AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(name)) {
                    int restrictionScope = RestrictToDetector.Companion.getRestrictionScope(annotation);
                    if ((restrictionScope & 8) == 0) continue;
                    return true;
                }
                if (StringsKt.endsWith$default((String)name, (String)VISIBLE_FOR_TESTING_SUFFIX, (boolean)false, (int)2, null)) {
                    return true;
                }
                if (!StringsKt.endsWith$default((String)name, (String)".TestOnly", (boolean)false, (int)2, null)) continue;
                return true;
            }
            current = (UElement)owner;
        }
        return false;
    }

    private final void checkVisibleForTesting(JavaContext context2, UElement node, PsiMember method, UAnnotation annotation, AnnotationUsageInfo usageInfo) {
        int visibility = RestrictToDetector.Companion.getVisibilityForTesting(annotation);
        if (visibility == 5) {
            RestrictToDetector.checkRestrictTo$default(this, context2, node, method, annotation, usageInfo, 8, false, 64, null);
        } else {
            boolean bl;
            PsiFile containingFile2;
            UFile uFile = UastUtils.getContainingUFile((UElement)node);
            PsiFile containingFile1 = UastLintUtils.Companion.getPsiFile(uFile);
            if (Intrinsics.areEqual((Object)containingFile1, (Object)(containingFile2 = UastLintUtils.Companion.getContainingFile((PsiElement)method))) || containingFile2 == null) {
                return;
            }
            PsiFile psiFile = containingFile1;
            if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getVirtualFile() : null), (Object)containingFile2.getVirtualFile())) {
                return;
            }
            if (visibility == 2) {
                if (!this.isTestContext(context2, node)) {
                    this.reportVisibilityError(context2, node, "private");
                }
                return;
            }
            JavaEvaluator evaluator = context2.getEvaluator();
            PsiPackage pkg = evaluator.getPackage(node);
            PsiPackage methodPackage = evaluator.getPackage((PsiElement)method);
            PsiPackage psiPackage = pkg;
            PsiPackage psiPackage2 = methodPackage;
            if (Intrinsics.areEqual((Object)(psiPackage != null ? psiPackage.getQualifiedName() : null), (Object)(psiPackage2 != null ? psiPackage2.getQualifiedName() : null))) {
                return;
            }
            if (visibility == 3) {
                if (!this.isTestContext(context2, node)) {
                    this.reportVisibilityError(context2, node, "package private");
                }
                return;
            }
            boolean bl2 = bl = visibility == 4;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            PsiClass methodClass = method.getContainingClass();
            UClass thisClass = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (thisClass == null || methodClass == null) {
                return;
            }
            String qualifiedName = methodClass.getQualifiedName();
            if (qualifiedName == null || evaluator.inheritsFrom((PsiClass)thisClass, qualifiedName, false)) {
                return;
            }
            if (!this.isTestContext(context2, node)) {
                this.reportVisibilityError(context2, node, "protected");
            }
        }
    }

    private final void reportVisibilityError(JavaContext context2, UElement node, String desc) {
        String message2 = "This method should only be accessed from tests or within " + desc + " scope";
        Location location2 = node instanceof UCallExpression ? context2.getCallLocation((UCallExpression)node, false, false) : context2.getLocation(node);
        this.report(context2, TEST_VISIBILITY, node, location2, message2);
    }

    private final void checkRestrictTo(JavaContext context2, UElement node, PsiMember method, UAnnotation annotation, AnnotationUsageInfo usageInfo, boolean applyClassAnnotationsToMembers) {
        int scope = RestrictToDetector.Companion.getRestrictionScope(annotation);
        if (scope != 0) {
            this.checkRestrictTo(context2, node, method, annotation, usageInfo, scope, applyClassAnnotationsToMembers);
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, AnnotationUsageInfo annotationUsageInfo, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, annotationUsageInfo, bl);
    }

    private final void checkRestrictTo(JavaContext context2, UElement node, PsiMember member, UAnnotation annotation, AnnotationUsageInfo usageInfo, int scope, boolean applyClassAnnotationsToMembers) {
        String qualifiedName;
        String methodGroup;
        String thisGroup;
        LintModelMavenName methodCoordinates;
        LintModelMavenName thisCoordinates;
        JavaEvaluator evaluator;
        PsiClass containingClass;
        Object object;
        if (node instanceof UTypeReferenceExpression) {
            object = PsiTypesUtil.getPsiClass((PsiType)((UTypeReferenceExpression)node).getType());
        } else {
            PsiMember psiMember = member;
            if (psiMember != null) {
                object = psiMember.getContainingClass();
            } else if (node instanceof UCallExpression) {
                PsiElement psiElement;
                UReferenceExpression uReferenceExpression = ((UCallExpression)node).getClassReference();
                Object object2 = psiElement = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
                object = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            } else {
                object = node instanceof PsiClass ? (PsiClass)node : null;
            }
        }
        if ((containingClass = object) == null) {
            return;
        }
        List<AnnotationInfo> annotations = usageInfo.getAnnotations();
        if (!applyClassAnnotationsToMembers) {
            AnnotationOrigin origin = annotations.get(usageInfo.getIndex()).getOrigin();
            if (member instanceof PsiClass ? origin != AnnotationOrigin.CLASS : origin != AnnotationOrigin.METHOD && origin != AnnotationOrigin.FIELD) {
                return;
            }
        }
        if (usageInfo.anyCloser((Function1<? super AnnotationInfo, Boolean>)((Function1)checkRestrictTo.1.INSTANCE))) {
            return;
        }
        if ((scope & 1) != 0 && member != null) {
            LintModelMavenName lintModelMavenName;
            evaluator = context2.getEvaluator();
            LintModelMavenName lintModelMavenName2 = evaluator.getLibrary(node);
            if (lintModelMavenName2 == null) {
                lintModelMavenName2 = thisCoordinates = context2.getProject().getMavenCoordinate();
            }
            if ((lintModelMavenName = evaluator.getLibrary((PsiElement)member)) == null) {
                RestrictToDetector $this$checkRestrictTo_u24lambda_u2d0 = this;
                boolean bl = false;
                if (thisCoordinates != null && !(member instanceof PsiCompiledElement)) {
                    Project project = context2.getEvaluator().getProject((PsiElement)member);
                    lintModelMavenName = project != null ? project.getMavenCoordinate() : null;
                } else {
                    lintModelMavenName = null;
                }
            }
            methodCoordinates = lintModelMavenName;
            LintModelMavenName lintModelMavenName3 = thisCoordinates;
            thisGroup = lintModelMavenName3 != null ? lintModelMavenName3.getGroupId() : null;
            LintModelMavenName lintModelMavenName4 = methodCoordinates;
            String string = methodGroup = lintModelMavenName4 != null ? lintModelMavenName4.getGroupId() : null;
            if (!Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) && methodGroup != null) {
                String string2 = thisGroup;
                if (string2 == null) {
                    string2 = "<unknown>";
                }
                String thisGroupDisplayText = string2;
                String where = "from within the same library group (referenced groupId=`" + methodGroup + "` from groupId=`" + thisGroupDisplayText + "`)";
                this.reportRestriction(where, containingClass, member, context2, node, usageInfo);
            }
        } else if ((scope & 4) != 0 && member != null) {
            LintModelMavenName lintModelMavenName;
            evaluator = context2.getEvaluator();
            LintModelMavenName lintModelMavenName5 = evaluator.getLibrary(node);
            if (lintModelMavenName5 == null) {
                lintModelMavenName5 = thisCoordinates = context2.getProject().getMavenCoordinate();
            }
            if ((lintModelMavenName = evaluator.getLibrary((PsiElement)member)) == null) {
                RestrictToDetector $this$checkRestrictTo_u24lambda_u2d1 = this;
                boolean bl = false;
                if (thisCoordinates != null && !(member instanceof PsiCompiledElement)) {
                    Project project = context2.getEvaluator().getProject((PsiElement)member);
                    lintModelMavenName = project != null ? project.getMavenCoordinate() : null;
                } else {
                    lintModelMavenName = null;
                }
            }
            methodCoordinates = lintModelMavenName;
            LintModelMavenName lintModelMavenName6 = thisCoordinates;
            thisGroup = lintModelMavenName6 != null ? lintModelMavenName6.getGroupId() : null;
            LintModelMavenName lintModelMavenName7 = methodCoordinates;
            String string = methodGroup = lintModelMavenName7 != null ? lintModelMavenName7.getGroupId() : null;
            if (!(methodGroup == null || thisGroup != null && Companion.sameLibraryGroupPrefix(thisGroup, methodGroup))) {
                String string3;
                int it = StringsKt.lastIndexOf$default((CharSequence)methodGroup, (char)'.', (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                if (it < 0) {
                    string3 = "\"\"";
                } else {
                    String string4 = methodGroup.substring(0, it);
                    string3 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                }
                String expectedPrefix = string3;
                String string5 = thisGroup;
                String where = "from within the same library group prefix (referenced groupId=`" + methodGroup + "` with prefix " + expectedPrefix + (String)(string5 != null ? " from groupId=`" + string5 + "`" : "") + ")";
                this.reportRestriction(where, containingClass, member, context2, node, usageInfo);
            }
        } else if ((scope & 2) != 0 && member != null) {
            Project project;
            evaluator = context2.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            if (lintModelMavenName == null) {
                lintModelMavenName = context2.getProject().getMavenCoordinate();
            }
            thisCoordinates = lintModelMavenName;
            methodCoordinates = evaluator.getLibrary((PsiElement)member);
            LintModelMavenName lintModelMavenName8 = thisCoordinates;
            thisGroup = lintModelMavenName8 != null ? lintModelMavenName8.getGroupId() : null;
            LintModelMavenName lintModelMavenName9 = methodCoordinates;
            String string = methodGroup = lintModelMavenName9 != null ? lintModelMavenName9.getGroupId() : null;
            if (!Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) && methodGroup != null) {
                String methodArtifact;
                LintModelMavenName lintModelMavenName10 = thisCoordinates;
                String thisArtifact = lintModelMavenName10 != null ? lintModelMavenName10.getArtifactId() : null;
                if (!Intrinsics.areEqual((Object)thisArtifact, (Object)(methodArtifact = methodCoordinates.getArtifactId()))) {
                    String where = "from within the same library (" + methodGroup + ":" + methodArtifact + ")";
                    this.reportRestriction(where, containingClass, member, context2, node, usageInfo);
                }
            } else if (!(member instanceof PsiCompiledElement) && (project = context2.getEvaluator().getProject((PsiElement)member)) != null && !Intrinsics.areEqual((Object)project, (Object)context2.getProject())) {
                LintModelMavenName coordinates = project.getMavenCoordinate();
                String name = coordinates != null ? coordinates.getGroupId() + ":" + coordinates.getArtifactId() : project.getName();
                String where = "from within the same library (" + name + ")";
                this.reportRestriction(where, containingClass, member, context2, node, usageInfo);
            }
        }
        if ((scope & 8) != 0 && !this.isTestContext(context2, node)) {
            this.reportRestriction("from tests", containingClass, member, context2, node, usageInfo);
        }
        if ((scope & 0x10) != 0 && (qualifiedName = containingClass.getQualifiedName()) != null) {
            JavaEvaluator evaluator2 = context2.getEvaluator();
            UClass outer = null;
            boolean isSubClass = false;
            UElement prev = node;
            while ((outer = (UClass)UastUtils.getParentOfType((UElement)prev, UClass.class, (boolean)true)) != null) {
                if (evaluator2.inheritsFrom((PsiClass)outer, qualifiedName, false)) {
                    isSubClass = true;
                    break;
                }
                if (evaluator2.isStatic((PsiModifierListOwner)outer)) break;
                prev = (UElement)outer;
            }
            if (!isSubClass) {
                this.reportRestriction("from subclasses", containingClass, member, context2, node, usageInfo);
            }
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, AnnotationUsageInfo annotationUsageInfo, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, annotationUsageInfo, n, bl);
    }

    private final void reportRestriction(String where, PsiClass containingClass, PsiMember member, JavaContext context2, UElement node, AnnotationUsageInfo usageInfo) {
        Object object;
        Object api2 = null;
        if (member == null || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
            Object object2 = member;
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = containingClass.getName() + " constructor";
            }
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n            member?.na\u2026\" constructor\")\n        }");
        } else if (Intrinsics.areEqual((Object)containingClass, (Object)member)) {
            object = member.getName();
            if (object == null) {
                object = "class";
            }
        } else {
            object = containingClass.getName() + "." + member.getName();
        }
        api2 = object;
        UElement locationNode = node;
        if (node instanceof UCallExpression) {
            UIdentifier nameElement = ((UCallExpression)node).getMethodIdentifier();
            if (nameElement != null) {
                locationNode = (UElement)nameElement;
            }
            AnnotationInfo annotation = usageInfo.getAnnotations().get(usageInfo.getIndex());
            PsiElement annotated = annotation.getAnnotated();
            if (where == null && annotated instanceof PsiClass && !Intrinsics.areEqual((Object)annotated, (Object)usageInfo.getReferenced())) {
                UExpression qualifier = ((UCallExpression)node).getReceiver();
                String className = ((PsiClass)annotated).getName();
                if (qualifier != null && className != null && Intrinsics.areEqual((Object)qualifier.asSourceString(), (Object)className)) {
                    locationNode = (UElement)qualifier;
                    api2 = className;
                }
            }
        }
        Object message2 = null;
        if (where == null) {
            message2 = (String)api2 + " is marked as internal and should not be accessed from apps";
        } else {
            String refType = member instanceof PsiMethod ? "called" : "accessed";
            message2 = (String)api2 + " can only be " + refType + " " + where;
            if (Intrinsics.areEqual((Object)where, (Object)"from within the same library (groupId=com.android.support)")) {
                message2 = "This API is marked as internal to the support library and should not be accessed from apps";
            }
        }
        Location location2 = locationNode instanceof UCallExpression ? context2.getCallLocation((UCallExpression)locationNode, false, false) : context2.getLocation(locationNode);
        this.report(context2, RESTRICTED, node, location2, (String)message2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u0017\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector$Companion;", "", "()V", "ATTR_OTHERWISE", "", "ATTR_PRODUCTION_VISIBILITY", "ATTR_VISIBILITY", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RESTRICTED", "Lcom/android/tools/lint/detector/api/Issue;", "RESTRICT_TO_LIBRARY", "", "RESTRICT_TO_LIBRARY_GROUP", "RESTRICT_TO_LIBRARY_GROUP_PREFIX", "RESTRICT_TO_SUBCLASSES", "RESTRICT_TO_TESTS", "TEST_VISIBILITY", "VISIBILITY_NONE", "VISIBILITY_PACKAGE_PRIVATE", "VISIBILITY_PRIVATE", "VISIBILITY_PROTECTED", "VISIBLE_FOR_TESTING_SUFFIX", "getRestrictionScope", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "expression", "Lorg/jetbrains/uast/UExpression;", "getVisibilityForTesting", "sameLibraryGroupPrefix", "", "group1", "group2", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final int getVisibilityForTesting(UAnnotation annotation) {
            block28: {
                PsiElement psi;
                UExpression value;
                block29: {
                    block27: {
                        UExpression uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_OTHERWISE);
                        if (uExpression == null && (uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY)) == null) {
                            uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_VISIBILITY);
                        }
                        if (!((value = uExpression) instanceof ULiteralExpression)) break block27;
                        Object v = ((ULiteralExpression)value).getValue();
                        if (v instanceof Integer) {
                            return ((Number)v).intValue();
                        }
                        break block28;
                    }
                    if (!(value instanceof UReferenceExpression)) break block29;
                    String v = ((UReferenceExpression)value).getResolvedName();
                    if (v == null) break block28;
                    int n = -1;
                    switch (v.hashCode()) {
                        case -89079770: {
                            if (v.equals("PACKAGE")) {
                                n = 1;
                            }
                            break;
                        }
                        case 2402104: {
                            if (v.equals("NONE")) {
                                n = 2;
                            }
                            break;
                        }
                        case -2116912242: {
                            if (v.equals("PROTECTED")) {
                                n = 3;
                            }
                            break;
                        }
                        case 403485027: {
                            if (v.equals("PRIVATE")) {
                                n = 4;
                            }
                            break;
                        }
                        case 1152750154: {
                            if (v.equals("PACKAGE_PRIVATE")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            return 5;
                        }
                        case 4: {
                            return 2;
                        }
                        case 3: {
                            return 4;
                        }
                        case 5: {
                            return 3;
                        }
                        case 1: {
                            return 3;
                        }
                    }
                    break block28;
                }
                if (value instanceof UnknownJavaExpression) {
                    Object v;
                    PsiElement sourcePsi = ((UnknownJavaExpression)value).getSourcePsi();
                    if (sourcePsi instanceof PsiLiteralExpression && (v = ((PsiLiteralExpression)sourcePsi).getValue()) instanceof Integer) {
                        return ((Number)v).intValue();
                    }
                } else if (value instanceof UastEmptyExpression && (psi = annotation.getSourcePsi()) instanceof ClsAnnotationImpl) {
                    Object constant;
                    JvmAnnotationAttributeValue v;
                    JvmAnnotationAttribute otherwise;
                    JvmAnnotationAttribute jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_OTHERWISE);
                    if (jvmAnnotationAttribute == null && (jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY)) == null) {
                        jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_VISIBILITY);
                    }
                    JvmAnnotationAttribute jvmAnnotationAttribute2 = otherwise = jvmAnnotationAttribute;
                    Object object = v = jvmAnnotationAttribute2 != null ? jvmAnnotationAttribute2.getAttributeValue() : null;
                    if (v instanceof JvmAnnotationConstantValue && (constant = ((JvmAnnotationConstantValue)v).getConstantValue()) instanceof Number) {
                        return ((Number)constant).intValue();
                    }
                }
            }
            return 2;
        }

        private final int getRestrictionScope(UAnnotation annotation) {
            UExpression value = annotation.findDeclaredAttributeValue("value");
            if (value != null) {
                return this.getRestrictionScope(value, annotation);
            }
            return 0;
        }

        private final int getRestrictionScope(UExpression expression, UAnnotation annotation) {
            int scope = 0;
            if (expression != null) {
                PsiElement psi;
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)expression))) {
                    UCallExpression initializerExpression = (UCallExpression)expression;
                    List initializers = initializerExpression.getValueArguments();
                    for (UExpression initializer : initializers) {
                        scope |= this.getRestrictionScope(initializer, annotation);
                    }
                } else if (expression instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)expression).resolve();
                    if (resolved instanceof PsiField) {
                        String string = ((PsiField)resolved).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolved.name");
                        String name = string;
                        if (Intrinsics.areEqual((Object)"GROUP_ID", (Object)name) || Intrinsics.areEqual((Object)"LIBRARY_GROUP", (Object)name)) {
                            scope |= 1;
                        } else if (Intrinsics.areEqual((Object)"SUBCLASSES", (Object)name)) {
                            scope |= 0x10;
                        } else if (Intrinsics.areEqual((Object)"TESTS", (Object)name)) {
                            scope |= 8;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY", (Object)name)) {
                            scope |= 2;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY_GROUP_PREFIX", (Object)name)) {
                            scope |= 4;
                        }
                    }
                } else if (expression instanceof UastEmptyExpression && (psi = annotation.getSourcePsi()) instanceof ClsAnnotationImpl) {
                    Object constant;
                    JvmAnnotationAttributeValue v;
                    JvmAnnotationAttribute otherwise;
                    JvmAnnotationAttribute jvmAnnotationAttribute = otherwise = ((ClsAnnotationImpl)psi).findAttribute("value");
                    Object object = v = jvmAnnotationAttribute != null ? jvmAnnotationAttribute.getAttributeValue() : null;
                    if (v instanceof JvmAnnotationConstantValue && (constant = ((JvmAnnotationConstantValue)v).getConstantValue()) instanceof Number) {
                        scope |= ((Number)constant).intValue();
                    }
                }
            }
            return scope;
        }

        public final boolean sameLibraryGroupPrefix(@NotNull String group1, @NotNull String group2) {
            Intrinsics.checkNotNullParameter((Object)group1, (String)"group1");
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group2");
            if (Intrinsics.areEqual((Object)group1, (Object)group2)) {
                return true;
            }
            int i1 = StringsKt.lastIndexOf$default((CharSequence)group1, (char)'.', (int)0, (boolean)false, (int)6, null);
            int i2 = StringsKt.lastIndexOf$default((CharSequence)group2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (i2 != i1 || i1 == -1) {
                return false;
            }
            return StringsKt.regionMatches$default((String)group1, (int)0, (String)group2, (int)0, (int)i1, (boolean)false, (int)16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

