/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ResourceCycleDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JH\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0002J,\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0016J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001e\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J0\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J(\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J \u0010+\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010,\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u0018H\u0016R(\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "mChains", "", "Lcom/android/resources/ResourceType;", "", "", "mLocations", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/detector/api/Location;", "mReferences", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "checkCrashItem", "Lcom/android/tools/lint/detector/api/XmlContext;", "item", "Lorg/w3c/dom/Element;", "dfs", "map", "from", "visiting", "", "visited", "findCycles", "type", "getApplicableAttributes", "", "getApplicableElements", "getLocationMap", "getTypeMap", "handleReference", "node", "Lorg/w3c/dom/Node;", "to", "recordLocation", "recordReference", "visitAttribute", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Companion", "android.sdktools.lint-checks"})
public final class ResourceCycleDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<ResourceType, Multimap<String, String>> mReferences;
    @Nullable
    private Map<ResourceType, Multimap<String, Location>> mLocations;
    @Nullable
    private Map<ResourceType, List<List<String>>> mChains;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ResourceCycleDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue CYCLE = Issue.Companion.create("ResourceCycle", "Cycle in resource definitions", "\n                There should be no cycles in resource definitions as this can lead to \\\n                runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue CRASH = Issue.Companion.create("AaptCrash", "Potential AAPT crash", "\n                Defining a style which sets `android:id` to a dynamically generated id can \\\n                cause many versions of `aapt`, the resource packaging tool, to crash. \\\n                To work around this, declare the id explicitly with \\\n                `<item type=\"id\" name=\"...\" />` instead.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.mReferences = Maps.newEnumMap(ResourceType.class);
        }
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.FONT || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"include", "style", "color", "item", "font", "string", "dimen"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        List list2 = ResourceXmlDetector.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ALL");
        return list2;
    }

    private final void recordReference(ResourceType type, String from, String to) {
        String string;
        if (((CharSequence)to).length() == 0 || StringsKt.startsWith$default((String)to, (String)"@android:", (boolean)false, (int)2, null)) {
            return;
        }
        Multimap<String, String> multimap = this.getTypeMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, String> map2 = multimap;
        if (to.charAt(0) == '@') {
            int index2 = StringsKt.indexOf$default((CharSequence)to, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index2 != -1) {
                String string2 = to.substring(index2 + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = to;
            }
        } else {
            string = to;
        }
        String name = string;
        map2.put((Object)from, (Object)name);
    }

    private final Multimap<String, String> getTypeMap(ResourceType type) {
        Map<ResourceType, Multimap<String, String>> map2 = this.mReferences;
        if (map2 == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, String>> references2 = map2;
        Multimap<String, String> map3 = references2.get(type);
        if (map3 != null) {
            return map3;
        }
        ListMultimap listMultimap = Multimaps.newListMultimap((Map)new TreeMap(), (Supplier)getTypeMap.newMap.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)listMultimap, (String)"newListMultimap(TreeMap(\u2026Size<String>(6)\n        }");
        Multimap newMap2 = (Multimap)listMultimap;
        references2.put(type, (Multimap<String, String>)newMap2);
        return newMap2;
    }

    private final void recordLocation(XmlContext context2, Node node, ResourceType type, String from) {
        Multimap<String, Location> multimap = this.getLocationMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, Location> map2 = multimap;
        Location location2 = context2.getLocation(node);
        map2.put((Object)from, (Object)location2);
    }

    private final Multimap<String, Location> getLocationMap(ResourceType type) {
        Map<ResourceType, Multimap<String, Location>> map2 = this.mLocations;
        if (map2 == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, Location>> locations = map2;
        Multimap<String, Location> map3 = locations.get(type);
        if (map3 != null) {
            return map3;
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((int)30, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(30, 4)");
        Multimap newMap2 = (Multimap)arrayListMultimap;
        locations.put(type, (Multimap<String, Location>)newMap2);
        return newMap2;
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        block53: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String tagName = element.getTagName();
            if (tagName == null) break block53;
            int n = -1;
            switch (tagName.hashCode()) {
                case 1942574248: {
                    if (tagName.equals("include")) {
                        n = 1;
                    }
                    break;
                }
                case 3242771: {
                    if (tagName.equals("item")) {
                        n = 2;
                    }
                    break;
                }
                case 95588145: {
                    if (tagName.equals("dimen")) {
                        n = 3;
                    }
                    break;
                }
                case 94842723: {
                    if (tagName.equals("color")) {
                        n = 3;
                    }
                    break;
                }
                case -891985903: {
                    if (tagName.equals("string")) {
                        n = 3;
                    }
                    break;
                }
                case 109780401: {
                    if (tagName.equals("style")) {
                        n = 4;
                    }
                    break;
                }
                case 3148879: {
                    if (tagName.equals("font")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    String drawable;
                    if (this.mReferences == null) {
                        return;
                    }
                    ResourceFolderType folderType = context2.getResourceFolderType();
                    if (folderType == ResourceFolderType.VALUES) {
                        Attr typeNode = element.getAttributeNode("type");
                        if (typeNode == null) break;
                        String typeName = typeNode.getValue();
                        ResourceType type = ResourceType.fromXmlValue((String)typeName);
                        Attr nameNode = element.getAttributeNode("name");
                        if (type == null || nameNode == null) break;
                        NodeList childNodes = element.getChildNodes();
                        int n2 = childNodes.getLength();
                        for (int i = 0; i < n2; ++i) {
                            char c;
                            Node child = childNodes.item(i);
                            if (child.getNodeType() != 3) continue;
                            String text = child.getNodeValue();
                            int max = text.length();
                            for (int k = 0; k < max && !Character.isWhitespace(c = text.charAt(k)) && c == '@'; ++k) {
                                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                                String string = type.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.getName()");
                                if (!StringsKt.startsWith$default((String)text, (String)string, (int)(k + 1), (boolean)false, (int)4, null)) break;
                                String $this$trim$iv = text;
                                boolean $i$f$trim = false;
                                CharSequence $this$trim$iv$iv = $this$trim$iv;
                                boolean $i$f$trim2 = false;
                                int startIndex$iv$iv = 0;
                                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                boolean startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                String to = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                if (this.mReferences == null) continue;
                                String name = nameNode.getValue();
                                if (this.mLocations != null) {
                                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                                    this.recordLocation(context2, child, type, name);
                                    continue;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                                this.recordReference(type, name, to);
                            }
                        }
                        break;
                    }
                    if (folderType == ResourceFolderType.COLOR) {
                        String color = element.getAttributeNS("http://schemas.android.com/apk/res/android", "color");
                        if (color == null || !StringsKt.startsWith$default((String)color, (String)"@color/", (boolean)false, (int)2, null)) break;
                        String string = context2.file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
                        String currentColor = Lint.getBaseName(string);
                        Node node = element;
                        String string2 = color.substring("@color/".length());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                        this.handleReference(context2, node, ResourceType.COLOR, currentColor, string2);
                        break;
                    }
                    if (folderType != ResourceFolderType.DRAWABLE || (drawable = element.getAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) == null || !StringsKt.startsWith$default((String)drawable, (String)"@drawable/", (boolean)false, (int)2, null)) break;
                    String string = context2.file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
                    String currentColor = Lint.getBaseName(string);
                    Node node = element;
                    String string3 = drawable.substring("@drawable/".length());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    this.handleReference(context2, node, ResourceType.DRAWABLE, currentColor, string3);
                    break;
                }
                case 4: {
                    Object name;
                    Attr nameNode = element.getAttributeNode("name");
                    Attr parentNode = element.getAttributeNode("parent");
                    if (parentNode != null && nameNode != null) {
                        name = nameNode.getValue();
                        String parent = parentNode.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
                        if (StringsKt.startsWith$default((String)parent, (String)"@style/", (boolean)false, (int)2, null)) {
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            if (StringsKt.startsWith$default((String)parent, (String)name, (int)"@style/".length(), (boolean)false, (int)4, null) && StringsKt.startsWith$default((String)parent, (String)".", (int)("@style/".length() + ((String)name).length()), (boolean)false, (int)4, null)) {
                                if (context2.isEnabled(CYCLE) && context2.getDriver().getPhase() == 1) {
                                    Node node = parentNode;
                                    Location location2 = context2.getLocation(parentNode);
                                    String string = parent.substring("@style/".length());
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                                    XmlContext.report$default(context2, CYCLE, node, location2, "Potential cycle: `" + (String)name + "` is the implied parent of `" + string + "` and this defines the opposite", null, 16, null);
                                }
                                return;
                            }
                        }
                        if (!(((CharSequence)parent).length() == 0) && !StringsKt.startsWith$default((String)parent, (String)"@android:style/", (boolean)false, (int)2, null)) {
                            String string = parent.substring(StringsKt.lastIndexOf$default((CharSequence)parent, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            String parentName = string;
                            Node node = parentNode;
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            this.handleReference(context2, node, ResourceType.STYLE, (String)name, parentName);
                            if (StringsKt.startsWith$default((String)parent, (String)"@", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)parent, (CharSequence)"style/", (boolean)false, (int)2, null)) {
                                XmlContext.report$default(context2, CYCLE, parentNode, context2.getLocation(parentNode), "Invalid parent reference: expected a @style", null, 16, null);
                            }
                        }
                    } else if (this.mReferences != null && nameNode != null) {
                        name = nameNode.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                        int index2 = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)name), (char)'.', (int)0, (boolean)false, (int)6, null);
                        if (index2 > 0) {
                            String string = ((String)name).substring(0, index2);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            String parent = string;
                            if (this.mReferences != null) {
                                if (this.mLocations != null) {
                                    Attr node = element.getAttributeNode("name");
                                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                                    this.recordLocation(context2, node, ResourceType.STYLE, (String)name);
                                } else {
                                    this.recordReference(ResourceType.STYLE, (String)name, parent);
                                }
                            }
                        }
                    }
                    if (!context2.isEnabled(CRASH) || context2.getDriver().getPhase() != 1) break;
                    for (Element item : XmlUtils.getSubTags((Node)element)) {
                        if (!Intrinsics.areEqual((Object)"android:id", (Object)item.getAttribute("name"))) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                        this.checkCrashItem(context2, item);
                    }
                    break;
                }
                case 1: {
                    Attr layoutNode = element.getAttributeNode("layout");
                    if (layoutNode == null) break;
                    String layout = layoutNode.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)layout, (String)"layout");
                    if (!StringsKt.startsWith$default((String)layout, (String)"@layout/", (boolean)false, (int)2, null)) break;
                    String string = context2.file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
                    String currentLayout = Lint.getBaseName(string);
                    this.handleReference(context2, layoutNode, ResourceType.LAYOUT, currentLayout, layout);
                    break;
                }
                case 3: {
                    NodeList childNodes = element.getChildNodes();
                    int n3 = childNodes.getLength();
                    for (int i = 0; i < n3; ++i) {
                        char c;
                        Node child = childNodes.item(i);
                        if (child.getNodeType() != 3) continue;
                        String text = child.getNodeValue();
                        int max = text.length();
                        for (int k = 0; k < max && !Character.isWhitespace(c = text.charAt(k)) && c == '@'; ++k) {
                            String to;
                            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                            if (!StringsKt.startsWith$default((String)text, (String)tagName, (int)(k + 1), (boolean)false, (int)4, null)) break;
                            String $this$trim$iv = text;
                            int $i$f$trim = 0;
                            CharSequence $this$trim$iv$iv = $this$trim$iv;
                            boolean $i$f$trim3 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            $i$f$trim = tagName.length() + 2;
                            Intrinsics.checkNotNullExpressionValue((Object)$this$trim$iv.substring($i$f$trim), (String)"this as java.lang.String).substring(startIndex)");
                            String name = element.getAttribute("name");
                            ResourceType type = ResourceType.fromXmlTagName((String)tagName);
                            if (type == null) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            this.handleReference(context2, child, type, name, to);
                        }
                    }
                    break;
                }
                case 5: {
                    Attr text = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "font");
                    if (text == null) break;
                    String string = text.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.value");
                    if (!StringsKt.startsWith$default((String)string, (String)"@font/", (boolean)false, (int)2, null)) break;
                    String string4 = text.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"text.value");
                    String $this$trim$iv = string4;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim4 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    int n4 = "@font/".length();
                    String string5 = $this$trim$iv.substring(n4);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                    String font = string5;
                    String string6 = context2.file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.file.name");
                    String currentFont = Lint.getBaseName(string6);
                    this.handleReference(context2, text, ResourceType.FONT, currentFont, font);
                }
            }
        }
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map<ResourceType, Multimap<String, String>> map2 = this.mReferences;
        if (map2 == null) {
            return;
        }
        Map<ResourceType, Multimap<String, String>> references2 = map2;
        int phase = context2.getDriver().getPhase();
        if (phase == 1) {
            for (Map.Entry<ResourceType, Multimap<String, String>> entry : references2.entrySet()) {
                ResourceType type = entry.getKey();
                Multimap<String, String> map3 = entry.getValue();
                this.findCycles(context2, type, map3);
            }
        } else {
            boolean bl;
            boolean bl2 = bl = phase == 2;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Map<ResourceType, List<List<String>>> map4 = this.mChains;
            if (map4 == null) {
                return;
            }
            Map<ResourceType, List<List<String>>> chainsMap = map4;
            Map<ResourceType, Multimap<String, Location>> map5 = this.mLocations;
            if (map5 == null) {
                return;
            }
            Map<ResourceType, Multimap<String, Location>> locationMap = map5;
            for (Map.Entry<ResourceType, List<List<String>>> entry : chainsMap.entrySet()) {
                ResourceType type = entry.getKey();
                List<List<String>> chains = entry.getValue();
                Multimap multimap = locationMap.get(type);
                if (multimap == null) {
                    multimap = (Multimap)ArrayListMultimap.create();
                }
                Multimap locations = multimap;
                for (List<String> chain : chains) {
                    String message2;
                    boolean bl3;
                    Location location2 = null;
                    boolean bl4 = bl3 = !chain.isEmpty();
                    if (_Assertions.ENABLED && !bl3) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    int n = chain.size();
                    for (int i = 0; i < n; ++i) {
                        String item = chain.get(i);
                        Collection itemLocations = locations.get((Object)item);
                        if (itemLocations.isEmpty()) continue;
                        Location itemLocation = (Location)itemLocations.iterator().next();
                        String next = chain.get((i + 1) % chain.size());
                        String label = "Reference from @" + type.getName() + "/" + item + " to " + type.getName() + "/" + next + " here";
                        itemLocation.setMessage(label);
                        itemLocation.setSecondary(location2);
                        location2 = itemLocation;
                    }
                    if (location2 == null) {
                        File file = context2.getProject().getDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.project.dir");
                        location2 = Location.Companion.create(file);
                    } else {
                        Location curr = location2.getSecondary();
                        while (curr != null) {
                            Location next = curr.getSecondary();
                            if (next == location2) {
                                curr.setSecondary(null);
                                break;
                            }
                            curr = next;
                        }
                    }
                    String string = "%1$s Resource definition cycle: %2$s";
                    Object[] objectArray = new Object[]{type.getDisplayName(), Joiner.on((String)" => ").join((Iterable)chain)};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                    Context.report$default(context2, CYCLE, location2, message2, null, 8, null);
                }
            }
        }
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        ResourceFolderType resourceFolderType = context2.getResourceFolderType();
        if (resourceFolderType == null || resourceFolderType == ResourceFolderType.VALUES) {
            return;
        }
        String value = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0 || !StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@id/", (boolean)false, (int)2, null)) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType);
        String primary = ((ResourceType)types.get(0)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)primary, (String)"primary");
        if (!StringsKt.regionMatches((String)value, (int)1, (String)primary, (int)0, (int)primary.length(), (boolean)false)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl url = resourceUrl;
        if (!types.contains(url.type)) {
            return;
        }
        if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)attribute.getNamespaceURI())) {
            return;
        }
        String string = context2.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
        String from = Lint.getBaseName(string);
        Node node = attribute;
        ResourceType resourceType = url.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"url.type");
        String string2 = url.name;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.name");
        this.handleReference(context2, node, resourceType, from, string2);
    }

    private final void handleReference(XmlContext context2, Node node, ResourceType type, String from, String to) {
        if (Intrinsics.areEqual((Object)from, (Object)to)) {
            if (context2.isEnabled(CYCLE) && context2.getDriver().getPhase() == 1) {
                String string;
                Location location2 = context2.getLocation(node);
                String string2 = type.getDisplayName();
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        string = "include";
                        break;
                    }
                    case 2: {
                        string = "extend";
                        break;
                    }
                    default: {
                        string = "reference";
                    }
                }
                XmlContext.report$default(context2, CYCLE, node, location2, string2 + " `" + to + "` should not " + string + " itself", null, 16, null);
            }
        } else if (this.mReferences != null) {
            if (this.mLocations != null) {
                this.recordLocation(context2, node, type, from);
            } else {
                this.recordReference(type, from, to);
            }
        }
    }

    private final void findCycles(Context context2, ResourceType type, Multimap<String, String> map2) {
        HashSet visiting = Sets.newHashSet();
        HashSet visited = Sets.newHashSetWithExpectedSize((int)map2.size());
        HashSet seen = Sets.newHashSetWithExpectedSize((int)map2.size());
        for (String from : map2.keySet()) {
            Map chains;
            List<List<String>> list2;
            if (seen.contains(from)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)from, (String)"from");
            Intrinsics.checkNotNullExpressionValue((Object)visiting, (String)"visiting");
            Set set = visiting;
            Intrinsics.checkNotNullExpressionValue((Object)visited, (String)"visited");
            List<String> chain = this.dfs(map2, from, set, visited);
            if (chain == null || chain.size() <= 2) continue;
            seen.addAll((Collection)chain);
            CollectionsKt.reverse(chain);
            Map map3 = this.mChains;
            if (map3 == null) {
                ResourceCycleDetector $this$findCycles_u24lambda_u2d3 = this;
                boolean bl = false;
                EnumMap newMap2 = Maps.newEnumMap(ResourceType.class);
                $this$findCycles_u24lambda_u2d3.mChains = newMap2;
                $this$findCycles_u24lambda_u2d3.mLocations = Maps.newEnumMap(ResourceType.class);
                context2.getDriver().requestRepeat($this$findCycles_u24lambda_u2d3, Scope.RESOURCE_FILE_SCOPE);
                EnumMap enumMap = newMap2;
                Intrinsics.checkNotNullExpressionValue((Object)enumMap, (String)"run {\n                  \u2026Map\n                    }");
                map3 = enumMap;
            }
            if ((list2 = (chains = map3).get(type)) == null) {
                Map map4 = chains;
                Object object = new List[]{chain};
                object = CollectionsKt.mutableListOf((Object[])object);
                map4.put((ResourceType)type, (List<List<String>>)object);
                continue;
            }
            list2.add(chain);
        }
    }

    private final void checkCrashItem(XmlContext context2, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int max = text.length();
            for (int k = 0; k < max; ++k) {
                String name;
                int endIndex$iv$iv;
                int startIndex$iv$iv;
                CharSequence $this$trim$iv$iv;
                String $this$trim$iv;
                char c = text.charAt(k);
                if (Character.isWhitespace(c)) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                if (StringsKt.startsWith$default((String)text, (String)"@+id/", (int)k, (boolean)false, (int)4, null)) {
                    $this$trim$iv = text;
                    boolean $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                } else {
                    return;
                }
                $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                int n2 = "@+id/".length();
                Intrinsics.checkNotNullExpressionValue((Object)$this$trim$iv.substring(n2), (String)"this as java.lang.String).substring(startIndex)");
                String message2 = "This construct can potentially crash `aapt` during a build. Change `@+id/" + name + "` to `@id/" + name + "` and define the id explicitly using `<item type=\"id\" name=\"" + name + "\"/>` instead.";
                XmlContext.report$default(context2, CRASH, item, context2.getLocation(item), message2, null, 16, null);
            }
        }
    }

    private final List<String> dfs(Multimap<String, String> map2, String from, Set<String> visiting, Set<String> visited) {
        visiting.add(from);
        visited.add(from);
        Collection targets = map2.get((Object)from);
        if (targets != null && !targets.isEmpty()) {
            for (String target2 : targets) {
                List<Object> chain;
                if (visiting.contains(target2)) {
                    chain = Lists.newArrayList();
                    ((ArrayList)chain).add(target2);
                    ((ArrayList)chain).add(from);
                    return chain;
                }
                if (visited.contains(target2)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)target2, (String)"target");
                chain = this.dfs(map2, target2, visiting, visited);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector$Companion;", "", "()V", "CRASH", "Lcom/android/tools/lint/detector/api/Issue;", "CYCLE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            nArray[ResourceType.LAYOUT.ordinal()] = 1;
            nArray[ResourceType.STYLE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

