/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0005H\u0002J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/RecyclerViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkDataBinders", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UMethod;", "references", "Lorg/jetbrains/uast/UCallExpression;", "checkMethod", "Lcom/intellij/psi/PsiMethod;", "cls", "Lcom/intellij/psi/PsiClass;", "getApplicableMethodNames", "isExecutePendingBindingsCall", "", "call", "reportError", "viewHolder", "Lcom/intellij/psi/PsiParameter;", "parameter", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitMethodCall", "node", "method", "Companion", "ParameterEscapesVisitor", "android.sdktools.lint-checks"})
public final class RecyclerViewDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RecyclerViewDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue FIXED_POSITION;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDER;
    @JvmField
    @NotNull
    public static final Issue CLEAR_ALL_DATA;
    @NotNull
    private static final String ON_BIND_VIEW_HOLDER = "onBindViewHolder";
    @NotNull
    private static final String NOTIFY_DATA_SET_CHANGED = "notifyDataSetChanged";
    @NotNull
    private static final String SUPERCLASS_SUPPORTLIB = "android.support.v7.widget.RecyclerView.Adapter";
    @NotNull
    private static final String SUPERCLASS_ANDROIDX = "androidx.recyclerview.widget.RecyclerView.Adapter";

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{SUPERCLASS_SUPPORTLIB, SUPERCLASS_ANDROIDX};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)NOTIFY_DATA_SET_CHANGED);
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context2.getEvaluator();
        PsiMethod[] psiMethodArray = declaration.findMethodsByName(ON_BIND_VIEW_HOLDER, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"declaration.findMethodsB\u2026_BIND_VIEW_HOLDER, false)");
        for (PsiMethod method : psiMethodArray) {
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            int size = evaluator.getParameterCount(method);
            switch (size) {
                case 2: 
                case 3: {
                    this.checkMethod(context2, method, (PsiClass)declaration);
                }
            }
        }
    }

    private final void checkMethod(JavaContext context2, PsiMethod declaration, PsiClass cls) {
        PsiParameter[] parameters = declaration.getParameterList().getParameters();
        PsiParameter viewHolder = parameters[0];
        PsiParameter parameter = parameters[1];
        Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
        ParameterEscapesVisitor visitor2 = new ParameterEscapesVisitor(cls, parameter);
        UMethod uMethod = Lint.getUMethod(declaration);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        method.accept((UastVisitor)visitor2);
        if (visitor2.variableEscapes()) {
            Intrinsics.checkNotNullExpressionValue((Object)viewHolder, (String)"viewHolder");
            this.reportError(context2, viewHolder, parameter);
        }
        this.checkDataBinders(context2, method, visitor2.getDataBinders());
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)NOTIFY_DATA_SET_CHANGED) && (JavaEvaluator.isMemberInSubClassOf$default(context2.getEvaluator(), (PsiMember)method, SUPERCLASS_SUPPORTLIB, false, 4, null) || JavaEvaluator.isMemberInSubClassOf$default(context2.getEvaluator(), (PsiMember)method, SUPERCLASS_ANDROIDX, false, 4, null))) {
            Context.report$default(context2, CLEAR_ALL_DATA, context2.getLocation((UElement)node), "It will always be more efficient to use more specific change events if you can. Rely on `notifyDataSetChanged` as a last resort.", null, 8, null);
        }
    }

    private final void reportError(JavaContext context2, PsiParameter viewHolder, PsiParameter parameter) {
        String string = viewHolder.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"viewHolder.name");
        String variablePrefix = string;
        String message2 = "Do not treat position as fixed; only use immediately and call `" + variablePrefix + ".getAdapterPosition()` to look it up later";
        JavaContext.report$default(context2, FIXED_POSITION, (PsiElement)parameter, context2.getLocation((PsiElement)parameter), message2, null, 16, null);
    }

    private final void checkDataBinders(JavaContext context2, UMethod declaration, List<? extends UCallExpression> references2) {
        if (references2 != null && !((Collection)references2).isEmpty()) {
            ArrayList targets = Lists.newArrayList();
            ArrayList sources = Lists.newArrayList();
            for (UCallExpression uCallExpression : references2) {
                if (this.isExecutePendingBindingsCall(uCallExpression)) {
                    targets.add(uCallExpression);
                    continue;
                }
                sources.add(uCallExpression);
            }
            HashMap parentToChildren = Maps.newHashMap();
            for (UCallExpression reference : sources) {
                Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"reference");
                UExpression statement = (UExpression)UastUtils.getParentOfType((UElement)((UElement)reference), UExpression.class, (boolean)true);
                if (statement == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)parentToChildren, (String)"parentToChildren");
                ((Map)parentToChildren).put(statement.getUastParent(), reference);
            }
            for (UCallExpression source : parentToChildren.values()) {
                UExpression sourceBinderReference;
                if (source.getReceiver() == null || RecyclerViewDetector.Companion.getDataBinderReference((UElement)sourceBinderReference) == null) continue;
                boolean reachesTarget = false;
                for (UCallExpression target2 : targets) {
                    PsiField sourceDataBinder;
                    if (!Intrinsics.areEqual((Object)sourceDataBinder, (Object)RecyclerViewDetector.Companion.getDataBinderReference((UElement)target2.getReceiver())) || !CutPasteDetector.isReachableFrom(declaration, (UElement)source, (UElement)target2)) continue;
                    reachesTarget = true;
                    break;
                }
                if (reachesTarget) continue;
                String lhs = sourceBinderReference.asSourceString();
                String message2 = "You must call `" + lhs + ".executePendingBindings()` before the `onBind` method exits, otherwise, the DataBinding library will update the UI in the next animation frame causing a delayed update & potential jumps if the item resizes.";
                Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
                Location location2 = context2.getLocation((UElement)source);
                JavaContext.report$default(context2, DATA_BINDER, (UElement)source, location2, message2, null, 16, null);
            }
        }
    }

    private final boolean isExecutePendingBindingsCall(UCallExpression call) {
        return Intrinsics.areEqual((Object)"executePendingBindings", (Object)Lint.getMethodName(call));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        FIXED_POSITION = Issue.Companion.create$default(companion, "RecyclerView", "RecyclerView Problems", "\n                `RecyclerView` will **not** call `onBindViewHolder` again when the position \\\n                of the item changes in the data set unless the item itself is invalidated or \\\n                the new position cannot be determined.\n\n                For this reason, you should **only** use the position parameter while \\\n                acquiring the related data item inside this method, and should **not** keep \\\n                a copy of it.\n\n                If you need the position of an item later on (e.g. in a click listener), use \\\n                `getAdapterPosition()` which will have the updated adapter position.\n                ", implementation, null, category, 8, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        DATA_BINDER = Issue.Companion.create$default(companion, "PendingBindings", "Missing Pending Bindings", "\n                When using a `ViewDataBinding` in a `onBindViewHolder` method, you **must** \\\n                call `executePendingBindings()` before the method exits; otherwise the data \\\n                binding runtime will update the UI in the next animation frame causing a \\\n                delayed update and potential jumps if the item resizes.\n                ", implementation, null, category, 8, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        CLEAR_ALL_DATA = Issue.Companion.create$default(companion, "NotifyDataSetChanged", "Invalidating All RecyclerView Data", "\n                The `RecyclerView` adapter's `onNotifyDataSetChanged` method does not specify what \\\n                about the data set has changed, forcing any observers to assume that all existing \\\n                items and structure may no longer be valid. `LayoutManager`s will be forced to \\\n                fully rebind and relayout all visible views.\n                ", implementation, null, category, 8, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/RecyclerViewDetector$ParameterEscapesVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "bindClass", "Lcom/intellij/psi/PsiClass;", "variable", "Lcom/intellij/psi/PsiParameter;", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/psi/PsiParameter;)V", "dataBinders", "", "Lorg/jetbrains/uast/UCallExpression;", "getDataBinders", "()Ljava/util/List;", "setDataBinders", "(Ljava/util/List;)V", "escapes", "", "foundInnerClass", "variables", "Lcom/intellij/psi/PsiVariable;", "variableEscapes", "visitBinaryExpression", "node", "Lorg/jetbrains/uast/UBinaryExpression;", "visitCallExpression", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitVariable", "Lorg/jetbrains/uast/UVariable;", "android.sdktools.lint-checks"})
    private static final class ParameterEscapesVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final PsiClass bindClass;
        @NotNull
        private final List<PsiVariable> variables;
        private boolean escapes;
        private boolean foundInnerClass;
        @Nullable
        private List<UCallExpression> dataBinders;

        public ParameterEscapesVisitor(@NotNull PsiClass bindClass, @NotNull PsiParameter variable) {
            Intrinsics.checkNotNullParameter((Object)bindClass, (String)"bindClass");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.bindClass = bindClass;
            Object[] objectArray = new PsiVariable[]{(PsiVariable)variable};
            ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(variable)");
            this.variables = arrayList;
        }

        @Nullable
        public final List<UCallExpression> getDataBinders() {
            return this.dataBinders;
        }

        public final void setDataBinders(@Nullable List<UCallExpression> list2) {
            this.dataBinders = list2;
        }

        public final boolean variableEscapes() {
            return this.escapes;
        }

        public boolean visitVariable(@NotNull UVariable node) {
            PsiElement resolved;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression initializer = node.getUastInitializer();
            if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) {
                if (resolved instanceof ULocalVariable) {
                    this.variables.add((PsiVariable)node);
                } else if (resolved instanceof PsiField) {
                    this.escapes = true;
                }
            }
            return super.visitVariable(node);
        }

        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getOperator() instanceof UastBinaryOperator.AssignOperator) {
                PsiElement resolved;
                UExpression rhs = node.getRightOperand();
                boolean clearLhs = true;
                if (rhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)rhs).resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) {
                    clearLhs = false;
                    PsiElement resolvedLhs = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
                    if (resolvedLhs instanceof PsiLocalVariable) {
                        this.variables.add((PsiVariable)resolvedLhs);
                    } else if (resolvedLhs instanceof PsiField) {
                        this.escapes = true;
                    }
                }
                if (clearLhs && (resolved = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()))) != null) {
                    TypeIntrinsics.asMutableCollection((Object)this.variables).remove(resolved);
                }
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            UElement outer;
            PsiElement resolved;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.foundInnerClass && (resolved = node.resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved) && !Intrinsics.areEqual((Object)this.bindClass, (Object)(outer = UastUtils.getParentOfType((UElement)((UElement)node), UClass.class, (boolean)true)))) {
                this.escapes = true;
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof UAnonymousClass || !node.isStatic()) {
                this.foundInnerClass = true;
            }
            return super.visitClass(node);
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            UExpression methodExpression;
            PsiField dataBinder;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)node)) && (dataBinder = Companion.getDataBinderReference((UElement)(methodExpression = node.getReceiver()))) != null) {
                List list2 = this.dataBinders;
                if (list2 == null) {
                    ParameterEscapesVisitor $this$visitCallExpression_u24lambda_u2d0 = this;
                    boolean bl = false;
                    ArrayList arrayList = Lists.newArrayList();
                    $this$visitCallExpression_u24lambda_u2d0.dataBinders = arrayList;
                    list2 = arrayList;
                }
                List list3 = list2;
                list3.add((UCallExpression)node);
            }
            return super.visitCallExpression(node);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/RecyclerViewDetector$Companion;", "", "()V", "CLEAR_ALL_DATA", "Lcom/android/tools/lint/detector/api/Issue;", "DATA_BINDER", "FIXED_POSITION", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "NOTIFY_DATA_SET_CHANGED", "", "ON_BIND_VIEW_HOLDER", "SUPERCLASS_ANDROIDX", "SUPERCLASS_SUPPORTLIB", "getDataBinderReference", "Lcom/intellij/psi/PsiField;", "element", "Lorg/jetbrains/uast/UElement;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiField getDataBinderReference(UElement element) {
            PsiElement resolved;
            if (element instanceof UReferenceExpression && (resolved = ((UReferenceExpression)element).resolve()) instanceof PsiField && Intrinsics.areEqual((Object)"dataBinder", (Object)((PsiField)resolved).getName())) {
                return (PsiField)resolved;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

