/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.PluralExample;
import com.android.tools.lint.checks.PluralExamplesLookup;
import com.android.tools.lint.checks.PluralsDatabase;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/PluralsDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
public final class PluralsDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PluralsDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @NotNull
    private static final Map<String, PluralsDatabase.Quantity> NEW_PLURAL_FORMS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"fr", (Object)((Object)PluralsDatabase.Quantity.many)));
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue EXTRA;
    @JvmField
    @NotNull
    public static final Issue IMPLIED_QUANTITY;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"plurals");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Object append;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int count = Lint.getChildCount(element);
        if (count == 0) {
            XmlContext.report$default(context2, MISSING, element, context2.getLocation(element), "There should be at least one quantity string in this `<plural>` definition", null, 16, null);
            return;
        }
        LocaleQualifier locale = Lint.getLocale(context2);
        if (locale == null || !locale.hasLanguage()) {
            return;
        }
        String string = locale.getLanguage();
        Intrinsics.checkNotNull((Object)string);
        String language = string;
        PluralsDatabase pluralsDatabase = PluralsDatabase.get();
        Intrinsics.checkNotNullExpressionValue((Object)pluralsDatabase, (String)"get()");
        PluralsDatabase plurals = pluralsDatabase;
        EnumSet<PluralsDatabase.Quantity> enumSet = plurals.getRelevant(language);
        if (enumSet == null) {
            return;
        }
        EnumSet<PluralsDatabase.Quantity> relevant = enumSet;
        EnumSet<PluralsDatabase.Quantity> defined = EnumSet.noneOf(PluralsDatabase.Quantity.class);
        NodeList children = element.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) {
                ++i;
                continue;
            }
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element child = (Element)node;
            if (!Intrinsics.areEqual((Object)"item", (Object)child.getTagName())) {
                ++i;
                continue;
            }
            String quantityString = child.getAttribute("quantity");
            Intrinsics.checkNotNullExpressionValue((Object)quantityString, (String)"quantityString");
            if (((CharSequence)quantityString).length() == 0) {
                ++i;
                continue;
            }
            PluralsDatabase.Quantity quantity = PluralsDatabase.Quantity.get(quantityString);
            if (quantity == null || quantity == PluralsDatabase.Quantity.other) {
                ++i;
                continue;
            }
            defined.add(quantity);
            if (plurals.hasMultipleValuesForQuantity(language, quantity) && !PluralsDetector.Companion.haveFormattingParameter(child) && context2.isEnabled(IMPLIED_QUANTITY)) {
                String example = plurals.findIntegerExamples(language, quantity);
                append = example == null ? "" : " (" + example + ")";
                String message2 = StringsKt.trimIndent((String)("\n                    The quantity `'" + quantity + "'` matches more than one specific number in this locale" + (String)append + ", but the message did not \\\n                    include a formatting argument (such as `%d`). This is usually an internationalization error. See full issue \\\n                    explanation for more.\n                    "));
                XmlContext.report$default(context2, IMPLIED_QUANTITY, child, context2.getLocation(child), message2, null, 16, null);
            }
            ++i;
        }
        if (Intrinsics.areEqual(relevant, defined)) {
            return;
        }
        Object object = relevant.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"relevant.clone()");
        Object missing = object;
        Intrinsics.checkNotNullExpressionValue(defined, (String)"defined");
        ((AbstractSet)missing).removeAll((Collection)defined);
        if (!((AbstractCollection)missing).isEmpty()) {
            void $this$mapTo$iv$iv;
            PluralExamplesLookup examplesLookup = PluralExamplesLookup.Companion.getInstance();
            Iterable $this$map$iv = (Iterable)missing;
            boolean $i$f$map = false;
            append = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String example;
                void form;
                PluralsDatabase.Quantity quantity = (PluralsDatabase.Quantity)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PluralExample pluralExample = examplesLookup.findExample(language, form.name());
                String string2 = example = pluralExample != null ? pluralExample.formattedWithNumber() : null;
                collection.add(example != null ? "`" + form.name() + "` (e.g. \"" + example + "\")" : "`" + form.name() + "`");
            }
            List withExamples = (List)destination$iv$iv;
            String languageDescription = TranslationDetector.Companion.getLanguageDescription(language);
            String message3 = withExamples.size() == 1 ? "For locale " + languageDescription + " the following quantity should also be defined: " + CollectionsKt.single((List)withExamples) : "For locale " + languageDescription + " the following quantities should also be defined: " + CollectionsKt.joinToString$default((Iterable)withExamples, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Incident incident = new Incident(MISSING, element, context2.getLocation(element), message3);
            if (NEW_PLURAL_FORMS.containsKey(language) && CollectionsKt.singleOrNull((Iterable)((Iterable)missing)) == NEW_PLURAL_FORMS.get(language)) {
                incident.overrideSeverity(Severity.WARNING);
            }
            context2.report(incident);
        }
        Object object2 = defined.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"defined.clone()");
        Object extra = object2;
        ((AbstractSet)extra).removeAll((Collection)relevant);
        if (!((Collection)extra).isEmpty()) {
            String string3 = "For language %1$s the following quantities are not relevant: %2$s";
            Object[] objectArray = new Object[]{TranslationDetector.Companion.getLanguageDescription(language), PluralsDatabase.Quantity.formatSet((EnumSet<PluralsDatabase.Quantity>)extra)};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            String message4 = string4;
            XmlContext.report$default(context2, EXTRA, element, context2.getLocation(element), message4, null, 16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.MESSAGES;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        MISSING = Issue.Companion.create$default(companion, "MissingQuantity", "Missing quantity translation", "\n                Different languages have different rules for grammatical agreement with quantity. In English, for example, the quantity 1 \\\n                is a special case. We write \"1 book\", but for any other quantity we'd write \"n books\". This distinction between singular \\\n                and plural is very common, but other languages make finer distinctions.\n\n                This lint check looks at each translation of a `<plural>` and makes sure that all the quantity strings considered by the \\\n                given language are provided by this translation.\n\n                For example, an English translation must provide a string for `quantity=\"one\"`. Similarly, a Czech translation must \\\n                provide a string for `quantity=\"few\"`.\n            ", implementation, "https://developer.android.com/guide/topics/resources/string-resource.html#Plurals", category, 8, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.MESSAGES;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        EXTRA = Issue.Companion.create$default(companion, "UnusedQuantity", "Unused quantity translations", "\n                Android defines a number of different quantity strings, such as `zero`, `one`, `few` and `many`. However, many languages \\\n                do not distinguish grammatically between all these different quantities.\n\n                This lint check looks at the quantity strings defined for each translation and flags any quantity strings that are unused \\\n                (because the language does not make that quantity distinction, and Android will therefore not look it up).\n\n                For example, in Chinese, only the `other` quantity is used, so even if you provide translations for `zero` and `one`, \\\n                these strings will **not** be returned when `getQuantityString()` is called, even with `0` or `1`.\n            ", implementation, "https://developer.android.com/guide/topics/resources/string-resource.html#Plurals", category, 3, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.MESSAGES;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        IMPLIED_QUANTITY = Issue.Companion.create$default(companion, "ImpliedQuantity", "Implied Quantities", "\n                Plural strings should generally include a `%s` or `%d` formatting argument. In locales like English, the `one` quantity \\\n                only applies to a single value, 1, but that's not true everywhere. For example, in Slovene, the `one` quantity will apply \\\n                to 1, 101, 201, 301, and so on. Similarly, there are locales where multiple values match the `zero` and `two` quantities.\n\n                In these locales, it is usually an error to have a message which does not include a formatting argument (such as '%d'), \\\n                since it will not be clear from the grammar what quantity the quantity string is describing.\n                ", implementation, "https://developer.android.com/guide/topics/resources/string-resource.html#Plurals", category, 5, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/PluralsDetector$Companion;", "", "()V", "EXTRA", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "IMPLIED_QUANTITY", "MISSING", "NEW_PLURAL_FORMS", "", "", "Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "containsExpandTemplate", "", "text", "haveFormattingParameter", "element", "Lorg/w3c/dom/Element;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean haveFormattingParameter(Element element) {
            NodeList children = element.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node child = children.item(i);
                short nodeType = child.getNodeType();
                if (nodeType == 1) {
                    Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    if (this.haveFormattingParameter((Element)child)) {
                        return true;
                    }
                } else if (nodeType == 3 || nodeType == 4) {
                    String text = child.getNodeValue();
                    Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                    if (this.containsExpandTemplate(text)) {
                        return true;
                    }
                    if (StringsKt.indexOf$default((CharSequence)text, (char)'%', (int)0, (boolean)false, (int)6, null) == -1) {
                        ++i;
                        continue;
                    }
                    if (StringFormatDetector.getFormatArgumentCount(text, null) >= 1) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        private final boolean containsExpandTemplate(String text) {
            int index2 = 0;
            while ((index2 = StringsKt.indexOf$default((CharSequence)text, (char)'^', (int)index2, (boolean)false, (int)4, null)) != -1 && index2 != text.length() - 1) {
                if (Character.isDigit(text.charAt(index2 + 1))) {
                    return true;
                }
                ++index2;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

