/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObsoleteLayoutParamsDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("ObsoleteLayoutParam", "Obsolete layout params", "The given layout_param is not defined for the given layout, meaning it has no effect. This usually happens when you change the parent layout or move view code around without updating the layout params. This will cause useless attribute processing at runtime, and is misleading for others reading the layout so the parameter should be removed.", Category.PERFORMANCE, 6, Severity.WARNING, new Implementation(ObsoleteLayoutParamsDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private Map<String, List<Pair<File, String>>> mIncludes;
    private final List<Pair<String, Location.Handle>> mPending = new ArrayList<Pair<String, Location.Handle>>();

    private static boolean isValid(String attribute) {
        switch (attribute) {
            case "layout_width": 
            case "layout_height": 
            case "layout_gravity": 
            case "layout_marginLeft": 
            case "layout_marginStart": 
            case "layout_marginRight": 
            case "layout_marginEnd": 
            case "layout_marginTop": 
            case "layout_marginBottom": 
            case "layout_margin": {
                return true;
            }
        }
        return false;
    }

    private static String getLayoutForAttribute(String attribute) {
        switch (attribute) {
            case "layout_x": {
                return "AbsoluteLayout";
            }
            case "layout_y": {
                return "AbsoluteLayout";
            }
            case "layout_weight": {
                return "LinearLayout";
            }
            case "layout_column": {
                return "GridLayout";
            }
            case "layout_columnSpan": {
                return "GridLayout";
            }
            case "layout_row": {
                return "GridLayout";
            }
            case "layout_rowSpan": {
                return "GridLayout";
            }
            case "layout_span": {
                return "TableRow";
            }
            case "layout_alignLeft": {
                return "RelativeLayout";
            }
            case "layout_alignStart": {
                return "RelativeLayout";
            }
            case "layout_alignRight": {
                return "RelativeLayout";
            }
            case "layout_alignEnd": {
                return "RelativeLayout";
            }
            case "layout_alignTop": {
                return "RelativeLayout";
            }
            case "layout_alignBottom": {
                return "RelativeLayout";
            }
            case "layout_alignParentTop": {
                return "RelativeLayout";
            }
            case "layout_alignParentBottom": {
                return "RelativeLayout";
            }
            case "layout_alignParentLeft": {
                return "RelativeLayout";
            }
            case "layout_alignParentStart": {
                return "RelativeLayout";
            }
            case "layout_alignParentRight": {
                return "RelativeLayout";
            }
            case "layout_alignParentEnd": {
                return "RelativeLayout";
            }
            case "layout_alignWithParentIfMissing": {
                return "RelativeLayout";
            }
            case "layout_alignBaseline": {
                return "RelativeLayout";
            }
            case "layout_centerInParent": {
                return "RelativeLayout";
            }
            case "layout_centerVertical": {
                return "RelativeLayout";
            }
            case "layout_centerHorizontal": {
                return "RelativeLayout";
            }
            case "layout_toRightOf": {
                return "RelativeLayout";
            }
            case "layout_toEndOf": {
                return "RelativeLayout";
            }
            case "layout_toLeftOf": {
                return "RelativeLayout";
            }
            case "layout_toStartOf": {
                return "RelativeLayout";
            }
            case "layout_below": {
                return "RelativeLayout";
            }
            case "layout_above": {
                return "RelativeLayout";
            }
        }
        return null;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("include");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        String name = attribute.getLocalName();
        if (name != null && name.startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            if (ObsoleteLayoutParamsDetector.isValid(name)) {
                return;
            }
            String parent = ObsoleteLayoutParamsDetector.getLayoutForAttribute(name);
            if (parent != null) {
                Element viewElement = attribute.getOwnerElement();
                Node layoutNode = viewElement.getParentNode();
                if (layoutNode == null || layoutNode.getNodeType() != 1) {
                    if (context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                        Location.Handle handle2 = context2.createLocationHandle(attribute);
                        handle2.setClientData(attribute);
                        this.mPending.add((Pair<String, Location.Handle>)Pair.of((Object)name, (Object)handle2));
                    }
                    return;
                }
                String parentTag = ((Element)layoutNode).getTagName();
                if (parentTag.equals("merge")) {
                    if (context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                        Location.Handle handle3 = context2.createLocationHandle(attribute);
                        handle3.setClientData(attribute);
                        this.mPending.add((Pair<String, Location.Handle>)Pair.of((Object)name, (Object)handle3));
                    }
                    return;
                }
                if (!ObsoleteLayoutParamsDetector.isValidParamForParent(context2, name, parent, parentTag)) {
                    if (name.equals("layout_column") && ObsoleteLayoutParamsDetector.isValidParamForParent(context2, name, "TableRow", parentTag)) {
                        return;
                    }
                    context2.report(ISSUE, attribute, context2.getLocation(attribute), String.format("Invalid layout param in a `%1$s`: `%2$s`", parentTag, name));
                }
            }
        }
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String layout = element.getAttribute("layout");
        if (layout.startsWith("@layout/")) {
            String tag;
            layout = layout.substring("@layout/".length());
            Node parent = element.getParentNode();
            if (parent.getNodeType() == 1 && (tag = parent.getNodeName()).indexOf(46) == -1 && !tag.equals("merge")) {
                List<Pair<File, String>> includes;
                if (!context2.getProject().getReportIssues()) {
                    return;
                }
                if (this.mIncludes == null) {
                    this.mIncludes = new HashMap<String, List<Pair<File, String>>>();
                }
                if ((includes = this.mIncludes.get(layout)) == null) {
                    includes = new ArrayList<Pair<File, String>>();
                    this.mIncludes.put(layout, includes);
                }
                includes.add((Pair<File, String>)Pair.of((Object)context2.file, (Object)tag));
            }
        }
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mIncludes == null) {
            return;
        }
        for (Pair<String, Location.Handle> pending : this.mPending) {
            String name;
            String parent;
            List<Pair<File, String>> includes;
            Location.Handle handle2 = (Location.Handle)pending.getSecond();
            Location location2 = handle2.resolve();
            File file = location2.getFile();
            String layout = file.getName();
            if (layout.endsWith(".xml")) {
                layout = layout.substring(0, layout.length() - ".xml".length());
            }
            if ((includes = this.mIncludes.get(layout)) == null || (parent = ObsoleteLayoutParamsDetector.getLayoutForAttribute(name = (String)pending.getFirst())) == null) continue;
            boolean isValid = false;
            for (Pair<File, String> include : includes) {
                String parentTag = (String)include.getSecond();
                if (ObsoleteLayoutParamsDetector.isValidParamForParent(context2, name, parent, parentTag)) {
                    isValid = true;
                    break;
                }
                if (isValid || !name.equals("layout_column") || !ObsoleteLayoutParamsDetector.isValidParamForParent(context2, name, "TableRow", parentTag)) continue;
                isValid = true;
                break;
            }
            if (isValid) continue;
            Object clientData = handle2.getClientData();
            if (clientData instanceof Node && context2.getDriver().isSuppressed(null, ISSUE, (Node)clientData)) {
                return;
            }
            StringBuilder sb = new StringBuilder(40);
            for (Pair pair2 : includes) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                File from = (File)pair2.getFirst();
                String parentTag = (String)pair2.getSecond();
                sb.append(String.format("included from within a `%1$s` in `%2$s`", parentTag, Lint.getFileNameWithParent(context2.getClient(), from)));
            }
            String message2 = String.format("Invalid layout param '`%1$s`' (%2$s)", name, sb.toString());
            context2.report(ISSUE, location2, message2);
        }
    }

    private static boolean isValidParamForParent(Context context2, String name, String parent, String parentTag) {
        if (parentTag.indexOf(46) != -1 || parentTag.equals("view")) {
            return true;
        }
        SdkInfo sdk = context2.getSdkInfo();
        if (!parentTag.equals(parent)) {
            String tag = sdk.getParentViewName(parentTag);
            while (tag != null) {
                if (tag.equals(parent)) {
                    return true;
                }
                tag = sdk.getParentViewName(tag);
            }
            return false;
        }
        return true;
    }
}

