/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/MotionLayoutDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "references", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "Lcom/android/tools/lint/detector/api/Location;", "referencesRecorded", "", "resourceModel", "Lcom/android/ide/common/resources/usage/ResourceUsageModel;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "kotlin.jvm.PlatformType", "isIncrementalMode", "motionSceneUrlFromMotionLayoutFileName", "Lcom/android/tools/lint/detector/api/XmlContext;", "visitElement", "element", "Lorg/w3c/dom/Element;", "visitMotionLayout", "visitMotionScene", "Companion", "android.sdktools.lint-checks"})
public final class MotionLayoutDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean referencesRecorded;
    @Nullable
    private ResourceUsageModel resourceModel;
    @Nullable
    private Map<ResourceUsageModel.Resource, Location> references;
    @NotNull
    public static final String KEY_URL = "url";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MotionLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue INVALID_SCENE_FILE_REFERENCE = Issue.Companion.create("MotionLayoutInvalidSceneFileReference", "layoutDescription must specify a scene file", "\n                A motion scene file specifies the animations used in a `MotionLayout`. \\\n                The `layoutDescription` is required to specify a valid motion \\\n                scene file.\n                ", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{AndroidXConstants.MOTION_LAYOUT.oldName(), AndroidXConstants.MOTION_LAYOUT.newName(), "MotionScene"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!this.referencesRecorded) {
                return;
            }
            boolean isIncremental = this.isIncrementalMode(context2);
            Map<ResourceUsageModel.Resource, Location> map2 = this.references;
            if (map2 == null) break block2;
            Map<ResourceUsageModel.Resource, Location> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ResourceUsageModel.Resource, Location>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                ResourceUsageModel.Resource resource;
                Map.Entry<ResourceUsageModel.Resource, Location> element$iv;
                Map.Entry<ResourceUsageModel.Resource, Location> entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceUsageModel.Resource reference = entry.getKey();
                Location location2 = entry.getValue();
                ResourceUsageModel resourceUsageModel = this.resourceModel;
                ResourceUsageModel.Resource resource2 = resource = resourceUsageModel != null ? resourceUsageModel.getResource(reference.type, reference.name) : null;
                if (isIncremental || resource != null && resource.isDeclared()) continue;
                Object[] objectArray = new Object[]{KEY_URL, reference.getUrl()};
                context2.report(INVALID_SCENE_FILE_REFERENCE, location2, "The motion scene file: " + reference.getUrl() + " doesn't exist", this.fix().name("Create " + reference.getUrl()).data(objectArray));
            }
        }
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"MotionScene")) {
            this.visitMotionScene(context2, element);
        } else {
            this.visitMotionLayout(context2, element);
        }
    }

    private final void visitMotionScene(XmlContext context2, Element element) {
        ResourceFolderType resourceFolderType = context2.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType resourceFolderType2 = resourceFolderType;
        ResourceType resourceType = ResourceType.fromFolderName((String)resourceFolderType2.getName());
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        String name = FilesKt.getNameWithoutExtension((File)context2.file);
        ResourceUsageModel resourceUsageModel = this.resourceModel;
        if (resourceUsageModel == null) {
            ResourceUsageModel resourceUsageModel2;
            ResourceUsageModel it = resourceUsageModel2 = new ResourceUsageModel();
            boolean bl = false;
            this.resourceModel = it;
            resourceUsageModel = resourceUsageModel2;
        }
        ResourceUsageModel model2 = resourceUsageModel;
        model2.addDeclaredResource(resourceType2, name, null, true);
    }

    private final void visitMotionLayout(XmlContext context2, Element element) {
        Attr description = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (description == null) {
            String sceneUrl = this.motionSceneUrlFromMotionLayoutFileName(context2);
            Object[] objectArray = new Object[]{KEY_URL, sceneUrl};
            context2.report(INVALID_SCENE_FILE_REFERENCE, element, context2.getNameLocation(element), "The attribute: `layoutDescription` is missing", this.fix().name("Create " + sceneUrl + " and set attribute").data(objectArray));
        } else {
            ResourceUsageModel model2;
            ResourceUsageModel.Resource resource;
            ResourceUsageModel resourceUsageModel = this.resourceModel;
            if (resourceUsageModel == null) {
                ResourceUsageModel resourceUsageModel2;
                ResourceUsageModel it = resourceUsageModel2 = new ResourceUsageModel();
                boolean bl = false;
                this.resourceModel = it;
                resourceUsageModel = resourceUsageModel2;
            }
            if ((resource = (model2 = resourceUsageModel).getResourceFromUrl(description.getValue())) != null && resource.type == ResourceType.XML) {
                Map map2 = this.references;
                if (map2 == null) {
                    Map map3;
                    Map it = map3 = (Map)new LinkedHashMap();
                    boolean bl = false;
                    this.references = it;
                    map2 = map3;
                }
                Map references2 = map2;
                references2.put((ResourceUsageModel.Resource)resource, (Location)context2.getValueLocation(description));
                this.referencesRecorded = true;
            } else {
                String sceneUrl = this.motionSceneUrlFromMotionLayoutFileName(context2);
                Object[] objectArray = new Object[]{KEY_URL, sceneUrl};
                context2.report(INVALID_SCENE_FILE_REFERENCE, element, context2.getValueLocation(description), "`" + description.getValue() + "` is an invalid value for layoutDescription", this.fix().name("Create " + sceneUrl + " and set attribute").data(objectArray));
            }
        }
    }

    private final boolean isIncrementalMode(Context context2) {
        return !context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES);
    }

    private final String motionSceneUrlFromMotionLayoutFileName(XmlContext context2) {
        return "@xml/" + FilesKt.getNameWithoutExtension((File)context2.file) + "_scene";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/MotionLayoutDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INVALID_SCENE_FILE_REFERENCE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_URL", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

