/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/MonochromeLauncherIconDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "foundIconName", "", "foundRoundIconName", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
public final class MonochromeLauncherIconDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String foundIconName;
    @Nullable
    private String foundRoundIconName;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MonochromeLauncherIconDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"application", "adaptive-icon"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getTagName();
        if (Intrinsics.areEqual((Object)string, (Object)"application")) {
            String string2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.getAttributeNS(S\u2026, SdkConstants.ATTR_ICON)");
            this.foundIconName = StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
            String string3 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "roundIcon");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element.getAttributeNS(S\u2026onstants.ATTR_ROUND_ICON)");
            this.foundRoundIconName = StringsKt.substringAfterLast$default((String)string3, (char)'/', null, (int)2, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)"adaptive-icon")) {
            if (XmlUtils.getFirstSubTagByName((Node)element, (String)"monochrome") != null) {
                return;
            }
            String string4 = context2.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.file.name");
            String currentIconName = StringsKt.removeSuffix((String)string4, (CharSequence)".xml");
            if (Intrinsics.areEqual((Object)currentIconName, (Object)this.foundIconName) || Intrinsics.areEqual((Object)currentIconName, (Object)this.foundRoundIconName)) {
                String iconDescription = Intrinsics.areEqual((Object)currentIconName, (Object)this.foundIconName) ? "icon" : "roundIcon";
                context2.report(new Incident(ISSUE, element, context2.getLocation(element), "The application adaptive " + iconDescription + " is missing a monochrome tag"));
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.ICONS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "MonochromeLauncherIcon", "Monochrome icon is not defined", "\n                If `android:roundIcon` and `android:icon` are both in your manifest, \\\n                you must either remove the reference to `android:roundIcon` if it is not needed; or, supply \\\n                the monochrome icon in the drawable defined by the `android:roundIcon` and `android:icon` attribute.\n\n                For example, if `android:roundIcon` and `android:icon` are both in the manifest, a launcher might choose to use \\\n                `android:roundIcon` over `android:icon` to display the adaptive app icon. Therefore, your themed application icon\\\n                will not show if your monochrome attribute is not also specified in `android:roundIcon`.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/MonochromeLauncherIconDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

