/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastSpecialExpressionKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinPostfixOperators;
import org.jetbrains.uast.kotlin.kinds.KotlinSpecialExpressionKinds;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 K2\u00020\u0001:\u0001KB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u00105\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0004H\u0016J\u0010\u0010:\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u0004H\u0016J\u0018\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u001e\u001a\u00020%H\u0002J\u0018\u0010>\u001a\u00020\t2\u0006\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020\u0004H\u0016J\b\u0010?\u001a\u00020\tH\u0016J\u0012\u0010@\u001a\u00020\t2\b\u0010A\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010B\u001a\u00020\u001d2\u0006\u00108\u001a\u00020%H\u0016J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020/H\u0016J\u0010\u0010E\u001a\u00020\t2\u0006\u00108\u001a\u00020%H\u0016J\b\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020%H\u0016J\u0010\u0010I\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020+H\u0016J\n\u0010J\u001a\u00020G*\u00020\u0017J\n\u0010J\u001a\u00020G*\u00020\u0004R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006L"}, d2={"Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "initial", "", "Lorg/jetbrains/uast/UElement;", "initialReferences", "Lcom/intellij/psi/PsiVariable;", "(Ljava/util/Collection;Ljava/util/Collection;)V", "failedResolve", "", "getFailedResolve", "()Z", "setFailedResolve", "(Z)V", "getInitial", "()Ljava/util/Collection;", "instances", "", "getInstances", "()Ljava/util/Set;", "received", "getReceived", "references", "Lcom/intellij/psi/PsiElement;", "getReferences", "types", "Lcom/intellij/psi/PsiClass;", "getTypes", "addVariableReference", "", "node", "Lorg/jetbrains/uast/UVariable;", "afterVisitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "afterVisitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "afterVisitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "afterVisitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "afterVisitLabeledExpression", "Lorg/jetbrains/uast/ULabeledExpression;", "afterVisitParenthesizedExpression", "Lorg/jetbrains/uast/UParenthesizedExpression;", "afterVisitPostfixExpression", "Lorg/jetbrains/uast/UPostfixExpression;", "afterVisitReturnExpression", "Lorg/jetbrains/uast/UReturnExpression;", "afterVisitSwitchClauseExpression", "Lorg/jetbrains/uast/USwitchClauseExpression;", "afterVisitTryExpression", "Lorg/jetbrains/uast/UTryExpression;", "afterVisitVariable", "afterVisitYieldExpression", "Lorg/jetbrains/uast/UYieldExpression;", "argument", "call", "reference", "field", "handleLambdaSuffix", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "ignoreArgument", "ignoreCopies", "isMatchingType", "containingClass", "receiver", "returns", "expression", "returnsSelf", "toString", "", "visitCallExpression", "visitParenthesizedExpression", "id", "Companion", "android.sdktools.lint-checks"})
public abstract class DataFlowAnalyzer
extends AbstractUastVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<UElement> initial;
    private boolean failedResolve;
    @NotNull
    private final Set<PsiElement> references;
    @NotNull
    private final Set<UElement> instances;
    @NotNull
    private final Set<UElement> received;
    @NotNull
    private final Set<PsiClass> types;

    public DataFlowAnalyzer(@NotNull Collection<? extends UElement> initial, @NotNull Collection<? extends PsiVariable> initialReferences) {
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        Intrinsics.checkNotNullParameter(initialReferences, (String)"initialReferences");
        this.initial = initial;
        this.references = new LinkedHashSet();
        this.instances = new LinkedHashSet();
        this.received = new LinkedHashSet();
        this.types = new LinkedHashSet();
        if (this.references.isEmpty()) {
            this.references.addAll(initialReferences);
        }
        if (this.instances.isEmpty()) {
            this.instances.addAll(this.initial);
            for (UElement element : this.initial) {
                Object object;
                if (element instanceof UCallExpression) {
                    UElement parent = UastUtils.skipParenthesizedExprUp((UElement)element.getUastParent());
                    if (parent instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)parent).getSelector(), (Object)element)) {
                        this.instances.add(parent);
                    }
                } else if (element instanceof UVariable) {
                    PsiVariable reference;
                    object = element.getJavaPsi();
                    PsiVariable psiVariable = reference = object instanceof PsiVariable ? (PsiVariable)object : null;
                    if (reference != null && !this.references.contains(reference)) {
                        this.references.add((PsiElement)reference);
                    }
                }
                UExpression uExpression = element instanceof UExpression ? (UExpression)element : null;
                object = uExpression != null ? uExpression.getExpressionType() : null;
                PsiClassType type = object instanceof PsiClassType ? (PsiClassType)object : null;
                PsiClassType psiClassType = type;
                if (psiClassType != null && (psiClassType = psiClassType.resolve()) != null) {
                    PsiClassType it = psiClassType;
                    boolean bl = false;
                    this.types.add((PsiClass)it);
                }
            }
        }
    }

    public /* synthetic */ DataFlowAnalyzer(Collection collection, Collection collection2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        this(collection, collection2);
    }

    @NotNull
    public final Collection<UElement> getInitial() {
        return this.initial;
    }

    public void receiver(@NotNull UCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
    }

    public void returns(@NotNull UReturnExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
    }

    public void field(@NotNull UElement field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
    }

    public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
    }

    public final boolean getFailedResolve() {
        return this.failedResolve;
    }

    public final void setFailedResolve(boolean bl) {
        this.failedResolve = bl;
    }

    public void failedResolve(@NotNull UElement reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)reference.getUastParent());
        if (uElement == null) {
            return;
        }
        UElement curr = uElement;
        if (curr instanceof UQualifiedReferenceExpression && UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent()) instanceof UQualifiedReferenceExpression) {
            this.failedResolve = true;
            return;
        }
        while (!(curr instanceof UMethod)) {
            if (curr instanceof UDeclarationsExpression || curr instanceof UBinaryExpression && UastExpressionUtils.isAssignment((UElement)curr)) {
                this.failedResolve = true;
                return;
            }
            if (curr.getUastParent() == null) break;
        }
    }

    public boolean ignoreArgument(@NotNull UCallExpression call, @NotNull UElement reference) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        String string = call.getMethodName();
        if (string == null) {
            return false;
        }
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"print") || Intrinsics.areEqual((Object)name, (Object)"println") || Intrinsics.areEqual((Object)name, (Object)"log")) {
            return true;
        }
        if (name.length() == 1) {
            UExpression receiver;
            UExpression uExpression = call.getReceiver();
            Object object = receiver = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
            if (receiver instanceof USimpleNameReferenceExpression && Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)receiver).getIdentifier(), (Object)"Log")) {
                return true;
            }
        }
        return false;
    }

    public boolean returnsSelf(@NotNull UCallExpression call) {
        PsiClass returnTypeClass;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            DataFlowAnalyzer $this$returnsSelf_u24lambda_u2d0 = this;
            boolean bl = false;
            $this$returnsSelf_u24lambda_u2d0.failedResolve((UElement)call);
            return false;
        }
        PsiMethod resolvedCall = psiMethod;
        if (call.getReturnType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (this.ignoreCopies()) {
            String string = Lint.getMethodName(call);
            if (string != null) {
                String name = string;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)name, (Object)"copy") || Intrinsics.areEqual((Object)name, (Object)"clone") || StringsKt.startsWith$default((String)name, (String)"to", (boolean)false, (int)2, null) && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
                    return false;
                }
            }
        }
        PsiClass psiClass = UastLintUtilsKt.getReceiverOrContainingClass((PsiMember)resolvedCall);
        if (psiClass == null) {
            return false;
        }
        PsiClass containingClass = psiClass;
        PsiType psiType = call.getReturnType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        Object object = returnTypeClass = psiClassType != null ? psiClassType.resolve() : null;
        if (Intrinsics.areEqual((Object)returnTypeClass, (Object)containingClass)) {
            return true;
        }
        if (UastLintUtilsKt.isReturningContext(call)) {
            return true;
        }
        if (returnTypeClass != null && !Intrinsics.areEqual((Object)containingClass.getName(), (Object)"Object") && returnTypeClass.isInheritor(containingClass, true)) {
            return true;
        }
        return Intrinsics.areEqual((Object)call.getReturnType(), (Object)Companion.getTypeOfExtensionMethod(resolvedCall));
    }

    public boolean ignoreCopies() {
        return true;
    }

    @NotNull
    protected final Set<PsiElement> getReferences() {
        return this.references;
    }

    @NotNull
    protected final Set<UElement> getInstances() {
        return this.instances;
    }

    @NotNull
    protected final Set<UElement> getReceived() {
        return this.received;
    }

    @NotNull
    protected final Set<PsiClass> getTypes() {
        return this.types;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        ULambdaExpression lambda;
        UElement parentParent;
        UElement parent;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression uExpression = node.getReceiver();
        UExpression receiver = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        boolean matched = false;
        if (receiver != null) {
            if (this.instances.contains(receiver)) {
                matched = true;
            } else {
                PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)receiver));
                if (resolved != null && this.references.contains(resolved)) {
                    matched = true;
                }
            }
        } else if (this.received.contains(node)) {
            matched = true;
        } else {
            List args;
            UCallExpression lambdaCall;
            UElement uElement = parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            parentParent = UastUtils.skipParenthesizedExprUp((UElement)(uElement != null ? uElement.getUastParent() : null));
            Object object = parent instanceof ULambdaExpression ? (ULambdaExpression)parent : null;
            if (object == null && (object = parentParent instanceof ULambdaExpression ? (ULambdaExpression)parentParent : null) == null) {
                UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)parentParent);
                UElement uElement3 = uElement2 != null ? uElement2.getUastParent() : null;
                object = uElement3 instanceof ULambdaExpression ? (ULambdaExpression)uElement3 : null;
            }
            ULambdaExpression uLambdaExpression = lambda = object;
            UElement uElement4 = UastUtils.skipParenthesizedExprUp((UElement)(uLambdaExpression != null ? uLambdaExpression.getUastParent() : null));
            UCallExpression uCallExpression = lambdaCall = uElement4 instanceof UCallExpression ? (UCallExpression)uElement4 : null;
            if (lambdaCall != null && UastLintUtilsKt.isReturningContext(lambdaCall)) {
                if (this.instances.contains(node)) {
                    matched = true;
                }
            } else if (UastLintUtilsKt.isScopingThis(node) && (args = node.getValueArguments()).size() == 2 && CollectionsKt.contains((Iterable)this.instances, (Object)UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(0)))) && UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(1))) instanceof ULambdaExpression) {
                UExpression uExpression2 = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(1)));
                Intrinsics.checkNotNull((Object)uExpression2, (String)"null cannot be cast to non-null type org.jetbrains.uast.ULambdaExpression");
                this.handleLambdaSuffix((ULambdaExpression)uExpression2, node);
            }
        }
        if (matched) {
            ULambdaExpression lambda2;
            if (!this.initial.contains(node)) {
                this.receiver(node);
            }
            if (this.returnsSelf(node)) {
                this.instances.add((UElement)node);
                parentParent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                UQualifiedReferenceExpression uQualifiedReferenceExpression = parent = parentParent instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)parentParent : null;
                if (parent != null) {
                    UExpression chained;
                    this.instances.add(parent);
                    lambda = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
                    UElement uElement = parentParent = lambda instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)lambda : null;
                    Object object = chained = uElement != null ? uElement.getSelector() : null;
                    if (chained != null) {
                        this.instances.add((UElement)chained);
                    }
                }
            }
            UExpression uExpression3 = (UExpression)CollectionsKt.lastOrNull((List)node.getValueArguments());
            UExpression uExpression4 = uExpression3 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression3) : null;
            ULambdaExpression uLambdaExpression = lambda2 = uExpression4 instanceof ULambdaExpression ? (ULambdaExpression)uExpression4 : null;
            if (lambda2 != null) {
                this.handleLambdaSuffix(lambda2, node);
            }
        }
        return super.visitCallExpression(node);
    }

    public void afterVisitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (UExpression expression : node.getValueArguments()) {
            if (this.instances.contains(expression)) {
                if (this.ignoreArgument(node, (UElement)expression)) continue;
                this.argument(node, (UElement)expression);
                continue;
            }
            if (!(expression instanceof UReferenceExpression) || !CollectionsKt.contains((Iterable)this.references, (Object)((UReferenceExpression)expression).resolve())) continue;
            if (this.ignoreArgument(node, (UElement)expression)) break;
            this.argument(node, (UElement)expression);
            break;
        }
        super.afterVisitCallExpression(node);
    }

    private final void handleLambdaSuffix(ULambdaExpression lambda, UCallExpression node) {
        if (UastLintUtilsKt.isScopingIt(node)) {
            if (lambda.getValueParameters().size() == 1) {
                UParameter lambdaVar = (UParameter)CollectionsKt.first((List)lambda.getValueParameters());
                this.instances.add((UElement)lambdaVar);
                this.addVariableReference((UVariable)lambdaVar);
            }
        } else if (UastLintUtilsKt.isScopingThis(node)) {
            lambda.getBody().accept((UastVisitor)new AbstractUastVisitor(this){
                final /* synthetic */ DataFlowAnalyzer this$0;
                {
                    this.this$0 = $receiver;
                }

                private final void checkBinding(UElement node, PsiElement resolved, Set<UElement> target2) {
                    block4: {
                        PsiMember psiMember = resolved instanceof PsiMember ? (PsiMember)resolved : null;
                        if (psiMember == null) {
                            return;
                        }
                        PsiMember member = psiMember;
                        PsiClass containingClass = member.getContainingClass();
                        if (DataFlowAnalyzer.access$isMatchingType(this.this$0, containingClass)) {
                            target2.add(node);
                        }
                        if (!(member instanceof PsiMethod)) break block4;
                        PsiClassType psiClassType = DataFlowAnalyzer.Companion.getTypeOfExtensionMethod((PsiMethod)member);
                        if (psiClassType != null && (psiClassType = psiClassType.resolve()) != null) {
                            PsiClassType psiClassType2 = psiClassType;
                            DataFlowAnalyzer dataFlowAnalyzer = this.this$0;
                            PsiClassType extensionClass = psiClassType2;
                            boolean bl = false;
                            if (DataFlowAnalyzer.access$isMatchingType(dataFlowAnalyzer, (PsiClass)extensionClass)) {
                                target2.add(node);
                            }
                        }
                    }
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.checkBinding((UElement)node, node.resolve(), this.this$0.getReceived());
                    return super.visitSimpleNameReferenceExpression(node);
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    UExpression callReceiver;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UExpression uExpression = node.getReceiver();
                    Object object = callReceiver = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                    if (callReceiver == null) {
                        this.checkBinding((UElement)node, (PsiElement)node.resolve(), this.this$0.getReceived());
                    } else if (callReceiver instanceof UThisExpression) {
                        this.checkBinding((UElement)callReceiver, (PsiElement)node.resolve(), this.this$0.getInstances());
                    }
                    return super.visitCallExpression(node);
                }

                public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                    PsiClass typeClass;
                    UCallExpression parent;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                    UCallExpression uCallExpression = parent = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
                    PsiType psiType = uCallExpression != null ? uCallExpression.getExpressionType() : null;
                    PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    Object object = typeClass = psiClassType != null ? psiClassType.resolve() : null;
                    if (DataFlowAnalyzer.access$isMatchingType(this.this$0, typeClass) && parent != null && UastLintUtilsKt.isScopingThis(parent)) {
                        return true;
                    }
                    return super.visitLambdaExpression(node);
                }
            });
        }
    }

    private final boolean isMatchingType(PsiClass containingClass) {
        PsiClass it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block10: {
            if (containingClass == null) {
                return false;
            }
            $this$any$iv = this.types;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PsiClass)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)containingClass, (Object)it)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)containingClass.getName(), (Object)"Object")) {
            boolean bl3;
            block11: {
                $this$any$iv = this.types;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PsiClass)element$iv;
                        boolean bl4 = false;
                        if (!it.isInheritor(containingClass, true)) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }

    public boolean visitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.instances.contains(node)) {
            this.instances.add((UElement)node.getExpression());
        }
        return super.visitParenthesizedExpression(node);
    }

    public void afterVisitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.instances.contains(node.getExpression())) {
            this.instances.add((UElement)node);
        }
        super.afterVisitParenthesizedExpression(node);
    }

    public void afterVisitVariable(@NotNull UVariable node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof ULocalVariable) {
            UExpression initializer;
            UExpression uExpression = node.getUastInitializer();
            Object object = initializer = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
            if (initializer != null) {
                PsiElement resolved;
                if (this.instances.contains(initializer)) {
                    this.addVariableReference(node);
                } else if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) != null && this.references.contains(resolved)) {
                    this.addVariableReference(node);
                }
            }
        }
        super.afterVisitVariable(node);
    }

    public void afterVisitPostfixExpression(@NotNull UPostfixExpression node) {
        UExpression element;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getOperator(), (Object)KotlinPostfixOperators.EXCLEXCL) && this.instances.contains(element = node.getOperand())) {
            this.instances.add((UElement)node);
        }
        super.afterVisitPostfixExpression(node);
    }

    public void afterVisitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression element = node.getOperand();
        if (this.instances.contains(element)) {
            this.instances.add((UElement)node);
        }
        super.afterVisitBinaryExpressionWithType(node);
    }

    protected final void addVariableReference(@NotNull UVariable node) {
        block1: {
            PsiElement it;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                this.references.add(it);
            }
            PsiElement psiElement2 = node.getJavaPsi();
            PsiVariable psiVariable = psiElement2 instanceof PsiVariable ? (PsiVariable)psiElement2 : null;
            if (psiVariable == null) break block1;
            it = psiVariable;
            boolean bl = false;
            this.references.add(it);
        }
    }

    public void afterVisitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof USwitchClauseExpressionWithBody) {
            for (UExpression expression : ((USwitchClauseExpressionWithBody)node).getBody().getExpressions()) {
                if (!this.instances.contains(expression)) continue;
                UElement $this$getParentOfType$iv = (UElement)node;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                USwitchExpression uSwitchExpression = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, USwitchExpression.class, (boolean)strict$iv);
                if (uSwitchExpression == null) continue;
                this.instances.add((UElement)uSwitchExpression);
                break;
            }
        }
        super.afterVisitSwitchClauseExpression(node);
    }

    public void afterVisitYieldExpression(@NotNull UYieldExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UElement element = (UElement)node.getExpression();
        if (element != null && this.instances.contains(element)) {
            this.instances.add((UElement)node);
        }
        super.afterVisitYieldExpression(node);
    }

    public void afterVisitLabeledExpression(@NotNull ULabeledExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.instances.contains(node.getExpression())) {
            this.instances.add((UElement)node);
        }
        super.afterVisitLabeledExpression(node);
    }

    public void afterVisitIfExpression(@NotNull UIfExpression node) {
        UExpression elseExpression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!Lint.isJava(node.getSourcePsi())) {
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            if (parent instanceof UExpressionList && Intrinsics.areEqual((Object)((UExpressionList)parent).getKind(), (Object)KotlinSpecialExpressionKinds.ELVIS)) {
                PsiElement variable;
                UExpression then2;
                UExpression uExpression = node.getThenExpression();
                Object object = then2 = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                if (then2 instanceof USimpleNameReferenceExpression && (variable = ((USimpleNameReferenceExpression)then2).resolve()) != null) {
                    if (this.references.contains(variable)) {
                        this.instances.add(parent);
                    } else if (variable instanceof UVariable) {
                        PsiElement psi = ((UVariable)variable).getJavaPsi();
                        PsiElement sourcePsi = ((UVariable)variable).getSourcePsi();
                        if (psi != null && this.references.contains(psi) || sourcePsi != null && this.references.contains(sourcePsi)) {
                            this.instances.add(parent);
                        }
                    }
                }
            }
        } else if (!node.isTernary()) {
            super.afterVisitIfExpression(node);
            return;
        }
        UExpression uExpression = node.getThenExpression();
        UExpression thenExpression = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        UExpression uExpression2 = node.getElseExpression();
        Object object = elseExpression = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
        if (thenExpression != null && this.instances.contains(thenExpression)) {
            this.instances.add((UElement)node);
        } else if (elseExpression != null && this.instances.contains(elseExpression)) {
            this.instances.add((UElement)node);
        } else {
            UExpression it;
            if (thenExpression instanceof UBlockExpression) {
                UExpression uExpression3 = (UExpression)CollectionsKt.lastOrNull((List)((UBlockExpression)thenExpression).getExpressions());
                if (uExpression3 != null) {
                    it = uExpression3;
                    boolean bl = false;
                    if (this.instances.contains(it)) {
                        this.instances.add((UElement)node);
                    }
                }
            }
            if (elseExpression instanceof UBlockExpression) {
                UExpression uExpression4 = (UExpression)CollectionsKt.lastOrNull((List)((UBlockExpression)elseExpression).getExpressions());
                if (uExpression4 != null) {
                    it = uExpression4;
                    boolean bl = false;
                    if (this.instances.contains(it)) {
                        this.instances.add((UElement)node);
                    }
                }
            }
        }
        super.afterVisitIfExpression(node);
    }

    public void afterVisitTryExpression(@NotNull UTryExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression uExpression = node.getTryClause();
        UBlockExpression uBlockExpression = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
        if (uBlockExpression == null) {
            return;
        }
        UBlockExpression tryBlock = uBlockExpression;
        UExpression uExpression2 = (UExpression)CollectionsKt.lastOrNull((List)tryBlock.getExpressions());
        if (uExpression2 != null) {
            UExpression lastExpression = uExpression2;
            boolean bl = false;
            if (this.instances.contains(lastExpression)) {
                this.instances.add((UElement)node);
            }
        }
        for (UCatchClause clause : node.getCatchClauses()) {
            UExpression lastExpression;
            UExpression uExpression3 = clause.getBody();
            UBlockExpression uBlockExpression2 = uExpression3 instanceof UBlockExpression ? (UBlockExpression)uExpression3 : null;
            if (uBlockExpression2 == null) continue;
            UBlockExpression clauseBody = uBlockExpression2;
            if ((UExpression)CollectionsKt.lastOrNull((List)clauseBody.getExpressions()) == null) continue;
            boolean bl = false;
            if (!this.instances.contains(lastExpression)) continue;
            this.instances.add((UElement)node);
        }
        super.afterVisitTryExpression(node);
    }

    public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
        PsiElement resolved;
        PsiElement lhs;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!UastExpressionUtils.isAssignment((UElement)((UElement)node))) {
            super.afterVisitBinaryExpression(node);
            return;
        }
        boolean clearLhs = true;
        UExpression rhs = node.getRightOperand();
        if (this.instances.contains(rhs)) {
            lhs = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
            if (lhs instanceof UVariable) {
                this.addVariableReference((UVariable)lhs);
            } else if (lhs instanceof PsiLocalVariable) {
                this.references.add(lhs);
            } else if (lhs instanceof PsiParameter) {
                this.references.add(lhs);
            } else if (lhs instanceof PsiField) {
                this.field((UElement)rhs);
            } else if (lhs instanceof PsiMethod) {
                this.field((UElement)rhs);
            }
        } else if (rhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)rhs).resolve()) != null && this.references.contains(resolved)) {
            clearLhs = false;
            PsiElement lhs2 = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
            if (lhs2 instanceof UVariable) {
                this.addVariableReference((UVariable)lhs2);
            } else if (lhs2 instanceof PsiParameter) {
                this.references.add(lhs2);
            } else if (lhs2 instanceof PsiLocalVariable) {
                this.references.add(lhs2);
            } else if (lhs2 instanceof PsiField) {
                this.field((UElement)rhs);
            } else if (lhs2 instanceof PsiMethod) {
                this.field((UElement)rhs);
            }
        }
        if (clearLhs) {
            UElement block;
            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)node.getLeftOperand());
            Object object = lhs = uExpression != null ? UastUtils.tryResolve((UElement)((UElement)uExpression)) : null;
            if (lhs != null && !Intrinsics.areEqual((Object)lhs, this.initial) && this.references.contains(lhs) && (block = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent())) instanceof UBlockExpression && this.initial.size() == 1) {
                Object object2 = CollectionsKt.first((Iterable)this.initial);
                UExpression uExpression2 = object2 instanceof UExpression ? (UExpression)object2 : null;
                if (uExpression2 == null || (uExpression2 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2)) == null) {
                    return;
                }
                UExpression element = uExpression2;
                if (UastLintUtilsKt.isBelow$default((UElement)element, (UElement)node, false, 2, null)) {
                    return;
                }
                Class[] classArray = new Class[]{UIfExpression.class};
                UElement uElement = UastUtils.getParentOfType((UElement)((UElement)element), (boolean)false, UBlockExpression.class, (Class[])classArray);
                if (uElement == null) {
                    return;
                }
                UElement initialBlock = uElement;
                if (initialBlock == block) {
                    this.references.remove(lhs);
                } else if (UastLintUtilsKt.isBelow$default((UElement)node, initialBlock, false, 2, null)) {
                    Ref.BooleanRef referenced = new Ref.BooleanRef();
                    UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                    if (uElement2 == null) {
                        return;
                    }
                    UElement target2 = uElement2;
                    initialBlock.accept((UastVisitor)new AbstractUastVisitor(target2, lhs, referenced){
                        private boolean reachedTarget;
                        final /* synthetic */ UElement $target;
                        final /* synthetic */ PsiElement $lhs;
                        final /* synthetic */ Ref.BooleanRef $referenced;
                        {
                            this.$target = $target;
                            this.$lhs = $lhs;
                            this.$referenced = $referenced;
                        }

                        public void afterVisitElement(@NotNull UElement node) {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (Intrinsics.areEqual((Object)node, (Object)this.$target)) {
                                this.reachedTarget = true;
                            }
                            super.afterVisitElement(node);
                        }

                        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                            PsiElement resolved;
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (this.reachedTarget && this.$lhs.isEquivalentTo(resolved = node.resolve())) {
                                this.$referenced.element = true;
                                return true;
                            }
                            return super.visitSimpleNameReferenceExpression(node);
                        }
                    });
                    if (!referenced.element) {
                        this.references.remove(lhs);
                    }
                }
            }
        }
        super.afterVisitBinaryExpression(node);
    }

    public void afterVisitReturnExpression(@NotNull UReturnExpression node) {
        UExpression returnValue;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression uExpression = node.getReturnExpression();
        Object object = returnValue = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        if (returnValue != null) {
            PsiElement resolved;
            if (this.instances.contains(returnValue)) {
                this.returns(node);
            } else if (returnValue instanceof UReferenceExpression && (resolved = ((UReferenceExpression)returnValue).resolve()) != null && this.references.contains(resolved)) {
                this.returns(node);
            }
        }
        super.afterVisitReturnExpression(node);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Instances:\n");
        for (UElement instance : this.instances) {
            sb.append(this.id(instance));
            sb.append("\n");
        }
        if (!((Collection)this.received).isEmpty()) {
            sb.append("Receivers:\n");
            for (UElement receiver : this.received) {
                sb.append(this.id(receiver));
                sb.append("\n");
            }
        }
        if (!((Collection)this.references).isEmpty()) {
            sb.append("References:\n");
            for (PsiElement reference : this.references) {
                sb.append(this.id(reference));
                sb.append("\n");
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String id(@NotNull UElement $this$id) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        String string3 = Integer.toHexString(System.identityHashCode($this$id));
        Object object = $this$id.getSourcePsi();
        if (object != null && (object = object.getText()) != null) {
            CharSequence charSequence = (CharSequence)object;
            Regex regex = new Regex("\\s+");
            String string4 = " ";
            string2 = regex.replace(charSequence, string4);
        } else {
            string2 = null;
        }
        String s = string3 + ":" + string2;
        int max = 100;
        if (s.length() > max) {
            String string5 = s.substring(0, max / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string6 = s.substring(s.length() - (max / 2 + 3));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
            string = string5 + "..." + string6;
        } else {
            string = s;
        }
        return string;
    }

    @NotNull
    public final String id(@NotNull PsiElement $this$id) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        String string3 = Integer.toHexString(System.identityHashCode($this$id));
        String string4 = $this$id.getText();
        if (string4 != null) {
            CharSequence charSequence = string4;
            Regex regex = new Regex("\\s+");
            String string5 = " ";
            string2 = regex.replace(charSequence, string5);
        } else {
            string2 = null;
        }
        String s = string3 + ":" + string2;
        int max = 100;
        if (s.length() > max) {
            String string6 = s.substring(0, max / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string7 = s.substring(s.length() - (max / 2 + 3));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
            string = string6 + "..." + string7;
        } else {
            string = s;
        }
        return string;
    }

    public static final /* synthetic */ boolean access$isMatchingType(DataFlowAnalyzer $this, PsiClass containingClass) {
        return $this.isMatchingType(containingClass);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/DataFlowAnalyzer$Companion;", "", "()V", "getTypeOfExtensionMethod", "Lcom/intellij/psi/PsiClassType;", "method", "Lcom/intellij/psi/PsiMethod;", "getVariableElement", "Lcom/intellij/psi/PsiVariable;", "rhs", "Lorg/jetbrains/uast/UCallExpression;", "allowChainedCalls", "", "allowFields", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiClassType getTypeOfExtensionMethod(@NotNull PsiMethod method) {
            PsiParameter firstParameter;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
            PsiParameterList parameterList = psiParameterList;
            if (parameterList.getParametersCount() > 0 && (firstParameter = parameterList.getParameter(0)) != null) {
                String string = firstParameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"firstParameter.name");
                if (StringsKt.startsWith$default((String)string, (String)"$this$", (boolean)false, (int)2, null)) {
                    PsiType psiType = firstParameter.getType();
                    return psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                }
            }
            return null;
        }

        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)rhs)).getUastParent());
            if (allowChainedCalls) {
                while (parent instanceof UQualifiedReferenceExpression) {
                    UElement parentParent = UastUtils.skipParenthesizedExprUp((UElement)((UQualifiedReferenceExpression)parent).getUastParent());
                    if (parentParent instanceof UQualifiedReferenceExpression) {
                        parent = UastUtils.skipParenthesizedExprUp((UElement)((UQualifiedReferenceExpression)parentParent).getUastParent());
                        continue;
                    }
                    if (!(parentParent instanceof UVariable) && !(parentParent instanceof UPolyadicExpression)) break;
                    parent = parentParent;
                    break;
                }
            }
            if (parent != null && UastExpressionUtils.isAssignment((UElement)parent)) {
                PsiElement resolved;
                UBinaryExpression assignment = (UBinaryExpression)parent;
                UExpression lhs = assignment.getLeftOperand();
                if (lhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lhs).resolve()) instanceof PsiVariable && (allowFields || !(resolved instanceof PsiField))) {
                    return (PsiVariable)resolved;
                }
            } else if (parent instanceof UVariable && (allowFields || !(parent instanceof UField))) {
                if (((UVariable)parent).getUastParent() instanceof UDeclarationsExpression) {
                    UElement uElement = ((UVariable)parent).getUastParent();
                    Intrinsics.checkNotNull((Object)uElement);
                    if (uElement.getUastParent() instanceof UExpressionList) {
                        UElement uElement2 = ((UVariable)parent).getUastParent();
                        Intrinsics.checkNotNull((Object)uElement2);
                        UElement uElement3 = uElement2.getUastParent();
                        Intrinsics.checkNotNull((Object)uElement3, (String)"null cannot be cast to non-null type org.jetbrains.uast.UExpressionList");
                        UExpressionList exp = (UExpressionList)uElement3;
                        UastSpecialExpressionKind kind = exp.getKind();
                        if (Intrinsics.areEqual((Object)kind.getName(), (Object)"elvis") && exp.getUastParent() instanceof UVariable) {
                            parent = exp.getUastParent();
                        }
                    }
                }
                UElement uElement = parent;
                Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UVariable");
                return ((UVariable)uElement).getPsi();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

