/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationOrigin;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UImplicitCallExpression;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationMethod;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Companion", "android.sdktools.lint-checks"})
public final class CheckResultDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String KEY_SUGGESTION = "suggestion";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue CHECK_RESULT;
    @JvmField
    @NotNull
    public static final Issue CHECK_PERMISSION;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{"CheckResult", "CheckReturnValue", "CanIgnoreReturnValue"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type != AnnotationUsageType.METHOD_OVERRIDE && super.isApplicableAnnotationUsage(type);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (StringsKt.endsWith$default((String)annotationInfo.getQualifiedName(), (String)".CanIgnoreReturnValue", (boolean)false, (int)2, null)) {
            return;
        }
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        PsiType psiType = method.getReturnType();
        if (psiType == null) {
            return;
        }
        PsiType returnType = psiType;
        if (Intrinsics.areEqual((Object)returnType, (Object)PsiType.VOID) || method.isConstructor() || Intrinsics.areEqual((Object)returnType.getCanonicalText(), (Object)"kotlin.Unit")) {
            return;
        }
        if (annotationInfo.getOrigin() != AnnotationOrigin.METHOD && annotationInfo.isInherited()) {
            return;
        }
        if (Companion.isExpressionValueUnused(element)) {
            LintFix lintFix;
            if (context2.getEvaluator().isSuspend((PsiModifierListOwner)method)) {
                PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList.parameters");
                PsiParameter psiParameter = (PsiParameter)ArraysKt.lastOrNull((Object[])psiParameterArray);
                PsiType psiType2 = psiParameter != null ? psiParameter.getType() : null;
                PsiClassType psiClassType = psiType2 instanceof PsiClassType ? (PsiClassType)psiType2 : null;
                if (psiClassType == null) {
                    return;
                }
                PsiClassType classReference = psiClassType;
                PsiType[] psiTypeArray = classReference.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"classReference.parameters");
                Object object = ArraysKt.singleOrNull((Object[])psiTypeArray);
                PsiWildcardType psiWildcardType = object instanceof PsiWildcardType ? (PsiWildcardType)object : null;
                if (psiWildcardType == null) {
                    return;
                }
                PsiWildcardType wildcard = psiWildcardType;
                PsiType psiType3 = wildcard.getBound();
                if (psiType3 == null) {
                    return;
                }
                PsiType bound = psiType3;
                if (Intrinsics.areEqual((Object)bound, (Object)PsiType.VOID) || Intrinsics.areEqual((Object)bound.getCanonicalText(), (Object)"kotlin.Unit")) {
                    return;
                }
            }
            if (element instanceof UExpression) {
                PsiType psiType4 = ((UExpression)element).getExpressionType();
                if (Intrinsics.areEqual((Object)(psiType4 != null ? psiType4.getCanonicalText() : null), (Object)"java.lang.Void")) {
                    return;
                }
            }
            if (usageInfo.anyCloser((Function1<? super AnnotationInfo, Boolean>)((Function1)visitAnnotationUsage.1.INSTANCE))) {
                return;
            }
            if (context2.isTestSource() && Companion.expectsSideEffect(context2, element)) {
                return;
            }
            String methodName = JavaContext.Companion.getMethodName(element);
            UAnnotation annotation = annotationInfo.getAnnotation();
            String suggested = UastLintUtils.Companion.getAnnotationStringValue(annotation, "suggest");
            Issue issue = CHECK_RESULT;
            if (methodName != null && StringsKt.startsWith$default((String)methodName, (String)"check", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)methodName, (CharSequence)"Permission", (boolean)false, (int)2, null)) {
                issue = CHECK_PERMISSION;
            }
            Object[] objectArray = "The result of `%1$s` is not used";
            Object[] objectArray2 = new Object[]{methodName};
            String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
            Object message2 = string;
            if (suggested != null) {
                objectArray = "The result of `%1$s` is not used; did you mean to call `%2$s`?";
                objectArray2 = new Object[]{methodName, suggested};
                String string2 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                message2 = string2;
            } else if (Intrinsics.areEqual((Object)"intersect", (Object)methodName) && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                message2 = (String)message2 + ". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.";
            }
            if (suggested != null) {
                objectArray = new Object[]{KEY_SUGGESTION, suggested};
                lintFix = this.fix().data(objectArray);
            } else {
                lintFix = null;
            }
            LintFix fix = lintFix;
            Location location2 = context2.getLocation(element);
            this.report(context2, issue, element, location2, (String)message2, fix);
        }
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)CheckResultDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), (EnumSet<Scope>)object);
        CHECK_RESULT = Issue.Companion.create("CheckResult", "Ignoring results", "\n                Some methods have no side effects, and calling them without doing something \\\n                with the result is suspicious.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
        object = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        CHECK_PERMISSION = Issue.Companion.create$default((Issue.Companion)object, "UseCheckPermission", "Using the result of check permission calls", "\n                You normally want to use the result of checking a permission; these methods \\\n                return whether the permission is held; they do not throw an error if the \\\n                permission is not granted. Code which does not do anything with the return \\\n                value probably meant to be calling the enforce methods instead, e.g. rather \\\n                than `Context#checkCallingPermission` it should call \\\n                `Context#enforceCallingPermission`.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/CheckResultDetector$Companion;", "", "()V", "CHECK_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "CHECK_RESULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEY_SUGGESTION", "", "expectsSideEffect", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "isExpressionValueUnused", "isThrowingRunnable", "s", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean expectsSideEffect(@NotNull JavaContext context2, @NotNull UElement element) {
            UElement previousStatement;
            PsiElement resolved;
            List annotations;
            String methodName;
            UElement nextStatement;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            UMethod containingMethod = (UMethod)UastUtils.getParentOfType$default((UElement)element, UMethod.class, (boolean)false, (int)2, null);
            UExpression uExpression = UastLintUtilsKt.nextStatement(element);
            Object object = nextStatement = uExpression != null ? UastLintUtilsKt.findSelector((UElement)uExpression) : null;
            if (nextStatement instanceof UCallExpression && (methodName = ((UCallExpression)nextStatement).getMethodName()) != null) {
                switch (methodName.hashCode()) {
                    case 3135262: {
                        if (methodName.equals("fail")) return true;
                        break;
                    }
                    case 2580550: {
                        if (methodName.equals("TODO")) return true;
                        break;
                    }
                    case 96784904: {
                        if (!methodName.equals("error")) break;
                        return true;
                    }
                }
            }
            UMethod uMethod = containingMethod;
            List list2 = annotations = uMethod != null ? uMethod.getUAnnotations() : null;
            if (annotations != null) {
                boolean bl;
                Iterable $this$any$iv = annotations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"org.junit.Test") && it.findDeclaredAttributeValue("expected") != null) {
                            return true;
                        }
                        boolean bl3 = false;
                        if (!bl3) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            if (nextStatement == null) {
                UElement containingClass;
                UElement lambda = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getParentOfType$default((UElement)element, ULambdaExpression.class, (boolean)false, (int)2, null));
                if (lambda instanceof UExpression) {
                    UElement call = ((UExpression)lambda).getUastParent();
                    if (call instanceof UCallExpression && (resolved = ((UCallExpression)call).resolve()) != null) {
                        String string = resolved.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolved.name");
                        String methodName2 = string;
                        if (Intrinsics.areEqual((Object)methodName2, (Object)"assertFails")) return true;
                        if (Intrinsics.areEqual((Object)methodName2, (Object)"assertFailsWith")) {
                            return true;
                        }
                        PsiParameter parameter = context2.getEvaluator().computeArgumentMapping((UCallExpression)call, (PsiMethod)resolved).get(lambda);
                        if (parameter != null) {
                            String string2 = parameter.getType().getCanonicalText();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter.type.canonicalText");
                            if (this.isThrowingRunnable(string2)) {
                                return true;
                            }
                        }
                    }
                } else if (containingMethod != null && (containingClass = containingMethod.getUastParent()) instanceof UAnonymousClass) {
                    PsiElement psiElement = ((UAnonymousClass)containingClass).getSuperTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"containingClass.superTypes");
                    for (PsiClassType type : psiElement) {
                        String string = type.getCanonicalText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.canonicalText");
                        if (!this.isThrowingRunnable(string)) continue;
                        return true;
                    }
                }
            }
            UExpression uExpression2 = UastLintUtilsKt.previousStatement(element);
            Object object2 = previousStatement = uExpression2 != null ? UastLintUtilsKt.findSelector((UElement)uExpression2) : null;
            if (previousStatement instanceof UCallExpression) {
                PsiMethod psiMethod = ((UCallExpression)previousStatement).resolve();
                if (psiMethod != null) {
                    String containingClass;
                    PsiMethod calledMethod = psiMethod;
                    boolean bl = false;
                    PsiClass psiClass = calledMethod.getContainingClass();
                    String string = containingClass = psiClass != null ? psiClass.getQualifiedName() : null;
                    if (Intrinsics.areEqual((Object)containingClass, (Object)"org.junit.rules.ExpectedException")) {
                        return true;
                    }
                }
            }
            if (!(element instanceof UCallExpression)) return false;
            UExpression receiver = ((UCallExpression)element).getReceiver();
            if (!(receiver instanceof UResolvable)) return false;
            resolved = ((UResolvable)receiver).resolve();
            if (!(resolved instanceof PsiMethod)) return false;
            PsiClass psiClass = ((PsiMethod)resolved).getContainingClass();
            if (psiClass == null) return false;
            String string = psiClass.getQualifiedName();
            String containingClass = string;
            if (containingClass == null) return false;
            if (!StringsKt.startsWith$default((String)containingClass, (String)"org.mockito.", (boolean)false, (int)2, null)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isThrowingRunnable(String s) {
            String string = s;
            switch (string.hashCode()) {
                case -971971376: {
                    if (string.equals("com.google.truth.ExpectFailure.DelegatedAssertionCallback")) return true;
                    return false;
                }
                case -542244434: {
                    if (string.equals("com.google.truth.ExpectFailure.SimpleSubjectBuilderCallback")) return true;
                    return false;
                }
                case 1272351205: {
                    if (string.equals("org.junit.function.ThrowingRunnable")) return true;
                    return false;
                }
                case 215653183: {
                    if (string.equals("com.google.truth.ExpectFailure.AssertionCallback")) return true;
                    return false;
                }
                case -1427655663: {
                    if (string.equals("org.junit.jupiter.api.function.Executable")) return true;
                    return false;
                }
                case 740268665: {
                    if (string.equals("com.google.truth.ExpectFailure.StandardSubjectBuilderCallback")) return true;
                    return false;
                }
                case -1007284543: {
                    if (string.equals("org.assertj.core.api.ThrowableAssert$ThrowingCallable")) return true;
                    return false;
                }
                case -954336362: {
                    if (!string.equals("com.google.devtools.build.lib.testutil.MoreAsserts$ThrowingRunnable")) return false;
                    return true;
                }
            }
            return false;
        }

        public final boolean isExpressionValueUnused(@NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof UParenthesizedExpression) {
                return this.isExpressionValueUnused((UElement)((UParenthesizedExpression)element).getExpression());
            }
            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)false);
            if (uExpression == null) {
                return true;
            }
            UElement prev = (UElement)uExpression;
            if (prev instanceof UImplicitCallExpression) {
                prev = (UElement)((UImplicitCallExpression)prev).getExpression();
            }
            UElement uElement = prev.getUastParent();
            if (uElement == null) {
                return true;
            }
            UElement curr = uElement;
            while (curr instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)curr).getSelector() == prev || curr instanceof UParenthesizedExpression) {
                prev = curr;
                if (curr.getUastParent() != null) continue;
                return true;
            }
            if (curr instanceof UBlockExpression) {
                PsiExpression lock;
                PsiElement sourcePsi = curr.getSourcePsi();
                if (sourcePsi instanceof PsiSynchronizedStatement && (lock = ((PsiSynchronizedStatement)sourcePsi).getLockExpression()) != null && UastLintUtilsKt.isBelow$default(element.getSourcePsi(), (PsiElement)lock, false, 2, null)) {
                    return false;
                }
                UElement block = curr;
                UElement expression = prev;
                int index2 = CollectionsKt.indexOf((List)((UBlockExpression)block).getExpressions(), (Object)expression);
                if (index2 == -1) {
                    return true;
                }
                if (index2 < ((UBlockExpression)block).getExpressions().size() - 1) {
                    return true;
                }
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
                if (parent instanceof ULambdaExpression && Lint.isKotlin(sourcePsi)) {
                    String expressionType;
                    PsiType psiType = ((ULambdaExpression)parent).getExpressionType();
                    String string = expressionType = psiType != null ? psiType.getCanonicalText() : null;
                    return expressionType != null && StringsKt.startsWith$default((String)expressionType, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)expressionType, (String)"kotlin.Unit>", (boolean)false, (int)2, null);
                }
                if (Lint.isJava(sourcePsi)) {
                    return true;
                }
                if (parent == null) {
                    return true;
                }
                if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                    return true;
                }
                return this.isExpressionValueUnused(parent);
            }
            if (curr instanceof UMethod && ((UMethod)curr).isConstructor()) {
                return true;
            }
            if (curr instanceof UIfExpression) {
                if (((UIfExpression)curr).getCondition() == prev) {
                    return false;
                }
                if (((UIfExpression)curr).isTernary()) {
                    return false;
                }
                UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
                if (uElement2 == null) {
                    return true;
                }
                UElement parent = uElement2;
                if (parent instanceof UMethod || parent instanceof UClassInitializer) {
                    return true;
                }
                return this.isExpressionValueUnused(curr);
            }
            if (curr instanceof UMethod || curr instanceof UClassInitializer) {
                return !(curr instanceof UAnnotationMethod);
            }
            if (curr instanceof UYieldExpression) {
                UElement uElement3 = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent());
                UElement p2 = UastUtils.skipParenthesizedExprUp((UElement)(uElement3 != null ? uElement3.getUastParent() : null));
                USwitchClauseExpressionWithBody uSwitchClauseExpressionWithBody = p2 instanceof USwitchClauseExpressionWithBody ? (USwitchClauseExpressionWithBody)p2 : null;
                if (uSwitchClauseExpressionWithBody == null) {
                    return false;
                }
                USwitchClauseExpressionWithBody body = uSwitchClauseExpressionWithBody;
                USwitchExpression uSwitchExpression = (USwitchExpression)UastUtils.getParentOfType$default((UElement)((UElement)body), USwitchExpression.class, (boolean)false, (int)2, null);
                if (uSwitchExpression == null) {
                    return true;
                }
                USwitchExpression uSwitchExpression2 = uSwitchExpression;
                return this.isExpressionValueUnused((UElement)uSwitchExpression2);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

