/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.StringHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J(\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/CanvasSizeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "computeErrorMessage", "verb", "name", "calling", "", "replacement", "computeQuickfixMessage", "kotlin", "drawable", "computeQuickfixReplacementString", "reportWarning", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "containingClass", "Lorg/jetbrains/uast/UClass;", "visitClass", "declaration", "Companion", "android.sdktools.lint-checks"})
public final class CanvasSizeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CanvasSizeDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String CLASS_CANVAS = "android.graphics.Canvas";
    @NotNull
    private static final String CLASS_DRAWABLE = "android.graphics.drawable.Drawable";
    @NotNull
    private static final String ON_DRAW = "onDraw";
    @NotNull
    private static final String DRAW = "draw";
    @NotNull
    private static final String GET_WIDTH = "getWidth";
    @NotNull
    private static final String GET_HEIGHT = "getHeight";
    @NotNull
    private static final String WIDTH = "width";
    @NotNull
    private static final String HEIGHT = "height";

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{"android.view.View", CLASS_DRAWABLE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        evaluator = context.getEvaluator();
        $this$filter$iv = declaration.getMethods();
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var11_11 = ((void)$this$filterTo$iv$iv).length;
        for (var10_10 = 0; var10_10 < var11_11; ++var10_10) {
            it = element$iv$iv = $this$filterTo$iv$iv[var10_10];
            $i$a$-filter-CanvasSizeDetector$visitClass$drawMethods$1 = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)"onDraw")) ** GOTO lbl-1000
            if (Intrinsics.areEqual((Object)it.getName(), (Object)"draw")) {
                var15_15 = new String[]{"android.graphics.Canvas"};
                ** if (!evaluator.parametersMatch((PsiMethod)((PsiMethod)it), (String[])var15_15)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v0 = true;
                ** GOTO lbl21
            }
lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
lbl21:
            // 2 sources

            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        drawMethods = (List)destination$iv$iv;
        for (UMethod method : drawMethods) {
            method.accept((UastVisitor)new AbstractUastVisitor(context, this, declaration){
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ CanvasSizeDetector this$0;
                final /* synthetic */ UClass $declaration;
                {
                    this.$context = $context;
                    this.this$0 = $receiver;
                    this.$declaration = $declaration;
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    PsiMethod sizeMethod;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    String name = Lint.getMethodName(node);
                    if ((Intrinsics.areEqual((Object)name, (Object)"getWidth") || Intrinsics.areEqual((Object)name, (Object)"getHeight")) && (sizeMethod = node.resolve()) != null && this.$context.getEvaluator().isMemberInClass((PsiMember)sizeMethod, "android.graphics.Canvas")) {
                        CanvasSizeDetector.access$reportWarning(this.this$0, this.$context, (UElement)node, name, this.$declaration);
                    }
                    return super.visitCallExpression(node);
                }

                public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    String name;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UExpression selector = node.getSelector();
                    if (selector instanceof USimpleNameReferenceExpression && (Intrinsics.areEqual((Object)(name = ((USimpleNameReferenceExpression)selector).getIdentifier()), (Object)"width") || Intrinsics.areEqual((Object)name, (Object)"height"))) {
                        PsiType type;
                        UExpression receiver = node.getReceiver();
                        PsiType psiType = type = receiver.getExpressionType();
                        if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)"android.graphics.Canvas")) {
                            CanvasSizeDetector.access$reportWarning(this.this$0, this.$context, (UElement)node, name, this.$declaration);
                        }
                    }
                    return super.visitQualifiedReferenceExpression(node);
                }
            });
        }
    }

    private final void reportWarning(JavaContext context2, UElement node, String name, UClass containingClass) {
        boolean drawable = context2.getEvaluator().extendsClass((PsiClass)containingClass, CLASS_DRAWABLE, false);
        boolean calling = node instanceof UCallExpression;
        String verb = calling ? "Calling" : "Referencing";
        boolean kotlin = Lint.isKotlin(node.getSourcePsi());
        String replacement = drawable ? (kotlin ? "bounds." + name : "getBounds()." + name) : name;
        String message2 = this.computeErrorMessage(verb, name, calling, replacement);
        Location range = context2.getLocation(node);
        LintFix fix = this.fix().name(this.computeQuickfixMessage(kotlin, calling, drawable, name)).replace().range(range).pattern((String)(drawable ? "(.*)" : "(.*)" + name)).with(this.computeQuickfixReplacementString(kotlin, drawable, name)).build();
        context2.report(ISSUE, node, context2.getLocation(node), message2, fix);
    }

    private final String computeQuickfixReplacementString(boolean kotlin, boolean drawable, String name) {
        String string;
        if (drawable) {
            StringBuilder $this$computeQuickfixReplacementString_u24lambda_u2d1 = new StringBuilder();
            boolean bl = false;
            if (kotlin) {
                $this$computeQuickfixReplacementString_u24lambda_u2d1.append("bounds.");
            } else {
                $this$computeQuickfixReplacementString_u24lambda_u2d1.append("getBounds().");
            }
            $this$computeQuickfixReplacementString_u24lambda_u2d1.append(Intrinsics.areEqual((Object)name, (Object)GET_WIDTH) ? WIDTH : (Intrinsics.areEqual((Object)name, (Object)GET_HEIGHT) ? HEIGHT : name));
            String string2 = $this$computeQuickfixReplacementString_u24lambda_u2d1.append("()").toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            with(Strin\u2026   }.toString()\n        }");
        } else {
            string = "";
        }
        return string;
    }

    private final String computeErrorMessage(String verb, String name, boolean calling, String replacement) {
        StringBuilder $this$computeErrorMessage_u24lambda_u2d2 = new StringBuilder();
        boolean bl = false;
        $this$computeErrorMessage_u24lambda_u2d2.append(verb);
        $this$computeErrorMessage_u24lambda_u2d2.append(" `Canvas.").append(name);
        if (calling) {
            $this$computeErrorMessage_u24lambda_u2d2.append("()");
        }
        $this$computeErrorMessage_u24lambda_u2d2.append("` is usually wrong; you should be ");
        $this$computeErrorMessage_u24lambda_u2d2.append(StringHelper.usLocaleDecapitalize((String)verb));
        $this$computeErrorMessage_u24lambda_u2d2.append(" `");
        $this$computeErrorMessage_u24lambda_u2d2.append(replacement);
        if (calling) {
            $this$computeErrorMessage_u24lambda_u2d2.append("()");
        }
        String string = $this$computeErrorMessage_u24lambda_u2d2.append("` instead").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(StringBuilder()) {\n\u2026ad\")\n        }.toString()");
        return string;
    }

    private final String computeQuickfixMessage(boolean kotlin, boolean calling, boolean drawable, String name) {
        StringBuilder $this$computeQuickfixMessage_u24lambda_u2d3 = new StringBuilder();
        boolean bl = false;
        if (calling || drawable) {
            $this$computeQuickfixMessage_u24lambda_u2d3.append("Call");
        } else {
            $this$computeQuickfixMessage_u24lambda_u2d3.append("Reference");
        }
        $this$computeQuickfixMessage_u24lambda_u2d3.append(" ");
        if (drawable) {
            if (kotlin) {
                $this$computeQuickfixMessage_u24lambda_u2d3.append("bounds");
            } else {
                $this$computeQuickfixMessage_u24lambda_u2d3.append("getBounds()");
            }
            $this$computeQuickfixMessage_u24lambda_u2d3.append(".");
            $this$computeQuickfixMessage_u24lambda_u2d3.append(Intrinsics.areEqual((Object)name, (Object)GET_WIDTH) ? WIDTH : (Intrinsics.areEqual((Object)name, (Object)GET_HEIGHT) ? HEIGHT : name));
        } else {
            $this$computeQuickfixMessage_u24lambda_u2d3.append(name);
        }
        if (calling || drawable) {
            $this$computeQuickfixMessage_u24lambda_u2d3.append("()");
        }
        String string = $this$computeQuickfixMessage_u24lambda_u2d3.append(" instead").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(StringBuilder()) {\n\u2026ad\")\n        }.toString()");
        return string;
    }

    public static final /* synthetic */ void access$reportWarning(CanvasSizeDetector $this, JavaContext context2, UElement node, String name, UClass containingClass) {
        $this.reportWarning(context2, node, name, containingClass);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "CanvasSize", "Wrong Canvas Size", "\n                In a custom view's draw implementation, you should normally call `getWidth` \\\n                and `getHeight` on the custom view itself, not on the `canvas` instance.\n\n                Canvas width and height are the width and height of the `Canvas`, which is \\\n                not always the same as size of the view.\n\n                In the hardware accelerated path the width and height of the canvas \\\n                typically always match that of the `View` because every view goes to its own \\\n                recorded `DisplayList`. But in software rendering there's just one canvas \\\n                that is clipped and transformed as it makes its way through the `View` tree, \\\n                and otherwise remains the same `Canvas` object for every View's draw method.\n\n                You should only use Canvas state to adjust how much you draw, such as a \\\n                quick-reject for early work avoidance if it's going to be clipped away, but \\\n                not what you draw.\n                ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/CanvasSizeDetector$Companion;", "", "()V", "CLASS_CANVAS", "", "CLASS_DRAWABLE", "DRAW", "GET_HEIGHT", "GET_WIDTH", "HEIGHT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ON_DRAW", "WIDTH", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

