/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastOperator;
import org.jetbrains.uast.UastPostfixOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00160\u0013H\u0016J0\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/checks/AssertDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkKotlinAssertion", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "assertion", "Lorg/jetbrains/uast/UCallExpression;", "condition", "Lorg/jetbrains/uast/UExpression;", "checkSideEffect", "createKotlinAssertionStatusFix", "Lcom/android/tools/lint/detector/api/LintFix;", "assertCall", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableMethodNames", "", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "getSideEffect", "Lkotlin/Pair;", "node", "depth", "", "callDepth", "isAssertionStatusCheck", "", "isExpensive", "argument", "isLocal", "lhs", "isWithinAssertionStatusCheck", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "warnAboutWork", "Issues", "android.sdktools.lint-checks"})
public final class AssertDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue SIDE_EFFECT = Issue.Companion.create("AssertionSideEffect", "Assertions with Side Effects", "\n                Assertion conditions can have side effects. This is risky because the behavior \\\n                depends on whether assertions are on or off. This is usually not intentional, \\\n                and can lead to bugs where the production version differs from the version tested \\\n                during development.\n\n                Generally, you'll want to perform the operation with the side effect before the \\\n                assertion, and then assert that the result was what you expected.\n                ", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue EXPENSIVE;
    private static final int MAX_CALL_DEPTH;
    private static final int MAX_RECURSION_DEPTH;
    private static final int MAX_STATEMENT_COUNT;

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new UElementHandler(this, context2){
            final /* synthetic */ AssertDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!(node.getSourcePsi() instanceof PsiAssertStatement)) break block2;
                    PsiElement psiElement = node.getSourcePsi();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiAssertStatement");
                    PsiExpression psiExpression = ((PsiAssertStatement)psiElement).getAssertCondition();
                    if (psiExpression == null) {
                        return;
                    }
                    PsiExpression condition = psiExpression;
                    UElement uElement = UastFacade.INSTANCE.convertElement((PsiElement)condition, (UElement)node, UExpression.class);
                    if (uElement != null) {
                        UElement uElement2 = uElement;
                        AssertDetector assertDetector = this.this$0;
                        JavaContext javaContext = this.$context;
                        UElement it = uElement2;
                        boolean bl = false;
                        AssertDetector.access$checkSideEffect(assertDetector, javaContext, (UExpression)it);
                    }
                }
            }
        };
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"assert");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!Lint.isKotlin(node.getSourcePsi())) {
            return;
        }
        Object object = method.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object containingClass = object;
        if (!Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt") && !Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt__AssertionsJVMKt")) {
            return;
        }
        List valueArguments = node.getValueArguments();
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)valueArguments);
        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return;
        }
        UExpression first = uExpression;
        UExpression condition = first instanceof ULambdaExpression ? (UExpression)CollectionsKt.last((List)valueArguments) : first;
        this.checkKotlinAssertion(context2, node, condition);
        this.checkSideEffect(context2, condition);
    }

    private final void checkKotlinAssertion(JavaContext context2, UCallExpression assertion, UExpression condition) {
        if (context2.isEnabled(EXPENSIVE) && this.warnAboutWork(assertion, condition)) {
            UClass cls;
            Location location2 = context2.getLocation((UElement)condition);
            Object message2 = "Kotlin assertion arguments are always evaluated, even when assertions are off";
            LintFix fix = null;
            UClass uClass = cls = (UClass)UastUtils.getParentOfType((UElement)((UElement)assertion), UClass.class, (boolean)true);
            if ((uClass != null ? uClass.getSourcePsi() : null) != null) {
                fix = this.createKotlinAssertionStatusFix(context2, assertion);
                message2 = (String)message2 + ". Consider surrounding assertion with `if (javaClass.desiredAssertionStatus()) { assert(...) }`";
            } else {
                fix = null;
            }
            context2.report(EXPENSIVE, (UElement)assertion, location2, (String)message2, fix);
        }
    }

    private final void checkSideEffect(JavaContext context2, UExpression condition) {
        Pair<UExpression, String> sideEffect = this.getSideEffect(condition, 0, 0);
        if (sideEffect != null) {
            JavaContext.report$default(context2, SIDE_EFFECT, (UElement)condition, context2.getLocation((UElement)sideEffect.getFirst()), "Assertion condition has a side effect: " + sideEffect.getSecond(), null, 16, null);
        }
    }

    private final Pair<UExpression, String> getSideEffect(UExpression node, int depth, int callDepth) {
        if (node == null) {
            return null;
        }
        if (depth == MAX_RECURSION_DEPTH) {
            return null;
        }
        UExpression uExpression = node;
        if (uExpression instanceof UUnaryExpression) {
            UastOperator operator = ((UUnaryExpression)node).getOperator();
            if (Intrinsics.areEqual((Object)operator, (Object)UastPrefixOperator.INC) || Intrinsics.areEqual((Object)operator, (Object)UastPrefixOperator.DEC) || Intrinsics.areEqual((Object)operator, (Object)UastPostfixOperator.INC) || Intrinsics.areEqual((Object)operator, (Object)UastPostfixOperator.DEC)) {
                if (callDepth > 0 && this.isLocal(((UUnaryExpression)node).getOperand())) {
                    return null;
                }
                PsiElement psiElement = ((UUnaryExpression)node).getSourcePsi();
                String string = psiElement != null ? psiElement.getText() : null;
                if (string == null) {
                    string = ((UUnaryExpression)node).getOperator().getText();
                }
                return new Pair((Object)node, (Object)string);
            }
        } else if (uExpression instanceof UPolyadicExpression) {
            if (node instanceof UBinaryExpression && ((UPolyadicExpression)node).getOperator() instanceof UastBinaryOperator.AssignOperator && (callDepth == 0 || !this.isLocal(((UBinaryExpression)node).getLeftOperand()))) {
                PsiElement psiElement = ((UPolyadicExpression)node).getSourcePsi();
                String string = psiElement != null ? psiElement.getText() : null;
                if (string == null) {
                    string = ((UPolyadicExpression)node).getOperator().getText();
                }
                return new Pair((Object)node, (Object)string);
            }
            for (UExpression operand : ((UPolyadicExpression)node).getOperands()) {
                Pair<UExpression, String> sideEffect = this.getSideEffect(operand, depth + 1, callDepth);
                if (sideEffect == null) continue;
                return sideEffect;
            }
        } else {
            if (uExpression instanceof UQualifiedReferenceExpression) {
                return this.getSideEffect(((UQualifiedReferenceExpression)node).getSelector(), depth + 1, callDepth);
            }
            if (uExpression instanceof UParenthesizedExpression) {
                return this.getSideEffect(((UParenthesizedExpression)node).getExpression(), depth + 1, callDepth);
            }
            if (uExpression instanceof UCallExpression) {
                if (callDepth > MAX_CALL_DEPTH) {
                    return null;
                }
                PsiMethod psiMethod = ((UCallExpression)node).resolve();
                if (psiMethod == null) {
                    return null;
                }
                PsiMethod called = psiMethod;
                if (called instanceof PsiCompiledElement) {
                    String string = called.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"called.name");
                    String name = string;
                    if (Intrinsics.areEqual((Object)name, (Object)"add") || Intrinsics.areEqual((Object)name, (Object)"remove") || Intrinsics.areEqual((Object)name, (Object)"put") || Intrinsics.areEqual((Object)name, (Object)"delete") || Intrinsics.areEqual((Object)name, (Object)"mkdir") || Intrinsics.areEqual((Object)name, (Object)"mkdirs") || StringsKt.startsWith$default((String)name, (String)"set", (boolean)false, (int)2, null) && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                        PsiElement psiElement = ((UCallExpression)node).getSourcePsi();
                        String string2 = psiElement != null ? psiElement.getText() : null;
                        if (string2 == null) {
                            string2 = name;
                        }
                        return new Pair((Object)node, (Object)string2);
                    }
                } else {
                    UMethod uMethod = Lint.getUMethod(called);
                    if (uMethod == null || (uMethod = uMethod.getUastBody()) == null) {
                        return null;
                    }
                    UMethod body = uMethod;
                    Pair<UExpression, String> sideEffect = this.getSideEffect((UExpression)body, depth + 1, callDepth + 1);
                    if (sideEffect != null) {
                        return new Pair((Object)node, sideEffect.getSecond());
                    }
                }
            } else {
                if (uExpression instanceof UReturnExpression) {
                    return this.getSideEffect(((UReturnExpression)node).getReturnExpression(), depth + 1, callDepth);
                }
                if (uExpression instanceof UIfExpression) {
                    Pair<UExpression, String> called = this.getSideEffect(((UIfExpression)node).getCondition(), depth + 1, callDepth);
                    if (called != null) {
                        Pair<UExpression, String> it = called;
                        boolean bl = false;
                        return it;
                    }
                    called = this.getSideEffect(((UIfExpression)node).getThenExpression(), depth + 1, callDepth);
                    if (called != null) {
                        Pair<UExpression, String> it = called;
                        boolean bl = false;
                        return it;
                    }
                    called = this.getSideEffect(((UIfExpression)node).getElseExpression(), depth + 1, callDepth);
                    if (called != null) {
                        Pair<UExpression, String> it = called;
                        boolean bl = false;
                        return it;
                    }
                } else if (uExpression instanceof UTryExpression) {
                    Pair<UExpression, String> called = this.getSideEffect(((UTryExpression)node).getTryClause(), depth + 1, callDepth);
                    if (called != null) {
                        Pair<UExpression, String> it = called;
                        boolean bl = false;
                        return it;
                    }
                    called = this.getSideEffect(((UTryExpression)node).getFinallyClause(), depth + 1, callDepth);
                    if (called != null) {
                        Pair<UExpression, String> it = called;
                        boolean bl = false;
                        return it;
                    }
                } else if (uExpression instanceof UBlockExpression) {
                    List expressions = ((UBlockExpression)node).getExpressions();
                    int n = Math.min(MAX_STATEMENT_COUNT, expressions.size());
                    for (int i = 0; i < n; ++i) {
                        Pair<UExpression, String> sideEffect = this.getSideEffect((UExpression)expressions.get(i), depth + 1, callDepth);
                        if (sideEffect == null) continue;
                        return new Pair((Object)node, sideEffect.getSecond());
                    }
                } else if (uExpression instanceof ULoopExpression) {
                    return this.getSideEffect(((ULoopExpression)node).getBody(), depth + 1, callDepth);
                }
            }
        }
        return null;
    }

    private final boolean isLocal(UExpression lhs) {
        PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)lhs));
        return resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter;
    }

    private final LintFix createKotlinAssertionStatusFix(JavaContext context2, UCallExpression assertCall) {
        return this.fix().name("Surround with desiredAssertionStatus() check").replace().range(context2.getLocation((UElement)assertCall)).pattern("(.*)").with("if (javaClass.desiredAssertionStatus()) { \\k<1> }").reformat(true).build();
    }

    private final boolean warnAboutWork(UCallExpression assertCall, UExpression condition) {
        return this.isExpensive(condition, 0) && !this.isWithinAssertionStatusCheck((UExpression)assertCall);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExpensive(UExpression argument, int depth) {
        UExpression value;
        if (depth == 4) {
            return true;
        }
        if (argument instanceof ULiteralExpression) return false;
        if (argument instanceof UInstanceExpression) {
            return false;
        }
        if (argument instanceof UBinaryExpressionWithType) {
            if (argument.getSourcePsi() instanceof KtIsExpression) {
                return false;
            }
            boolean bl = this.isExpensive(((UBinaryExpressionWithType)argument).getOperand(), depth + 1);
            return bl;
        }
        if (argument instanceof UPolyadicExpression) {
            UExpression value2;
            Iterator iterator = ((UPolyadicExpression)argument).getOperands().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!this.isExpensive(value2 = (UExpression)iterator.next(), depth + 1));
            return true;
        }
        if (argument instanceof UParenthesizedExpression) {
            return this.isExpensive(((UParenthesizedExpression)argument).getExpression(), depth);
        }
        if (argument instanceof UBinaryExpression) {
            if (this.isExpensive(((UBinaryExpression)argument).getLeftOperand(), depth + 1)) return true;
            if (!this.isExpensive(((UBinaryExpression)argument).getRightOperand(), depth + 1)) return false;
            return true;
        }
        if (argument instanceof UUnaryExpression) {
            return this.isExpensive(((UUnaryExpression)argument).getOperand(), depth + 1);
        }
        if (argument instanceof USimpleNameReferenceExpression) {
            return false;
        }
        if (argument instanceof UQualifiedReferenceExpression) {
            return false;
        }
        if (argument instanceof UCallExpression) {
            PsiMethod method = ((UCallExpression)argument).resolve();
            if (method != null && !(method instanceof PsiCompiledElement)) {
                UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)((UElement)UastFacade.INSTANCE.getMethodBody(method)));
                if (uElement == null) {
                    return true;
                }
                UElement body = uElement;
                if (body instanceof UBlockExpression) {
                    List expressions = ((UBlockExpression)body).getExpressions();
                    if (expressions.size() != 1) return true;
                    if (!(expressions.get(0) instanceof UReturnExpression)) return true;
                    Object e = expressions.get(0);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.uast.UReturnExpression");
                    UExpression retExp = ((UReturnExpression)e).getReturnExpression();
                    if (retExp == null) return true;
                    if (!this.isExpensive(retExp, depth + 1)) return false;
                    return true;
                }
                if (!(body instanceof UExpression)) return true;
                return this.isExpensive((UExpression)body, depth + 1);
            }
            String name = ((UCallExpression)argument).getMethodName();
            if (name == null) return true;
            switch (name.hashCode()) {
                case -567445985: {
                    if (name.equals("contains")) return false;
                    return true;
                }
                case 2058039875: {
                    if (name.equals("isEmpty")) return false;
                    return true;
                }
                case 759061892: {
                    if (!name.equals("isNotEmpty")) return true;
                    return false;
                }
            }
            return true;
        }
        if (!(argument instanceof UArrayAccessExpression)) return true;
        Iterator iterator = ((UArrayAccessExpression)argument).getIndices().iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!this.isExpensive(value = (UExpression)iterator.next(), depth + 1));
        return true;
    }

    private final boolean isWithinAssertionStatusCheck(UExpression node) {
        UElement uElement = node.getUastParent();
        if (uElement == null) {
            return false;
        }
        UElement curr = uElement;
        while (true) {
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        if (curr instanceof UIfExpression && this.isAssertionStatusCheck(((UIfExpression)curr).getCondition())) break block10;
                        if (!(curr instanceof USwitchClauseExpressionWithBody)) break block11;
                        Iterable $this$all$iv = ((USwitchClauseExpressionWithBody)curr).getCaseValues();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                UExpression p0 = (UExpression)element$iv;
                                boolean bl2 = false;
                                if (this.isAssertionStatusCheck(p0)) continue;
                                bl = false;
                                break block9;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) break block11;
                }
                return true;
            }
            if (curr.getUastParent() != null) continue;
            return false;
        }
    }

    private final boolean isAssertionStatusCheck(UExpression condition) {
        Object object = condition.getSourcePsi();
        return object != null && (object = object.getText()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"desiredAssertionStatus", (boolean)false, (int)2, null) : false;
    }

    public static final /* synthetic */ void access$checkSideEffect(AssertDetector $this, JavaContext context2, UExpression condition) {
        $this.checkSideEffect(context2, condition);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EXPENSIVE = Issue.Companion.create$default(companion, "ExpensiveAssertion", "Expensive Assertions", "\n                In Kotlin, assertions are not handled the same way as from the Java programming \\\n                language. In particular, they're just implemented as a library call, and inside \\\n                the library call the error is only thrown if assertions are enabled.\n\n                This means that the arguments to the `assert` call will **always** \\\n                be evaluated. If you're doing any computation in the expression being \\\n                asserted, that computation will unconditionally be performed whether or not \\\n                assertions are turned on. This typically turns into wasted work in release \\\n                builds.\n\n                This check looks for cases where the assertion condition is nontrivial, e.g. \\\n                it is performing method calls or doing more work than simple comparisons \\\n                on local variables or fields.\n\n                You can work around this by writing your own inline assert method instead:\n\n                ```kotlin\n                @Suppress(\"INVISIBLE_REFERENCE\", \"INVISIBLE_MEMBER\")\n                inline fun assert(condition: () -> Boolean) {\n                    if (_Assertions.ENABLED && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n\n                In Android, because assertions are not enforced at runtime, instead use this:\n\n                ```kotlin\n                inline fun assert(condition: () -> Boolean) {\n                    if (BuildConfig.DEBUG && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n                ", implementation, null, category, 6, severity, false, null, null, null, 3600, null);
        MAX_CALL_DEPTH = LintClient.Companion.isStudio() ? 1 : 2;
        MAX_RECURSION_DEPTH = LintClient.Companion.isStudio() ? 5 : 10;
        MAX_STATEMENT_COUNT = LintClient.Companion.isStudio() ? 8 : 20;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/AssertDetector$Issues;", "", "()V", "EXPENSIVE", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MAX_CALL_DEPTH", "", "MAX_RECURSION_DEPTH", "MAX_STATEMENT_COUNT", "SIDE_EFFECT", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

