/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.text.Charsets;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppLinksAutoVerifyDetector
extends Detector
implements XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AppLinksAutoVerifyDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue ISSUE = Issue.create("AppLinksAutoVerify", "App Links Auto Verification Failure", "Ensures that app links are correctly set and associated with website.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://g.co/appindexing/applinks").setAliases(Arrays.asList("AppLinksAutoVerifyError", "AppLinksAutoVerifyWarning")).setEnabledByDefault(false);
    private static final String ATTRIBUTE_AUTO_VERIFY = "autoVerify";
    private static final String JSON_RELATIVE_PATH = "/.well-known/assetlinks.json";
    @VisibleForTesting
    static final int STATUS_HTTP_CONNECT_FAIL = -1;
    @VisibleForTesting
    static final int STATUS_MALFORMED_URL = -2;
    @VisibleForTesting
    static final int STATUS_UNKNOWN_HOST = -3;
    @VisibleForTesting
    static final int STATUS_NOT_FOUND = -4;
    @VisibleForTesting
    static final int STATUS_WRONG_JSON_SYNTAX = -5;
    @VisibleForTesting
    static final int STATUS_JSON_PARSE_FAIL = -6;
    private final Map<String, Future<HttpResult>> mFutures = Maps.newHashMap();
    private final Map<String, Attr> mJsonHost = Maps.newHashMap();

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        if (!context2.getScope().contains((Object)Scope.ALL_JAVA_FILES)) {
            return;
        }
        if (document.getDocumentElement() != null) {
            List<Element> intents = AppLinksAutoVerifyDetector.getTags(document.getDocumentElement(), "intent-filter");
            if (!AppLinksAutoVerifyDetector.needAutoVerification(intents)) {
                return;
            }
            for (Element intent : intents) {
                boolean actionView = AppLinksAutoVerifyDetector.hasNamedSubTag(intent, "action", "android.intent.action.VIEW");
                boolean browsableCategory = AppLinksAutoVerifyDetector.hasNamedSubTag(intent, "category", "android.intent.category.BROWSABLE");
                if (!actionView || !browsableCategory) continue;
                this.mJsonHost.putAll(AppLinksAutoVerifyDetector.getJsonUrl(context2, intent));
            }
        }
        Map<String, HttpResult> results = this.getJsonFileAsync(context2.getClient());
        String packageName = context2.getProject().getPackage();
        block11: for (Map.Entry<String, HttpResult> result : results.entrySet()) {
            Attr host;
            if (result.getValue() == null || (host = this.mJsonHost.get(result.getKey())) == null) continue;
            String jsonPath = result.getKey() + JSON_RELATIVE_PATH;
            switch (result.getValue().mStatus) {
                case 200: {
                    List<String> packageNames = AppLinksAutoVerifyDetector.getPackageNameFromJson(result.getValue().mJsonFile);
                    if (packageNames.contains(packageName)) continue block11;
                    this.reportError(context2, host, context2.getLocation(host), String.format("This host does not support app links to your app. Checks the Digital Asset Links JSON file: %s", jsonPath));
                    continue block11;
                }
                case -1: {
                    this.reportWarning(context2, host, context2.getLocation(host), String.format("Connection to Digital Asset Links JSON file %s fails", jsonPath));
                    continue block11;
                }
                case -2: {
                    this.reportError(context2, host, context2.getLocation(host), String.format("Malformed URL of Digital Asset Links JSON file: %s. An unknown protocol is specified", jsonPath));
                    continue block11;
                }
                case -3: {
                    this.reportWarning(context2, host, context2.getLocation(host), String.format("Unknown host: %s. Check if the host exists, and check your network connection", result.getKey()));
                    continue block11;
                }
                case -4: {
                    this.reportError(context2, host, context2.getLocation(host), String.format("Digital Asset Links JSON file %s is not found on the host", jsonPath));
                    continue block11;
                }
                case -5: {
                    this.reportError(context2, host, context2.getLocation(host), String.format("%s has incorrect JSON syntax", jsonPath));
                    continue block11;
                }
                case -6: {
                    this.reportError(context2, host, context2.getLocation(host), String.format("Parsing JSON file %s fails", jsonPath));
                    continue block11;
                }
                case 301: 
                case 302: {
                    continue block11;
                }
            }
            this.reportWarning(context2, host, context2.getLocation(host), String.format("HTTP request for Digital Asset Links JSON file %1$s fails. HTTP response code: %2$s", jsonPath, result.getValue().mStatus));
        }
    }

    private void reportWarning(XmlContext context2, Node node, Location location2, String message2) {
        Incident incident = new Incident(ISSUE, node, location2, message2);
        incident.overrideSeverity(Severity.WARNING);
        context2.report(incident);
    }

    private void reportError(XmlContext context2, Node node, Location location2, String message2) {
        Incident incident = new Incident(ISSUE, node, location2, message2);
        incident.overrideSeverity(Severity.ERROR);
        context2.report(incident);
    }

    private static List<Element> getTags(Element element, String tagName) {
        ArrayList tagList = Lists.newArrayList();
        if (element.getTagName().equalsIgnoreCase(tagName)) {
            tagList.add(element);
        } else {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                tagList.addAll(AppLinksAutoVerifyDetector.getTags((Element)child, tagName));
            }
        }
        return tagList;
    }

    private static boolean needAutoVerification(List<Element> intents) {
        for (Element intent : intents) {
            if (!intent.getAttributeNS("http://schemas.android.com/apk/res/android", ATTRIBUTE_AUTO_VERIFY).equals("true")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNamedSubTag(Element element, String tagName, String nameAttrValue) {
        NodeList children = element.getElementsByTagName(tagName);
        for (int i = 0; i < children.getLength(); ++i) {
            Element e = (Element)children.item(i);
            if (!e.getAttributeNS("http://schemas.android.com/apk/res/android", "name").equals(nameAttrValue)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Attr> getJsonUrl(XmlContext context2, Element intent) {
        ArrayList schemes = Lists.newArrayList();
        ArrayList hosts = Lists.newArrayList();
        NodeList dataTags = intent.getElementsByTagName("data");
        for (int k = 0; k < dataTags.getLength(); ++k) {
            Element dataTag = (Element)dataTags.item(k);
            String scheme = dataTag.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme");
            if (scheme.equals("http") || scheme.equals("https")) {
                schemes.add(scheme);
            }
            if (!dataTag.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) continue;
            Attr host = dataTag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "host");
            hosts.add(host);
        }
        HashMap urls = Maps.newHashMap();
        for (String scheme : schemes) {
            for (Attr host : hosts) {
                String hostname = host.getValue();
                if (hostname.startsWith("${") && (hostname = AppLinksAutoVerifyDetector.resolvePlaceHolder(context2, hostname)) == null) continue;
                urls.put(scheme + "://" + hostname, host);
            }
        }
        return urls;
    }

    private static String resolvePlaceHolder(XmlContext context2, String hostname) {
        assert (hostname.startsWith("${"));
        LintModelVariant variant = context2.getProject().getBuildVariant();
        if (variant != null) {
            Map<String, String> placeHolders = variant.getManifestPlaceholders();
            String name = hostname.substring("${".length(), hostname.length() - "}".length());
            return placeHolders.get(name);
        }
        return null;
    }

    private Map<String, HttpResult> getJsonFileAsync(LintClient client) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (Map.Entry<String, Attr> url : this.mJsonHost.entrySet()) {
            Future<HttpResult> future = executorService.submit(() -> AppLinksAutoVerifyDetector.getJson(client, (String)url.getKey() + JSON_RELATIVE_PATH, 0));
            this.mFutures.put(url.getKey(), future);
        }
        executorService.shutdown();
        HashMap jsons = Maps.newHashMap();
        for (Map.Entry<String, Future<HttpResult>> entry : this.mFutures.entrySet()) {
            try {
                jsons.put(entry.getKey(), entry.getValue().get());
            }
            catch (Exception e) {
                if (LintClient.isUnitTest()) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new IllegalArgumentException("Network failure", cause);
                }
                jsons.put(entry.getKey(), null);
            }
        }
        return jsons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static HttpResult getJson(LintClient client, String url, int redirectsCount) {
        try {
            URL urlObj = new URL(url);
            URLConnection urlConnection = client.openConnection(urlObj, 3000);
            if (!(urlConnection instanceof HttpURLConnection)) {
                return new HttpResult(-1, null);
            }
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            try {
                int status = connection.getResponseCode();
                if (status == 301 || status == 302) {
                    Object newUrl;
                    if (redirectsCount < 3 && (newUrl = connection.getHeaderField("Location")) != null && !((String)newUrl).equals(url)) {
                        HttpResult httpResult = AppLinksAutoVerifyDetector.getJson(client, (String)newUrl, redirectsCount + 1);
                        return httpResult;
                    }
                    newUrl = new HttpResult(status, null);
                    return newUrl;
                }
                InputStream inputStream = connection.getInputStream();
                if (inputStream == null) {
                    HttpResult httpResult = new HttpResult(status, null);
                    return httpResult;
                }
                String response = new String(inputStream.readAllBytes(), Charsets.UTF_8);
                inputStream.close();
                try {
                    JsonElement jsonFile = new JsonParser().parse(response);
                    HttpResult httpResult = new HttpResult(status, jsonFile);
                    return httpResult;
                }
                catch (JsonSyntaxException e) {
                    HttpResult httpResult = new HttpResult(-5, null);
                    connection.disconnect();
                    return httpResult;
                }
                catch (RuntimeException e) {
                    HttpResult httpResult = new HttpResult(-6, null);
                    connection.disconnect();
                    return httpResult;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (MalformedURLException e) {
            return new HttpResult(-2, null);
        }
        catch (UnknownHostException e) {
            return new HttpResult(-3, null);
        }
        catch (FileNotFoundException e) {
            return new HttpResult(-4, null);
        }
        catch (IOException e) {
            return new HttpResult(-1, null);
        }
    }

    private static List<String> getPackageNameFromJson(JsonElement element) {
        ArrayList packageNames = Lists.newArrayList();
        if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject target2;
                JsonElement app = jsonArray.get(i);
                if (!(app instanceof JsonObject) || (target2 = ((JsonObject)app).getAsJsonObject("target")) == null) continue;
                JsonElement namespace = target2.get("namespace");
                JsonElement packageName = target2.get("package_name");
                if (namespace == null || !namespace.getAsString().equals("android_app") || packageName == null) continue;
                packageNames.add(packageName.getAsString());
            }
        }
        return packageNames;
    }

    @VisibleForTesting
    static final class HttpResult {
        private final int mStatus;
        private final JsonElement mJsonFile;

        @VisibleForTesting
        HttpResult(int status, JsonElement jsonFile) {
            this.mStatus = status;
            this.mJsonFile = jsonFile;
        }
    }
}

