/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.VersionChecks;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00180\bH\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/AnnotationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "warnedFlags", "", "Lcom/intellij/psi/PsiElement;", "computeFieldNames", "", "", "node", "Lorg/jetbrains/uast/USwitchExpression;", "allowedValues", "", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "displayConstants", "list", "getAnnotationScope", "Lorg/jetbrains/uast/UElement;", "Lorg/jetbrains/uast/UAnnotation;", "getApplicableUastTypes", "Ljava/lang/Class;", "removeFieldFromList", "", "fields", "", "resolvedField", "Lcom/intellij/psi/PsiField;", "AnnotationChecker", "Companion", "android.sdktools.lint-checks"})
public final class AnnotationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<PsiElement> warnedFlags;
    @NotNull
    public static final String KEY_CASES = "cases";
    @NotNull
    public static final String ATTR_SUGGEST = "suggest";
    @NotNull
    public static final String ATTR_TO = "to";
    @NotNull
    public static final String ATTR_FROM = "from";
    @NotNull
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    @NotNull
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    @NotNull
    public static final String ATTR_MULTIPLE = "multiple";
    @NotNull
    public static final String ATTR_MIN = "min";
    @NotNull
    public static final String ATTR_MAX = "max";
    @NotNull
    public static final String ATTR_ALL_OF = "allOf";
    @NotNull
    public static final String ATTR_ANY_OF = "anyOf";
    @NotNull
    public static final String ATTR_CONDITIONAL = "conditional";
    @NotNull
    private static final String JAVA_ANNOTATION_TARGET_FQN = "java.lang.annotation.Target";
    @NotNull
    private static final String KOTLIN_ANNOTATION_TARGET_FQN = "kotlin.annotation.Target";
    public static final boolean WARN_ABOUT_EXTENSION_LEVEL_GAPS = false;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue INSIDE_METHOD = Issue.Companion.create("LocalSuppress", "@SuppressLint on invalid element", "\n                The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while \\\n                many lint checks analyzes the Java source code, where they can find annotations on \\\n                (for example) local variables, some checks are analyzing the `.class` files. And in class \\\n                files, annotations only appear on classes, fields and methods. Annotations placed on local \\\n                variables disappear. If you attempt to suppress a lint error for a class-file based lint \\\n                check, the suppress annotation not work. You must move the annotation out to the \\\n                surrounding method.\n                ", Category.CORRECTNESS, 3, Severity.ERROR, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue ANNOTATION_USAGE = Issue.Companion.create("SupportAnnotationUsage", "Incorrect support annotation usage", "\n                This lint check makes sure that the support annotations (such as `@IntDef` and `@ColorInt`) \\\n                are used correctly. For example, it's an error to specify an `@IntRange` where the `from` \\\n                value is higher than the `to` value.\n                ", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue UNIQUE;
    @JvmField
    @NotNull
    public static final Issue FLAG_STYLE;
    @JvmField
    @NotNull
    public static final Issue SWITCH_TYPE_DEF;

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UAnnotation.class, USwitchExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new AnnotationChecker(context2);
    }

    private final String displayConstants(List<String> list2) {
        return CollectionsKt.joinToString((Iterable)list2, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", (Function1)displayConstants.1.INSTANCE);
    }

    private final List<String> computeFieldNames(USwitchExpression node, Iterable<?> allowedValues) {
        List list2 = new ArrayList();
        for (Object allowedValue : allowedValues) {
            String name;
            PsiClass containingClass;
            PsiElement resolved;
            Object ref;
            Object o = allowedValue;
            if (o instanceof PsiReferenceExpression) {
                ref = o;
                resolved = ((PsiReferenceExpression)ref).resolve();
                if (resolved == null) {
                    String referenceName = ((PsiReferenceExpression)ref).getReferenceName();
                    if (referenceName == null) continue;
                    list2.add(referenceName);
                    continue;
                }
                o = resolved;
            } else {
                if (o instanceof PsiLiteral) {
                    list2.add(String.valueOf(((PsiLiteral)o).getValue()));
                    continue;
                }
                if (o instanceof UReferenceExpression) {
                    ref = o;
                    resolved = ((UReferenceExpression)ref).resolve();
                    if (resolved == null) {
                        String resolvedName = ((UReferenceExpression)ref).getResolvedName();
                        if (resolvedName == null) continue;
                        list2.add(resolvedName);
                        continue;
                    }
                    o = resolved;
                }
            }
            if (!(o instanceof PsiField)) continue;
            Object field = o;
            Intrinsics.checkNotNullExpressionValue((Object)((PsiField)field).getName(), (String)"field.name");
            UClass clz = (UClass)UastUtils.getParentOfType((UElement)((UElement)node), UClass.class, (boolean)true);
            if (clz != null && (containingClass = ((PsiField)field).getContainingClass()) != null && !containingClass.isEquivalentTo((PsiElement)clz.getPsi())) {
                name = containingClass.getQualifiedName() + "." + ((PsiField)field).getName();
            }
            list2.add(name);
        }
        CollectionsKt.sort((List)list2);
        return list2;
    }

    private final UElement getAnnotationScope(UAnnotation node) {
        UAnnotation uAnnotation = (UAnnotation)UastUtils.getParentOfType((UElement)((UElement)node), UAnnotation.class, (boolean)true);
        return uAnnotation != null ? (UElement)uAnnotation : (UElement)node;
    }

    private final boolean removeFieldFromList(List<? extends Object> fields, PsiField resolvedField) {
        for (Object object : fields) {
            if (!(object instanceof PsiField) || !((PsiField)object).isEquivalentTo((PsiElement)resolvedField)) continue;
            return true;
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        UNIQUE = Issue.Companion.create$default(companion, "UniqueConstants", "Overlapping Enumeration Constants", "\n                The `@IntDef` annotation allows you to create a light-weight \"enum\" or type definition. \\\n                However, it's possible to accidentally specify the same value for two or more of the \\\n                values, which can lead to hard-to-detect bugs. This check looks for this scenario and \\\n                flags any repeated constants.\n\n                In some cases, the repeated constant is intentional (for example, renaming a constant to \\\n                a more intuitive name, and leaving the old name in place for compatibility purposes).  In \\\n                that case, simply suppress this check by adding a `@SuppressLint(\"UniqueConstants\")` \\\n                annotation.\n                ", implementation, null, category, 3, severity, false, true, null, null, 3344, null);
        FLAG_STYLE = Issue.Companion.create("ShiftFlags", "Dangerous Flag Constant Declaration", "\n                When defining multiple constants for use in flags, the recommended style is to use the \\\n                form `1 << 2`, `1 << 3`, `1 << 4` and so on to ensure that the constants are unique and \\\n                non-overlapping.\n                ", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        SWITCH_TYPE_DEF = Issue.Companion.create$default(companion, "SwitchIntDef", "Missing @IntDef in Switch", "\n                This check warns if a `switch` statement does not explicitly include all the values \\\n                declared by the typedef `@IntDef` declaration.\n                ", implementation, null, category, 3, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0002JN\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0016\u0010\u001e\u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020!H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\"\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0017\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0002\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020,H\u0002J\u0010\u00100\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u00101\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u000202H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/lint/checks/AnnotationDetector$AnnotationChecker;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/checks/AnnotationDetector;Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkAndroidxAnnotation", "", "type", "", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "checkAnnotation", "checkConstructorParameter", "checkJavaTarget", "node", "checkRequiresApi", "checkRequiresExtension", "checkSuppressAnnotation", "checkSuppressLint", "", "id", "checkTargetType", "name", "type1", "type2", "type3", "type4", "allowCollection", "checkTypedefAnnotation", "ensureUniqueValues", "ensureUsingFlagStyle", "constants", "", "Lorg/jetbrains/uast/UExpression;", "findIntDefAnnotation", "expression", "findTypeDef", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "getAttributeValueLocation", "Lcom/android/tools/lint/detector/api/Location;", "getConstantValue", "", "intDefConstantRef", "Lcom/intellij/psi/PsiField;", "(Lcom/intellij/psi/PsiField;)Ljava/lang/Integer;", "isDeprecated", "field", "visitAnnotation", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "SwitchChecker", "android.sdktools.lint-checks"})
    private final class AnnotationChecker
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public AnnotationChecker(JavaContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @Override
        public void visitAnnotation(@NotNull UAnnotation node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            String string = node.getQualifiedName();
            if (string == null) {
                return;
            }
            String type = string;
            if (Intrinsics.areEqual((Object)type, (Object)AnnotationDetector.JAVA_ANNOTATION_TARGET_FQN)) {
                this.checkJavaTarget(node);
            }
            if (StringsKt.startsWith$default((String)type, (String)"java.lang.", (boolean)false, (int)2, null)) {
                return;
            }
            this.checkAnnotation(node, type);
        }

        /*
         * WARNING - void declaration
         */
        private final void checkJavaTarget(UAnnotation node) {
            String string;
            boolean bl;
            Location location2;
            block7: {
                void $this$getParentOfType$iv;
                if (!Lint.isKotlin(node.getSourcePsi())) {
                    return;
                }
                PsiElement nameElement = UAnnotationKt.getNamePsiElement((UAnnotation)node);
                location2 = nameElement != null ? this.context.getLocation(nameElement) : this.context.getLocation((UElement)node);
                UElement uElement = (UElement)node;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UAnnotated uAnnotated = (UAnnotated)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UAnnotated.class, (boolean)strict$iv);
                if (uAnnotated == null) {
                    return;
                }
                UAnnotated annotated = uAnnotated;
                Iterable $this$any$iv = JavaEvaluator.getAllAnnotations$default(this.context.getEvaluator(), annotated, false, 2, null);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)AnnotationDetector.KOTLIN_ANNOTATION_TARGET_FQN)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean hasTarget = bl;
            LintFix fix = null;
            if (hasTarget) {
                fix = AnnotationDetector.this.fix().replace().all().with("").range(this.context.getLocation((UElement)node)).build();
                string = "Do not use `@java.lang.annotation.Target` here; it will cause the annotation to not be allowed on **any** element types from Java";
            } else {
                fix = AnnotationDetector.this.fix().replace().text(AnnotationDetector.JAVA_ANNOTATION_TARGET_FQN).with("Target").range(this.context.getLocation((UElement)node)).build();
                string = "Use `@kotlin.annotation.Target`, not `@java.lang.annotation.Target` here; these targets will be ignored from Kotlin and the annotation will not be allowed on **any** element types from Java";
            }
            String message2 = string;
            Incident incident = new Incident(ANNOTATION_USAGE, node, location2, message2, fix).overrideSeverity(Severity.ERROR);
            this.context.report(incident);
        }

        private final void checkAnnotation(UAnnotation annotation, String type) {
            if (Intrinsics.areEqual((Object)"android.annotation.SuppressLint", (Object)type)) {
                this.checkSuppressAnnotation(annotation);
            } else if (AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(type)) {
                this.checkAndroidxAnnotation(type, annotation);
            } else {
                this.checkTypedefAnnotation(annotation, type);
                if (AndroidPlatformAnnotations.Companion.isPlatformAnnotation(type)) {
                    this.checkAnnotation(annotation, AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(type));
                }
            }
        }

        private final void checkSuppressAnnotation(UAnnotation annotation) {
            UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent());
            if (uElement == null) {
                return;
            }
            UElement parent = uElement;
            if (!(parent instanceof UDeclarationsExpression || parent instanceof ULocalVariable || parent instanceof UParameter)) {
                return;
            }
            List attributes = annotation.getAttributeValues();
            if (attributes.size() == 1) {
                UNamedExpression attribute = (UNamedExpression)attributes.get(0);
                UExpression value = UastUtils.skipParenthesizedExprDown((UExpression)attribute.getExpression());
                if (value instanceof ULiteralExpression) {
                    Object v = ((ULiteralExpression)value).getValue();
                    if (v instanceof String) {
                        this.checkSuppressLint(annotation, (String)v);
                    }
                } else if (value != null && UastExpressionUtils.isArrayInitializer((UElement)((UElement)value))) {
                    for (UExpression element : ((UCallExpression)value).getValueArguments()) {
                        Object v;
                        UExpression ex = UastUtils.skipParenthesizedExprDown((UExpression)element);
                        if (!(ex instanceof ULiteralExpression) || !((v = ((ULiteralExpression)ex).getValue()) instanceof String) || this.checkSuppressLint(annotation, (String)v)) continue;
                        return;
                    }
                }
            }
        }

        private final void checkAndroidxAnnotation(String type, UAnnotation annotation) {
            UElement parent;
            if (AnnotationDetectorKt.CHECK_RESULT_ANNOTATION.isEquals(type)) {
                UElement parent2 = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent());
                if (parent2 instanceof UMethod && !((UMethod)parent2).isConstructor() && Intrinsics.areEqual((Object)PsiType.VOID, (Object)((UMethod)parent2).getReturnType())) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "@CheckResult should not be specified on `void` methods", null, 16, null);
                }
            } else if (AnnotationDetectorKt.INT_RANGE_ANNOTATION.isEquals(type) || AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.isEquals(type)) {
                boolean invalid;
                boolean bl;
                if (AnnotationDetectorKt.INT_RANGE_ANNOTATION.isEquals(type)) {
                    AnnotationChecker.checkTargetType$default(this, annotation, type, "int", "long", null, null, false, 112, null);
                    long from = UastLintUtils.Companion.getLongAttribute(this.context, annotation, AnnotationDetector.ATTR_FROM, Long.MIN_VALUE);
                    long to = UastLintUtils.Companion.getLongAttribute(this.context, annotation, AnnotationDetector.ATTR_TO, Long.MAX_VALUE);
                    bl = from > to;
                } else {
                    AnnotationChecker.checkTargetType$default(this, annotation, type, "float", "double", null, null, false, 112, null);
                    double from = UastLintUtils.Companion.getDoubleAttribute(this.context, annotation, AnnotationDetector.ATTR_FROM, Double.NEGATIVE_INFINITY);
                    double to = UastLintUtils.Companion.getDoubleAttribute(this.context, annotation, AnnotationDetector.ATTR_TO, Double.POSITIVE_INFINITY);
                    bl = invalid = from > to;
                }
                if (invalid) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "Invalid range: the `from` attribute must be less than the `to` attribute", null, 16, null);
                }
            } else if (AnnotationDetectorKt.SIZE_ANNOTATION.isEquals(type)) {
                int unset = -42;
                long exact = UastLintUtils.Companion.getLongAttribute(this.context, annotation, "value", unset);
                long min = UastLintUtils.Companion.getLongAttribute(this.context, annotation, AnnotationDetector.ATTR_MIN, Long.MIN_VALUE);
                long max = UastLintUtils.Companion.getLongAttribute(this.context, annotation, AnnotationDetector.ATTR_MAX, Long.MAX_VALUE);
                long multiple = UastLintUtils.Companion.getLongAttribute(this.context, annotation, AnnotationDetector.ATTR_MULTIPLE, 1L);
                if (min > max) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "Invalid size range: the `min` attribute must be less than the `max` attribute", null, 16, null);
                } else if (multiple < 1L) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "The size multiple must be at least 1", null, 16, null);
                } else if (exact < 0L && exact != (long)unset || min < 0L && min != Long.MIN_VALUE) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "The size can't be negative", null, 16, null);
                }
            } else if (AnnotationDetectorKt.GRAVITY_INT_ANNOTATION.isEquals(type)) {
                AnnotationChecker.checkTargetType$default(this, annotation, type, "int", "long", null, null, false, 112, null);
            } else if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(type)) {
                AnnotationChecker.checkTargetType$default(this, annotation, type, "int", "long", null, null, false, 112, null);
            } else if (ResourceEvaluator.DIMENSION_ANNOTATION.isEquals(type) || ResourceEvaluator.PX_ANNOTATION.isEquals(type)) {
                AnnotationChecker.checkTargetType$default(this, annotation, type, "int", "long", "float", "double", false, 64, null);
            } else if (AndroidXConstants.INT_DEF_ANNOTATION.isEquals(type) || AndroidXConstants.LONG_DEF_ANNOTATION.isEquals(type)) {
                this.ensureUniqueValues(annotation);
            } else if (AnnotationDetectorKt.PERMISSION_ANNOTATION.isEquals(type)) {
                UElement parent3 = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent());
                if (parent3 instanceof UMethod) {
                    String value = UastLintUtils.Companion.getAnnotationStringValue(annotation, "value");
                    String[] anyOf = UastLintUtils.Companion.getAnnotationStringValues(annotation, AnnotationDetector.ATTR_ANY_OF);
                    String[] allOf = UastLintUtils.Companion.getAnnotationStringValues(annotation, AnnotationDetector.ATTR_ALL_OF);
                    int set = 0;
                    if (value != null) {
                        ++set;
                    }
                    if (allOf != null) {
                        ++set;
                    }
                    if (anyOf != null) {
                        ++set;
                    }
                    if (set == 0) {
                        JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "For methods, permission annotation should specify one of `value`, `anyOf` or `allOf`", null, 16, null);
                    } else if (set > 1) {
                        JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "Only specify one of `value`, `anyOf` or `allOf`", null, 16, null);
                    }
                }
            } else if (AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.isEquals(type)) {
                AnnotationChecker.checkTargetType$default(this, annotation, type, "short", null, null, null, false, 120, null);
            } else if (StringsKt.endsWith$default((String)type, (String)"Res", (boolean)false, (int)2, null)) {
                AnnotationChecker.checkTargetType$default(this, annotation, type, "int", "long", null, null, false, 112, null);
            } else if (AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(type)) {
                this.checkConstructorParameter(annotation, type);
                UExpression uExpression = annotation.findDeclaredAttributeValue("value");
                if (uExpression == null && (uExpression = annotation.findDeclaredAttributeValue(null)) == null) {
                    AnnotationChecker $this$checkAndroidxAnnotation_u24lambda_u2d1 = this;
                    boolean bl = false;
                    JavaContext.report$default($this$checkAndroidxAnnotation_u24lambda_u2d1.context, ANNOTATION_USAGE, (UElement)annotation, $this$checkAndroidxAnnotation_u24lambda_u2d1.context.getLocation((UElement)annotation), "Restrict to what? Expected at least one `RestrictTo.Scope` arguments.", null, 16, null);
                    return;
                }
                UExpression attributeValue = uExpression;
                String values = attributeValue.asSourceString();
                if (StringsKt.contains$default((CharSequence)values, (CharSequence)"SUBCLASSES", (boolean)false, (int)2, null) && UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent()) instanceof UClass) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "`RestrictTo.Scope.SUBCLASSES` should only be specified on methods and fields", null, 16, null);
                }
            } else if (AnnotationDetectorKt.VISIBLE_FOR_TESTING_ANNOTATION.isEquals(type)) {
                this.checkConstructorParameter(annotation, type);
            } else if (VersionChecks.REQUIRES_API_ANNOTATION.isEquals(type)) {
                this.checkRequiresApi(annotation);
            } else if (Intrinsics.areEqual((Object)type, (Object)"androidx.annotation.RequiresExtension")) {
                this.checkRequiresExtension(annotation);
            } else if (Intrinsics.areEqual((Object)type, (Object)"androidx.annotation.EmptySuper")) {
                UElement parent4 = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent());
                if (parent4 instanceof UMethod && ((UMethod)parent4).isFinal()) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "`@EmptySuper` is pointless on a final method", null, 16, null);
                }
            } else if (Intrinsics.areEqual((Object)type, (Object)"androidx.annotation.OpenForTesting")) {
                PsiElement sourcePsi = annotation.getSourcePsi();
                if (sourcePsi != null && !Lint.isKotlin(sourcePsi)) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "`@OpenForTesting` only applies to Kotlin APIs", null, 16, null);
                }
            } else if (Intrinsics.areEqual((Object)type, (Object)"androidx.annotation.ReturnThis") && (parent = UastUtils.skipParenthesizedExprUp((UElement)annotation.getUastParent())) instanceof UMethod) {
                PsiType returnType = ((UMethod)parent).getReturnType();
                if (!((UMethod)parent).isConstructor() && (Intrinsics.areEqual((Object)PsiType.VOID, (Object)returnType) || returnType instanceof PsiPrimitiveType)) {
                    JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "`@ReturnThis` should not be specified on `void` or primitive methods", null, 16, null);
                }
            }
        }

        private final void checkRequiresExtension(UAnnotation annotation) {
            UElement uElement = annotation.getUastParent();
            UAnnotated uAnnotated = uElement instanceof UAnnotated ? (UAnnotated)uElement : null;
            if (uAnnotated == null) {
                return;
            }
            UAnnotated holder = uAnnotated;
            boolean foundFirst = false;
            List levels = new ArrayList();
            for (UAnnotation a : holder.getUAnnotations()) {
                int sdkVersion;
                String qualifiedName = a.getQualifiedName();
                if (Intrinsics.areEqual((Object)qualifiedName, (Object)"androidx.annotation.RequiresExtension")) {
                    if (!foundFirst) {
                        if (!Intrinsics.areEqual((Object)a, (Object)annotation)) {
                            return;
                        }
                        foundFirst = true;
                    }
                    if ((sdkVersion = (int)UastLintUtils.Companion.getAnnotationLongValue(a, "extension", -1L)) == -1) {
                        Location location2 = this.context.getLocation((UElement)a);
                        JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)a, location2, "Must specify an extension `sdk` id attribute", null, 16, null);
                        return;
                    }
                    int extensionVersion = (int)UastLintUtils.Companion.getAnnotationLongValue(a, "version", -1L);
                    if (extensionVersion == -1) {
                        Location location3 = this.context.getLocation((UElement)a);
                        JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)a, location3, "Must specify an extension `version` level attribute", null, 16, null);
                        return;
                    }
                    levels.add(new Triple((Object)a, (Object)sdkVersion, (Object)extensionVersion));
                    continue;
                }
                if (!VersionChecks.REQUIRES_API_ANNOTATION.isEquals(qualifiedName)) continue;
                long it = UastLintUtils.Companion.getAnnotationLongValue(a, "api", -1L);
                boolean bl = false;
                sdkVersion = (int)(it != -1L ? it : UastLintUtils.Companion.getAnnotationLongValue(a, "value", -1L));
                if (sdkVersion == -1) {
                    return;
                }
                levels.add(new Triple((Object)a, (Object)sdkVersion, (Object)0));
            }
            levels.removeIf(checkRequiresExtension.1.INSTANCE);
            Function1[] function1Array = new Function1[]{checkRequiresExtension.2.INSTANCE, checkRequiresExtension.3.INSTANCE};
            CollectionsKt.sortedWith((Iterable)levels, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
            Triple prev = null;
            for (Triple triple : levels) {
                if (prev != null) {
                    Location location4;
                    if (((Number)prev.getSecond()).intValue() - ((Number)triple.getSecond()).intValue() > 1) {
                        // empty if block
                    }
                    if (((Number)triple.getSecond()).intValue() == ((Number)prev.getSecond()).intValue() && Intrinsics.areEqual((Object)((UAnnotation)triple.getFirst()).getQualifiedName(), (Object)((UAnnotation)prev.getFirst()).getQualifiedName())) {
                        Location location5;
                        Location location6 = this.getAttributeValueLocation(this.context, (UAnnotation)triple.getFirst(), "extension");
                        if (location6 == null) {
                            location6 = location4 = this.context.getLocation((UElement)triple.getFirst());
                        }
                        if ((location5 = this.getAttributeValueLocation(this.context, (UAnnotation)prev.getFirst(), "extension")) == null) {
                            location5 = this.context.getLocation((UElement)prev.getFirst());
                        }
                        location4.setSecondary(location5);
                        Location location7 = location4.getSecondary();
                        if (location7 != null) {
                            location7.setMessage("Previous level", false);
                        }
                        JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)triple.getFirst(), location4, "Repeated SDK extension level " + triple.getSecond(), null, 16, null);
                    } else if (((Number)prev.getThird()).intValue() > ((Number)triple.getThird()).intValue() && ((Number)triple.getSecond()).intValue() != ((Number)prev.getSecond()).intValue() && Intrinsics.areEqual((Object)((UAnnotation)triple.getFirst()).getQualifiedName(), (Object)"androidx.annotation.RequiresExtension")) {
                        Location location8;
                        Location location9 = this.getAttributeValueLocation(this.context, (UAnnotation)triple.getFirst(), "version");
                        if (location9 == null) {
                            location9 = location4 = this.context.getLocation((UElement)triple.getFirst());
                        }
                        if ((location8 = this.getAttributeValueLocation(this.context, (UAnnotation)prev.getFirst(), "version")) == null) {
                            location8 = this.context.getLocation((UElement)prev.getFirst());
                        }
                        location4.setSecondary(location8);
                        Location location10 = location4.getSecondary();
                        if (location10 != null) {
                            location10.setMessage("Previous version", false);
                        }
                        JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)triple.getFirst(), location4, "Suspicious extension level; expect previous extension versions to be at least as high as later SDK extension", null, 16, null);
                    }
                }
                prev = triple;
            }
        }

        private final Location getAttributeValueLocation(JavaContext context2, UAnnotation annotation, String name) {
            UExpression uExpression = annotation.findDeclaredAttributeValue(name);
            if (uExpression == null) {
                return null;
            }
            UExpression attribute = uExpression;
            return context2.getLocation((UElement)attribute);
        }

        private final void checkRequiresApi(UAnnotation annotation) {
            if (annotation.getAttributeValues().isEmpty()) {
                String name = "Specify API level";
                LintFix fix = LintFix.Companion.create().name(name).replace().end().with("(TODO)").select("TODO").build();
                Location location2 = this.context.getLocation((UElement)annotation);
                this.context.report(ANNOTATION_USAGE, (UElement)annotation, location2, "Must specify an API level", fix);
            }
        }

        private final void checkConstructorParameter(UAnnotation annotation, String type) {
            PsiElement source = annotation.getSourcePsi();
            if (source instanceof KtAnnotationEntry) {
                AnnotationUseSiteTarget target2;
                PsiElement psiElement = ((KtAnnotationEntry)source).getParent();
                PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
                KtParameter ktParameter = psiElement2 instanceof KtParameter ? (KtParameter)psiElement2 : null;
                if (ktParameter == null) {
                    return;
                }
                KtParameter parameter = ktParameter;
                if (!parameter.hasValOrVar()) {
                    return;
                }
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ((KtAnnotationEntry)source).getUseSiteTarget();
                Object object = target2 = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
                if (target2 == null || target2 == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER) {
                    String name = StringsKt.substringAfterLast$default((String)type, (char)'.', null, (int)2, null);
                    LintFix fix = target2 == null ? AnnotationDetector.this.fix().name("Change to `@get:`").replace().text("@").with("@get:").build() : (LintFix)null;
                    this.context.report(ANNOTATION_USAGE, (UElement)annotation, this.context.getLocation((UElement)annotation), "Did you mean `@get:" + name + "`? Without `get:` this annotates the constructor parameter itself instead of the associated getter.", fix);
                }
            }
        }

        private final void checkTypedefAnnotation(UAnnotation annotation, String type) {
            PsiClass psiClass = annotation.resolve();
            if (psiClass == null) {
                return;
            }
            PsiClass cls = psiClass;
            if (cls.isAnnotationType() && cls.getModifierList() != null) {
                for (UAnnotation a : JavaEvaluator.getAnnotations$default(this.context.getEvaluator(), (PsiModifierListOwner)cls, false, null, 4, null)) {
                    String name;
                    if (a.getQualifiedName() == null) continue;
                    if (AndroidPlatformAnnotations.Companion.isPlatformAnnotation(name)) {
                        name = AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(name);
                    }
                    if (AndroidXConstants.INT_DEF_ANNOTATION.isEquals(name)) {
                        AnnotationChecker.checkTargetType$default(this, annotation, name, "int", null, null, null, false, 120, null);
                        continue;
                    }
                    if (AndroidXConstants.LONG_DEF_ANNOTATION.isEquals(name)) {
                        AnnotationChecker.checkTargetType$default(this, annotation, name, "long", null, null, null, false, 120, null);
                        continue;
                    }
                    if (!AndroidXConstants.STRING_DEF_ANNOTATION.isEquals(type)) continue;
                    AnnotationChecker.checkTargetType$default(this, annotation, name, "java.lang.String", null, null, null, false, 120, null);
                }
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void checkTargetType(UAnnotation node, String name, String type1, String type2, String type3, String type4, boolean allowCollection) {
            void var12_22;
            void var12_19;
            PsiType[] psiTypeArray;
            PsiType type;
            PsiType parentType;
            PsiType psiType;
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            if (parent instanceof UDeclarationsExpression) {
                List elements = ((UDeclarationsExpression)parent).getDeclarations();
                if (((Collection)elements).isEmpty()) return;
                boolean bl = true;
                if (!bl) return;
                UDeclaration element = (UDeclaration)elements.get(0);
                if (!(element instanceof ULocalVariable)) return;
                psiType = ((ULocalVariable)element).getType();
            } else if (parent instanceof UMethod) {
                psiType = ((UMethod)parent).isConstructor() ? (PsiType)this.context.getEvaluator().getClassType((PsiClass)UastUtils.getContainingUClass((UElement)parent)) : ((UMethod)parent).getReturnType();
            } else {
                if (!(parent instanceof UVariable)) return;
                if (((UVariable)parent).getTypeReference() == null) {
                    return;
                }
                psiType = ((UVariable)parent).getType();
            }
            PsiType psiType2 = parentType = psiType;
            if (psiType2 == null) {
                return;
            }
            PsiType originalType = type = psiType2;
            if (type instanceof PsiClassType) {
                String string = type.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.getCanonicalText()");
                if (StringsKt.startsWith$default((String)string, (String)"kotlin.properties.ReadWriteProperty", (boolean)false, (int)2, null)) {
                    boolean bl;
                    boolean bl2 = true;
                    if (parent instanceof UVariable) {
                        PsiType[] parameters = ((PsiClassType)type).getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"parameters");
                        if (!(parameters.length == 0)) {
                            PsiType psiType3 = parameters[parameters.length - 1];
                            Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"parameters[parameters.size - 1]");
                            type = psiType3;
                            bl = false;
                            originalType = type;
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
            }
            if (allowCollection) {
                if (type instanceof PsiArrayType) {
                    PsiType psiType4 = type.getDeepComponentType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiType4, (String)"type.getDeepComponentType()");
                    type = psiType4;
                } else if (type instanceof PsiClassType) {
                    PsiType[] psiTypeArray2 = ((PsiClassType)type).getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray2, (String)"parameters");
                    if (!(psiTypeArray2.length == 0)) {
                        PsiType psiType5 = psiTypeArray2[0];
                        Intrinsics.checkNotNullExpressionValue((Object)psiType5, (String)"parameters[0]");
                        type = psiType5;
                    }
                }
            }
            if (!type.isValid()) {
                return;
            }
            PsiType[] psiTypeArray3 = type.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray3, (String)"type.canonicalText");
            switch (psiTypeArray = psiTypeArray3) {
                case "error.NonExistentClass": {
                    return;
                }
                case "android.util.SparseIntArray": {
                    String string = "int";
                    break;
                }
                case "android.util.LongSparseArray": 
                case "android.util.SparseLongArray": {
                    String string = "long";
                    break;
                }
                case "android.util.SparseBooleanArray": {
                    String string = "boolean";
                }
            }
            if (Intrinsics.areEqual((Object)var12_19, (Object)type1)) return;
            if (Intrinsics.areEqual((Object)var12_19, (Object)type2)) return;
            if (Intrinsics.areEqual((Object)var12_19, (Object)type3)) return;
            if (Intrinsics.areEqual((Object)var12_19, (Object)type4)) return;
            if (Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType(type1))) return;
            if (type2 != null) {
                if (Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType(type2))) return;
            }
            if (type3 != null) {
                if (Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType(type3))) return;
            }
            if (type4 != null && Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType(type4))) {
                return;
            }
            if (Intrinsics.areEqual((Object)var12_19, (Object)"byte") || Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType("byte")) || Intrinsics.areEqual((Object)var12_19, (Object)"short") || Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType("short"))) {
                if (Intrinsics.areEqual((Object)type1, (Object)"int")) return;
                if (Intrinsics.areEqual((Object)type1, (Object)"long")) {
                    return;
                }
            }
            if (type2 == null && Intrinsics.areEqual((Object)type1, (Object)"int")) {
                if (Intrinsics.areEqual((Object)var12_19, (Object)"long")) return;
                if (Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType("long"))) {
                    return;
                }
            }
            if (type2 == null && Intrinsics.areEqual((Object)type1, (Object)"long")) {
                if (Intrinsics.areEqual((Object)var12_19, (Object)"int")) return;
                if (Intrinsics.areEqual((Object)var12_19, (Object)Lint.getAutoBoxedType("int"))) {
                    return;
                }
            }
            Object expectedTypes = type4 != null ? type1 + ", " + type2 + ", " + type3 + ", or " + type4 : (type3 != null ? type1 + ", " + type2 + ", or " + type3 : (type2 != null ? type1 + " or " + type2 : type1));
            String string = originalType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"originalType.canonicalText");
            String string2 = string;
            boolean isString = Intrinsics.areEqual((Object)string2, (Object)"java.lang.String");
            if (isString) {
                String string3 = "String";
            }
            String message2 = "This annotation does not apply for type " + (String)var12_22 + "; expected " + (String)expectedTypes;
            if (isString && Intrinsics.areEqual((Object)type1, (Object)"int") && AndroidXConstants.INT_DEF_ANNOTATION.isEquals(name)) {
                message2 = message2 + ". Should `" + node.asSourceString() + "` be annotated with `@StringDef` instead?";
            }
            Location location2 = this.context.getLocation((UElement)node);
            JavaContext.report$default(this.context, ANNOTATION_USAGE, (UElement)node, location2, message2, null, 16, null);
        }

        static /* synthetic */ void checkTargetType$default(AnnotationChecker annotationChecker, UAnnotation uAnnotation, String string, String string2, String string3, String string4, String string5, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            if ((n & 0x20) != 0) {
                string5 = null;
            }
            if ((n & 0x40) != 0) {
                bl = true;
            }
            annotationChecker.checkTargetType(uAnnotation, string, string2, string3, string4, string5, bl);
        }

        @Override
        public void visitSwitchExpression(@NotNull USwitchExpression node) {
            UAnnotation annotation;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression condition = node.getExpression();
            if (condition != null && Intrinsics.areEqual((Object)PsiType.INT, (Object)condition.getExpressionType()) && (annotation = this.findIntDefAnnotation(condition)) != null) {
                UExpression value;
                UExpression uExpression = annotation.findAttributeValue("value");
                if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                    UExpression uExpression2 = annotation.findAttributeValue(null);
                    if (uExpression2 != null) {
                        uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2);
                    } else {
                        return;
                    }
                }
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)(value = uExpression)))) {
                    boolean open2 = UastLintUtils.Companion.getAnnotationBooleanValue(annotation, "open", false);
                    if (open2) {
                        return;
                    }
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    List allowedValues = ((UCallExpression)value).getValueArguments();
                    node.accept((UastVisitor)new SwitchChecker(node, allowedValues));
                }
            }
        }

        private final UAnnotation findIntDefAnnotation(UExpression expression) {
            if (expression instanceof UReferenceExpression) {
                UExpression lastAssignment;
                UAnnotation annotation;
                PsiElement resolved = ((UReferenceExpression)expression).resolve();
                if (resolved instanceof PsiModifierListOwner && (annotation = this.findTypeDef(expression, (PsiModifierListOwner)resolved)) != null) {
                    return annotation;
                }
                if (resolved instanceof PsiLocalVariable && (lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)expression)) != null) {
                    return this.findIntDefAnnotation(lastAssignment);
                }
            } else if (expression instanceof UCallExpression) {
                UAnnotation annotation;
                PsiMethod method = ((UCallExpression)expression).resolve();
                if (method != null && (annotation = this.findTypeDef(expression, (PsiModifierListOwner)method)) != null) {
                    return annotation;
                }
            } else if (expression instanceof UIfExpression) {
                UAnnotation result;
                if (((UIfExpression)expression).getThenExpression() != null) {
                    UExpression uExpression = ((UIfExpression)expression).getThenExpression();
                    Intrinsics.checkNotNull((Object)uExpression);
                    result = this.findIntDefAnnotation(uExpression);
                    if (result != null) {
                        return result;
                    }
                }
                if (((UIfExpression)expression).getElseExpression() != null) {
                    UExpression uExpression = ((UIfExpression)expression).getElseExpression();
                    Intrinsics.checkNotNull((Object)uExpression);
                    result = this.findIntDefAnnotation(uExpression);
                    if (result != null) {
                        return result;
                    }
                }
            } else {
                if (expression instanceof UBinaryExpressionWithType) {
                    return this.findIntDefAnnotation(((UBinaryExpressionWithType)expression).getOperand());
                }
                if (expression instanceof UParenthesizedExpression) {
                    return this.findIntDefAnnotation(((UParenthesizedExpression)expression).getExpression());
                }
            }
            return null;
        }

        private final UAnnotation findTypeDef(UExpression expression, PsiModifierListOwner owner) {
            JavaEvaluator evaluator = this.context.getEvaluator();
            List annotations = JavaEvaluator.getAnnotations$default(evaluator, owner, true, null, 4, null);
            Object[] objectArray = new String[]{AndroidXConstants.INT_DEF_ANNOTATION.oldName(), AndroidXConstants.INT_DEF_ANNOTATION.newName()};
            List<UAnnotation> uAnnotations = evaluator.filterRelevantAnnotations(annotations, (UElement)expression, (Set<String>)SetsKt.setOf((Object[])objectArray));
            return TypedefDetector.Companion.findIntDef(uAnnotations);
        }

        private final Integer getConstantValue(PsiField intDefConstantRef) {
            Object constant = intDefConstantRef.computeConstantValue();
            Number number = constant instanceof Number ? (Number)((Number)constant) : (Number)null;
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }

        private final void ensureUniqueValues(UAnnotation node) {
            boolean flag;
            UExpression value;
            UExpression uExpression = node.findDeclaredAttributeValue("value");
            if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                UExpression uExpression2 = node.findDeclaredAttributeValue(null);
                if (uExpression2 != null) {
                    uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2);
                } else {
                    return;
                }
            }
            if (!UastExpressionUtils.isArrayInitializer((UElement)((UElement)(value = uExpression)))) {
                return;
            }
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            List initializers = ((UCallExpression)value).getValueArguments();
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)initializers.size());
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(initializers.size)");
            Map valueToIndex = hashMap;
            boolean bl = flag = UastLintUtils.Companion.getAnnotationBooleanValue(node, "flag") == Boolean.TRUE;
            if (flag) {
                this.ensureUsingFlagStyle(initializers);
            }
            ConstantEvaluator constantEvaluator = new ConstantEvaluator();
            int n = initializers.size();
            for (int index2 = 0; index2 < n; ++index2) {
                UExpression expression = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)initializers.get(index2)));
                Object object = constantEvaluator.evaluate((UElement)expression);
                Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
                if (number == null) continue;
                Number number2 = number;
                if (valueToIndex.containsKey(number2)) {
                    String message2 = null;
                    String prevLocationLabel = null;
                    Integer n2 = (Integer)valueToIndex.get(number2);
                    if (n2 == null) {
                        continue;
                    }
                    int prevIndex = n2;
                    UExpression prevConstant = (UExpression)initializers.get(prevIndex);
                    UExpression uExpression3 = expression;
                    Intrinsics.checkNotNull((Object)uExpression3);
                    String constant1 = uExpression3.asSourceString();
                    String constant2 = prevConstant.asSourceString();
                    if (Intrinsics.areEqual((Object)constant1, (Object)constant2)) {
                        message2 = "Constant `" + constant1 + "` has already been included";
                        prevLocationLabel = "Previous occurrence";
                    } else {
                        PsiElement resolved;
                        String valueString = number2.toString();
                        if (expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) instanceof PsiField) {
                            PsiElement referencedField;
                            UExpression initializer;
                            PsiElement resolvePrev;
                            PsiField prevField = null;
                            if (prevConstant instanceof UReferenceExpression && (resolvePrev = ((UReferenceExpression)prevConstant).resolve()) instanceof PsiField) {
                                prevField = (PsiField)resolvePrev;
                                if (Intrinsics.areEqual((Object)((PsiField)resolved).getName(), (Object)prevField.getName())) {
                                    return;
                                }
                            }
                            if ((initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved)) instanceof ULiteralExpression) {
                                PsiElement source = ((ULiteralExpression)initializer).getSourcePsi();
                                if (source != null) {
                                    String string = source.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.text");
                                    valueString = string;
                                }
                            } else if (initializer instanceof UReferenceExpression && prevField != null && (referencedField = ((UReferenceExpression)initializer).resolve()) != null && referencedField.isEquivalentTo((PsiElement)prevField)) {
                                return;
                            }
                            if (prevField != null && this.isDeprecated((PsiField)resolved) != this.isDeprecated(prevField)) {
                                return;
                            }
                        }
                        message2 = "Constants `" + constant1 + "` and `" + constant2 + "` specify the same exact value (" + valueString + "); this is usually a cut & paste or merge error";
                        prevLocationLabel = "Previous same value";
                    }
                    Location location2 = this.context.getLocation((UElement)expression);
                    Location secondary = this.context.getLocation((UElement)prevConstant);
                    secondary.setMessage(prevLocationLabel);
                    location2.setSecondary(secondary);
                    UElement scope = AnnotationDetector.this.getAnnotationScope(node);
                    JavaContext.report$default(this.context, UNIQUE, scope, location2, message2, null, 16, null);
                    break;
                }
                object = index2;
                valueToIndex.put(number2, object);
            }
        }

        private final boolean isDeprecated(PsiField field) {
            UField uField;
            if (field instanceof KtLightField && (uField = (UField)UastContextKt.toUElement((PsiElement)((PsiElement)field))) != null) {
                boolean bl;
                block4: {
                    List annotations = uField.getUAnnotations();
                    Iterable $this$any$iv = annotations;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UAnnotation it = (UAnnotation)element$iv;
                            boolean bl2 = false;
                            String name = it.getQualifiedName();
                            if (!(Intrinsics.areEqual((Object)name, (Object)"java.lang.Deprecated") || Intrinsics.areEqual((Object)name, (Object)"kotlin.Deprecated"))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            return field.hasAnnotation("java.lang.Deprecated") || field.hasAnnotation("kotlin.Deprecated");
        }

        private final void ensureUsingFlagStyle(List<? extends UExpression> constants) {
            Number o;
            if (constants.size() < 3) {
                return;
            }
            List oneBitConstants = new ArrayList();
            for (UExpression uExpression : constants) {
                long value;
                PsiElement resolved;
                if (!(uExpression instanceof UReferenceExpression) || (resolved = ((UReferenceExpression)uExpression).resolve()) instanceof PsiCompiledElement || !(resolved instanceof PsiField)) continue;
                Object object = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved);
                UExpression uExpression2 = object != null ? UastUtils.skipParenthesizedExprDown((UExpression)object) : null;
                ULiteralExpression uLiteralExpression = uExpression2 instanceof ULiteralExpression ? (ULiteralExpression)uExpression2 : null;
                if (uLiteralExpression == null) continue;
                ULiteralExpression initializer = uLiteralExpression;
                object = initializer.getValue();
                Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
                if (number == null || Math.abs(value = (o = number).longValue()) <= 1L) continue;
                if (Long.bitCount(value) != 1) {
                    return;
                }
                oneBitConstants.add(new Triple((Object)initializer, (Object)resolved, (Object)o));
            }
            for (Triple triple : oneBitConstants) {
                String message2;
                String replace;
                UExpression initializer = (UExpression)triple.component1();
                PsiElement resolved = (PsiElement)triple.component2();
                o = (Number)triple.component3();
                long value = o.longValue();
                int shift2 = Long.numberOfTrailingZeros(value);
                if (AnnotationDetector.this.warnedFlags == null) {
                    AnnotationDetector.this.warnedFlags = new LinkedHashSet();
                }
                Set set = AnnotationDetector.this.warnedFlags;
                Intrinsics.checkNotNull((Object)set);
                if (!set.add(resolved)) {
                    return;
                }
                String operator = Lint.isKotlin(resolved) ? "shl" : "<<";
                Locale locale = Locale.US;
                Object object = "Consider declaring this constant using 1 %s %d instead";
                Object object2 = new Object[]{operator, shift2};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, (String)object, Arrays.copyOf(object2, ((Object[])object2).length)), (String)"format(locale, format, *args)");
                object = Locale.ROOT;
                object2 = "1%s %s %d";
                Object[] objectArray = new Object[]{o instanceof Long ? "L" : "", operator, shift2};
                Intrinsics.checkNotNullExpressionValue((Object)String.format((Locale)object, (String)object2, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(locale, format, *args)");
                LintFix fix = AnnotationDetector.this.fix().replace().sharedName("Change declaration to " + operator).with(replace).autoFix().build();
                Location location2 = this.context.getLocation((UElement)initializer);
                this.context.report(FLAG_STYLE, (UElement)initializer, location2, message2, fix);
            }
        }

        private final boolean checkSuppressLint(UAnnotation node, String id) {
            IssueRegistry registry = this.context.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains((Object)Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                UElement scope = AnnotationDetector.this.getAnnotationScope(node);
                JavaContext.report$default(this.context, INSIDE_METHOD, scope, this.context.getLocation((UElement)node), "The `@SuppressLint` annotation cannot be used on a local variable with the lint check '" + id + "': move out to the surrounding method", null, 16, null);
                return false;
            }
            return true;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/AnnotationDetector$AnnotationChecker$SwitchChecker;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "switchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "allowedValues", "", "Lorg/jetbrains/uast/UExpression;", "(Lcom/android/tools/lint/checks/AnnotationDetector$AnnotationChecker;Lorg/jetbrains/uast/USwitchExpression;Ljava/util/List;)V", "fields", "", "", "reported", "", "seenValues", "", "afterVisitSwitchExpression", "", "node", "reportMissingSwitchCases", "visitSwitchClauseExpression", "Lorg/jetbrains/uast/USwitchClauseExpression;", "android.sdktools.lint-checks"})
        private final class SwitchChecker
        extends AbstractUastVisitor {
            @NotNull
            private final USwitchExpression switchExpression;
            @Nullable
            private final List<UExpression> allowedValues;
            @NotNull
            private final List<Object> fields;
            @NotNull
            private final List<Integer> seenValues;
            private boolean reported;

            public SwitchChecker(@NotNull USwitchExpression switchExpression, List<? extends UExpression> allowedValues) {
                Intrinsics.checkNotNullParameter((Object)switchExpression, (String)"switchExpression");
                Intrinsics.checkNotNullParameter(allowedValues, (String)"allowedValues");
                this.switchExpression = switchExpression;
                this.allowedValues = allowedValues;
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)allowedValues.size());
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayListWithCapacity(allowedValues.size)");
                this.fields = arrayList;
                for (UExpression uExpression : allowedValues) {
                    if (uExpression instanceof UReferenceExpression) {
                        PsiElement resolved = ((UReferenceExpression)uExpression).resolve();
                        if (resolved == null) continue;
                        this.fields.add(resolved);
                        continue;
                    }
                    if (!(uExpression instanceof ULiteralExpression)) continue;
                    this.fields.add(uExpression);
                }
                ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)allowedValues.size());
                Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"newArrayListWithCapacity(allowedValues.size)");
                this.seenValues = arrayList2;
            }

            public boolean visitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.reported) {
                    return true;
                }
                if (this.allowedValues == null) {
                    return true;
                }
                List caseValues = node.getCaseValues();
                if (caseValues.isEmpty()) {
                    this.fields.clear();
                    return true;
                }
                for (UExpression caseValue : caseValues) {
                    if (caseValue instanceof ULiteralExpression) {
                        List list2 = AnnotationDetector.this.computeFieldNames(this.switchExpression, this.allowedValues);
                        String message2 = "Don't use a constant here; expected one of: " + AnnotationDetector.this.displayConstants(list2);
                        JavaContext.report$default(AnnotationChecker.this.context, SWITCH_TYPE_DEF, (UElement)caseValue, AnnotationChecker.this.context.getLocation((UElement)caseValue), message2, null, 16, null);
                        this.reported = true;
                        continue;
                    }
                    if (caseValue instanceof UReferenceExpression) {
                        PsiElement resolved;
                        if (((UReferenceExpression)caseValue).resolve() == null) {
                            return true;
                        }
                        if (!(resolved instanceof PsiField)) continue;
                        boolean found = AnnotationDetector.this.removeFieldFromList(this.fields, (PsiField)resolved);
                        if (!found) {
                            UExpression initializer;
                            UExpression uExpression = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved);
                            Object object = initializer = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                            if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) instanceof PsiField) {
                                found = AnnotationDetector.this.removeFieldFromList(this.fields, (PsiField)resolved);
                            }
                        }
                        if (found) {
                            PsiElement psiElement = resolved;
                            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiField");
                            Integer cv = AnnotationChecker.this.getConstantValue((PsiField)psiElement);
                            if (cv == null) continue;
                            this.seenValues.add(cv);
                            continue;
                        }
                        List list3 = AnnotationDetector.this.computeFieldNames(this.switchExpression, this.allowedValues);
                        String message3 = "Unexpected constant; expected one of: " + AnnotationDetector.this.displayConstants(list3);
                        Object[] objectArray = new Object[]{AnnotationDetector.KEY_CASES, list3};
                        LintFix fix = AnnotationDetector.this.fix().data(objectArray);
                        Location location2 = AnnotationChecker.this.context.getNameLocation((UElement)caseValue);
                        AnnotationChecker.this.context.report(SWITCH_TYPE_DEF, (UElement)caseValue, location2, message3, fix);
                        continue;
                    }
                    PsiElement sourcePsi = caseValue.getSourcePsi();
                    if (!(sourcePsi instanceof PsiSwitchLabelStatement) || !((PsiSwitchLabelStatement)sourcePsi).isDefaultCase()) continue;
                    this.fields.clear();
                    return true;
                }
                return true;
            }

            public void afterVisitSwitchExpression(@NotNull USwitchExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.reportMissingSwitchCases();
                super.afterVisitSwitchExpression(node);
            }

            private final void reportMissingSwitchCases() {
                Object[] cv;
                if (this.reported) {
                    return;
                }
                if (this.allowedValues == null) {
                    return;
                }
                if (!((Collection)this.fields).isEmpty()) {
                    ListIterator<Object> iterator = this.fields.listIterator();
                    while (iterator.hasNext()) {
                        Object next = iterator.next();
                        if (!(next instanceof PsiField) || !this.seenValues.contains(cv = AnnotationChecker.this.getConstantValue((PsiField)next))) continue;
                        iterator.remove();
                    }
                }
                if (!((Collection)this.fields).isEmpty()) {
                    List list2 = AnnotationDetector.this.computeFieldNames(this.switchExpression, this.fields);
                    cv = new Object[]{AnnotationDetector.KEY_CASES, list2};
                    LintFix fix = AnnotationDetector.this.fix().data(cv);
                    UIdentifier identifier = this.switchExpression.getSwitchIdentifier();
                    Location location2 = AnnotationChecker.this.context.getLocation((UElement)identifier);
                    if (this.switchExpression.getSourcePsi() instanceof KtWhenExpression && !Intrinsics.areEqual((Object)"when", (Object)identifier.getName())) {
                        PsiElement psiElement = this.switchExpression.getSourcePsi();
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
                        KtWhenExpression sourcePsi = (KtWhenExpression)psiElement;
                        PsiElement keyword = sourcePsi.getFirstChild();
                        if (keyword != null) {
                            location2 = AnnotationChecker.this.context.getLocation(keyword);
                        }
                    }
                    String message2 = "Switch statement on an `int` with known associated constant missing case " + AnnotationDetector.this.displayConstants(list2);
                    AnnotationChecker.this.context.report(SWITCH_TYPE_DEF, (UElement)this.switchExpression, location2, message2, fix);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/AnnotationDetector$Companion;", "", "()V", "ANNOTATION_USAGE", "Lcom/android/tools/lint/detector/api/Issue;", "ATTR_ALL_OF", "", "ATTR_ANY_OF", "ATTR_CONDITIONAL", "ATTR_FROM", "ATTR_FROM_INCLUSIVE", "ATTR_MAX", "ATTR_MIN", "ATTR_MULTIPLE", "ATTR_SUGGEST", "ATTR_TO", "ATTR_TO_INCLUSIVE", "FLAG_STYLE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "INSIDE_METHOD", "JAVA_ANNOTATION_TARGET_FQN", "KEY_CASES", "KOTLIN_ANNOTATION_TARGET_FQN", "SWITCH_TYPE_DEF", "UNIQUE", "WARN_ABOUT_EXTENSION_LEVEL_GAPS", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

