/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.Installer;
import com.android.tools.idea.protobuf.ByteString;
import com.android.utils.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LiveUpdateDeployer {
    private final ILogger logger;

    public LiveUpdateDeployer(ILogger logger) {
        this.logger = logger;
    }

    public List<UpdateLiveEditError> updateLiveLiteral(Installer installer, AdbClient adb, String packageName, Collection<UpdateLiveLiteralParam> params) {
        List<Integer> pids = adb.getPids(packageName);
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.LiveLiteralUpdateRequest.Builder requestBuilder = Deploy.LiveLiteralUpdateRequest.newBuilder();
        for (UpdateLiveLiteralParam param : params) {
            requestBuilder.addUpdates(Deploy.LiveLiteral.newBuilder().setKey(param.key).setOffset(param.offset).setHelperClass(param.helper).setType(param.type).setValue(param.value));
        }
        requestBuilder.setPackageName(packageName);
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        Deploy.LiveLiteralUpdateRequest request = requestBuilder.build();
        LinkedList<UpdateLiveEditError> errors = new LinkedList<UpdateLiveEditError>();
        try {
            Deploy.LiveLiteralUpdateResponse response = installer.updateLiveLiterals(request);
            for (Deploy.AgentResponse failure : response.getFailedAgentsList()) {
                errors.add(new UpdateLiveEditError(failure.getLiveLiteralResponse().getExtra()));
            }
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, Arrays.toString(errors.toArray()), new Object[0]);
        }
        return errors;
    }

    public UpdateLiveEditResult updateLiveEdit(Installer installer, AdbClient adb, String packageName, UpdateLiveEditsParam param) {
        if (param.classData.length == 0) {
            return new UpdateLiveEditResult();
        }
        List<Integer> pids = adb.getPids(packageName);
        if (pids.isEmpty()) {
            System.out.println("Cancelling LiveEdit request(No target pids)");
            LinkedList<UpdateLiveEditError> error2 = new LinkedList<UpdateLiveEditError>();
            error2.add(new UpdateLiveEditError("No target pids to Live Edit"));
            return new UpdateLiveEditResult(error2);
        }
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.LiveEditRequest.Builder requestBuilder = Deploy.LiveEditRequest.newBuilder();
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        requestBuilder.setPackageName(packageName);
        requestBuilder.setComposable(param.isComposable);
        requestBuilder.setGroupId(param.groupId);
        requestBuilder.addTargetClasses(Deploy.LiveEditClass.newBuilder().setClassName(param.className).setClassData(ByteString.copyFrom((byte[])param.classData)).setMethodName(param.methodName).setMethodDesc(param.methodDesc));
        for (String name : param.supportClasses.keySet()) {
            ByteString data = ByteString.copyFrom((byte[])param.supportClasses.get(name));
            requestBuilder.addSupportClasses(Deploy.LiveEditClass.newBuilder().setClassName(name).setClassData(data));
        }
        requestBuilder.setDebugModeEnabled(param.debugModeEnabled);
        requestBuilder.setRecomposeAfterPriming(param.recomposeAfterPriming);
        Deploy.LiveEditRequest request = requestBuilder.build();
        System.out.println("Live Edit: Uploading " + param.className + "." + param.methodName + " of " + param.classData.length + " bytes.");
        UpdateLiveEditResult result = null;
        try {
            LinkedList<UpdateLiveEditError> errors = new LinkedList<UpdateLiveEditError>();
            Deploy.LiveEditResponse response = installer.liveEdit(request);
            Deploy.AgentLiveEditResponse.RecomposeType recomposeType = Deploy.AgentLiveEditResponse.RecomposeType.NONE;
            if (response.getStatus() == Deploy.LiveEditResponse.Status.AGENT_ERROR) {
                for (Deploy.AgentResponse failure : response.getFailedAgentsList()) {
                    failure.getLeResponse().getErrorsList().forEach(error -> errors.add(new UpdateLiveEditError((Deploy.UnsupportedChange)error)));
                }
            }
            if (response.getStatus() == Deploy.LiveEditResponse.Status.OK) {
                for (Deploy.AgentResponse success : response.getSuccessAgentsList()) {
                    if (!success.hasLeResponse()) {
                        throw new RuntimeException("Live Edit response does not contain agent response object");
                    }
                    Deploy.AgentLiveEditResponse ler = success.getLeResponse();
                    recomposeType = ler.getRecomposeType();
                }
            } else {
                errors.add(new UpdateLiveEditError(response.getStatus().toString()));
            }
            result = new UpdateLiveEditResult(errors, recomposeType);
        }
        catch (IOException e) {
            result = new UpdateLiveEditResult(Collections.singletonList(new UpdateLiveEditError(e)), Deploy.AgentLiveEditResponse.RecomposeType.NONE);
        }
        return result;
    }

    public void recompose(Installer installer, AdbClient adb, String applicationId) {
        Deploy.RecomposeRequest.Builder builder = Deploy.RecomposeRequest.newBuilder();
        List<Integer> pids = adb.getPids(applicationId);
        if (pids.isEmpty()) {
            System.out.println("Cancelling Recompose (No target pids)");
            return;
        }
        builder.setArch(adb.getArch(pids));
        builder.addAllProcessIds(pids);
        builder.setApplicationId(applicationId);
        try {
            installer.recompose(builder.build());
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "Recompose error", new Object[0]);
        }
    }

    public boolean retrieveComposeStatus(Installer installer, AdbClient adb, String appId) {
        List<Integer> pids = adb.getPids(appId);
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.ComposeStatusRequest.Builder requestBuilder = Deploy.ComposeStatusRequest.newBuilder();
        requestBuilder.setApplicationId(appId);
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        Deploy.ComposeStatusRequest request = requestBuilder.build();
        try {
            Deploy.ComposeStatusResponse response = installer.composeStatus(request);
            Iterator iterator = response.getExceptionsList().iterator();
            if (iterator.hasNext()) {
                Deploy.ComposeException exception = (Deploy.ComposeException)iterator.next();
                System.out.print("Live Edit Recompose Status Exception: (");
                System.out.print(exception.getRecoverable() ? "Recoverable" : "Not Recoverable");
                System.out.println(") " + exception.getMessage());
                return false;
            }
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "Cannot retrieve Compose Status", new Object[0]);
        }
        return true;
    }

    public static class UpdateLiveEditError {
        private static final String APP_RESTART_STR = "\nPlease Re-Run your application.";
        private static final String ADDED_CLASS_STR = "Unsupported addition of new class '%s' in file '%s'.";
        private static final String ADDED_METHOD_STR = "Unsupported addition of new method '%s.%s' in file '%s', line %d.";
        private static final String REMOVED_METHOD_STR = "Unsupported deletion of method '%s.%s' in file '%s'.";
        private static final String ADDED_FIELD_STR = "Unsupported addition of field '%s' in class '%s' in file '%s'.";
        private static final String REMOVED_FIELD_STR = "Unsupported deletion of field '%s' in class '%s' in file '%s'.";
        private static final String MODIFIED_FIELD_STR = "Unsupported change to field '%s' in class '%s' in file '%s'.";
        private static final String MODIFIED_SUPER_STR = "Unsupported change to superclass of class '%s' in file '%s'.";
        private static final String ADDED_INTERFACE_STR = "Unsupported change to interfaces of class '%s' in file '%s'.";
        private static final String REMOVED_INTERFACE_STR = "Unsupported change to interfaces of class '%s' in file '%s'.";
        private static final String UNSUPPORTED_COMPOSE_VERSION = "Update Compose runtime and compiler versions 1.3.0 or higher in order to view the latest Live Edit changes.";
        private final String msg;
        private final Deploy.UnsupportedChange.Type type;

        public UpdateLiveEditError(Exception e) {
            this.msg = e.getMessage();
            this.type = Deploy.UnsupportedChange.Type.UNKNOWN;
        }

        public UpdateLiveEditError(String msg) {
            this.msg = msg;
            this.type = Deploy.UnsupportedChange.Type.UNKNOWN;
        }

        public UpdateLiveEditError(Deploy.UnsupportedChange error) {
            this.type = error.getType();
            switch (error.getType()) {
                case ADDED_CLASS: {
                    this.msg = String.format(Locale.US, ADDED_CLASS_STR, error.getClassName(), error.getFileName());
                    break;
                }
                case ADDED_METHOD: {
                    this.msg = String.format(Locale.US, ADDED_METHOD_STR, error.getClassName(), error.getTargetName(), error.getFileName(), error.getLineNumber());
                    break;
                }
                case REMOVED_METHOD: {
                    this.msg = String.format(Locale.US, REMOVED_METHOD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case ADDED_FIELD: {
                    this.msg = String.format(Locale.US, ADDED_FIELD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case REMOVED_FIELD: {
                    this.msg = String.format(Locale.US, REMOVED_FIELD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case MODIFIED_FIELD: {
                    this.msg = String.format(Locale.US, MODIFIED_FIELD_STR, error.getClassName(), error.getTargetName(), error.getFileName());
                    break;
                }
                case MODIFIED_SUPER: {
                    this.msg = String.format(Locale.US, MODIFIED_SUPER_STR, error.getClassName(), error.getFileName());
                    break;
                }
                case ADDED_INTERFACE: {
                    this.msg = String.format(Locale.US, "Unsupported change to interfaces of class '%s' in file '%s'.", error.getClassName(), error.getFileName());
                    break;
                }
                case REMOVED_INTERFACE: {
                    this.msg = String.format(Locale.US, "Unsupported change to interfaces of class '%s' in file '%s'.", error.getClassName(), error.getFileName());
                    break;
                }
                case UNSUPPORTED_COMPOSE_VERSION: {
                    this.msg = UNSUPPORTED_COMPOSE_VERSION;
                    break;
                }
                default: {
                    this.msg = "Unknown error";
                }
            }
        }

        public String getMessage() {
            if (this.type == Deploy.UnsupportedChange.Type.UNSUPPORTED_COMPOSE_VERSION) {
                return this.msg;
            }
            return this.msg + APP_RESTART_STR;
        }

        public Deploy.UnsupportedChange.Type getType() {
            return this.type;
        }
    }

    public static final class UpdateLiveEditResult {
        public final List<UpdateLiveEditError> errors;
        public final Deploy.AgentLiveEditResponse.RecomposeType recomposeType;

        public UpdateLiveEditResult() {
            this(new ArrayList<UpdateLiveEditError>(), Deploy.AgentLiveEditResponse.RecomposeType.NONE);
        }

        public UpdateLiveEditResult(List<UpdateLiveEditError> errors) {
            this(errors, Deploy.AgentLiveEditResponse.RecomposeType.NONE);
        }

        public UpdateLiveEditResult(List<UpdateLiveEditError> errors, Deploy.AgentLiveEditResponse.RecomposeType type) {
            this.errors = errors;
            this.recomposeType = type;
        }
    }

    public static class UpdateLiveEditsParam {
        public final String className;
        public final String methodName;
        public final String methodDesc;
        public final boolean isComposable;
        public final int groupId;
        public final byte[] classData;
        public final Map<String, byte[]> supportClasses;
        final boolean debugModeEnabled;
        final boolean recomposeAfterPriming;

        public UpdateLiveEditsParam(String className, String methodName, String methodDesc, boolean isComposable, int groupId, byte[] classData, Map<String, byte[]> supportClasses, boolean debugModeEnabled, boolean recomposeAfterPriming) {
            this.className = className;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.isComposable = isComposable;
            this.groupId = groupId;
            this.classData = classData;
            this.supportClasses = supportClasses;
            this.debugModeEnabled = debugModeEnabled;
            this.recomposeAfterPriming = recomposeAfterPriming;
        }
    }

    public static class UpdateLiveLiteralParam {
        final String key;
        final String type;
        final String value;
        final int offset;
        final String helper;

        public UpdateLiveLiteralParam(String key, int offset, String helper, String type, String value) {
            this.key = key;
            this.offset = offset;
            this.helper = helper;
            this.type = type;
            this.value = value;
        }
    }
}

