/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.WearComponent;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import com.android.utils.ILogger;

public class Tile
extends WearComponent {
    public Tile(ManifestServiceInfo info, String appId, IDevice device2, ILogger logger) {
        super(device2, appId, info, logger);
    }

    @Override
    public void activate(String extraFlags, AppComponent.Mode activationMode, IShellOutputReceiver addTileReceiver) throws DeployerException {
        this.validate(extraFlags);
        this.logger.info("Activating Tile '%s' %s", new Object[]{this.info.getQualifiedName(), activationMode.equals((Object)AppComponent.Mode.DEBUG) ? "for debug" : ""});
        if (activationMode.equals((Object)AppComponent.Mode.DEBUG)) {
            this.setUpAmDebugApp();
            this.setUpDebugSurfaceDebugApp();
        }
        String command = this.getStartTileCommand();
        this.runStartCommand(command, addTileReceiver, this.logger);
    }

    private void validate(String extraFlags) throws DeployerException {
        if (!extraFlags.isEmpty()) {
            throw DeployerException.componentActivationException(String.format("Extra flags are not supported by Tile. Detected flags `%s`", extraFlags));
        }
    }

    private String getStartTileCommand() {
        return ShellCommand.SET_TILE + this.getFQEscapedName();
    }

    public static class ShellCommand {
        public static String SET_TILE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation 'add-tile' --ecn component ";
        public static String UNSET_TILE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation remove-tile --ecn component ";
        public static String SHOW_TILE_COMMAND = "am broadcast -a com.google.android.wearable.app.DEBUG_SYSUI --es operation show-tile --ei index ";
    }
}

