/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkChecker;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ApkEntryExtractor;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.ApkParser;
import com.android.tools.deployer.ApkPreInstaller;
import com.android.tools.deployer.ApkSwapper;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.CachedDexSplitter;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.D8DexSplitter;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.DexComparator;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.OptimisticApkInstaller;
import com.android.tools.deployer.OptimisticApkSwapper;
import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.RootPushApkInstaller;
import com.android.tools.deployer.Sites;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.SwapVerifier;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.deployer.tasks.Task;
import com.android.tools.deployer.tasks.TaskResult;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;

public class Deployer {
    public static final String BASE_DIRECTORY = Sites.deviceStudioFolder();
    public static final String INSTALLER_DIRECTORY = Sites.installerExecutableFolder();
    public static final String INSTALLER_TMP_DIRECTORY = Sites.installerTmpFolder();
    private final AdbClient adb;
    private final SqlApkFileDatabase dexDb;
    private final DeploymentCacheDatabase deployCache;
    private final Installer installer;
    private final TaskRunner runner;
    private final UIService service;
    private final MetricsRecorder metrics;
    private final ILogger logger;
    private final DeployerOption options;

    public Deployer(AdbClient adb, DeploymentCacheDatabase deployCache, SqlApkFileDatabase dexDb, TaskRunner runner, Installer installer, UIService service, MetricsRecorder metrics, ILogger logger, DeployerOption options) {
        this.adb = adb;
        this.deployCache = deployCache;
        this.dexDb = dexDb;
        this.runner = runner;
        this.installer = installer;
        this.service = service;
        this.metrics = metrics;
        this.logger = logger;
        this.options = options;
    }

    public Result install(String packageName, List<String> apks, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        try (Trace ignored = Trace.begin("install");){
            Canceller canceller = installOptions.getCancelChecker();
            String sessionUID = UUID.randomUUID().toString();
            InstallInfo info = this.options.useRootPushInstall ? this.rootPushInstall(sessionUID, packageName, apks, installOptions, installMode) : (this.supportsNewPipeline() ? this.optimisticInstall(sessionUID, packageName, apks, installOptions, installMode) : this.packageManagerInstall(sessionUID, packageName, apks, installOptions, installMode));
            App app = new App(packageName, info.apks, this.adb.getDevice(), this.logger);
            if (this.options.skipPostInstallTasks) {
                Result result = new Result(info.skippedInstall, false, false, app);
                return result;
            }
            Task<Boolean> installCoroutineDebugger = null;
            Task<List<Apk>> parsedApksTask = this.runner.create(info.apks);
            if (this.useCoroutineDebugger()) {
                installCoroutineDebugger = this.runner.create(Tasks.INSTALL_COROUTINE_DEBUGGER, list2 -> this.installCoroutineDebugger(packageName, (List<Apk>)list2), parsedApksTask);
            }
            CachedDexSplitter splitter = new CachedDexSplitter(this.dexDb, new D8DexSplitter());
            this.runner.create(Tasks.CACHE, splitter::cache, parsedApksTask);
            ApkChecker checker = new ApkChecker(sessionUID, this.logger);
            this.runner.create(Tasks.APK_CHECK, checker::log, parsedApksTask);
            this.runner.runAsync(canceller);
            boolean coroutineDebuggerInstalled = installCoroutineDebugger != null ? installCoroutineDebugger.get() : false;
            Result result = new Result(info.skippedInstall, false, coroutineDebuggerInstalled, app);
            return result;
        }
    }

    private InstallInfo packageManagerInstall(String deploySessionUID, String packageName, List<String> paths2, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        this.logger.info("Deploy Install Session %s", new Object[]{deploySessionUID});
        ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
        boolean skippedInstall = !apkInstaller.install(packageName, paths2, installOptions, installMode, this.metrics.getDeployMetrics());
        return new InstallInfo(skippedInstall, new ApkParser().parsePaths(paths2));
    }

    private InstallInfo rootPushInstall(String deploySessionUID, String packageName, List<String> paths2, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        this.logger.info("Deploy Root Push Install Session %s", new Object[]{deploySessionUID});
        Canceller canceller = installOptions.getCancelChecker();
        Task<List> apks = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, this.runner.create(paths2));
        Task<Boolean> installSuccess = this.runner.create(Tasks.ROOT_PUSH_INSTALL, new RootPushApkInstaller(this.adb, this.installer, this.logger)::install, this.runner.create(packageName), apks);
        TaskResult result = this.runner.run(canceller);
        result.getMetrics().forEach(this.metrics::add);
        boolean skippedInstall = false;
        if (!result.isSuccess() || !installSuccess.get().booleanValue()) {
            ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
            skippedInstall = !apkInstaller.install(packageName, paths2, installOptions, installMode, this.metrics.getDeployMetrics());
        }
        return new InstallInfo(skippedInstall, apks.get());
    }

    private InstallInfo optimisticInstall(String deploySessionUID, String pkgName, List<String> paths2, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        this.logger.info("Optimistic Deploy Install Session %s", new Object[]{deploySessionUID});
        Canceller canceller = installOptions.getCancelChecker();
        installMode = installMode == InstallMode.DELTA ? InstallMode.DELTA_NO_SKIP : installMode;
        Task<String> packageName = this.runner.create(pkgName);
        Task<String> deviceSerial = this.runner.create(this.adb.getSerial());
        Task<List> apks = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, this.runner.create(paths2));
        boolean installSuccess = false;
        if (!this.options.optimisticInstallSupport.isEmpty()) {
            OptimisticApkInstaller apkInstaller = new OptimisticApkInstaller(this.installer, this.adb, this.deployCache, this.metrics, this.options, this.logger);
            Task<List<String>> userFlags = this.runner.create(installOptions.getUserFlags());
            Task<OverlayId> overlayId = this.runner.create(Tasks.OPTIMISTIC_INSTALL, apkInstaller::install, packageName, apks, userFlags);
            TaskResult result = this.runner.run(canceller);
            installSuccess = result.isSuccess();
            if (installSuccess) {
                this.runner.create(Tasks.DEPLOY_CACHE_STORE, this.deployCache::store, deviceSerial, packageName, apks, overlayId);
            }
            result.getMetrics().forEach(this.metrics::add);
        }
        boolean skippedInstall = false;
        if (!installSuccess) {
            this.logger.info("Optimistic Install Session %s: falling back to PM", new Object[]{deploySessionUID});
            ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
            skippedInstall = !apkInstaller.install(pkgName, paths2, installOptions, installMode, this.metrics.getDeployMetrics());
            this.runner.create(Tasks.DEPLOY_CACHE_STORE, this.deployCache::invalidate, deviceSerial, packageName);
        }
        this.runner.runAsync(canceller);
        return new InstallInfo(skippedInstall, apks.get());
    }

    public Result codeSwap(List<String> apks, Map<Integer, ClassRedefiner> debuggerRedefiners, Canceller canceller) throws DeployerException {
        try (Trace ignored = Trace.begin("codeSwap");){
            if (this.supportsNewPipeline()) {
                Result result = this.optimisticSwap(apks, false, debuggerRedefiners, canceller);
                return result;
            }
            Result result = this.swap(apks, false, debuggerRedefiners, canceller);
            return result;
        }
    }

    public Result fullSwap(List<String> apks, Canceller canceller) throws DeployerException {
        try (Trace ignored = Trace.begin("fullSwap");){
            if (this.supportsNewPipeline() && this.options.useOptimisticResourceSwap) {
                Result result = this.optimisticSwap(apks, true, (Map<Integer, ClassRedefiner>)ImmutableMap.of(), canceller);
                return result;
            }
            Result result = this.swap(apks, true, (Map<Integer, ClassRedefiner>)ImmutableMap.of(), canceller);
            return result;
        }
    }

    private boolean installCoroutineDebugger(String packageName, List<Apk> apk) {
        try {
            Deploy.Arch arch = AdbClient.getArchForAbi(this.adb.getAbiForApks(apk));
            Deploy.InstallCoroutineAgentResponse response = this.installer.installCoroutineAgent(packageName, arch);
            return response.getStatus() == Deploy.InstallCoroutineAgentResponse.Status.OK;
        }
        catch (Exception e) {
            this.logger.warning(e.getMessage(), new Object[0]);
            return false;
        }
    }

    private boolean useCoroutineDebugger() {
        return this.options.enableCoroutineDebugger && this.adb.getVersion().isGreaterOrEqualThan(28);
    }

    private Result swap(List<String> argPaths, boolean argRestart, Map<Integer, ClassRedefiner> debuggerRedefiners, Canceller canceller) throws DeployerException {
        if (!this.adb.getVersion().isGreaterOrEqualThan(26)) {
            throw DeployerException.apiNotSupported();
        }
        String deploySessionUID = UUID.randomUUID().toString();
        this.logger.info("Deploy Apply " + (argRestart ? "" : "Code ") + "Session %s", new Object[]{deploySessionUID});
        Task<List<String>> paths2 = this.runner.create(argPaths);
        Task<Boolean> restart = this.runner.create(argRestart);
        Task<CachedDexSplitter> splitter = this.runner.create(new CachedDexSplitter(this.dexDb, new D8DexSplitter()));
        Task<List> newFiles = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, paths2);
        Task<ApplicationDumper.Dump> dumps = this.runner.create(Tasks.DUMP, new ApplicationDumper(this.installer)::dump, newFiles);
        Task<List> diffs = this.runner.create(Tasks.DIFF, (dump2, newApks) -> new ApkDiffer().diff(dump2.apks, (List<Apk>)newApks), dumps, newFiles);
        Task<String> sessionId = this.runner.create(Tasks.PREINSTALL, new ApkPreInstaller(this.adb, this.installer, this.logger)::preinstall, dumps, newFiles, diffs);
        Task<List> dexDiffs = this.runner.create(Tasks.VERIFY, new SwapVerifier()::verify, diffs, restart);
        Task<DexComparator.ChangedClasses> toSwap = this.runner.create(Tasks.COMPARE, new DexComparator()::compare, dexDiffs, splitter);
        ApkSwapper swapper = new ApkSwapper(this.installer, debuggerRedefiners, argRestart, this.adb, this.logger);
        this.runner.create(Tasks.SWAP, swapper::swap, swapper::error, dumps, sessionId, toSwap);
        TaskResult result = this.runner.run(canceller);
        result.getMetrics().forEach(this.metrics::add);
        Task<String> packageName = this.runner.create(Tasks.PARSE_APP_IDS, ApplicationDumper::getPackageName, newFiles);
        if (!result.isSuccess()) {
            throw result.getException();
        }
        this.runner.create(Tasks.CACHE, DexSplitter::cache, splitter, newFiles);
        ApkChecker checker = new ApkChecker(deploySessionUID, this.logger);
        this.runner.create(Tasks.APK_CHECK, checker::log, newFiles);
        this.runner.runAsync(canceller);
        App app = new App(packageName.get(), newFiles.get(), this.adb.getDevice(), this.logger);
        boolean skippedInstall = sessionId.get().equals("<SKIPPED-INSTALLATION>");
        return new Result(skippedInstall, false, false, app);
    }

    private Result optimisticSwap(List<String> argPaths, boolean argRestart, Map<Integer, ClassRedefiner> redefiners, Canceller canceller) throws DeployerException {
        if (!this.adb.getVersion().isGreaterOrEqualThan(26)) {
            throw DeployerException.apiNotSupported();
        }
        String deploySessionUID = UUID.randomUUID().toString();
        this.logger.info("Deploy Optimistic Apply " + (argRestart ? "" : "Code ") + "Session %s", new Object[]{deploySessionUID});
        Task<List<String>> paths2 = this.runner.create(argPaths);
        Task<Boolean> restart = this.runner.create(argRestart);
        Task<CachedDexSplitter> splitter = this.runner.create(new CachedDexSplitter(this.dexDb, new D8DexSplitter()));
        Task<String> deviceSerial = this.runner.create(this.adb.getSerial());
        Task<List> newFiles = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, paths2);
        Task<String> packageName = this.runner.create(Tasks.PARSE_APP_IDS, ApplicationDumper::getPackageName, newFiles);
        Task<List> pids = this.runner.create(Tasks.GET_PIDS, this.adb::getPids, packageName);
        Task<Deploy.Arch> arch = this.runner.create(Tasks.GET_ARCH, this.adb::getArch, pids);
        Task<DeploymentCacheDatabase.Entry> speculativeDump = this.runner.create(Tasks.OPTIMISTIC_DUMP, this::dumpWithCache, packageName, deviceSerial, newFiles);
        Task<List> diffs = this.runner.create(Tasks.DIFF, new ApkDiffer()::specDiff, speculativeDump, newFiles);
        Predicate<String> filter2 = file -> file.startsWith("res") || file.startsWith("assets");
        Task<Map> extractedFiles = this.runner.create(Tasks.EXTRACT_APK_ENTRIES, new ApkEntryExtractor(filter2)::extractFromDiffs, diffs);
        Task<List> dexDiffs = this.runner.create(Tasks.VERIFY, new SwapVerifier()::verify, newFiles, diffs, restart);
        Task<DexComparator.ChangedClasses> changedClasses = this.runner.create(Tasks.COMPARE, new DexComparator()::compare, dexDiffs, splitter);
        OptimisticApkSwapper swapper = new OptimisticApkSwapper(this.installer, redefiners, argRestart, this.options, this.metrics);
        Task<OptimisticApkSwapper.OverlayUpdate> overlayUpdate = this.runner.create(Tasks.COLLECT_SWAP_DATA, OptimisticApkSwapper.OverlayUpdate::new, speculativeDump, changedClasses, extractedFiles);
        Task<OptimisticApkSwapper.SwapResult> swapResultTask = this.runner.create(Tasks.OPTIMISTIC_SWAP, swapper::optimisticSwap, packageName, pids, arch, overlayUpdate);
        TaskResult result = this.runner.run(canceller);
        result.getMetrics().forEach(this.metrics::add);
        if (!result.isSuccess()) {
            throw result.getException();
        }
        this.runner.create(Tasks.CACHE, DexSplitter::cache, splitter, newFiles);
        this.runner.create(Tasks.DEPLOY_CACHE_STORE, (serial, pkgName, files2, swap) -> this.deployCache.store((String)serial, (String)pkgName, (List<Apk>)files2, swap.overlayId), deviceSerial, packageName, newFiles, swapResultTask);
        ApkChecker checker = new ApkChecker(deploySessionUID, this.logger);
        this.runner.create(Tasks.APK_CHECK, checker::log, newFiles);
        this.runner.runAsync(canceller);
        App app = new App(packageName.get(), newFiles.get(), this.adb.getDevice(), this.logger);
        boolean needsRestart = this.options.fastRestartOnSwapFail && !swapResultTask.get().hotswapSucceeded;
        return new Result(false, needsRestart, false, app);
    }

    private DeploymentCacheDatabase.Entry dumpWithCache(String packageName, String deviceSerial, List<Apk> apks) throws DeployerException {
        String serial = this.adb.getSerial();
        DeploymentCacheDatabase.Entry entry = this.deployCache.get(serial, packageName);
        if (entry != null && !entry.getOverlayId().isBaseInstall()) {
            return entry;
        }
        ApplicationDumper dumper = new ApplicationDumper(this.installer);
        List<Apk> deviceApks = dumper.dump(apks).apks;
        this.deployCache.store(serial, packageName, deviceApks, new OverlayId(deviceApks));
        return this.deployCache.get(serial, packageName);
    }

    public boolean supportsNewPipeline() {
        return this.options.useOptimisticSwap && this.adb.getVersion().getApiLevel() >= 30;
    }

    private static class InstallInfo {
        public final boolean skippedInstall;
        public final List<Apk> apks;

        public InstallInfo(boolean skippedInstall, List<Apk> apks) {
            this.skippedInstall = skippedInstall;
            this.apks = apks;
        }
    }

    public static class Result {
        public final boolean skippedInstall;
        public final boolean needsRestart;
        public final boolean coroutineDebuggerInstalled;
        public final App app;

        public Result(boolean skippedInstall, boolean needsRestart, boolean coroutineDebuggerInstalled, App app) {
            this.skippedInstall = skippedInstall;
            this.needsRestart = needsRestart;
            this.coroutineDebuggerInstalled = coroutineDebuggerInstalled;
            this.app = app;
        }
    }

    public static enum InstallMode {
        DELTA,
        DELTA_NO_SKIP,
        FULL;

    }

    static enum Tasks {
        CACHE,
        DUMP,
        DIFF,
        PREINSTALL,
        VERIFY,
        COMPARE,
        SWAP,
        PARSE_PATHS,
        APK_CHECK,
        PARSE_APP_IDS,
        DEPLOY_CACHE_STORE,
        OPTIMISTIC_DUMP,
        VERIFY_DUMP,
        EXTRACT_APK_ENTRIES,
        COLLECT_SWAP_DATA,
        OPTIMISTIC_SWAP,
        OPTIMISTIC_INSTALL,
        ROOT_PUSH_INSTALL,
        GET_PIDS,
        GET_ARCH,
        COMPUTE_FRESHINSTALL_OID,
        INSTALL_COROUTINE_DEBUGGER;

    }
}

