/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.model.component.ComponentType;
import com.android.utils.StdLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DeployRunnerParameters {
    private final List<Command> commands = new ArrayList<Command>();
    private boolean forceFullInstall = false;
    private boolean optimisticInstall = false;
    private boolean skipPostInstallTasks = false;
    private boolean useRootPushInstall = false;
    private boolean jdwpClientSupport = true;
    private String installersPath = null;
    private String adbExecutablePath = null;
    private String targetUserId = null;
    private StdLogger.Level logLevel = StdLogger.Level.ERROR;
    private String applicationId;
    private final List<String> targetDevices = new ArrayList<String>();
    private final List<String> apkPaths = new ArrayList<String>();
    private Component componentToActivate = null;

    private DeployRunnerParameters() {
    }

    private void parseFlag(String arg) {
        if ("--force-full-install".equals(arg)) {
            this.forceFullInstall = true;
        } else if (arg.startsWith("--installers-path=")) {
            this.installersPath = arg.substring("--installers-path=".length());
        } else if (arg.startsWith("--optimistic-install")) {
            this.optimisticInstall = true;
        } else if (arg.startsWith("--device=")) {
            this.targetDevices.add(arg.substring("--device=".length()));
        } else if (arg.startsWith("--activate=")) {
            this.parseComponentToActivate(arg);
        } else if (arg.startsWith("--adb=")) {
            this.adbExecutablePath = arg.substring("--adb=".length());
        } else if (arg.startsWith("--user=")) {
            this.targetUserId = arg.substring("--user=".length());
        } else if (arg.startsWith("--skip-post-install")) {
            this.skipPostInstallTasks = true;
        } else if (arg.startsWith("--use-root-push-install")) {
            this.useRootPushInstall = true;
        } else if (arg.startsWith("--no-jdwp-client-support")) {
            this.jdwpClientSupport = false;
        } else if (arg.startsWith("--log-level=")) {
            try {
                this.logLevel = StdLogger.Level.valueOf((String)arg.substring("--log-level=".length()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            throw new RuntimeException("Unknown flag: '" + arg + "'");
        }
    }

    private void parseCommand(String arg) {
        try {
            this.commands.add(Command.valueOf(arg.toUpperCase()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown command: '" + arg + "'");
        }
    }

    private void parseComponentToActivate(String arg) {
        ComponentType type;
        String[] typeAndName = arg.substring("--activate=".length()).split(",");
        if (typeAndName.length != 2) {
            throw new RuntimeException("Incorrect parameters for --activate flag. Usage: --activate=type,name");
        }
        this.commands.add(Command.ACTIVATE);
        try {
            type = ComponentType.valueOf(typeAndName[0].trim().toUpperCase(Locale.US));
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown component type");
        }
        String name = typeAndName[1].trim();
        this.componentToActivate = new Component(type, name);
    }

    public static DeployRunnerParameters parse(String[] args) {
        DeployRunnerParameters drp = new DeployRunnerParameters();
        drp.parseCommand(args[0]);
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("--")) {
                drp.parseFlag(args[i]);
                continue;
            }
            if (drp.applicationId == null) {
                drp.applicationId = args[i];
                continue;
            }
            drp.apkPaths.add(args[i]);
        }
        if (drp.commands.contains((Object)Command.ACTIVATE) && drp.componentToActivate == null) {
            throw new RuntimeException("App component for activation is not specified");
        }
        return drp;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public List<String> getTargetDevices() {
        return this.targetDevices;
    }

    public List<String> getApks() {
        return this.apkPaths;
    }

    public boolean isForceFullInstall() {
        return this.forceFullInstall;
    }

    public String getInstallersPath() {
        return this.installersPath;
    }

    public boolean isOptimisticInstall() {
        return this.optimisticInstall;
    }

    public String getAdbExecutablePath() {
        return this.adbExecutablePath;
    }

    public boolean getSkipPostInstallTasks() {
        return this.skipPostInstallTasks;
    }

    public boolean getUseRootPushInstall() {
        return this.useRootPushInstall;
    }

    public boolean getJdwpClientSupport() {
        return this.jdwpClientSupport;
    }

    public StdLogger.Level getLogLevel() {
        return this.logLevel;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public Component getComponentToActivate() {
        return this.componentToActivate;
    }

    static class Component {
        final ComponentType type;
        final String name;

        private Component(ComponentType type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static enum Command {
        INSTALL,
        CODESWAP,
        FULLSWAP,
        ACTIVATE,
        UNKNOWN;

    }
}

