/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DexComparator;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.InstallerBasedClassRedefiner;
import com.android.tools.deployer.InstallerResponseHandler;
import com.android.tools.deployer.model.DexClass;
import com.android.tools.idea.protobuf.ByteString;
import com.android.utils.ILogger;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

public class ApkSwapper {
    private final Installer installer;
    private final boolean restart;
    private final Map<Integer, ClassRedefiner> debuggerRedefiners;
    private final AdbClient adb;
    private final ILogger logger;

    public ApkSwapper(Installer installer, Map<Integer, ClassRedefiner> debuggerRedefiners, boolean restart, AdbClient adb, ILogger logger) {
        this.installer = installer;
        this.debuggerRedefiners = debuggerRedefiners;
        this.restart = restart;
        this.adb = adb;
        this.logger = logger;
    }

    Void error(ApplicationDumper.Dump unused, String sessionId, DexComparator.ChangedClasses unused2) {
        if (sessionId == null) {
            return null;
        }
        if ("<SKIPPED-INSTALLATION>".equals(sessionId)) {
            return null;
        }
        String abortResult = this.adb.abortSession(sessionId);
        if (!abortResult.startsWith("Success")) {
            this.logger.warning("Unable to abandon session: '%s'", new Object[]{abortResult});
        }
        return null;
    }

    public boolean swap(ApplicationDumper.Dump dump2, String sessionId, DexComparator.ChangedClasses changedClasses) throws DeployerException {
        if (dump2.packagePids.isEmpty()) {
            throw DeployerException.unknownProcess();
        }
        if (dump2.packagePids.size() > 1) {
            throw DeployerException.swapMultiplePackages();
        }
        Deploy.SwapRequest swapRequest = this.buildSwapRequest(dump2, sessionId, changedClasses);
        boolean needAgents = this.isSwapRequestInstallOnly(swapRequest);
        Thread t = null;
        DeployerException[] exceptions = new DeployerException[1];
        if (needAgents) {
            t = new Thread(() -> {
                try {
                    ApkSwapper.sendSwapRequest(swapRequest, new InstallerBasedClassRedefiner(this.installer));
                }
                catch (DeployerException e) {
                    exceptions[0] = e;
                }
            });
            t.start();
        }
        for (Map.Entry<Integer, ClassRedefiner> entry : this.debuggerRedefiners.entrySet()) {
            ApkSwapper.sendSwapRequest(swapRequest, entry.getValue());
        }
        if (t != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw DeployerException.interrupted(e.getMessage());
            }
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        } else {
            ApkSwapper.sendSwapRequest(swapRequest, new InstallerBasedClassRedefiner(this.installer));
        }
        return true;
    }

    private Deploy.SwapRequest buildSwapRequest(ApplicationDumper.Dump dump2, String sessionId, DexComparator.ChangedClasses changedClasses) throws DeployerException {
        Map.Entry onlyPackage = (Map.Entry)Iterables.getOnlyElement(dump2.packagePids.entrySet());
        return this.buildSwapRequest((String)onlyPackage.getKey(), (List)onlyPackage.getValue(), dump2.arch, sessionId, changedClasses);
    }

    private Deploy.SwapRequest buildSwapRequest(String packageId, List<Integer> pids, Deploy.Arch arch, String sessionId, DexComparator.ChangedClasses changedClasses) throws DeployerException {
        Deploy.SwapRequest.Builder request = Deploy.SwapRequest.newBuilder().setPackageName(packageId).setRestartActivity(this.restart).setSessionId(sessionId);
        for (DexClass clazz : changedClasses.newClasses) {
            request.addNewClasses(Deploy.ClassDef.newBuilder().setName(clazz.name).setDex(ByteString.copyFrom((byte[])clazz.code)));
        }
        for (DexClass clazz : changedClasses.modifiedClasses) {
            request.addModifiedClasses(Deploy.ClassDef.newBuilder().setName(clazz.name).setDex(ByteString.copyFrom((byte[])clazz.code)));
        }
        int extraAgents = 0;
        block8: for (Integer pid : pids) {
            if (this.debuggerRedefiners.containsKey(pid)) {
                ClassRedefiner redefiner = this.debuggerRedefiners.get(pid);
                switch (redefiner.canRedefineClass().support) {
                    case FULL: {
                        continue block8;
                    }
                    case NEEDS_AGENT_SERVER: {
                        ++extraAgents;
                        continue block8;
                    }
                    case MAIN_THREAD_RUNNING: {
                        request.addProcessIds(pid.intValue());
                        continue block8;
                    }
                    case NONE: {
                        throw DeployerException.operationNotSupported("The redefiner is not able to swap the current state of the debug application. All available threads are suspended but not on a breakpoint.");
                    }
                }
                continue;
            }
            request.addProcessIds(pid.intValue());
        }
        request.setExtraAgents(extraAgents);
        request.setArch(arch);
        return request.build();
    }

    private boolean isSwapRequestInstallOnly(Deploy.SwapRequest request) {
        return request.getProcessIdsCount() > 0 || request.getExtraAgents() > 0;
    }

    private static void sendSwapRequest(Deploy.SwapRequest request, ClassRedefiner redefiner) throws DeployerException {
        Deploy.SwapResponse swapResponse = redefiner.redefine(request);
        new InstallerResponseHandler(InstallerResponseHandler.RedefinitionCapability.MOFIFY_CODE_ONLY).handle(swapResponse);
    }
}

