/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.SdkConstants;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.Apk;
import com.android.tools.manifest.parser.ManifestInfo;
import com.android.tools.tracer.Trace;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ApkParser {
    public static final int EOCD_SIGNATURE = 101010256;
    private static final byte[] SIGNATURE_BLOCK_MAGIC = "APK Sig Block 42".getBytes();
    private static final long USHRT_MAX = 65535L;
    public static final int EOCD_SIZE = 22;
    static final String NO_MANIFEST_MSG = "Missing AndroidManifest.xml entry";
    private static final String NO_MANIFEST_MSG_DETAILS = "in '%s'";

    public List<Apk> parsePaths(List<String> paths2) throws DeployerException {
        Trace ignored = Trace.begin("parseApks");
        try {
            ArrayList<Apk> newFiles = new ArrayList<Apk>();
            for (String apkPath : paths2) {
                newFiles.add(this.parse(apkPath));
            }
            ArrayList<Apk> arrayList = newFiles;
            if (ignored != null) {
                ignored.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw DeployerException.parseFailed(e.getMessage());
            }
        }
    }

    public ManifestInfo getApkDetails(String path2) throws IOException {
        ManifestInfo manifestInfo;
        try (ZipFile zipFile = new ZipFile(path2);){
            ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
            if (manifestEntry == null) {
                StringBuilder msg = new StringBuilder(NO_MANIFEST_MSG);
                msg.append(" ");
                msg.append(String.format(Locale.US, NO_MANIFEST_MSG_DETAILS, path2));
                throw new IOException(msg.toString());
            }
            InputStream stream = zipFile.getInputStream(manifestEntry);
            manifestInfo = ManifestInfo.parseBinaryFromStream(stream);
        }
        if (manifestInfo.getApplicationId() == null) {
            throw new IllegalArgumentException("Package name was not found in manifest");
        }
        return manifestInfo;
    }

    private File getApkFileFromPath(String apkPath) throws IOException {
        int separatorIndex;
        if (apkPath.startsWith("jar:") && (separatorIndex = apkPath.lastIndexOf(33)) != -1) {
            String subPath = apkPath.substring(separatorIndex + 1);
            try (FileSystem fileSystem = FileSystems.newFileSystem(URI.create(apkPath), Collections.emptyMap());){
                Path outputApk = Files.createTempFile("extracted", ".apk", new FileAttribute[0]);
                FileUtils.copyFile((Path)fileSystem.getPath(subPath, new String[0]), (Path)outputApk);
                File file = outputApk.toFile();
                return file;
            }
        }
        return new File(apkPath);
    }

    Apk parse(String apkPath) throws IOException, DeployerException {
        List<ZipUtils.ZipEntry> zipEntries;
        String digest;
        File file = this.getApkFileFromPath(apkPath);
        String absolutePath = file.getAbsolutePath();
        try (RandomAccessFile raf = new RandomAccessFile(absolutePath, "r");
             FileChannel fileChannel = raf.getChannel();){
            ApkArchiveMap map2 = new ApkArchiveMap();
            ApkParser.findCDLocation(fileChannel, map2);
            ApkParser.findSignatureLocation(fileChannel, map2);
            digest = this.generateDigest(raf, map2);
            zipEntries = this.readZipEntries(raf, map2);
        }
        ManifestInfo manifest = this.getApkDetails(absolutePath);
        String apkFileName = manifest.getSplitName() == null ? "base.apk" : "split_" + manifest.getSplitName() + ".apk";
        Apk.Builder builder = Apk.builder().setName(apkFileName).setChecksum(digest).setPath(absolutePath).setPackageName(manifest.getApplicationId()).setTargetPackages(manifest.getInstrumentationTargetPackages()).setActivities(manifest.activities()).setServices(manifest.services()).setSdkLibraries(manifest.getSdkLibraries());
        for (ZipUtils.ZipEntry entry : zipEntries) {
            String[] paths2;
            if (entry.name.startsWith("lib/") && (paths2 = entry.name.split("/")).length > 1) {
                builder.addLibraryAbi(paths2[1]);
            }
            builder.addApkEntry(entry);
        }
        return builder.build();
    }

    public static void findSignatureLocation(FileChannel channel, ApkArchiveMap map2) {
        try {
            ByteBuffer signatureBlockMagicNumber = ByteBuffer.allocate(SIGNATURE_BLOCK_MAGIC.length);
            channel.read(signatureBlockMagicNumber, map2.cdOffset - (long)SIGNATURE_BLOCK_MAGIC.length);
            signatureBlockMagicNumber.rewind();
            if (!signatureBlockMagicNumber.equals(ByteBuffer.wrap(SIGNATURE_BLOCK_MAGIC))) {
                return;
            }
            ByteBuffer sizeBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(sizeBuffer, map2.cdOffset - (long)SIGNATURE_BLOCK_MAGIC.length - 8L);
            sizeBuffer.rewind();
            long lowerSignatureBlockSize = sizeBuffer.getLong();
            sizeBuffer.rewind();
            channel.read(sizeBuffer, map2.cdOffset - 8L - lowerSignatureBlockSize);
            sizeBuffer.rewind();
            long upperSignatureBlocSize = sizeBuffer.getLong();
            if (lowerSignatureBlockSize != upperSignatureBlocSize) {
                return;
            }
            map2.signatureBlockOffset = map2.cdOffset - 8L - lowerSignatureBlockSize;
            map2.signatureBlockSize = lowerSignatureBlockSize;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void findCDLocation(FileChannel channel, ApkArchiveMap map2) throws IOException, DeployerException {
        long fileSize = channel.size();
        if (fileSize < 22L) {
            throw DeployerException.parseFailed("File is too small to be a valid zip file");
        }
        ByteBuffer eocdBuffer = ByteBuffer.allocate(22).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(eocdBuffer, fileSize - 22L);
        eocdBuffer.rewind();
        if (ApkParser.readEOCD(map2, eocdBuffer)) {
            return;
        }
        ByteBuffer endofFileBuffer = ByteBuffer.allocate((int)Math.min(fileSize, 65557L)).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(endofFileBuffer, fileSize - (long)endofFileBuffer.capacity());
        endofFileBuffer.position(endofFileBuffer.capacity() - 22);
        while (!ApkParser.readEOCD(map2, endofFileBuffer)) {
            if (endofFileBuffer.position() - 5 < 0) {
                throw DeployerException.parseFailed("Unable to find apk's ECOD signature");
            }
            endofFileBuffer.position(endofFileBuffer.position() - 5);
        }
        return;
    }

    private static boolean readEOCD(ApkArchiveMap map2, ByteBuffer buffer2) {
        if (buffer2.getInt() != 101010256) {
            return false;
        }
        buffer2.position(buffer2.position() + 8);
        map2.cdSize = ZipUtils.uintToLong(buffer2.getInt());
        map2.cdOffset = ZipUtils.uintToLong(buffer2.getInt());
        return true;
    }

    private List<ZipUtils.ZipEntry> readZipEntries(RandomAccessFile randomAccessFile, ApkArchiveMap map2) throws IOException {
        ByteBuffer buffer2;
        if (SdkConstants.currentPlatform() == 2) {
            byte[] cdContent = new byte[(int)map2.cdSize];
            randomAccessFile.seek(map2.cdOffset);
            randomAccessFile.readFully(cdContent);
            buffer2 = ByteBuffer.wrap(cdContent);
        } else {
            buffer2 = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, map2.cdOffset, map2.cdSize);
        }
        return ZipUtils.readZipEntries(buffer2);
    }

    private String generateDigest(RandomAccessFile randomAccessFile, ApkArchiveMap map2) throws IOException {
        byte[] sigContent;
        if (map2.signatureBlockOffset != -1L) {
            sigContent = new byte[(int)map2.signatureBlockSize];
            randomAccessFile.seek(map2.signatureBlockOffset);
            randomAccessFile.readFully(sigContent);
        } else {
            sigContent = new byte[(int)map2.cdSize];
            randomAccessFile.seek(map2.cdOffset);
            randomAccessFile.readFully(sigContent);
        }
        ByteBuffer buffer2 = ByteBuffer.wrap(sigContent);
        return ZipUtils.digest(buffer2);
    }

    public static class ApkArchiveMap {
        public static final long UNINITIALIZED = -1L;
        long cdOffset = -1L;
        long cdSize = -1L;
        long signatureBlockOffset = -1L;
        long signatureBlockSize = -1L;
    }
}

