/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.AdbInstallerChannel;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;

public class AdbInstallerChannelManager {
    private static final HashMap<String, AdbInstallerChannel> channels = new HashMap();
    private final ILogger logger;
    private final AdbInstaller.Mode mode;

    AdbInstallerChannelManager(ILogger logger, AdbInstaller.Mode mode) {
        this.logger = logger;
        this.mode = mode;
    }

    public synchronized AdbInstallerChannel getChannel(AdbClient client, String version2) throws IOException {
        AdbInstallerChannel channel;
        String deviceId = client.getSerial();
        if (channels.containsKey(deviceId) && (channel = channels.get(deviceId)).isClosed()) {
            channels.remove(deviceId);
        }
        if (!channels.containsKey(deviceId)) {
            this.logger.info("Created SocketChannel to '" + deviceId + "'", new Object[0]);
            channel = this.createChannel(client, version2);
            channels.put(deviceId, channel);
        }
        return channels.get(deviceId);
    }

    private synchronized AdbInstallerChannel createChannel(AdbClient client, String version2) throws IOException {
        AbstractInterruptibleChannel channel = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add("-version=" + version2);
        if (this.mode == AdbInstaller.Mode.DAEMON) {
            parameters.add("-daemon");
        }
        try {
            channel = client.rawExec(AdbInstaller.INSTALLER_PATH, parameters.toArray(new String[0]));
        }
        catch (AdbCommandRejectedException | TimeoutException e) {
            AbstractInterruptibleChannel c = channel;
            if (c != null) {
                c.close();
            }
            throw new IOException(e);
        }
        return new AdbInstallerChannel((SocketChannel)channel, this.logger);
    }

    public synchronized void reset(AdbClient client) throws IOException {
        String serial = client.getSerial();
        this.logger.info("Reset SocketChannel to '" + serial + "'", new Object[0]);
        try (AdbInstallerChannel c = channels.get(serial);){
            channels.remove(serial);
        }
    }
}

