/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.internal.AbstractArchive;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;

public class AppBundleArchive
extends AbstractArchive {
    public static String BUNDLE_BASELINE_PROFILE_PATH = String.format("/BUNDLE-METADATA/%s/%s", "com.android.tools.build.profiles", "baseline.prof");
    public static String BUNDLE_BASELINE_PROFILE_METADATA_PATH = String.format("/BUNDLE-METADATA/%s/%s", "com.android.tools.build.profiles", "baseline.profm");
    private final FileSystem zipFileSystem;

    private AppBundleArchive(Path path2) throws IOException {
        super(path2);
        this.zipFileSystem = FileUtils.createZipFilesystem((Path)path2);
    }

    public static AppBundleArchive fromBundleFile(Path artifact) throws IOException {
        return new AppBundleArchive(artifact);
    }

    @Override
    public Path getContentRoot() {
        return this.zipFileSystem.getPath("/", new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.zipFileSystem.close();
    }

    @Override
    public boolean isProtoXml(Path p, byte[] content) {
        boolean xmlResource;
        if (!p.toString().endsWith(".xml")) {
            return false;
        }
        Path name = p.getFileName();
        if (name == null) {
            return false;
        }
        boolean manifest = AppBundleArchive.isManifestFile(p);
        boolean insideResFolder = AppBundleArchive.isInsideResFolder(p);
        boolean insideResRaw = AppBundleArchive.isInsiderResRawFolder(p);
        boolean bl = xmlResource = insideResFolder && !insideResRaw;
        if (!manifest && !xmlResource) {
            return false;
        }
        return XmlUtils.isProtoXml((byte[])content);
    }

    @Override
    public boolean isBaselineProfile(Path p, byte[] content) {
        String path2 = p.toString();
        return path2.equals(BUNDLE_BASELINE_PROFILE_PATH) || path2.equals(BUNDLE_BASELINE_PROFILE_METADATA_PATH);
    }

    private static boolean isManifestFile(Path p) {
        return AppBundleArchive.matchPathPrefix(p, PathEntry.any(), PathEntry.FD_MANIFEST, PathEntry.FN_ANDROID_MANIFEST_XML);
    }

    private static boolean isInsideResFolder(Path p) {
        return AppBundleArchive.matchPathPrefix(p, PathEntry.any(), PathEntry.name("res"));
    }

    private static boolean isInsiderResRawFolder(Path p) {
        return AppBundleArchive.matchPathPrefix(p, PathEntry.any(), PathEntry.FD_RES, PathEntry.FD_RES_RAW);
    }

    private static boolean matchPathPrefix(Path path2, PathEntry ... prefixEntries) {
        int index2 = 0;
        for (PathEntry entry : prefixEntries) {
            if (!entry.matches(path2.getName(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    public static class NamePathEntry
    extends PathEntry {
        private final String name;

        public NamePathEntry(String name) {
            this.name = name;
        }

        @Override
        public boolean matches(Path name) {
            return name.toString().equals(this.name);
        }
    }

    public static class AnyPathEntry
    extends PathEntry {
        public static AnyPathEntry instance = new AnyPathEntry();

        @Override
        public boolean matches(Path name) {
            return true;
        }
    }

    public static abstract class PathEntry {
        public static final PathEntry FD_RES = PathEntry.name("res");
        public static final PathEntry FD_RES_RAW = PathEntry.name("raw");
        public static final PathEntry FN_ANDROID_MANIFEST_XML = PathEntry.name("AndroidManifest.xml");
        public static final PathEntry FD_MANIFEST = PathEntry.name("manifest");

        public abstract boolean matches(Path var1);

        public static PathEntry any() {
            return AnyPathEntry.instance;
        }

        public static PathEntry name(String name) {
            return new NamePathEntry(name);
        }
    }
}

