/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex.tree;

import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableReference;

public class DexMethodNode
extends DexElementNode {
    private long size;

    public DexMethodNode(String displayName, ImmutableMethodReference reference) {
        super(displayName, false, (ImmutableReference)reference);
    }

    public MethodReference getReference() {
        return (MethodReference)super.getReference();
    }

    @Override
    public boolean isSeed(ProguardSeedsMap seedsMap, ProguardMap map2, boolean checkChildren) {
        MethodReference reference;
        if (seedsMap != null && (reference = this.getReference()) != null) {
            String className = PackageTreeCreator.decodeClassName(reference.getDefiningClass(), map2);
            String methodName = PackageTreeCreator.decodeMethodName(reference, map2);
            String params = PackageTreeCreator.decodeMethodParams(reference, map2);
            if ("<init>".equals(methodName)) {
                methodName = SigUtils.getSimpleName(className);
            }
            return seedsMap.hasMethod(className, methodName + params);
        }
        return false;
    }

    @Override
    public int getMethodDefinitionsCount() {
        return this.isDefined() ? 1 : 0;
    }

    @Override
    public int getMethodReferencesCount() {
        return this.isRemoved() ? 0 : 1;
    }

    @Override
    public void update() {
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

