/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.Arity;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.intellij.util.ArrayUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicPluralsResourceItem
extends BasicValueResourceItemBase
implements PluralsResourceValue {
    @NotNull
    private final Arity[] myArities;
    @NotNull
    private final String[] myValues;
    private final int myDefaultIndex;

    public BasicPluralsResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull Map<Arity, String> quantityValues, @Nullable Arity defaultArity) {
        this(name, sourceFile, visibility, quantityValues.keySet().toArray(Arity.EMPTY_ARRAY), quantityValues.values().toArray(ArrayUtil.EMPTY_STRING_ARRAY), BasicPluralsResourceItem.getIndex(defaultArity, quantityValues.keySet()));
    }

    private BasicPluralsResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull Arity[] arities, @NotNull String[] values, int defaultIndex) {
        super(ResourceType.PLURALS, name, sourceFile, visibility);
        assert (arities.length == values.length);
        this.myArities = arities;
        this.myValues = values;
        assert (values.length == 0 || defaultIndex < values.length);
        this.myDefaultIndex = defaultIndex;
    }

    private static int getIndex(@Nullable Arity arity, @NotNull Collection<Arity> arities) {
        if (arity == null || arities.isEmpty()) {
            return 0;
        }
        int index2 = 0;
        for (Arity ar : arities) {
            if (ar == arity) {
                return index2;
            }
            ++index2;
        }
        throw new IllegalArgumentException();
    }

    public int getPluralsCount() {
        return this.myArities.length;
    }

    @NotNull
    public String getQuantity(int index2) {
        return this.myArities[index2].getName();
    }

    @NotNull
    public String getValue(int index2) {
        return this.myValues[index2];
    }

    @Nullable
    public String getValue(@NotNull String quantity) {
        int n = this.myArities.length;
        for (int i = 0; i < n; ++i) {
            if (!quantity.equals(this.myArities[i].getName())) continue;
            return this.myValues[i];
        }
        return null;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myValues.length == 0 ? null : this.myValues[this.myDefaultIndex];
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicPluralsResourceItem other = (BasicPluralsResourceItem)obj;
        return Arrays.equals(this.myArities, other.myArities) && Arrays.equals(this.myValues, other.myValues);
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int n = this.myArities.length;
        stream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            stream.writeInt(this.myArities[i].ordinal());
            stream.writeString(this.myValues[i]);
        }
        stream.writeInt(this.myDefaultIndex);
    }

    @NotNull
    static BasicPluralsResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        int n = stream.readInt();
        Arity[] arities = n == 0 ? Arity.EMPTY_ARRAY : new Arity[n];
        String[] values = n == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : new String[n];
        for (int i = 0; i < n; ++i) {
            arities[i] = Arity.values()[stream.readInt()];
            values[i] = stream.readString();
        }
        int defaultIndex = stream.readInt();
        if (values.length != 0 && defaultIndex >= values.length) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        BasicPluralsResourceItem item = new BasicPluralsResourceItem(name, sourceFile, visibility, arities, values, defaultIndex);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

