/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.io.CancellableFileIo;
import com.android.resources.ResourceType;
import com.android.resources.aar.AarSourceResourceRepository;
import com.android.resources.aar.CachingData;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.NamespaceResolver;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSerializationUtil;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FrameworkResourceRepository
extends AarSourceResourceRepository {
    private static final ResourceNamespace ANDROID_NAMESPACE = ResourceNamespace.ANDROID;
    private static final Map<String, String> LANGUAGE_TO_GROUP = ImmutableMap.of((Object)"rm", (Object)"it");
    private static final String RESOURCES_TABLE_PREFIX = "resources_";
    private static final String RESOURCE_TABLE_SUFFIX = ".bin";
    private static final String COMPILED_9PNG_EXTENSION = ".compiled.9.png";
    private static final Logger LOG = Logger.getInstance(FrameworkResourceRepository.class);
    private final Set<String> myLanguageGroups = new TreeSet<String>();
    private int myNumberOfLanguageGroupsLoadedFromCache;
    private final boolean myUseCompiled9Patches;

    private FrameworkResourceRepository(@NotNull RepositoryLoader<FrameworkResourceRepository> loader, boolean useCompiled9Patches) {
        super(loader, null);
        this.myUseCompiled9Patches = useCompiled9Patches;
    }

    @NotNull
    public static FrameworkResourceRepository create(@NotNull Path resourceDirectoryOrFile, @Nullable Set<String> languagesToLoad, @Nullable CachingData cachingData, boolean useCompiled9Patches) {
        long start2 = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Set<String> languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        Loader loader = new Loader(resourceDirectoryOrFile, languageGroups);
        FrameworkResourceRepository repository2 = new FrameworkResourceRepository(loader, useCompiled9Patches);
        repository2.load(null, cachingData, loader, languageGroups, loader.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = repository2.getNumberOfLanguageGroupsLoadedFromOrigin() == 0 ? "cache" : (repository2.myNumberOfLanguageGroupsLoadedFromCache == 0 ? resourceDirectoryOrFile.toString() : "cache and " + resourceDirectoryOrFile);
            LOG.debug("Loaded from " + source + " with " + (repository2.myLanguageGroups.size() - 1) + " languages in " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
        }
        return repository2;
    }

    public boolean containsLanguages(@NotNull Set<String> languages) {
        for (String language : languages) {
            if (this.myLanguageGroups.contains(FrameworkResourceRepository.getLanguageGroup(language))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public FrameworkResourceRepository loadMissingLanguages(@Nullable Set<String> languagesToLoad, @Nullable CachingData cachingData) {
        Set<String> languageGroups;
        Set<String> set = languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        if (languageGroups != null && this.myLanguageGroups.containsAll(languageGroups)) {
            return this;
        }
        long start2 = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Loader loader = new Loader(this, languageGroups);
        FrameworkResourceRepository newRepository = new FrameworkResourceRepository(loader, this.myUseCompiled9Patches);
        newRepository.load(this, cachingData, loader, languageGroups, loader.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = newRepository.getNumberOfLanguageGroupsLoadedFromOrigin() == this.getNumberOfLanguageGroupsLoadedFromOrigin() ? "cache" : (newRepository.myNumberOfLanguageGroupsLoadedFromCache == this.myNumberOfLanguageGroupsLoadedFromCache ? this.myResourceDirectoryOrFile.toString() : "cache and " + this.myResourceDirectoryOrFile);
            LOG.debug("Loaded " + (newRepository.myLanguageGroups.size() - this.myLanguageGroups.size()) + " additional languages from " + source + " in " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
        }
        return newRepository;
    }

    private void load(@Nullable FrameworkResourceRepository sourceRepository, @Nullable CachingData cachingData, @NotNull Loader loader, @Nullable Set<String> languageGroups, @NotNull Set<String> languageGroupsLoadedFromSourceRepositoryOrCache) {
        Executor executor;
        ImmutableSet configurationsToTakeOver;
        HashMap stringCache = Maps.newHashMapWithExpectedSize((int)10000);
        HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
        Object object = configurationsToTakeOver = sourceRepository == null ? ImmutableSet.of() : this.copyFromRepository(sourceRepository, stringCache, namespaceResolverCache);
        if (!loader.isLoadingFromZipArchive() && cachingData != null) {
            this.loadFromPersistentCache(cachingData, languageGroups, languageGroupsLoadedFromSourceRepositoryOrCache, stringCache, namespaceResolverCache);
        }
        this.myLanguageGroups.addAll(languageGroupsLoadedFromSourceRepositoryOrCache);
        if (languageGroups == null || !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(languageGroups)) {
            loader.loadRepositoryContents(this);
        }
        this.myLoadedFromCache = this.myNumberOfLanguageGroupsLoadedFromCache == this.myLanguageGroups.size();
        this.populatePublicResourcesMap();
        this.freezeResources();
        this.takeOverConfigurations((Set<RepositoryConfiguration>)configurationsToTakeOver);
        if (!loader.isLoadingFromZipArchive() && cachingData != null && (executor = cachingData.getCacheCreationExecutor()) != null && !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(this.myLanguageGroups)) {
            executor.execute(() -> this.createPersistentCache(cachingData, languageGroupsLoadedFromSourceRepositoryOrCache));
        }
    }

    @Override
    @Nullable
    public String getPackageName() {
        return ANDROID_NAMESPACE.getPackageName();
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull ResourceNamespace namespace) {
        return namespace == ANDROID_NAMESPACE ? Sets.immutableEnumSet(this.myResources.keySet()) : ImmutableSet.of();
    }

    @NotNull
    private Set<RepositoryConfiguration> copyFromRepository(@NotNull FrameworkResourceRepository sourceRepository, @NotNull Map<String, String> stringCache, @NotNull Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        Collection resourceMaps = sourceRepository.myResources.values();
        Set sourceConfigurations = Sets.newIdentityHashSet();
        for (ListMultimap resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                this.addResourceItem(item);
                sourceConfigurations.add(((BasicResourceItemBase)item).getRepositoryConfiguration());
                if (item instanceof BasicValueResourceItemBase) {
                    ResourceNamespace.Resolver resolver = ((BasicValueResourceItemBase)item).getNamespaceResolver();
                    NamespaceResolver namespaceResolver = resolver == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver;
                    namespaceResolverCache.put(namespaceResolver, namespaceResolver);
                }
                String name = item.getName();
                stringCache.put(name, name);
            }
        }
        this.myNumberOfLanguageGroupsLoadedFromCache += sourceRepository.myNumberOfLanguageGroupsLoadedFromCache;
        return sourceConfigurations;
    }

    private void loadFromPersistentCache(@NotNull CachingData cachingData, @Nullable Set<String> languagesToLoad, @NotNull Set<String> loadedLanguages, @NotNull Map<String, String> stringCache, @Nullable Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        Set<String> languages = languagesToLoad == null ? fileNameGenerator.getAllCacheFileLanguages() : languagesToLoad;
        for (String language : languages) {
            if (loadedLanguages.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            try (Base128InputStream stream = new Base128InputStream(cacheFile);){
                byte[] header = ResourceSerializationUtil.getCacheFileHeader(s -> this.writeCacheHeaderContent(cachingData, language, s));
                if (!stream.validateContents(header)) {
                    if (!language.isEmpty()) continue;
                    break;
                }
                this.loadFromStream(stream, stringCache, namespaceResolverCache);
                loadedLanguages.add(language);
                ++this.myNumberOfLanguageGroupsLoadedFromCache;
            }
            catch (NoSuchFileException e) {
                if (!language.isEmpty()) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                this.cleanupAfterFailedLoadingFromCache();
                loadedLanguages.clear();
                throw e;
            }
            catch (Throwable e) {
                this.cleanupAfterFailedLoadingFromCache();
                loadedLanguages.clear();
                LOG.warn("Failed to load from cache file " + cacheFile.toString(), e);
                break;
            }
        }
    }

    @Override
    protected void cleanupAfterFailedLoadingFromCache() {
        super.cleanupAfterFailedLoadingFromCache();
        this.myNumberOfLanguageGroupsLoadedFromCache = 0;
    }

    private void createPersistentCache(@NotNull CachingData cachingData, @NotNull Set<String> languagesToSkip) {
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        for (String language : this.myLanguageGroups) {
            if (languagesToSkip.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, language, stream));
            ResourceSerializationUtil.createPersistentCache(cacheFile, header, stream -> this.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config))));
        }
    }

    private void writeCacheHeaderContent(@NotNull CachingData cachingData, @NotNull String language, @NotNull Base128OutputStream stream) throws IOException {
        this.writeCacheHeaderContent(cachingData, stream);
        stream.writeString(language);
    }

    static String getResourceTableNameForLanguage(@NotNull String language) {
        return language.isEmpty() ? "resources.bin" : RESOURCES_TABLE_PREFIX + language + RESOURCE_TABLE_SUFFIX;
    }

    @NotNull
    static String getLanguageGroup(@NotNull FolderConfiguration config) {
        LocaleQualifier locale = config.getLocaleQualifier();
        return locale == null ? "" : FrameworkResourceRepository.getLanguageGroup(StringUtil.notNullize((String)locale.getLanguage()));
    }

    @NotNull
    private static String getLanguageGroup(@NotNull String language) {
        return LANGUAGE_TO_GROUP.getOrDefault(language, language);
    }

    @NotNull
    private static Set<String> getLanguageGroups(@NotNull Set<String> languages) {
        TreeSet<String> result = new TreeSet<String>();
        result.add("");
        for (String language : languages) {
            result.add(FrameworkResourceRepository.getLanguageGroup(language));
        }
        return result;
    }

    @NotNull
    Set<String> getLanguageGroups() {
        TreeSet<String> languages = new TreeSet<String>();
        for (ListMultimap resourceMap : this.myResources.values()) {
            for (ResourceItem item : resourceMap.values()) {
                FolderConfiguration config = item.getConfiguration();
                languages.add(FrameworkResourceRepository.getLanguageGroup(config));
            }
        }
        return languages;
    }

    private int getNumberOfLanguageGroupsLoadedFromOrigin() {
        return this.myLanguageGroups.size() - this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    @TestOnly
    int getNumberOfLanguageGroupsLoadedFromCache() {
        return this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    @NotNull
    private String updateResourcePath(@NotNull String relativeResourcePath) {
        if (this.myUseCompiled9Patches && relativeResourcePath.endsWith(".9.png")) {
            return StringUtil.replaceSubstring((String)relativeResourcePath, (TextRange)TextRange.create((int)(relativeResourcePath.length() - ".9.png".length()), (int)relativeResourcePath.length()), (String)COMPILED_9PNG_EXTENSION);
        }
        return relativeResourcePath;
    }

    @Override
    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        return super.getResourceUrl(this.updateResourcePath(relativeResourcePath));
    }

    @Override
    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return super.getSourceFile(this.updateResourcePath(relativeResourcePath), forFileResource);
    }

    private void takeOverConfigurations(@NotNull Set<RepositoryConfiguration> sourceConfigurations) {
        for (RepositoryConfiguration configuration : sourceConfigurations) {
            configuration.transferOwnershipTo(this);
        }
    }

    private static class CacheFileNameGenerator {
        private final Path myLanguageNeutralFile;
        private final String myPrefix;
        private final String mySuffix;

        CacheFileNameGenerator(@NotNull CachingData cachingData) {
            this.myLanguageNeutralFile = cachingData.getCacheFile();
            String fileName = this.myLanguageNeutralFile.getFileName().toString();
            int dotPos = fileName.lastIndexOf(46);
            this.myPrefix = dotPos >= 0 ? fileName.substring(0, dotPos) : fileName;
            this.mySuffix = dotPos >= 0 ? fileName.substring(dotPos) : "";
        }

        @NotNull
        Path getCacheFile(@NotNull String language) {
            return language.isEmpty() ? this.myLanguageNeutralFile : this.myLanguageNeutralFile.resolveSibling(this.myPrefix + '_' + language + this.mySuffix);
        }

        @Nullable
        String getLanguage(@NotNull String cacheFileName) {
            if (!cacheFileName.startsWith(this.myPrefix) || !cacheFileName.endsWith(this.mySuffix)) {
                return null;
            }
            int baseLength = this.myPrefix.length() + this.mySuffix.length();
            if (cacheFileName.length() == baseLength) {
                return "";
            }
            if (cacheFileName.length() != baseLength + 3 || cacheFileName.charAt(this.myPrefix.length()) != '_') {
                return null;
            }
            String language = cacheFileName.substring(this.myPrefix.length() + 1, this.myPrefix.length() + 3);
            if (!CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(0)) || !CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(1))) {
                return null;
            }
            return language;
        }

        @NotNull
        public Set<String> getAllCacheFileLanguages() {
            TreeSet<String> result = new TreeSet<String>();
            try (Stream stream = CancellableFileIo.list((Path)this.myLanguageNeutralFile.getParent());){
                stream.forEach(file -> {
                    String language = this.getLanguage(file.getFileName().toString());
                    if (language != null) {
                        result.add(language);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }

        private static boolean isLowerCaseLatinLetter(char c) {
            return 'a' <= c && c <= 'z';
        }
    }

    private static class Loader
    extends RepositoryLoader<FrameworkResourceRepository> {
        @NotNull
        private final List<String> myPublicFileNames = ImmutableList.of((Object)"public.xml", (Object)"public-final.xml", (Object)"public-staging.xml");
        @NotNull
        private final Set<String> myLoadedLanguageGroups;
        @Nullable
        private Set<String> myLanguageGroups;

        Loader(@NotNull Path resourceDirectoryOrFile, @Nullable Set<String> languageGroups) {
            super(resourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>();
        }

        Loader(@NotNull FrameworkResourceRepository sourceRepository, @Nullable Set<String> languageGroups) {
            super(sourceRepository.myResourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>(sourceRepository.myLanguageGroups);
        }

        @Override
        public List<String> getPublicXmlFileNames() {
            return this.myPublicFileNames;
        }

        @Override
        protected void loadFromZip(@NotNull FrameworkResourceRepository repository2) {
            try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
                if (this.myLanguageGroups == null) {
                    this.myLanguageGroups = Loader.readLanguageGroups(zipFile);
                }
                HashMap stringCache = Maps.newHashMapWithExpectedSize((int)10000);
                HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
                for (String language : this.myLanguageGroups) {
                    if (this.myLoadedLanguageGroups.contains(language)) continue;
                    String entryName = FrameworkResourceRepository.getResourceTableNameForLanguage(language);
                    ZipEntry zipEntry = zipFile.getEntry(entryName);
                    if (zipEntry == null) {
                        if (!language.isEmpty()) continue;
                        throw new IOException("\"" + entryName + "\" not found in " + this.myResourceDirectoryOrFile.toString());
                    }
                    try (Base128InputStream stream = new Base128InputStream(zipFile.getInputStream(zipEntry));){
                        repository2.loadFromStream(stream, stringCache, namespaceResolverCache);
                    }
                }
                repository2.populatePublicResourcesMap();
                repository2.freezeResources();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
        }

        @NotNull
        private static Set<String> readLanguageGroups(@NotNull ZipFile zipFile) {
            ImmutableSortedSet.Builder result = ImmutableSortedSet.naturalOrder();
            result.add((Object)"");
            zipFile.stream().forEach(entry -> {
                String name = entry.getName();
                if (name.startsWith(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX) && name.endsWith(FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX) && name.length() == FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX.length() + 2 && Character.isLetter(name.charAt(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length())) && Character.isLetter(name.charAt(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + 1))) {
                    result.add((Object)name.substring(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length(), FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + 2));
                }
            });
            return result.build();
        }

        @Override
        public void loadRepositoryContents(@NotNull FrameworkResourceRepository repository2) {
            super.loadRepositoryContents(repository2);
            Set<String> languageGroups = this.myLanguageGroups == null ? repository2.getLanguageGroups() : this.myLanguageGroups;
            repository2.myLanguageGroups.addAll(languageGroups);
        }

        @Override
        public boolean isIgnored(@NotNull Path fileOrDirectory, @NotNull BasicFileAttributes attrs) {
            if (fileOrDirectory.equals(this.myResourceDirectoryOrFile)) {
                return false;
            }
            if (super.isIgnored(fileOrDirectory, attrs)) {
                return true;
            }
            String fileName = fileOrDirectory.getFileName().toString();
            if (attrs.isDirectory()) {
                if (fileName.startsWith("values-mcc") || fileName.startsWith("raw") && (fileName.length() == "raw".length() || fileName.charAt("raw".length()) == '-')) {
                    return true;
                }
                if (this.myLanguageGroups != null || !this.myLoadedLanguageGroups.isEmpty()) {
                    FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)fileName);
                    if (config == null) {
                        return true;
                    }
                    String language = FrameworkResourceRepository.getLanguageGroup(config);
                    if (this.myLanguageGroups != null && !this.myLanguageGroups.contains(language) || this.myLoadedLanguageGroups.contains(language)) {
                        return true;
                    }
                    this.myFolderConfigCache.put(config.getQualifierString(), config);
                }
            } else {
                if ((this.myPublicFileNames.contains(fileName) || fileName.equals("symbols.xml")) && "values".equals(new PathString(fileOrDirectory).getParentFileName())) {
                    return true;
                }
                if (fileName.endsWith(FrameworkResourceRepository.COMPILED_9PNG_EXTENSION)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected final void addResourceItem(@NotNull BasicResourceItem item, @NotNull FrameworkResourceRepository repository2) {
            repository2.addResourceItem((ResourceItem)item);
        }

        @Override
        @NotNull
        protected String getKeyForVisibilityLookup(@NotNull String resourceName) {
            return resourceName;
        }
    }
}

