/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Arity;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.aar.AbstractAarResourceRepository;
import com.android.resources.aar.ProtoConfigurationDecoder;
import com.android.resources.aar.ProtoStyledStringDecoder;
import com.android.resources.base.BasicArrayResourceItem;
import com.android.resources.base.BasicAttrReference;
import com.android.resources.base.BasicAttrResourceItem;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicFileResourceItem;
import com.android.resources.base.BasicPluralsResourceItem;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicTextValueResourceItem;
import com.android.resources.base.BasicValueResourceItem;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSourceFile;
import com.android.resources.base.ResourceSourceFileImpl;
import com.android.resources.base.ResourceUrlParser;
import com.android.utils.DecimalUtils;
import com.android.utils.SdkUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Table;
import com.google.protobuf.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.BitUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarProtoResourceRepository
extends AbstractAarResourceRepository {
    protected static final Predicate<ConfigurationOuterClass.Configuration> TRIVIAL_CONFIG_FILTER = config -> true;
    protected static final Predicate<ResourceType> TRIVIAL_RESOURCE_TYPE_FILTER = type -> true;
    @NotNull
    private static final String APK_PROTOCOL = "apk";
    private static final String RESOURCE_TABLE_ENTRY = "resources.pb";
    private static final Logger LOG = Logger.getInstance(AarProtoResourceRepository.class);
    private static final int COMPLEX_UNIT_MASK = 15;
    private static final String[] DIMEN_SUFFIXES = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_SUFFIXES = new String[]{"%", "%p"};
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final double[] RADIX_FACTORS = new double[]{1.0, 0.0078125, 3.0517578125E-5, 1.1920928955078125E-7};
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    @NotNull
    protected final Path myResApkFile;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final String myResourceUrlPrefix;
    @Nullable
    private final String mySourceAttachmentPrefix;

    protected AarProtoResourceRepository(@NotNull Loader loader, @Nullable String libraryName, @Nullable Path sourceJar) {
        super(loader.myNamespace, libraryName);
        this.myResApkFile = loader.myResApkFile;
        this.myResourcePathPrefix = this.myResApkFile.toString() + "!/";
        this.myResourceUrlPrefix = "apk://" + RepositoryLoader.portableFileName(this.myResApkFile.toString()) + "!/";
        this.mySourceAttachmentPrefix = sourceJar != null && loader.myPackageName != null ? sourceJar.toString() + "!/" + AarProtoResourceRepository.getPackageNamePrefix(loader.myPackageName) : null;
    }

    @Override
    @NotNull
    public Path getOrigin() {
        return this.myResApkFile;
    }

    @Nullable
    public final String getPackageName() {
        return this.myNamespace.getPackageName();
    }

    @NotNull
    public static AarProtoResourceRepository create(@NotNull Path resApkFile, @NotNull String libraryName) {
        Loader loader = new Loader(resApkFile, TRIVIAL_CONFIG_FILTER, TRIVIAL_RESOURCE_TYPE_FILTER);
        try {
            loader.readApkFile();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return new AarProtoResourceRepository(loader, libraryName, null);
        }
        Path sourceJar = AarProtoResourceRepository.getSourceJarPath(resApkFile);
        if (!Files.exists(sourceJar, new LinkOption[0])) {
            sourceJar = null;
        }
        AarProtoResourceRepository repository2 = new AarProtoResourceRepository(loader, libraryName, sourceJar);
        loader.loadRepositoryContents(repository2);
        return repository2;
    }

    private static Path getSourceJarPath(@NotNull Path resApkFile) {
        String filename = resApkFile.getFileName().toString();
        int extensionPos = filename.lastIndexOf(46);
        if (extensionPos >= 0) {
            filename = filename.substring(0, extensionPos);
        }
        filename = filename + "-src.jar";
        return resApkFile.resolveSibling(filename);
    }

    @Override
    @NotNull
    public final String getResourceUrl(@NotNull String relativeResourcePath) {
        return this.expandRelativeResourcePath(this.myResourceUrlPrefix, relativeResourcePath, true);
    }

    @Override
    @NotNull
    public final PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return new PathString(APK_PROTOCOL, this.expandRelativeResourcePath(this.myResourcePathPrefix, relativeResourcePath, forFileResource));
    }

    private String expandRelativeResourcePath(@NotNull String prefix, @NotNull String relativeResourcePath, boolean forFileResource) {
        int offset = 0;
        if (this.hasOverlaySegment(relativeResourcePath, forFileResource)) {
            assert (Character.isDigit(relativeResourcePath.charAt(0)));
            offset = relativeResourcePath.indexOf(47) + 1;
        }
        int prefixLength = prefix.length();
        int pathLength = relativeResourcePath.length();
        char[] result = new char[prefixLength + pathLength - offset];
        prefix.getChars(0, prefixLength, result, 0);
        relativeResourcePath.getChars(offset, pathLength, result, prefixLength);
        return new String(result);
    }

    private boolean hasOverlaySegment(@NotNull String relativeResourcePath, boolean forFileResource) {
        return forFileResource && this.mySourceAttachmentPrefix != null && AarProtoResourceRepository.isXml(relativeResourcePath);
    }

    @Override
    @Nullable
    public final PathString getOriginalSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        if (AarProtoResourceRepository.isXml(relativeResourcePath)) {
            if (this.mySourceAttachmentPrefix == null) {
                return null;
            }
            return new PathString("jar", this.mySourceAttachmentPrefix + relativeResourcePath);
        }
        return this.getSourceFile(relativeResourcePath, forFileResource);
    }

    private static boolean isXml(@NotNull String filePath) {
        return SdkUtils.endsWithIgnoreCase((String)filePath, (String)".xml");
    }

    @NotNull
    private static String getPackageNamePrefix(@NotNull String packageName) {
        return packageName.replace('.', '/') + '/';
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " for " + this.myResApkFile;
    }

    private static class StringPool {
        private static final int STRING_COUNT_OFFSET = 8;
        private static final int FLAGS_OFFSET = 16;
        private static final int STRINGS_START_INDEX_OFFSET = 20;
        private static final int UTF8_FLAG = 256;
        private static final String REPLACEMENT_PREFIX = "0/res/";
        @NotNull
        final String[] strings;
        private int currentOffset;

        StringPool(@NotNull Resources.StringPool stringPoolMsg, @Nullable String packageName) {
            ByteString bytes = stringPoolMsg.getData();
            if ((StringPool.getInt32(bytes, 16) & 0x100) == 0) {
                throw new IllegalArgumentException("UTF-16 encoded string pool is not supported");
            }
            int stringCount = StringPool.getInt32(bytes, 8);
            this.strings = new String[stringCount];
            this.currentOffset = StringPool.getInt32(bytes, 20);
            for (int i = 0; i < stringCount; ++i) {
                this.getByteEncodedLength(bytes);
                int byteCount = this.getByteEncodedLength(bytes);
                int endOffset = this.currentOffset + byteCount;
                this.strings[i] = bytes.substring(this.currentOffset, endOffset).toStringUtf8();
                this.currentOffset = endOffset + 1;
            }
            this.normalizePaths(packageName);
        }

        private static int getByte(@NotNull ByteString bytes, int offset) {
            return bytes.byteAt(offset) & 0xFF;
        }

        private static int getInt32(@NotNull ByteString bytes, int offset) {
            return StringPool.getByte(bytes, offset) | StringPool.getByte(bytes, offset + 1) << 8 | StringPool.getByte(bytes, offset + 2) << 16 | StringPool.getByte(bytes, offset + 3) << 24;
        }

        private int getByteEncodedLength(@NotNull ByteString bytes) {
            int b;
            if (((b = StringPool.getByte(bytes, this.currentOffset++)) & 0x80) == 0) {
                return b;
            }
            return (b & 0x7F) << 8 | StringPool.getByte(bytes, this.currentOffset++);
        }

        private void normalizePaths(@Nullable String packageName) {
            String packagePrefix = packageName == null ? null : AarProtoResourceRepository.getPackageNamePrefix(packageName);
            String prefix = null;
            for (String str : this.strings) {
                if (str.isEmpty()) continue;
                if ((str = RepositoryLoader.portableFileName(str)).charAt(0) == '/') {
                    String anchor;
                    int pos;
                    if (prefix == null && (pos = str.indexOf(anchor = "/res/")) >= 0) {
                        prefix = str.substring(0, pos + anchor.length());
                    }
                    if (prefix == null && (pos = str.indexOf(anchor = "/namespaced_res/")) >= 0 && (pos = str.indexOf(47, pos + anchor.length())) >= 0) {
                        prefix = str.substring(0, pos + 1);
                    }
                    if (prefix != null && str.startsWith(prefix)) {
                        str = REPLACEMENT_PREFIX + str.substring(prefix.length());
                    }
                } else if (packagePrefix != null && str.startsWith(packagePrefix)) {
                    str = str.substring(packagePrefix.length());
                }
                this.strings[i] = str;
            }
        }

        @NotNull
        public String getString(int index2) {
            return this.strings[index2];
        }
    }

    protected static class Loader {
        @NotNull
        private final Path myResApkFile;
        @NotNull
        private final Predicate<ConfigurationOuterClass.Configuration> myConfigFilter;
        @NotNull
        private final Predicate<ResourceType> myResourceTypeFilter;
        @NotNull
        private final ResourceUrlParser myUrlParser = new ResourceUrlParser();
        @NotNull
        private final ListMultimap<String, BasicStyleableResourceItem> myStyleables = ArrayListMultimap.create();
        @NotNull
        private final Table<String, ConfigurationOuterClass.Configuration, ResourceSourceFile> mySourceFileCache = HashBasedTable.create();
        @Nullable
        private Resources.ResourceTable myResourceTableMsg;
        @Nullable
        private String myPackageName;
        private ResourceNamespace myNamespace;

        Loader(@NotNull Path resApkFile, @NotNull Predicate<ConfigurationOuterClass.Configuration> configFilter, @NotNull Predicate<ResourceType> resourceTypeFilter) {
            this.myResApkFile = resApkFile;
            this.myConfigFilter = configFilter;
            this.myResourceTypeFilter = resourceTypeFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readApkFile() throws IOException {
            ResourceNamespace resourceNamespace;
            try {
                try (ZipFile zipFile = new ZipFile(this.myResApkFile.toFile());){
                    this.myResourceTableMsg = Loader.readResourceTableFromResApk(zipFile);
                    this.myPackageName = AndroidManifestPackageNameUtils.getPackageNameFromResApk((ZipFile)zipFile);
                }
                resourceNamespace = this.myPackageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)this.myPackageName);
            }
            catch (Throwable throwable) {
                this.myNamespace = this.myPackageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)this.myPackageName);
                throw throwable;
            }
            this.myNamespace = resourceNamespace;
        }

        public void loadRepositoryContents(@NotNull AarProtoResourceRepository repository2) {
            if (this.myResourceTableMsg != null) {
                this.loadFromResourceTable(repository2, this.myResourceTableMsg);
            }
        }

        private void loadFromResourceTable(@NotNull AarProtoResourceRepository repository2, @NotNull Resources.ResourceTable resourceTableMsg) {
            StringPool stringPool = repository2.mySourceAttachmentPrefix == null ? null : new StringPool(resourceTableMsg.getSourcePool(), this.myNamespace.getPackageName());
            for (Resources.Package packageMsg : resourceTableMsg.getPackageList()) {
                for (Resources.Type typeMsg : packageMsg.getTypeList()) {
                    String typeName = typeMsg.getName();
                    ResourceType resourceType = ResourceType.fromClassName((String)typeName);
                    if (resourceType == null) {
                        if (typeName.equals("^attr-private")) {
                            resourceType = ResourceType.ATTR;
                        } else {
                            LOG.warn("Unexpected resource type: " + typeName);
                            continue;
                        }
                    }
                    if (!this.myResourceTypeFilter.test(resourceType)) continue;
                    for (Resources.Entry entryMsg : typeMsg.getEntryList()) {
                        String resourceName = entryMsg.getName();
                        Resources.Visibility visibilityMsg = entryMsg.getVisibility();
                        ResourceVisibility visibility = Loader.decodeVisibility(visibilityMsg);
                        for (Resources.ConfigValue configValueMsg : entryMsg.getConfigValueList()) {
                            ResourceSourceFile sourceFile;
                            BasicResourceItem item;
                            ConfigurationOuterClass.Configuration configMsg;
                            String sourcePath;
                            Resources.Value valueMsg = configValueMsg.getValue();
                            Resources.Source sourceMsg = valueMsg.getSource();
                            String string = sourcePath = stringPool == null ? null : stringPool.getString(sourceMsg.getPathIdx());
                            if (sourcePath != null && sourcePath.isEmpty()) {
                                sourcePath = null;
                            }
                            if (!this.myConfigFilter.test(configMsg = configValueMsg.getConfig()) || (item = this.createResourceItem(valueMsg, resourceType, resourceName, sourceFile = this.getSourceFile(repository2, sourcePath, configMsg), visibility)) == null) continue;
                            this.addResourceItem(repository2, (ResourceItem)item);
                        }
                    }
                }
            }
            for (BasicStyleableResourceItem styleable : this.myStyleables.values()) {
                repository2.addResourceItem((ResourceItem)RepositoryLoader.resolveAttrReferences(styleable));
            }
            repository2.populatePublicResourcesMap();
            repository2.freezeResources();
        }

        private void addResourceItem(@NotNull AarProtoResourceRepository repository2, @NotNull ResourceItem item) {
            if (item.getType() == ResourceType.STYLEABLE) {
                this.myStyleables.put((Object)item.getName(), (Object)((BasicStyleableResourceItem)item));
            } else {
                repository2.addResourceItem(item);
            }
        }

        @Nullable
        private BasicResourceItem createResourceItem(@NotNull Resources.Value valueMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            switch (valueMsg.getValueCase()) {
                case ITEM: {
                    return this.createResourceItem(valueMsg.getItem(), resourceType, resourceName, sourceFile, visibility);
                }
                case COMPOUND_VALUE: {
                    String description = valueMsg.getComment();
                    if (CharMatcher.whitespace().matchesAllOf((CharSequence)description)) {
                        description = null;
                    }
                    return this.createResourceItem(valueMsg.getCompoundValue(), resourceName, sourceFile, visibility, description);
                }
            }
            LOG.warn("Unexpected Value message: " + valueMsg);
            return null;
        }

        @Nullable
        private BasicResourceItem createResourceItem(@NotNull Resources.Item itemMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            switch (itemMsg.getValueCase()) {
                case FILE: {
                    Density densityValue;
                    FolderConfiguration folderConfiguration;
                    DensityQualifier densityQualifier;
                    String path2 = sourceFile.getRelativePath();
                    if (path2 == null || !AarProtoResourceRepository.isXml(path2)) {
                        path2 = itemMsg.getFile().getPath();
                    }
                    RepositoryConfiguration configuration = sourceFile.getConfiguration();
                    if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = (folderConfiguration = configuration.getFolderConfiguration()).getDensityQualifier()) != null && (densityValue = densityQualifier.getValue()) != null) {
                        return new BasicDensityBasedFileResourceItem(resourceType, resourceName, configuration, visibility, path2, densityValue);
                    }
                    return new BasicFileResourceItem(resourceType, resourceName, configuration, visibility, path2);
                }
                case REF: {
                    String ref = this.decode(itemMsg.getRef());
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, ref);
                }
                case STR: {
                    String textValue = itemMsg.getStr().getValue();
                    return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue);
                }
                case RAW_STR: {
                    String str = itemMsg.getRawStr().getValue();
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, str);
                }
                case PRIM: {
                    String str = Loader.decode(itemMsg.getPrim());
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, str);
                }
                case STYLED_STR: {
                    Resources.StyledString styledStrMsg = itemMsg.getStyledStr();
                    String textValue = styledStrMsg.getValue();
                    String rawXmlValue = ProtoStyledStringDecoder.getRawXmlValue(styledStrMsg);
                    if (rawXmlValue.equals(textValue)) {
                        return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue);
                    }
                    return new BasicTextValueResourceItem(resourceType, resourceName, sourceFile, visibility, textValue, rawXmlValue);
                }
                case ID: {
                    return Loader.createResourceItem(resourceType, resourceName, sourceFile, visibility, null);
                }
            }
            LOG.warn("Unexpected Item message: " + itemMsg);
            return null;
        }

        @NotNull
        private static BasicResourceItem createResourceItem(@NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String value) {
            return new BasicValueResourceItem(resourceType, resourceName, sourceFile, visibility, value);
        }

        @Nullable
        private BasicResourceItem createResourceItem(@NotNull Resources.CompoundValue compoundValueMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String description) {
            switch (compoundValueMsg.getValueCase()) {
                case ATTR: {
                    return Loader.createAttr(compoundValueMsg.getAttr(), resourceName, sourceFile, visibility, description);
                }
                case STYLE: {
                    return this.createStyle(compoundValueMsg.getStyle(), resourceName, sourceFile, visibility);
                }
                case STYLEABLE: {
                    return this.createStyleable(compoundValueMsg.getStyleable(), resourceName, sourceFile, visibility);
                }
                case ARRAY: {
                    return this.createArray(compoundValueMsg.getArray(), resourceName, sourceFile, visibility);
                }
                case PLURAL: {
                    return this.createPlurals(compoundValueMsg.getPlural(), resourceName, sourceFile, visibility);
                }
            }
            LOG.warn("Unexpected CompoundValue message: " + compoundValueMsg);
            return null;
        }

        @NotNull
        private static BasicAttrResourceItem createAttr(@NotNull Resources.Attribute attributeMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String description) {
            Set<AttributeFormat> formats = Loader.decodeFormatFlags(attributeMsg.getFormatFlags());
            List symbolList = attributeMsg.getSymbolList();
            Map<String, Integer> valueMap = Collections.emptyMap();
            Map<String, String> valueDescriptionMap = Collections.emptyMap();
            for (Resources.Attribute.Symbol symbolMsg : symbolList) {
                String name = symbolMsg.getName().getName();
                int slashPos = name.lastIndexOf(47);
                if (slashPos >= 0) {
                    name = name.substring(slashPos + 1);
                }
                String symbolDescription = symbolMsg.getComment();
                if (CharMatcher.whitespace().matchesAllOf((CharSequence)symbolDescription)) {
                    symbolDescription = null;
                }
                if (valueMap.isEmpty()) {
                    valueMap = new HashMap<String, Integer>();
                }
                valueMap.put(name, symbolMsg.getValue());
                if (symbolDescription == null) continue;
                if (valueDescriptionMap.isEmpty()) {
                    valueDescriptionMap = new HashMap<String, String>();
                }
                valueDescriptionMap.put(name, symbolDescription);
            }
            String groupName = null;
            return new BasicAttrResourceItem(resourceName, sourceFile, visibility, description, groupName, formats, valueMap, valueDescriptionMap);
        }

        @NotNull
        private BasicStyleResourceItem createStyle(@NotNull Resources.Style styleMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            String libraryName = sourceFile.getRepository().getLibraryName();
            this.myUrlParser.parseResourceUrl(styleMsg.getParent().getName());
            String parentStyle = this.myUrlParser.getQualifiedName();
            if (StyleResourceValue.isDefaultParentStyleName((String)parentStyle, (String)resourceName)) {
                parentStyle = null;
            }
            ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>(styleMsg.getEntryCount());
            for (Resources.Style.Entry entryMsg : styleMsg.getEntryList()) {
                String url = entryMsg.getKey().getName();
                this.myUrlParser.parseResourceUrl(url);
                String name = this.myUrlParser.getQualifiedName();
                String value = this.decode(entryMsg.getItem());
                StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(this.myNamespace, name, value, libraryName);
                styleItems.add((StyleItemResourceValue)itemValue);
            }
            return new BasicStyleResourceItem(resourceName, sourceFile, visibility, parentStyle, styleItems);
        }

        @NotNull
        private BasicStyleableResourceItem createStyleable(@NotNull Resources.Styleable styleableMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>(styleableMsg.getEntryCount());
            for (Resources.Styleable.Entry entryMsg : styleableMsg.getEntryList()) {
                String url = entryMsg.getAttr().getName();
                this.myUrlParser.parseResourceUrl(url);
                String packageName = this.myUrlParser.getNamespacePrefix();
                ResourceNamespace attrNamespace = packageName == null ? this.myNamespace : ResourceNamespace.fromPackageName((String)packageName);
                String comment = entryMsg.getComment();
                BasicAttrReference attr = new BasicAttrReference(attrNamespace, this.myUrlParser.getName(), sourceFile, visibility, comment.isEmpty() ? null : comment, null);
                attrs.add(attr);
            }
            return new BasicStyleableResourceItem(resourceName, sourceFile, visibility, attrs);
        }

        @NotNull
        private BasicArrayResourceItem createArray(@NotNull Resources.Array arrayMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            ArrayList<String> elements = new ArrayList<String>(arrayMsg.getElementCount());
            for (Resources.Array.Element elementMsg : arrayMsg.getElementList()) {
                String text = this.decode(elementMsg.getItem());
                if (text == null) continue;
                elements.add(text);
            }
            return new BasicArrayResourceItem(resourceName, sourceFile, visibility, elements, 0);
        }

        @NotNull
        private BasicPluralsResourceItem createPlurals(@NotNull Resources.Plural pluralMsg, @NotNull String resourceName, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
            EnumMap<Arity, String> values = new EnumMap<Arity, String>(Arity.class);
            for (Resources.Plural.Entry entryMsg : pluralMsg.getEntryList()) {
                values.put(Loader.decodeArity(entryMsg.getArity()), this.decode(entryMsg.getItem()));
            }
            return new BasicPluralsResourceItem(resourceName, sourceFile, visibility, values, null);
        }

        @NotNull
        private ResourceSourceFile getSourceFile(@NotNull AarProtoResourceRepository repository2, @Nullable String sourcePath, @NotNull ConfigurationOuterClass.Configuration configMsg) {
            String sourcePathKey = sourcePath == null ? "" : sourcePath;
            ResourceSourceFile sourceFile = (ResourceSourceFile)this.mySourceFileCache.get((Object)sourcePathKey, (Object)configMsg);
            if (sourceFile != null) {
                return sourceFile;
            }
            FolderConfiguration configuration = ProtoConfigurationDecoder.getConfiguration(configMsg);
            configuration.normalizeByRemovingRedundantVersionQualifier();
            sourceFile = new ResourceSourceFileImpl(sourcePath, new RepositoryConfiguration(repository2, configuration));
            this.mySourceFileCache.put((Object)sourcePathKey, (Object)configMsg, (Object)sourceFile);
            return sourceFile;
        }

        @Nullable
        private String decode(@NotNull Resources.Item itemMsg) {
            switch (itemMsg.getValueCase()) {
                case REF: {
                    return this.decode(itemMsg.getRef());
                }
                case STR: {
                    return itemMsg.getStr().getValue();
                }
                case RAW_STR: {
                    return itemMsg.getRawStr().getValue();
                }
                case STYLED_STR: {
                    return itemMsg.getStyledStr().getValue();
                }
                case FILE: {
                    return itemMsg.getFile().getPath();
                }
                case ID: {
                    return null;
                }
                case PRIM: {
                    return Loader.decode(itemMsg.getPrim());
                }
            }
            return null;
        }

        @NotNull
        private String decode(@NotNull Resources.Reference referenceMsg) {
            String name = referenceMsg.getName();
            if (name.isEmpty()) {
                return "";
            }
            if (referenceMsg.getType() == Resources.Reference.Type.ATTRIBUTE) {
                this.myUrlParser.parseResourceUrl(name);
                if (this.myUrlParser.hasType(ResourceType.ATTR.getName())) {
                    name = this.myUrlParser.getQualifiedName();
                }
                return '?' + name;
            }
            return '@' + name;
        }

        @Nullable
        private static String decode(@NotNull Resources.Primitive primitiveMsg) {
            switch (primitiveMsg.getOneofValueCase()) {
                case NULL_VALUE: {
                    return null;
                }
                case EMPTY_VALUE: {
                    return "";
                }
                case FLOAT_VALUE: {
                    return DecimalUtils.trimInsignificantZeros((String)Float.toString(primitiveMsg.getFloatValue()));
                }
                case DIMENSION_VALUE: {
                    return Loader.decodeComplexDimensionValue(primitiveMsg.getDimensionValue(), 1.0, DIMEN_SUFFIXES);
                }
                case FRACTION_VALUE: {
                    return Loader.decodeComplexDimensionValue(primitiveMsg.getFractionValue(), 100.0, FRACTION_SUFFIXES);
                }
                case INT_DECIMAL_VALUE: {
                    return Integer.toString(primitiveMsg.getIntDecimalValue());
                }
                case INT_HEXADECIMAL_VALUE: {
                    return String.format("0x%X", primitiveMsg.getIntHexadecimalValue());
                }
                case BOOLEAN_VALUE: {
                    return Boolean.toString(primitiveMsg.getBooleanValue());
                }
                case COLOR_ARGB8_VALUE: {
                    return String.format("#%08X", primitiveMsg.getColorArgb8Value());
                }
                case COLOR_RGB8_VALUE: {
                    return String.format("#%06X", primitiveMsg.getColorRgb8Value() & 0xFFFFFF);
                }
                case COLOR_ARGB4_VALUE: {
                    int argb = primitiveMsg.getColorArgb4Value();
                    return String.format("#%X%X%X%X", argb >>> 24 & 0xF, argb >>> 16 & 0xF, argb >>> 8 & 0xF, argb & 0xF);
                }
                case COLOR_RGB4_VALUE: {
                    int rgb = primitiveMsg.getColorRgb4Value();
                    return String.format("#%X%X%X", rgb >>> 16 & 0xF, rgb >>> 8 & 0xF, rgb & 0xF);
                }
            }
            LOG.warn("Unexpected Primitive message: " + primitiveMsg);
            return null;
        }

        private static String decodeComplexDimensionValue(int bits, double scaleFactor, @NotNull String[] unitSuffixes) {
            int unitCode = bits & 0xF;
            String unit = unitCode < unitSuffixes.length ? unitSuffixes[unitCode] : " unknown unit: " + unitCode;
            int radix = bits >> 4 & 3;
            int mantissa = bits >> 8;
            double value = (double)mantissa * RADIX_FACTORS[radix] * scaleFactor;
            return DecimalUtils.trimInsignificantZeros((String)String.format(Locale.US, "%.5g", value)) + unit;
        }

        @NotNull
        private static Set<AttributeFormat> decodeFormatFlags(int flags) {
            EnumSet<AttributeFormat> result = EnumSet.noneOf(AttributeFormat.class);
            if (BitUtil.isSet((int)flags, (int)1)) {
                result.add(AttributeFormat.REFERENCE);
            }
            if (BitUtil.isSet((int)flags, (int)2)) {
                result.add(AttributeFormat.STRING);
            }
            if (BitUtil.isSet((int)flags, (int)4)) {
                result.add(AttributeFormat.INTEGER);
            }
            if (BitUtil.isSet((int)flags, (int)8)) {
                result.add(AttributeFormat.BOOLEAN);
            }
            if (BitUtil.isSet((int)flags, (int)16)) {
                result.add(AttributeFormat.COLOR);
            }
            if (BitUtil.isSet((int)flags, (int)32)) {
                result.add(AttributeFormat.FLOAT);
            }
            if (BitUtil.isSet((int)flags, (int)64)) {
                result.add(AttributeFormat.DIMENSION);
            }
            if (BitUtil.isSet((int)flags, (int)128)) {
                result.add(AttributeFormat.FRACTION);
            }
            if (BitUtil.isSet((int)flags, (int)65536)) {
                result.add(AttributeFormat.ENUM);
            }
            if (BitUtil.isSet((int)flags, (int)131072)) {
                result.add(AttributeFormat.FLAGS);
            }
            return result;
        }

        @NotNull
        private static Arity decodeArity(@NotNull Resources.Plural.Arity arity) {
            switch (arity) {
                case ZERO: {
                    return Arity.ZERO;
                }
                case ONE: {
                    return Arity.ONE;
                }
                case TWO: {
                    return Arity.TWO;
                }
                case FEW: {
                    return Arity.FEW;
                }
                case MANY: {
                    return Arity.MANY;
                }
            }
            return Arity.OTHER;
        }

        @NotNull
        private static ResourceVisibility decodeVisibility(@NotNull Resources.Visibility visibilityMsg) {
            switch (visibilityMsg.getLevel()) {
                case UNKNOWN: {
                    return ResourceVisibility.PRIVATE_XML_ONLY;
                }
                case PRIVATE: {
                    return ResourceVisibility.PRIVATE;
                }
                case PUBLIC: {
                    return ResourceVisibility.PUBLIC;
                }
            }
            return ResourceVisibility.UNDEFINED;
        }

        @NotNull
        private static Resources.ResourceTable readResourceTableFromResApk(@NotNull ZipFile resApk) throws IOException {
            ZipEntry zipEntry = resApk.getEntry(AarProtoResourceRepository.RESOURCE_TABLE_ENTRY);
            if (zipEntry == null) {
                throw new IOException("\"resources.pb\" not found in " + resApk.getName());
            }
            try (BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));){
                Resources.ResourceTable resourceTable = Resources.ResourceTable.parseFrom((InputStream)stream);
                return resourceTable;
            }
        }
    }
}

