/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.CmdSets;
import com.android.jdwptracer.Command;
import com.android.jdwptracer.Event;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.NamedEvent;
import com.android.jdwptracer.Reply;
import com.android.jdwptracer.Transmission;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

class SystraceOutput {
    SystraceOutput() {
    }

    static void genOutput(List<Event> events, Path path2) {
        try {
            FileWriter out = new FileWriter(path2.toAbsolutePath().toString());
            out.write("[ ");
            for (int i = 0; i < events.size(); ++i) {
                Event event = events.get(i);
                if (event instanceof Transmission) {
                    SystraceOutput.processTransmission(out, (Transmission)event, i);
                    continue;
                }
                if (event instanceof NamedEvent) {
                    SystraceOutput.processNamedEvent(out, (NamedEvent)event, i);
                    continue;
                }
                throw new IllegalStateException("Unknown type of event");
            }
            out.write("{}");
            out.write("]");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void processNamedEvent(FileWriter out, NamedEvent event, int i) throws IOException {
        String name = event.name();
        SystraceOutput.emitInstantEvent(out, event.time() / 1000L, i, name);
        SystraceOutput.nameThread(out, i, name);
    }

    private static void processTransmission(FileWriter out, Transmission transmission, int i) throws IOException {
        Command command = transmission.cmd();
        CmdSet cmdset = CmdSets.get(transmission.cmd().cmdSetID());
        String name = cmdset.name() + ":" + cmdset.cmdName(transmission.cmd().cmdID());
        if (!command.message().name().isEmpty()) {
            name = name + ":" + command.message().name();
        }
        if (transmission.reply().isPresent()) {
            Reply reply = transmission.reply().get();
            long duration = reply.time() - command.time();
            JsonObject args = new JsonObject();
            args.add("cmd", (JsonElement)SystraceOutput.makeMessagePayload(command.message()));
            args.add("reply", (JsonElement)SystraceOutput.makeMessagePayload(reply.message()));
            SystraceOutput.emitCompleteEvent(out, command.time() / 1000L, duration / 1000L, i, name, args);
        } else {
            SystraceOutput.emitInstantEvent(out, command.time() / 1000L, i, name, SystraceOutput.makeMessagePayload(command.message()));
        }
        SystraceOutput.nameThread(out, i, name);
    }

    private static JsonObject makeMessagePayload(Message message2) {
        JsonObject payloadObject = new JsonObject();
        payloadObject.addProperty("length", (Number)message2.payloadLength());
        JsonObject arguments = message2.args();
        if (arguments.size() > 0) {
            payloadObject.add("payload", (JsonElement)arguments);
        }
        return payloadObject;
    }

    private static void emitCompleteEvent(FileWriter out, long startTime, long duration, int i, String name, JsonObject args) throws IOException {
        JsonObject part = new JsonObject();
        part.addProperty("name", name);
        part.addProperty("cat", "foo");
        part.addProperty("ph", "X");
        part.addProperty("ts", (Number)startTime);
        part.addProperty("dur", (Number)duration);
        part.addProperty("pid", (Number)0);
        part.addProperty("tid", (Number)i);
        part.add("args", (JsonElement)args);
        out.write(part.toString());
        out.write(",\n");
    }

    private static void emitInstantEvent(FileWriter out, long time, int threadID, String name) throws IOException {
        SystraceOutput.emitInstantEvent(out, time, threadID, name, null);
    }

    private static void emitInstantEvent(FileWriter out, long time, int threadID, String name, JsonObject args) throws IOException {
        JsonObject part = new JsonObject();
        part.addProperty("name", name);
        part.addProperty("ph", "i");
        part.addProperty("ts", (Number)time);
        part.addProperty("pid", (Number)0);
        part.addProperty("tid", (Number)threadID);
        part.addProperty("s", "t");
        if (args != null) {
            part.add("args", (JsonElement)args);
        }
        out.write(part.toString());
        out.write(",\n");
    }

    private static void nameThread(FileWriter out, int threadID, String name) throws IOException {
        JsonObject args = new JsonObject();
        args.addProperty("name", name);
        JsonObject part = new JsonObject();
        part.addProperty("name", "thread_name");
        part.addProperty("ph", "M");
        part.addProperty("pid", (Number)0);
        part.addProperty("tid", (Number)threadID);
        part.add("args", (JsonElement)args);
        out.write(part.toString());
        out.write(",\n");
    }
}

