/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.CmdSetVM;
import com.android.jdwptracer.CmdSets;
import com.android.jdwptracer.Command;
import com.android.jdwptracer.Event;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import com.android.jdwptracer.NamedEvent;
import com.android.jdwptracer.Packet;
import com.android.jdwptracer.Reply;
import com.android.jdwptracer.Transmission;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

class Session {
    private MessageReader messageReader = new MessageReader();
    private final HashMap<Integer, Transmission> idToTransmission = new HashMap();
    List<Event> events = new ArrayList<Event>();

    Session() {
    }

    boolean addPacket(ByteBuffer packet) {
        long now = System.nanoTime();
        int length = packet.getInt();
        int id = packet.getInt();
        byte flag = packet.get();
        if (Packet.isReply(flag)) {
            short error = packet.getShort();
            if (!this.idToTransmission.containsKey(id)) {
                String msg = String.format(Locale.US, "Found reply id=%d packet without a cmd", id);
                System.out.println("Warning: " + msg);
                return false;
            }
            Transmission t = this.idToTransmission.get(id);
            int cmdSetID = t.cmd().cmdSetID();
            int cmdID = t.cmd().cmdID();
            CmdSet cmdSet = CmdSets.get(cmdSetID);
            Message message2 = cmdSet.getCmd(cmdID).getReplyParser().parse(packet, this.messageReader);
            Reply reply = new Reply(id, length, error, now, message2);
            t.addReply(reply);
            return cmdSetID == 1 && cmdID == CmdSetVM.Cmd.EXIT.ID;
        }
        int cmdSetID = packet.get() & 0xFF;
        int cmdID = packet.get() & 0xFF;
        CmdSet cmdSet = CmdSets.get(cmdSetID);
        Message message3 = cmdSet.getCmd(cmdID).getCmdParser().parse(packet, this.messageReader);
        Command command = new Command(id, cmdSetID, cmdID, length, now, message3);
        Transmission t = new Transmission(command, id);
        this.idToTransmission.put(id, t);
        this.events.add(t);
        return false;
    }

    void addEvent(String name) {
        long now = System.nanoTime();
        this.events.add(new NamedEvent(name, now));
    }

    List<Event> events() {
        return this.events;
    }
}

