/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

class MessageReader {
    private int fieldIDSize = 8;
    private int methodIDSize = 8;
    private int objectIDSize = 8;
    private int referenceTypeIDSize = 8;
    private int frameIDSize = 8;

    MessageReader() {
    }

    void setFieldIDSize(int size) {
        this.fieldIDSize = size;
    }

    void setMethodIDSize(int size) {
        this.methodIDSize = size;
    }

    void setObjectIDSize(int size) {
        this.objectIDSize = size;
    }

    void setReferenceTypeIDSize(int size) {
        this.referenceTypeIDSize = size;
    }

    void setFrameIDSize(int size) {
        this.frameIDSize = size;
    }

    byte getByte(ByteBuffer buffer2) {
        return buffer2.get();
    }

    String getTypeTag(ByteBuffer buffer2) {
        byte type = this.getByte(buffer2);
        switch (type) {
            case 1: {
                return "CLASS";
            }
            case 2: {
                return "INTERFACE";
            }
            case 3: {
                return "ARRAY";
            }
        }
        return "UNKNOWN";
    }

    boolean getBoolean(ByteBuffer buffer2) {
        return buffer2.get() != 0;
    }

    short getShort(ByteBuffer buffer2) {
        return buffer2.getShort();
    }

    int getInt(ByteBuffer buffer2) {
        return buffer2.getInt();
    }

    long getLong(ByteBuffer buffer2) {
        return buffer2.getLong();
    }

    JsonObject getLocation(ByteBuffer buffer2) {
        JsonObject location2 = new JsonObject();
        location2.addProperty("type", this.getTypeTag(buffer2));
        location2.addProperty("classID", (Number)this.getClassID(buffer2));
        location2.addProperty("methodID", (Number)this.getMethodID(buffer2));
        location2.addProperty("index", (Number)this.getLong(buffer2));
        return location2;
    }

    void getValue(ByteBuffer buffer2) {
        byte tag = this.getByte(buffer2);
        switch (tag) {
            case 91: {
                this.getObjectID(buffer2);
                break;
            }
            case 66: {
                this.getByte(buffer2);
                break;
            }
            case 67: {
                this.getShort(buffer2);
                break;
            }
            case 76: {
                this.getObjectID(buffer2);
                break;
            }
            case 70: {
                this.getInt(buffer2);
                break;
            }
            case 68: {
                this.getLong(buffer2);
                break;
            }
            case 73: {
                this.getInt(buffer2);
                break;
            }
            case 74: {
                this.getLong(buffer2);
                break;
            }
            case 83: {
                this.getShort(buffer2);
                break;
            }
            case 86: {
                break;
            }
            case 90: {
                this.getByte(buffer2);
                break;
            }
            case 115: {
                this.getObjectID(buffer2);
                break;
            }
            case 116: {
                this.getObjectID(buffer2);
                break;
            }
            case 103: {
                this.getObjectID(buffer2);
                break;
            }
            case 108: {
                this.getObjectID(buffer2);
                break;
            }
            case 99: {
                this.getObjectID(buffer2);
                break;
            }
        }
    }

    long getFieldID(ByteBuffer buffer2) {
        return this.getID(buffer2, this.fieldIDSize);
    }

    long getMethodID(ByteBuffer buffer2) {
        return this.getID(buffer2, this.methodIDSize);
    }

    long getClassID(ByteBuffer buffer2) {
        return this.getReferenceTypeID(buffer2);
    }

    long getObjectID(ByteBuffer buffer2) {
        return this.getID(buffer2, this.objectIDSize);
    }

    long getThreadID(ByteBuffer byteBuffer) {
        return this.getObjectID(byteBuffer);
    }

    void getTaggedObjectID(ByteBuffer buffer2) {
        this.getObjectID(buffer2);
        this.getByte(buffer2);
    }

    long getReferenceTypeID(ByteBuffer buffer2) {
        return this.getID(buffer2, this.referenceTypeIDSize);
    }

    long getFrameID(ByteBuffer buffer2) {
        return this.getID(buffer2, this.frameIDSize);
    }

    public String getString(ByteBuffer buffer2) {
        byte[] bytes = new byte[this.getInt(buffer2)];
        buffer2.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private long getID(ByteBuffer buffer2, int size) {
        switch (size) {
            case 1: {
                return buffer2.get();
            }
            case 2: {
                return buffer2.getShort();
            }
            case 4: {
                return buffer2.getInt();
            }
            case 8: {
                return buffer2.getLong();
            }
        }
        throw new IllegalArgumentException("Unsupported id size: " + size);
    }
}

