/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.Session;
import com.android.jdwptracer.SystraceOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JDWPTracer {
    private Session session;
    private final boolean enabled;
    private final Path outputFolder;

    public JDWPTracer(boolean enabled) {
        this(enabled, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]));
    }

    public JDWPTracer(boolean enabled, Path folder) {
        this.enabled = enabled;
        this.outputFolder = folder;
        this.session = new Session();
    }

    public synchronized void addPacket(ByteBuffer buffer2) {
        if (!this.enabled) {
            return;
        }
        buffer2 = buffer2.duplicate();
        buffer2.order(ByteOrder.BIG_ENDIAN);
        boolean exitDetected = this.session.addPacket(buffer2);
        if (exitDetected) {
            Path outputPath = this.outputFolder.resolve("perfetto-trace.json");
            SystraceOutput.genOutput(this.session.events(), outputPath);
            System.out.println("JDWTrace written to '" + outputPath.toAbsolutePath() + "'");
            this.session = new Session();
        }
    }

    public synchronized void addEvent(String name) {
        if (!this.enabled) {
            return;
        }
        this.session.addEvent(name);
    }
}

