/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import java.util.HashMap;
import java.util.Map;

enum EventKind {
    SINGLE_STEP(1),
    BREAKPOINT(2),
    FRAME_POP(3),
    EXCEPTION(4),
    USER_DEFINED(5),
    THREAD_START(6),
    THREAD_DEATH(7),
    CLASS_PREPARE(8),
    CLASS_UNLOAD(9),
    CLASS_LOAD(10),
    FIELD_ACCESS(20),
    FIELD_MODIFICATION(21),
    EXCEPTION_CATCH(30),
    METHOD_ENTRY(40),
    METHOD_EXIT(41),
    METHOD_EXIT_WITH_RETURN_VALUE(42),
    MONITOR_CONTENDED_ENTER(43),
    MONITOR_CONTENDED_ENTERED(44),
    MONITOR_WAIT(45),
    MONITOR_WAITED(46),
    VM_START(90),
    VM_DEATH(99);

    private int id;
    static Map<Integer, EventKind> idToEnum;

    private EventKind(int id) {
        this.id = id;
    }

    static EventKind fromID(int id) {
        if (!idToEnum.containsKey(id)) {
            throw new IllegalStateException("No EventKind with id=" + id);
        }
        return idToEnum.get(id);
    }

    static {
        idToEnum = new HashMap<Integer, EventKind>();
        for (EventKind eventKind : EventKind.values()) {
            idToEnum.put(eventKind.id, eventKind);
        }
    }
}

