/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import com.android.jdwptracer.PacketParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

class CmdSetVM
extends CmdSet {
    static final int ID = 1;

    CmdSetVM() {
        super(1, "VM");
        this.add(Cmd.VERSION);
        this.add(Cmd.CLASSES_BY_SIGNATURE, CmdSetVM::parseClassesBySignatureCmd, CmdSetVM::parseClassesBySignatureReply);
        this.add(Cmd.ALL_CLASSES);
        this.add(Cmd.ALL_THREADS);
        this.add(Cmd.TOP_LEVEL_GROUP_THREADS);
        this.add(Cmd.DISPOSE);
        this.add(Cmd.ID_SIZES, CmdSetVM::parseCmdIdSizes, CmdSetVM::parseReplyIdSizes);
        this.add(Cmd.SUSPEND);
        this.add(Cmd.RESUME);
        this.add(Cmd.EXIT);
        this.add(Cmd.CREATE_STRING);
        this.add(Cmd.CAPABILITIES);
        this.add(Cmd.CLASSPATH);
        this.add(Cmd.DISPOSE_OBJECTS);
        this.add(Cmd.HOLD_EVENTS);
        this.add(Cmd.RELEASE_EVENTS);
        this.add(Cmd.CAPACITIES_NEW);
        this.add(Cmd.REDEFINE_CLASSES);
        this.add(Cmd.SET_DEFAULT_STRATUM);
        this.add(Cmd.ALL_CLASSES_WITH_GENERIC, CmdSetVM::parseAllClassesWithGenericsCmd, CmdSetVM::parseAllClassesWithGenericsReply);
        this.add(Cmd.INSTANCE_COUNTS);
    }

    private void add(Cmd cmd) {
        this.add(cmd.ID, cmd.NAME);
    }

    private void add(Cmd cmd, PacketParser onCmd, PacketParser onReply) {
        this.add(cmd.ID, cmd.NAME, onCmd, onReply);
    }

    private static Message parseReplyIdSizes(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        int fieldIDSize = reader.getInt(byteBuffer);
        reader.setFieldIDSize(fieldIDSize);
        message2.addArg("FieldIDSize", Integer.toString(fieldIDSize));
        int methodIDSize = reader.getInt(byteBuffer);
        reader.setMethodIDSize(methodIDSize);
        message2.addArg("methodIDSize", Integer.toString(methodIDSize));
        int objectIDSize = reader.getInt(byteBuffer);
        reader.setObjectIDSize(objectIDSize);
        message2.addArg("objectIDSize", Integer.toString(objectIDSize));
        int referenceTypeIDSize = reader.getInt(byteBuffer);
        reader.setReferenceTypeIDSize(referenceTypeIDSize);
        message2.addArg("referenceTypeID", Integer.toString(referenceTypeIDSize));
        int frameIDSize = reader.getInt(byteBuffer);
        reader.setFrameIDSize(frameIDSize);
        message2.addArg("frameIDSize", Integer.toString(frameIDSize));
        return message2;
    }

    private static Message parseCmdIdSizes(ByteBuffer byteBuffer, MessageReader reader) {
        return Message.defaultMessageParser(byteBuffer, reader);
    }

    private static Message parseClassesBySignatureCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = Message.defaultMessageParser(byteBuffer, reader);
        message2.addArg("signature", reader.getString(byteBuffer));
        return message2;
    }

    private static Message parseClassesBySignatureReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        int classes = reader.getInt(byteBuffer);
        message2.addArg("classes", classes);
        JsonArray classList = new JsonArray();
        for (int i = 0; i < classes; ++i) {
            JsonObject classEntry = new JsonObject();
            classEntry.addProperty("refTypeTag", (Number)reader.getByte(byteBuffer));
            classEntry.addProperty("typeID", (Number)reader.getReferenceTypeID(byteBuffer));
            classEntry.addProperty("status", (Number)reader.getInt(byteBuffer));
            classList.add((JsonElement)classEntry);
        }
        message2.addArg("classList", (JsonElement)classList);
        return message2;
    }

    private static Message parseAllClassesWithGenericsCmd(ByteBuffer byteBuffer, MessageReader reader) {
        return Message.defaultMessageParser(byteBuffer, reader);
    }

    private static Message parseAllClassesWithGenericsReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        int classes = reader.getInt(byteBuffer);
        message2.addArg("classes", Integer.toString(classes));
        JsonArray classList = new JsonArray();
        for (int i = 0; i < classes; ++i) {
            JsonObject classEntry = new JsonObject();
            classEntry.addProperty("refTypeTag", (Number)reader.getByte(byteBuffer));
            classEntry.addProperty("typeID", (Number)reader.getReferenceTypeID(byteBuffer));
            classEntry.addProperty("signature", reader.getString(byteBuffer));
            classEntry.addProperty("genericSignature", reader.getString(byteBuffer));
            classEntry.addProperty("status", (Number)reader.getInt(byteBuffer));
            classList.add((JsonElement)classEntry);
        }
        message2.addArg("classList", (JsonElement)classList);
        return message2;
    }

    static enum Cmd {
        VERSION(1, "Version"),
        CLASSES_BY_SIGNATURE(2, "ClassesBySignature"),
        ALL_CLASSES(3, "AllClasses"),
        ALL_THREADS(4, "AllThreads"),
        TOP_LEVEL_GROUP_THREADS(5, "TopLevelGroupThreads"),
        DISPOSE(6, "Dispose"),
        ID_SIZES(7, "IdSizes"),
        SUSPEND(8, "Suspend"),
        RESUME(9, "Resume"),
        EXIT(10, "Exit"),
        CREATE_STRING(11, "CreateString"),
        CAPABILITIES(12, "Capabilities"),
        CLASSPATH(13, "ClassPaths"),
        DISPOSE_OBJECTS(14, "DisposeObjects"),
        HOLD_EVENTS(15, "HoldEvents"),
        RELEASE_EVENTS(16, "ReleaseEvents"),
        CAPACITIES_NEW(17, "CapabilitiesNew"),
        REDEFINE_CLASSES(18, "RedefineClasses"),
        SET_DEFAULT_STRATUM(19, "SetDefaultStratum"),
        ALL_CLASSES_WITH_GENERIC(20, "AllClassesWithGeneric"),
        INSTANCE_COUNTS(21, "InstanceCounts");

        public final int ID;
        public final String NAME;

        private Cmd(int id, String name) {
            this.ID = id;
            this.NAME = name;
        }
    }
}

