/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

class CmdSetThreadReference
extends CmdSet {
    protected CmdSetThreadReference() {
        super(11, "THREAD_REF");
        this.add(1, "Name");
        this.add(2, "Suspend");
        this.add(3, "Resume");
        this.add(4, "Status");
        this.add(5, "ThreadGroup");
        this.add(6, "Frames", CmdSetThreadReference::parseFramesCmd, CmdSetThreadReference::parseFramesReply);
        this.add(7, "FrameCount");
        this.add(8, "OwnerMonitors");
        this.add(9, "CurrentContendedMonitor");
        this.add(10, "Stop");
        this.add(11, "Interrupt");
        this.add(12, "SuspendCount");
        this.add(13, "OwnerMonitorStackDepthInfo");
        this.add(14, "ForceEarlyReturn");
    }

    private static Message parseFramesCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        long threadID = reader.getThreadID(byteBuffer);
        int startFrame = reader.getInt(byteBuffer);
        int length = reader.getInt(byteBuffer);
        message2.addArg("threadID", threadID);
        message2.addArg("startFrame", startFrame);
        message2.addArg("length", length);
        return message2;
    }

    private static Message parseFramesReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        int frames = reader.getInt(byteBuffer);
        JsonArray framesArray = new JsonArray();
        for (int i = 0; i < frames; ++i) {
            long frameID = reader.getFrameID(byteBuffer);
            JsonObject location2 = reader.getLocation(byteBuffer);
            JsonObject frame = new JsonObject();
            frame.addProperty("frameID", (Number)frameID);
            frame.add("location", (JsonElement)location2);
            framesArray.add((JsonElement)frame);
        }
        message2.addArg("frames", (JsonElement)framesArray);
        return message2;
    }
}

