/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

public class CmdSetStackFrame
extends CmdSet {
    protected CmdSetStackFrame() {
        super(16, "STACK_FRAME");
        this.add(1, "GetValues", CmdSetStackFrame::parseGetValuesCmd, CmdSetStackFrame::parseGetValuesReply);
        this.add(2, "SetValues");
        this.add(3, "ThisObject");
        this.add(4, "PopFrames");
    }

    private static Message parseGetValuesCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        long threadID = reader.getThreadID(byteBuffer);
        long frameID = reader.getFrameID(byteBuffer);
        message2.addArg("threadID", threadID);
        message2.addArg("frameID", frameID);
        int numSlots = reader.getInt(byteBuffer);
        JsonArray slots = new JsonArray();
        for (int i = 0; i < numSlots; ++i) {
            int slot = reader.getInt(byteBuffer);
            byte sigbyte = reader.getByte(byteBuffer);
            JsonObject slotEntry = new JsonObject();
            slotEntry.addProperty("slot", (Number)slot);
            slotEntry.addProperty("sigbyte", (Number)sigbyte);
            slots.add((JsonElement)slotEntry);
        }
        message2.addArg("slots", (JsonElement)slots);
        return message2;
    }

    private static Message parseGetValuesReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        int values = reader.getInt(byteBuffer);
        message2.addArg("values", values);
        return message2;
    }
}

