/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

class CmdSetReferenceType
extends CmdSet {
    protected CmdSetReferenceType() {
        super(2, "REF_TYPE");
        this.add(1, "Signature", CmdSetReferenceType::parseSignatureCmd, CmdSetReferenceType::parseSignatureReply);
        this.add(2, "Classloader");
        this.add(3, "Modifiers");
        this.add(4, "Fields");
        this.add(5, "Methods", CmdSetReferenceType::parseMethodsCmd, CmdSetReferenceType::parseMethodsReply);
        this.add(6, "GetValues");
        this.add(7, "SourceFile");
        this.add(8, "NestedTypes");
        this.add(9, "Status");
        this.add(10, "Interfaces");
        this.add(11, "ClassObject");
        this.add(12, "SourceDebugExtension", CmdSetReferenceType::parseSourceDebugExtensionCmd, CmdSetReferenceType::parseSourceDebugExtensionReply);
        this.add(13, "SignatureWithGenerics", CmdSetReferenceType::parseSignatureWithGenericCmd, CmdSetReferenceType::parseSignatureWithGenericReply);
        this.add(14, "FieldWithGenerics");
        this.add(15, "MethodWithGenerics", CmdSetReferenceType::parseMethodsWithGenericsCmd, CmdSetReferenceType::parseMethodsWithGenericsReply);
        this.add(16, "Instances");
        this.add(17, "ClassFileVersion");
        this.add(18, "ConstantPool");
    }

    private static Message parseSignatureCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("refType", reader.getReferenceTypeID(byteBuffer));
        return message2;
    }

    private static Message parseSignatureReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("signature", reader.getString(byteBuffer));
        return message2;
    }

    private static Message parseSourceDebugExtensionCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("refType", reader.getReferenceTypeID(byteBuffer));
        return message2;
    }

    private static Message parseSourceDebugExtensionReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        if (byteBuffer.hasRemaining()) {
            message2.addArg("extension", reader.getString(byteBuffer));
        }
        return message2;
    }

    private static Message parseSignatureWithGenericCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("refType", reader.getReferenceTypeID(byteBuffer));
        return message2;
    }

    private static Message parseSignatureWithGenericReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("signature", reader.getString(byteBuffer));
        message2.addArg("genericSignature", reader.getString(byteBuffer));
        return message2;
    }

    private static Message parseMethodsCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("refType", reader.getReferenceTypeID(byteBuffer));
        return message2;
    }

    private static Message parseMethodsReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        int declared = reader.getInt(byteBuffer);
        JsonArray methods = new JsonArray();
        for (int i = 0; i < declared; ++i) {
            JsonObject method = new JsonObject();
            method.addProperty("methodID", (Number)reader.getMethodID(byteBuffer));
            method.addProperty("name", reader.getString(byteBuffer));
            method.addProperty("signature", reader.getString(byteBuffer));
            method.addProperty("modBits", (Number)reader.getInt(byteBuffer));
            methods.add((JsonElement)method);
        }
        message2.addArg("declared", declared);
        message2.addArg("methods", (JsonElement)methods);
        return message2;
    }

    private static Message parseMethodsWithGenericsCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("refType", reader.getReferenceTypeID(byteBuffer));
        return message2;
    }

    private static Message parseMethodsWithGenericsReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        int declared = reader.getInt(byteBuffer);
        JsonArray methods = new JsonArray();
        for (int i = 0; i < declared; ++i) {
            JsonObject method = new JsonObject();
            method.addProperty("methodID", (Number)reader.getMethodID(byteBuffer));
            method.addProperty("name", reader.getString(byteBuffer));
            method.addProperty("signature", reader.getString(byteBuffer));
            method.addProperty("genericSignature", reader.getString(byteBuffer));
            method.addProperty("modBits", (Number)reader.getInt(byteBuffer));
            methods.add((JsonElement)method);
        }
        message2.addArg("declared", declared);
        message2.addArg("methods", (JsonElement)methods);
        return message2;
    }
}

