/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.EventKind;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import com.android.jdwptracer.ModKind;
import com.android.jdwptracer.SuspendPolicy;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

class CmdSetEventRequest
extends CmdSet {
    protected CmdSetEventRequest() {
        super(15, "EVENT_REQ");
        this.add(1, "Set", CmdSetEventRequest::parseCmd, CmdSetEventRequest::parseReply);
        this.add(2, "Clear");
        this.add(3, "ClearAllBreakpoints");
    }

    private static Message parseReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        message2.addArg("requestID", reader.getInt(byteBuffer));
        return message2;
    }

    private static Message parseCmd(ByteBuffer buffer2, MessageReader reader) {
        Message message2 = new Message(buffer2);
        byte eventKind = reader.getByte(buffer2);
        String eventName = EventKind.fromID(eventKind).name();
        message2.addArg("eventKind", eventName);
        message2.setName(eventName);
        byte suspendPolicy = reader.getByte(buffer2);
        message2.addArg("suspendPolicy", SuspendPolicy.fromID(suspendPolicy).name());
        int numModifiers = reader.getInt(buffer2);
        message2.addArg("numModifiers", Integer.toString(numModifiers));
        JsonArray modifiers = new JsonArray();
        message2.addArg("modifiers", (JsonElement)modifiers);
        block13: for (int n = 0; n < numModifiers; ++n) {
            ModKind kind = ModKind.fromID(reader.getByte(buffer2));
            JsonObject modifier = new JsonObject();
            modifiers.add((JsonElement)modifier);
            modifier.addProperty("modKind", kind.name());
            switch (kind) {
                case COUNT: {
                    int count = reader.getInt(buffer2);
                    modifier.addProperty("count", (Number)count);
                    continue block13;
                }
                case CONDITIONAL: {
                    modifier.addProperty("exprID", (Number)reader.getInt(buffer2));
                    continue block13;
                }
                case THREAD_ONLY: {
                    modifier.addProperty("threadID", (Number)reader.getThreadID(buffer2));
                    continue block13;
                }
                case CLASS_ONLY: {
                    modifier.addProperty("clazz", (Number)reader.getReferenceTypeID(buffer2));
                    continue block13;
                }
                case CLASS_MATCH: 
                case CLASS_EXCLUDE: {
                    modifier.addProperty("classPattern", reader.getString(buffer2));
                    continue block13;
                }
                case LOCATION_ONLY: {
                    modifier.add("loc", (JsonElement)reader.getLocation(buffer2));
                    continue block13;
                }
                case EXCEPTION_ONLY: {
                    modifier.addProperty("exceptionOrNull", (Number)reader.getReferenceTypeID(buffer2));
                    modifier.addProperty("caught", Boolean.valueOf(reader.getBoolean(buffer2)));
                    modifier.addProperty("uncaught", Boolean.valueOf(reader.getBoolean(buffer2)));
                    continue block13;
                }
                case FIELD_ONLY: {
                    modifier.addProperty("declaring", (Number)reader.getReferenceTypeID(buffer2));
                    modifier.addProperty("fieldID", (Number)reader.getFieldID(buffer2));
                    continue block13;
                }
                case STEP: {
                    modifier.addProperty("thread", (Number)reader.getThreadID(buffer2));
                    modifier.addProperty("size", (Number)reader.getInt(buffer2));
                    modifier.addProperty("depth", (Number)reader.getInt(buffer2));
                    continue block13;
                }
                case INSTANCE_ONLY: {
                    modifier.addProperty("instance", (Number)reader.getObjectID(buffer2));
                    continue block13;
                }
                case SOURCE_NAME_MATCH: {
                    modifier.addProperty("sourceNamePattern", reader.getString(buffer2));
                }
            }
        }
        return message2;
    }
}

