/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.EventKind;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import java.nio.ByteBuffer;

class CmdSetEvent
extends CmdSet {
    protected CmdSetEvent() {
        super(64, "EVENT");
        this.add(100, "Composite", CmdSetEvent::parseCmdComposite, CmdSetEvent::parseReplyComposite);
    }

    private static Message parseReplyComposite(ByteBuffer byteBuffer, MessageReader reader) {
        return new Message(byteBuffer);
    }

    private static Message parseCmdComposite(ByteBuffer byteBuffer, MessageReader reader) {
        Message message2 = new Message(byteBuffer);
        byte suspendPolicy = reader.getByte(byteBuffer);
        message2.addArg("suspendPolicy", Byte.toString(suspendPolicy));
        int numEvents = reader.getInt(byteBuffer);
        message2.addArg("numEvents", Integer.toString(numEvents));
        block13: for (int i = 0; i < numEvents; ++i) {
            byte eventKind = reader.getByte(byteBuffer);
            EventKind kind = EventKind.fromID(eventKind);
            message2.addArg("EventKing[" + i + "]", kind.name());
            message2.setName(kind.name());
            reader.getInt(byteBuffer);
            switch (kind) {
                case SINGLE_STEP: 
                case BREAKPOINT: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    reader.getThreadID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    continue block13;
                }
                case METHOD_EXIT_WITH_RETURN_VALUE: {
                    reader.getThreadID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    reader.getValue(byteBuffer);
                    continue block13;
                }
                case MONITOR_CONTENDED_ENTER: 
                case MONITOR_CONTENDED_ENTERED: {
                    reader.getThreadID(byteBuffer);
                    reader.getTaggedObjectID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    continue block13;
                }
                case MONITOR_WAIT: {
                    reader.getThreadID(byteBuffer);
                    reader.getTaggedObjectID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    reader.getLong(byteBuffer);
                    continue block13;
                }
                case MONITOR_WAITED: {
                    reader.getThreadID(byteBuffer);
                    reader.getTaggedObjectID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    reader.getBoolean(byteBuffer);
                    continue block13;
                }
                case EXCEPTION: {
                    reader.getThreadID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    reader.getTaggedObjectID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    continue block13;
                }
                case VM_START: 
                case THREAD_START: 
                case THREAD_DEATH: {
                    reader.getThreadID(byteBuffer);
                    continue block13;
                }
                case CLASS_PREPARE: {
                    message2.addArg("thread", reader.getThreadID(byteBuffer));
                    message2.addArg("refTypeTag", reader.getTypeTag(byteBuffer));
                    message2.addArg("typeID", reader.getReferenceTypeID(byteBuffer));
                    message2.addArg("signature", reader.getString(byteBuffer));
                    message2.addArg("status", reader.getInt(byteBuffer));
                    continue block13;
                }
                case CLASS_UNLOAD: {
                    reader.getString(byteBuffer);
                    continue block13;
                }
                case FIELD_ACCESS: {
                    reader.getThreadID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    reader.getByte(byteBuffer);
                    reader.getReferenceTypeID(byteBuffer);
                    reader.getFieldID(byteBuffer);
                    reader.getTaggedObjectID(byteBuffer);
                    continue block13;
                }
                case FIELD_MODIFICATION: {
                    reader.getThreadID(byteBuffer);
                    reader.getLocation(byteBuffer);
                    reader.getByte(byteBuffer);
                    reader.getObjectID(byteBuffer);
                    reader.getFieldID(byteBuffer);
                    reader.getTaggedObjectID(byteBuffer);
                    reader.getValue(byteBuffer);
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("Unprocessed Kind" + kind.name());
                }
            }
        }
        if (numEvents != 1) {
            message2.setName("multiple");
        }
        return message2;
    }
}

