/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.MessageReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

class CmdSetDdm
extends CmdSet {
    private static Map<Integer, String> ddmTypes = new HashMap<Integer, String>();

    protected CmdSetDdm() {
        super(199, "DDM");
        this.add(1, "Packet", this::parseDdmCmd, this::parseDdmReply);
    }

    private Message parseDdmReply(ByteBuffer byteBuffer, MessageReader reader) {
        Message msg = new Message(byteBuffer);
        return msg;
    }

    private Message parseDdmCmd(ByteBuffer byteBuffer, MessageReader reader) {
        Message msg = new Message(byteBuffer);
        int type = reader.getInt(byteBuffer);
        int length = reader.getInt(byteBuffer);
        if (ddmTypes.containsKey(type)) {
            msg.setName(ddmTypes.get(type));
        } else {
            msg.setName("UNKNOWN(" + CmdSetDdm.typeToName(type) + ")");
        }
        return msg;
    }

    private static void addType(String name) {
        ddmTypes.put(CmdSetDdm.typeFromName(name), name);
    }

    private static String typeToName(int type) {
        char[] ascii = new char[]{(char)(type >> 24 & 0xFF), (char)(type >> 16 & 0xFF), (char)(type >> 8 & 0xFF), (char)(type & 0xFF)};
        return new String(ascii);
    }

    private static int typeFromName(String name) {
        if (name.length() != 4) {
            throw new RuntimeException("DDM Type name must be 4 letter long");
        }
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val <<= 8;
            val |= (byte)name.charAt(i);
        }
        return val;
    }

    static {
        CmdSetDdm.addType("APNM");
        CmdSetDdm.addType("EXIT");
        CmdSetDdm.addType("HELO");
        CmdSetDdm.addType("FEAT");
        CmdSetDdm.addType("TEST");
        CmdSetDdm.addType("WAIT");
        CmdSetDdm.addType("MPRS");
        CmdSetDdm.addType("MPSS");
        CmdSetDdm.addType("MPSE");
        CmdSetDdm.addType("MPRQ");
        CmdSetDdm.addType("MPRQ");
        CmdSetDdm.addType("SPSS");
        CmdSetDdm.addType("SPSE");
        CmdSetDdm.addType("HPIF");
        CmdSetDdm.addType("HPST");
        CmdSetDdm.addType("HPEN");
        CmdSetDdm.addType("HPSG");
        CmdSetDdm.addType("HPGC");
        CmdSetDdm.addType("HPDU");
        CmdSetDdm.addType("HPDS");
        CmdSetDdm.addType("REAE");
        CmdSetDdm.addType("REAQ");
        CmdSetDdm.addType("REAL");
    }
}

