/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import java.nio.ByteBuffer;

public class DdmCommandPacket {
    private int mLength;
    private String mCommand;

    public DdmCommandPacket(ByteBuffer buffer2) {
        if (buffer2.position() < 4) {
            this.mLength = -1;
            return;
        }
        try {
            this.mLength = Integer.parseInt(new String(buffer2.array(), 0, 4), 16);
        }
        catch (NumberFormatException nfe) {
            this.mLength = -1;
            return;
        }
        if (buffer2.position() < 4 + this.mLength) {
            this.mLength = -1;
            return;
        }
        this.mCommand = new String(buffer2.array(), 4, this.mLength);
    }

    public int getLength() {
        return this.mLength;
    }

    public String getCommand() {
        return this.mCommand;
    }

    public int getTotalSize() {
        return this.mLength + 4;
    }
}

